/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 35637:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Node = {
  child: __webpack_require__(32081),
  crypto: __webpack_require__(6113),
  fs: __webpack_require__(57147),
  os: __webpack_require__(22037),
  path: __webpack_require__(71017),
  process: process,
  util: __webpack_require__(73837)
};

function Attempt(instance, end) {
  var platform = Node.process.platform;
  if (platform === 'darwin') return Mac(instance, end);
  if (platform === 'linux') return Linux(instance, end);
  if (platform === 'win32') return Windows(instance, end);
  end(new Error('Platform not yet supported.'));
}

function EscapeDoubleQuotes(string) {
  if (typeof string !== 'string') throw new Error('Expected a string.');
  return string.replace(/"/g, '\\"');
}

function SPLog(instance, msg) {
  if (instance.options.logger) {
    instance.options.logger.info(msg);
  }
}

function Exec() {
  if (arguments.length < 1 || arguments.length > 3) {
    throw new Error('Wrong number of arguments.');
  }
  var command = arguments[0];
  var options = {};
  var end = function() {};
  if (typeof command !== 'string') {
    throw new Error('Command should be a string.');
  }
  if (arguments.length === 2) {
    if (Node.util.isObject(arguments[1])) {
      options = arguments[1];
    } else if (Node.util.isFunction(arguments[1])) {
      end = arguments[1];
    } else {
      throw new Error('Expected options or callback.');
    }
  } else if (arguments.length === 3) {
    if (Node.util.isObject(arguments[1])) {
      options = arguments[1];
    } else {
      throw new Error('Expected options to be an object.');
    }
    if (Node.util.isFunction(arguments[2])) {
      end = arguments[2];
    } else {
      throw new Error('Expected callback to be a function.');
    }
  }
  if (/^sudo/i.test(command)) {
    return end(new Error('Command should not be prefixed with "sudo".'));
  }
  if (typeof options.name === 'undefined') {
    var title = Node.process.title;
    if (ValidName(title)) {
      options.name = title;
    } else {
      return end(new Error('process.title cannot be used as a valid name.'));
    }
  } else if (!ValidName(options.name)) {
    var error = '';
    error += 'options.name must be alphanumeric only ';
    error += '(spaces are allowed) and <= 70 characters.';
    return end(new Error(error));
  }
  if (typeof options.icns !== 'undefined') {
    if (typeof options.icns !== 'string') {
      return end(new Error('options.icns must be a string if provided.'));
    } else if (options.icns.trim().length === 0) {
      return end(new Error('options.icns must not be empty if provided.'));
    }
  }
  if (typeof options.env !== 'undefined') {
    if (typeof options.env !== 'object') {
      return end(new Error('options.env must be an object if provided.'));
    } else if (Object.keys(options.env).length === 0) {
      return end(new Error('options.env must not be empty if provided.'));
    } else {
      for (var key in options.env) {
        var value = options.env[key];
        if (typeof key !== 'string' || typeof value !== 'string') {
          return end(
            new Error('options.env environment variables must be strings.')
          );
        }
        // "Environment variable names used by the utilities in the Shell and
        // Utilities volume of IEEE Std 1003.1-2001 consist solely of uppercase
        // letters, digits, and the '_' (underscore) from the characters defined
        // in Portable Character Set and do not begin with a digit. Other
        // characters may be permitted by an implementation; applications shall
        // tolerate the presence of such names."
        if (!/^[a-zA-Z_][a-zA-Z0-9_]*$/.test(key)) {
          return end(
            new Error(
              'options.env has an invalid environment variable name: ' +
              JSON.stringify(key)
            )
          );
        }
        if (/[\r\n]/.test(value)) {
          return end(
            new Error(
              'options.env has an invalid environment variable value: ' +
              JSON.stringify(value)
            )
          );
        }
      }
    }
  }
  var platform = Node.process.platform;
  if (platform !== 'darwin' && platform !== 'linux' && platform !== 'win32') {
    return end(new Error('Platform not yet supported.'));
  }
  var instance = {
    command: command,
    options: options,
    uuid: undefined,
    path: undefined
  };
  Attempt(instance, end);
}

function Linux(instance, end) {
  LinuxBinary(instance,
    function(error, binary) {
      if (error) return end(error);
      var command = [];
      // Preserve current working directory:
      command.push('cd "' + EscapeDoubleQuotes(Node.process.cwd()) + '";');
      // Export environment variables:
      for (var key in instance.options.env) {
        var value = instance.options.env[key];
        command.push('export ' + key + '="' + EscapeDoubleQuotes(value) + '";');
      }
      command.push('"' + EscapeDoubleQuotes(binary) + '"');
      if (/kdesudo/i.test(binary)) {
        command.push(
          '--comment',
          '"' + instance.options.name + ' wants to make changes. ' +
          'Enter your password to allow this."'
        );
        command.push('-d'); // Do not show the command to be run in the dialog.
        command.push('--');
      } else if (/pkexec/i.test(binary)) {
        command.push('--disable-internal-agent');
      }
      var magic = 'SUDOPROMPT\n';
      command.push(
        '/bin/bash -c "echo ' + EscapeDoubleQuotes(magic.trim()) + '; ' +
        EscapeDoubleQuotes(instance.command) +
        '"'
      );
      command = command.join(' ');
      Node.child.exec(command, { encoding: 'utf-8', maxBuffer: MAX_BUFFER },
        function(error, stdout, stderr) {
          // ISSUE 88:
          // We must distinguish between elevation errors and command errors.
          //
          // KDESUDO:
          // kdesudo provides no way to do this. We add a magic marker to know
          // if elevation succeeded. Any error thereafter is a command error.
          //
          // PKEXEC:
          // "Upon successful completion, the return value is the return value of
          // PROGRAM. If the calling process is not authorized or an
          // authorization could not be obtained through authentication or an
          // error occured, pkexec exits with a return value of 127. If the
          // authorization could not be obtained because the user dismissed the
          // authentication dialog, pkexec exits with a return value of 126."
          //
          // However, we do not rely on pkexec's return of 127 since our magic
          // marker is more reliable, and we already use it for kdesudo.
          var elevated = stdout && stdout.slice(0, magic.length) === magic;
          if (elevated) stdout = stdout.slice(magic.length);
          // Only normalize the error if it is definitely not a command error:
          // In other words, if we know that the command was never elevated.
          // We do not inspect error messages beyond NO_POLKIT_AGENT.
          // We cannot rely on English errors because of internationalization.
          if (error && !elevated) {
            if (/No authentication agent found/.test(stderr)) {
              error.message = NO_POLKIT_AGENT;
            } else {
              error.message = PERMISSION_DENIED;
            }
          }
          end(error, stdout, stderr);
        }
      );
    }
  );
}

function LinuxBinary(instance, end) {
  var index = 0;
  // We used to prefer gksudo over pkexec since it enabled a better prompt.
  // However, gksudo cannot run multiple commands concurrently.
  var paths = ['/usr/bin/kdesudo', '/usr/bin/pkexec'];
  function test() {
    if (index === paths.length) {
      return end(new Error('Unable to find pkexec or kdesudo.'));
    }
    var path = paths[index++];
    Node.fs.stat(path,
      function(error) {
        if (error) {
          if (error.code === 'ENOTDIR') return test();
          if (error.code === 'ENOENT') return test();
          end(error);
        } else {
          end(undefined, path);
        }
      }
    );
  }
  test();
}

function Mac(instance, callback) {
  var temp = Node.os.tmpdir();
  if (!temp) return callback(new Error('os.tmpdir() not defined.'));
  var user = Node.process.env.USER; // Applet shell scripts require $USER.
  if (!user) return callback(new Error('env[\'USER\'] not defined.'));
  UUID(instance,
    function(error, uuid) {
      if (error) return callback(error);
      instance.appletName = instance.options.name + '.app';
      instance.log = Node.path.join(temp, 'sudoLog.txt');
      instance.uuid = uuid;
      instance.path = Node.path.join(
        temp,
        instance.uuid,
        instance.appletName
      );
      instance.root = Node.path.join(
        temp,
        instance.uuid);
      function end(_error, stdout, stderr) {
        callback(undefined, stdout, stderr);
        Remove(Node.path.dirname(instance.path),
          function(errorRemove) {
            if (error) return callback(error);
            if (errorRemove) return callback(errorRemove);
            callback(undefined, stdout, stderr);
          }
        );
      }
      MacCreateApplet(instance,
        function(error, stdout, stderr) {
          if (error) return end(error, stdout, stderr);
          MacCopyScript(instance,
            function(error) {
              if (error) return end(error);
              MacModifyPropertyList(instance,
                function(error, stdout, stderr) {
                  if (error) return end(error, stdout, stderr);
                  MacCreateCommand(instance,
                    function(error) {
                      if (error) return end(error);
                      MacRunApplet(instance,
                        function(error, stdout, stderr) {
                          if (error) return end(error, stdout, stderr);
                          MacCollectResults(instance, end);
                        }
                      );
                    }
                  );
                }
              );
            }
          );
        }
      );
    }
  );
}

function MacCreateApplet(instance, end) {
  var parent = Node.path.dirname(instance.path);
  Node.fs.mkdir(parent,
    function(error) {
      Node.fs.appendFileSync(instance.log, `MacCreateApplet() - Creating parent folder ${parent}. Error was ${error}.\n`);
      if (error) return end(error);
      var zip = Node.path.join(parent, 'sudo-prompt-applet.zip');
      Node.fs.writeFile(zip, APPLET, 'base64',
        function(error) {
          Node.fs.appendFileSync(instance.log, `MacCreateApplet() - Write applet at ${zip}. Error was ${error}.\n`);
          if (error) return end(error);
          var command = [];
          command.push('/usr/bin/unzip');
          command.push('-o'); // Overwrite any existing applet.
          command.push('"' + EscapeDoubleQuotes(zip) + '"');
          command.push('-d "' + EscapeDoubleQuotes(instance.path) + '"');
          command = command.join(' ');
          Node.child.exec(command, { encoding: 'utf-8' }, end);
          Node.fs.appendFileSync(instance.log, `MacCreateApplet() - Unzipping with: ${command}.\n`);
        }
      );
    }
  );
}


// Puts the "sudo-prompt-command" script in root.
function MacCreateCommand(instance, end) {
  var path = Node.path.join(
    instance.root,
    'sudo-prompt-command'
  );
  var script = [];
  // Preserve current working directory:
  // We do this for commands that rely on relative paths.
  // This runs in a subshell and will not change the cwd of sudo-prompt-script.
  script.push('cd "' + EscapeDoubleQuotes(Node.process.cwd()) + '"');
  // Export environment variables:
  for (var key in instance.options.env) {
    var value = instance.options.env[key];
    script.push('export ' + key + '="' + EscapeDoubleQuotes(value) + '"');
  }
  script.push(instance.command);
  script = script.join('\n');
  Node.fs.writeFile(path, script, 'utf-8', end);
}


// used to copy the script out of the app into the root folder where it's expected.
function MacCopyScript(instance, end) {
  let scriptSrc = Node.path.join(instance.path, 'Contents', 'Resources', 'Scripts', 'sudo-prompt-script');
  let scriptDest = Node.path.join(instance.root, 'sudo-prompt-script');
  Node.fs.copyFile(scriptSrc, scriptDest, end);
}

function MacRunApplet(instance, end) {
  // We must run the binary directly so that the cwd will apply.
  var binary = Node.path.join(instance.path, 'Contents', 'MacOS', 'applet');
  // We must set the cwd so that the AppleScript can find the shell scripts.
  Node.fs.appendFileSync(instance.log, `MacRunApplet() - Setting cwd as ${instance.root}.\n`);
  var options = {
    cwd: instance.root,
    encoding: 'utf-8'
  };
  // We use the relative path rather than the absolute path. The instance.path
  // may contain spaces which the cwd can handle, but which exec() cannot.
  const commandPath = '"./' + instance.appletName + '/Contents/MacOS/' + Node.path.basename(binary) + '"';
  Node.fs.appendFileSync(instance.log, `MacRunApplet() - Running with: ${commandPath}.\n`);
  Node.child.exec(commandPath, options, end);
}

// Used to overwrite plist of applet but now just writes it to the root as a NOP (so as to not break code signing)
function MacModifyPropertyList(instance, end) {
  // Value must be in single quotes (not double quotes) according to man entry.
  // e.g. defaults write com.companyname.appname "Default Color" '(255, 0, 0)'
  // The defaults command will be changed in an upcoming major release to only
  // operate on preferences domains. General plist manipulation utilities will
  // be folded into a different command-line program.
  var plist = Node.path.join(instance.root, 'Info.plist');
  var path = EscapeDoubleQuotes(plist);
  var key = EscapeDoubleQuotes('CFBundleName');
  var value = instance.options.name + ' Password Prompt';
  if (/'/.test(value)) {
    return end(new Error('Value should not contain single quotes.'));
  }
  var command = [];
  command.push('/usr/bin/defaults');
  command.push('write');
  command.push('"' + path + '"');
  command.push('"' + key + '"');
  command.push("'" + value + "'"); // We must use single quotes for value.
  command = command.join(' ');
  Node.child.exec(command, { encoding: 'utf-8' }, end);
}

function MacCollectResults(instance, end) {
  var cwd = Node.path.join(instance.path, 'Contents', 'MacOS');
  Node.fs.readFile(Node.path.join(cwd, 'code'), 'utf-8',
    function(error, code) {
      if (error) {
        if (error.code === 'ENOENT') return end(new Error(PERMISSION_DENIED));
        end(error);
      } else {
        Node.fs.readFile(Node.path.join(cwd, 'stdout'), 'utf-8',
          function(error, stdout) {
            if (error) return end(error);
            Node.fs.readFile(Node.path.join(cwd, 'stderr'), 'utf-8',
              function(error, stderr) {
                if (error) return end(error);
                code = parseInt(code.trim(), 10); // Includes trailing newline.
                if (code === 0) {
                  end(undefined, stdout, stderr);
                } else {
                  error = new Error(
                    'Command failed: ' + instance.command + '\n' + stderr
                  );
                  error.code = code;
                  end(error, stdout, stderr);
                }
              }
            );
          }
        );
      }
    }
  );
}

function Remove(path, end) {
  if (typeof path !== 'string' || !path.trim()) {
    return end(new Error('Argument path not defined.'));
  }
  var command = [];
  if (Node.process.platform === 'win32') {
    if (/"/.test(path)) {
      return end(new Error('Argument path cannot contain double-quotes.'));
    }
    command.push('rmdir /s /q "' + path + '"');
  } else {
    command.push('/bin/rm');
    command.push('-rf');
    command.push('"' + EscapeDoubleQuotes(Node.path.normalize(path)) + '"');
  }
  command = command.join(' ');
  Node.child.exec(command, { encoding: 'utf-8' }, end);
}

function UUID(instance, end) {
  Node.crypto.randomBytes(256,
    function(error, random) {
      if (error) random = Date.now() + '' + Math.random();
      var hash = Node.crypto.createHash('SHA256');
      hash.update('sudo-prompt-3');
      hash.update(instance.options.name);
      hash.update(instance.command);
      hash.update(random);
      var uuid = hash.digest('hex').slice(-32);
      if (!uuid || typeof uuid !== 'string' || uuid.length !== 32) {
        // This is critical to ensure we don't remove the wrong temp directory.
        return end(new Error('Expected a valid UUID.'));
      }
      end(undefined, uuid);
    }
  );
}

function ValidName(string) {
  // We use 70 characters as a limit to side-step any issues with Unicode
  // normalization form causing a 255 character string to exceed the fs limit.
  if (!/^[a-z0-9 ]+$/i.test(string)) return false;
  if (string.trim().length === 0) return false;
  if (string.length > 70) return false;
  return true;
}

function Windows(instance, callback) {
  var temp = Node.os.tmpdir();
  if (!temp) return callback(new Error('os.tmpdir() not defined.'));
  SPLog(instance, `SudoPrompt: Windows function starting. Temp folder was: ${temp}`);
  UUID(instance,
    function(error, uuid) {
      if (error) return callback(error);
      instance.uuid = uuid;
      instance.path = Node.path.join(temp, instance.uuid);
      if (/"/.test(instance.path)) {
        // We expect double quotes to be reserved on Windows.
        // Even so, we test for this and abort if they are present.
        return callback(
          new Error('instance.path cannot contain double-quotes.')
        );
      }
      instance.pathExecute = Node.path.join(instance.path, 'execute.bat');
      instance.pathCommand = Node.path.join(instance.path, 'command.bat');
      instance.pathStdout = Node.path.join(instance.path, 'stdout');
      instance.pathStderr = Node.path.join(instance.path, 'stderr');
      instance.pathStatus = Node.path.join(instance.path, 'status');
      Node.fs.mkdir(instance.path,
        function(error) {
          if (error) return callback(error);
          function end(error, stdout, stderr) {
            SPLog(instance, `SudoPrompt: Windows function - Ending.`);
            if (!instance.options.noClean) {
              SPLog(instance, `SudoPrompt: Windows function - Removing at ${instance.path}`);
              Remove(instance.path,
                function(errorRemove) {
                  if (error) return callback(error);
                  if (errorRemove) return callback(errorRemove);
                  callback(undefined, stdout, stderr);
                }
              );
            } else {
              SPLog(instance, `SudoPrompt: Windows function - Not cleaning.`);
              callback(undefined, stdout, stderr);
            }
          }
          WindowsVerifyPS(instance,
            function(error) {
              if (error) return end(error);
              WindowsWriteExecuteScript(instance,
                function(error) {
                  if (error) return end(error);
                  WindowsWriteCommandScript(instance,
                    function(error) {
                      if (error) return end(error);
                      WindowsCopyCmd(instance,
                        function(error) {
                          if (error) return end(error);
                          WindowsElevate(instance,
                            function(error, stdout, stderr) {
                              if (error) return end(error, stdout, stderr);
                              WindowsWaitForStatus(instance,
                                function(error) {
                                  if (error) return end(error);
                                  WindowsResult(instance, end);
                                }
                              );
                            }
                          );
                        }
                      );
                    }
                  );
                }
              );
            }
          );
        }
      )
    }
  );
}


function WindowsNeedsCopyCmd(instance) {
  const specialChars = ['&', '`', "'", '"', '<', '>', '|', '^', '(', ')'];
  for (const specialChar of specialChars) {
    if (instance.path.includes(specialChar)) {
      return true;
    }
  }
  return false;
}


function WindowsCopyCmd(instance, end) {
  if (!WindowsNeedsCopyCmd(instance)) {
    end();
    return;
  }
  // Work around https://github.com/jorangreef/sudo-prompt/issues/97
  // Powershell can't properly escape amperstands in paths.
  // We work around this by copying cmd.exe in our temporary folder and running
  // it from here (see WindowsElevate below).
  // That way, we don't have to pass the path containing the amperstand at all.
  // A symlink would probably work too but you have to be an administrator in
  // order to create symlinks on Windows.
  const srcPath = Node.path.join(Node.process.env.SystemRoot, 'System32', 'cmd.exe');
  const dstPath = Node.path.join(instance.path, 'cmd.exe');
  SPLog(instance, `SudoPrompt::WindowsCopyCmd() - Copying cmd from: ${srcPath} to: ${dstPath}`);
  Node.fs.copyFile(
    srcPath,
    dstPath,
    end,
  );
}


// Ensure that powershell is installed and working.
// Writes the output "PSPresent" and looks for the correct output.
//
function WindowsVerifyPS(instance, end) {
  // Run an empty command in powershell and ensure no error code...
  var command = [];
  command.push('powershell.exe');
  command.push('Write-Output');
  command.push('PSPresent');
  command = command.join(' ');
  var options = { encoding: 'utf8' };

  SPLog(instance, `SudoPrompt::WindowsElevate() - Verify command was: ${command}`);
  var child = Node.child.exec(command, options,
    function(error, stdout, stderr) {
      // We used to return PERMISSION_DENIED only for error messages containing
      // the string 'canceled by the user'. However, Windows internationalizes
      // error messages (issue 96) so now we must assume all errors here are
      // permission errors. This seems reasonable, given that we already run the
      // user's command in a subshell.
      if (error) {
        SPLog(instance, `SudoPrompt::WindowsElevate() - Error testing powershell: ${error} stdout: ${stdout}, stderr: ${stderr}`);
        return end(new Error(PERMISSION_DENIED), stdout, stderr);
      }
      // Print the output to the log...
      const expected = 'PSPresent';
      const outputTrim = stdout ? stdout.trim() : '';
      successfullyExecuted = outputTrim === expected
      SPLog(instance, `SudoPrompt::WindowsElevate() - Verify output matches: "${expected}". Got: "${outputTrim}". Success? ${successfullyExecuted}`);
      if (!successfullyExecuted) {
        return end(new Error(PERMISSION_DENIED), stdout, stderr);
      }
      end();
    }
  );
  child.stdin.end(); // Otherwise PowerShell waits indefinitely on Windows 7.
}


function WindowsElevate(instance, end) {
  // We used to use this for executing elevate.vbs:
  SPLog(instance, `SudoPrompt::WindowsElevate() - Start.`);
  var command = [];
  command.push('powershell.exe');
  command.push('Start-Process');
  command.push('-FilePath');
  var options = { encoding: 'utf8' };
  if (WindowsNeedsCopyCmd(instance)) {
    // Node.path.join('.', 'cmd.exe') would return 'cmd.exe'
    SPLog(instance, `SudoPrompt::WindowsElevate() - We need to copy cmd.exe.`);
    command.push(['.', 'cmd.exe'].join(Node.path.sep));
    command.push('-ArgumentList');
    command.push('"/C","execute.bat"');
    options.cwd = instance.path;
  } else {
    // Escape characters for cmd using double quotes:
    // Escape characters for PowerShell using single quotes:
    // Escape single quotes for PowerShell using backtick:
    // See: https://ss64.com/ps/syntax-esc.html
    SPLog(instance, `SudoPrompt::WindowsElevate() - No copy of cmd.exe needed.`);
    command.push('"\'' + instance.pathExecute.replace(/'/g, "`'") + '\'"');
  }
  command.push('-WindowStyle hidden');
  command.push('-Verb runAs');
  command = command.join(' ');

  SPLog(instance, `SudoPrompt::WindowsElevate() - Command was: ${command}`);
  var child = Node.child.exec(command, options,
    function(error, stdout, stderr) {
      // We used to return PERMISSION_DENIED only for error messages containing
      // the string 'canceled by the user'. However, Windows internationalizes
      // error messages (issue 96) so now we must assume all errors here are
      // permission errors. This seems reasonable, given that we already run the
      // user's command in a subshell.
      if (error) return end(new Error(PERMISSION_DENIED), stdout, stderr);
      end();
    }
  );
  child.stdin.end(); // Otherwise PowerShell waits indefinitely on Windows 7.
}

function WindowsResult(instance, end) {
  SPLog(instance, `SudoPrompt::WindowsResult() - Start.`);
  Node.fs.readFile(instance.pathStatus, 'utf-8',
    function(error, code) {
      if (error) return end(error);
      Node.fs.readFile(instance.pathStdout, 'utf-8',
        function(error, stdout) {
          if (error) return end(error);
          Node.fs.readFile(instance.pathStderr, 'utf-8',
            function(error, stderr) {
              if (error) return end(error);
              code = parseInt(code.trim(), 10);
              if (code === 0) {
                end(undefined, stdout, stderr);
              } else {
                error = new Error(
                  'Command failed: ' + instance.command + '\r\n' + stderr
                );
                error.code = code;
                end(error, stdout, stderr);
              }
            }
          );
        }
      );
    }
  );
}

function WindowsWaitForStatus(instance, end) {
  // VBScript cannot wait for the elevated process to finish so we have to poll.
  // VBScript cannot return error code if user does not grant permission.
  // PowerShell can be used to elevate and wait on Windows 10.
  // PowerShell can be used to elevate on Windows 7 but it cannot wait.
  // powershell.exe Start-Process cmd.exe -Verb runAs -Wait
  SPLog(instance, `SudoPrompt::WindowsWaitForStatus() - Start. Checking status from file: ${instance.pathStatus}`);
  Node.fs.stat(instance.pathStatus,
    function(error, stats) {
      if ((error && error.code === 'ENOENT') || stats.size < 2) {
        // Retry if file does not exist or is not finished writing.
        // We expect a file size of 2. That should cover at least "0\r".
        // We use a 1 second timeout to keep a light footprint for long-lived
        // sudo-prompt processes.
        setTimeout(
          function() {
            // If administrator has no password and user clicks Yes, then
            // PowerShell returns no error and execute (and command) never runs.
            // We check that command output has been redirected to stdout file:
            Node.fs.stat(instance.pathStdout,
              function(error) {
                if (error) {
                  SPLog(instance, `SudoPrompt::WindowsWaitForStatus() - Error in timeout ${error}`);
                  return end(new Error(PERMISSION_DENIED));
                }
                WindowsWaitForStatus(instance, end);
              }
            );
          },
          1000
        );
      } else if (error) {
        SPLog(instance, `SudoPrompt::WindowsWaitForStatus() - Error: ${error}`);
        end(error);
      } else {
        SPLog(instance, `SudoPrompt::WindowsWaitForStatus() - Success.`);
        end();
      }
    }
  );
}


// This writes command.bat which directly calls the command, redirecting stdout and stderr.
function WindowsWriteCommandScript(instance, end) {
  SPLog(instance, `SudoPrompt::WindowsWriteCommandScript() - starting.`);
  var cwd = Node.process.cwd();
  if (/"/.test(cwd)) {
    // We expect double quotes to be reserved on Windows.
    // Even so, we test for this and abort if they are present.
    return end(new Error('process.cwd() cannot contain double-quotes.'));
  }
  var script = [];
  script.push('@echo off');
  // Set code page to UTF-8:
  script.push('chcp 65001>nul');
  // Preserve current working directory:
  // We pass /d as an option in case the cwd is on another drive (issue 70).
  script.push('cd /d "' + cwd + '"');
  // Export environment variables:
  for (var key in instance.options.env) {
    // "The characters <, >, |, &, ^ are special command shell characters, and
    // they must be preceded by the escape character (^) or enclosed in
    // quotation marks. If you use quotation marks to enclose a string that
    // contains one of the special characters, the quotation marks are set as
    // part of the environment variable value."
    // In other words, Windows assigns everything that follows the equals sign
    // to the value of the variable, whereas Unix systems ignore double quotes.
    var value = instance.options.env[key];
    script.push('set ' + key + '=' + value.replace(/([<>\\|&^])/g, '^$1'));
  }
  script.push(instance.command);
  script = script.join('\r\n');
  SPLog(instance, `SudoPrompt::WindowsWriteCommandScript() - Script was:\n${script}\nEnd of Script. Writing to: ${instance.pathCommand}`);
  Node.fs.writeFile(instance.pathCommand, script, 'utf-8', end);
}

function WindowsWriteExecuteScript(instance, end) {
  var script = [];
  script.push('@echo off');
  script.push('chcp 65001>nul');
  script.push(
    'call "' + instance.pathCommand + '"' +
    ' > "' + instance.pathStdout + '" 2> "' + instance.pathStderr + '"'
  );
  script.push('(echo %ERRORLEVEL%) > "' + instance.pathStatus + '"');
  script = script.join('\r\n');
  SPLog(instance, `SudoPrompt::WindowsWriteExecuteScript() - Script was:\n${script}\nEnd of Script. Writing to: ${instance.pathExecute}`);
  Node.fs.writeFile(instance.pathExecute, script, 'utf-8', end);
}

module.exports.exec = Exec;

// We used to expect that applet.app would be included with this module.
// This could not be copied when sudo-prompt was packaged within an asar file.
// We now store applet.app as a zip file in base64 within index.js instead.
// To recreate: "zip -r ../applet.zip Contents" (with applet.app as CWD).
// The zip file must not include applet.app as the root directory so that we
// can extract it directly to the target app directory.
//
// To extract the applet:
// mkdir applet.app
// cd applet.app
// echo -n "UEs... (the string below)" | base64 --decode --output applet.zip
// unzip applet.zip
// rm applet.zip

// Make any changes needed...

// Sign the app...
// Extract app if needed
// security unlock-keychain
// codesign -f -s "Developer ID Application: Vectorworks, Inc." --verbose=4 --deep --options runtime applet.app
// # Zip the signed app
// zip -r appsigned.zip applet.app/
// # Notarize signed app
// xcrun notarytool submit "appsigned.zip" --keychain-profile "vw-notarization" --wait --progress --verbose
// (if it fails...)
//     xcrun notarytool log --keychain-profile "vw-notarization" c38709e3-0d34-4433-904c-8b07db26354a
// # Staple
// xcrun stapler staple applet.app
// # zip it back up (inside applet.app)
// zip -r ../appletContents.zip Contents
//
// To update the applet, follow these steps:
// * open main.scpt in macOS Script Editor and edit it as needed
// * select File | Export... (file format: Application)
// * replace the `applet` in `Contents/MacOS`
// * `zip -r ../applet.zip Contents`
// * base64 encode the zip file
// base64 --input appletContents.zip
// (copy the output and replace the contents of the `APPLET` variable below with the copied output)

var APPLET = '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';
var PERMISSION_DENIED = 'User did not grant permission.';
var NO_POLKIT_AGENT = 'No polkit authentication agent found.';

// See issue 66:
var MAX_BUFFER = 134217728;


/***/ }),

/***/ 43510:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
var __webpack_unused_export__;

__webpack_unused_export__ = ({ value: true });
// https://github.com/ajv-validator/ajv/issues/889
const equal = __webpack_require__(64063);
equal.code = 'require("ajv/dist/runtime/equal").default';
exports.Z = equal;
//# sourceMappingURL=equal.js.map

/***/ }),

/***/ 14277:
/***/ ((module) => {

"use strict";


module.exports = ({onlyFirst = false} = {}) => {
	const pattern = [
		'[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)',
		'(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))'
	].join('|');

	return new RegExp(pattern, onlyFirst ? undefined : 'g');
};


/***/ }),

/***/ 74154:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * archiver-utils
 *
 * Copyright (c) 2012-2014 Chris Talkington, contributors.
 * Licensed under the MIT license.
 * https://github.com/archiverjs/node-archiver/blob/master/LICENSE-MIT
 */
var fs = __webpack_require__(20077);
var path = __webpack_require__(71017);

var flatten = __webpack_require__(5800);
var difference = __webpack_require__(61478);
var union = __webpack_require__(96744);
var isPlainObject = __webpack_require__(8146);

var glob = __webpack_require__(12884);

var file = module.exports = {};

var pathSeparatorRe = /[\/\\]/g;

// Process specified wildcard glob patterns or filenames against a
// callback, excluding and uniquing files in the result set.
var processPatterns = function(patterns, fn) {
  // Filepaths to return.
  var result = [];
  // Iterate over flattened patterns array.
  flatten(patterns).forEach(function(pattern) {
    // If the first character is ! it should be omitted
    var exclusion = pattern.indexOf('!') === 0;
    // If the pattern is an exclusion, remove the !
    if (exclusion) { pattern = pattern.slice(1); }
    // Find all matching files for this pattern.
    var matches = fn(pattern);
    if (exclusion) {
      // If an exclusion, remove matching files.
      result = difference(result, matches);
    } else {
      // Otherwise add matching files.
      result = union(result, matches);
    }
  });
  return result;
};

// True if the file path exists.
file.exists = function() {
  var filepath = path.join.apply(path, arguments);
  return fs.existsSync(filepath);
};

// Return an array of all file paths that match the given wildcard patterns.
file.expand = function(...args) {
  // If the first argument is an options object, save those options to pass
  // into the File.prototype.glob.sync method.
  var options = isPlainObject(args[0]) ? args.shift() : {};
  // Use the first argument if it's an Array, otherwise convert the arguments
  // object to an array and use that.
  var patterns = Array.isArray(args[0]) ? args[0] : args;
  // Return empty set if there are no patterns or filepaths.
  if (patterns.length === 0) { return []; }
  // Return all matching filepaths.
  var matches = processPatterns(patterns, function(pattern) {
    // Find all matching files for this pattern.
    return glob.sync(pattern, options);
  });
  // Filter result set?
  if (options.filter) {
    matches = matches.filter(function(filepath) {
      filepath = path.join(options.cwd || '', filepath);
      try {
        if (typeof options.filter === 'function') {
          return options.filter(filepath);
        } else {
          // If the file is of the right type and exists, this should work.
          return fs.statSync(filepath)[options.filter]();
        }
      } catch(e) {
        // Otherwise, it's probably not the right type.
        return false;
      }
    });
  }
  return matches;
};

// Build a multi task "files" object dynamically.
file.expandMapping = function(patterns, destBase, options) {
  options = Object.assign({
    rename: function(destBase, destPath) {
      return path.join(destBase || '', destPath);
    }
  }, options);
  var files = [];
  var fileByDest = {};
  // Find all files matching pattern, using passed-in options.
  file.expand(options, patterns).forEach(function(src) {
    var destPath = src;
    // Flatten?
    if (options.flatten) {
      destPath = path.basename(destPath);
    }
    // Change the extension?
    if (options.ext) {
      destPath = destPath.replace(/(\.[^\/]*)?$/, options.ext);
    }
    // Generate destination filename.
    var dest = options.rename(destBase, destPath, options);
    // Prepend cwd to src path if necessary.
    if (options.cwd) { src = path.join(options.cwd, src); }
    // Normalize filepaths to be unix-style.
    dest = dest.replace(pathSeparatorRe, '/');
    src = src.replace(pathSeparatorRe, '/');
    // Map correct src path to dest path.
    if (fileByDest[dest]) {
      // If dest already exists, push this src onto that dest's src array.
      fileByDest[dest].src.push(src);
    } else {
      // Otherwise create a new src-dest file mapping object.
      files.push({
        src: [src],
        dest: dest,
      });
      // And store a reference for later use.
      fileByDest[dest] = files[files.length - 1];
    }
  });
  return files;
};

// reusing bits of grunt's multi-task source normalization
file.normalizeFilesArray = function(data) {
  var files = [];

  data.forEach(function(obj) {
    var prop;
    if ('src' in obj || 'dest' in obj) {
      files.push(obj);
    }
  });

  if (files.length === 0) {
    return [];
  }

  files = _(files).chain().forEach(function(obj) {
    if (!('src' in obj) || !obj.src) { return; }
    // Normalize .src properties to flattened array.
    if (Array.isArray(obj.src)) {
      obj.src = flatten(obj.src);
    } else {
      obj.src = [obj.src];
    }
  }).map(function(obj) {
    // Build options object, removing unwanted properties.
    var expandOptions = Object.assign({}, obj);
    delete expandOptions.src;
    delete expandOptions.dest;

    // Expand file mappings.
    if (obj.expand) {
      return file.expandMapping(obj.src, obj.dest, expandOptions).map(function(mapObj) {
        // Copy obj properties to result.
        var result = Object.assign({}, obj);
        // Make a clone of the orig obj available.
        result.orig = Object.assign({}, obj);
        // Set .src and .dest, processing both as templates.
        result.src = mapObj.src;
        result.dest = mapObj.dest;
        // Remove unwanted properties.
        ['expand', 'cwd', 'flatten', 'rename', 'ext'].forEach(function(prop) {
          delete result[prop];
        });
        return result;
      });
    }

    // Copy obj properties to result, adding an .orig property.
    var result = Object.assign({}, obj);
    // Make a clone of the orig obj available.
    result.orig = Object.assign({}, obj);

    if ('src' in result) {
      // Expose an expand-on-demand getter method as .src.
      Object.defineProperty(result, 'src', {
        enumerable: true,
        get: function fn() {
          var src;
          if (!('result' in fn)) {
            src = obj.src;
            // If src is an array, flatten it. Otherwise, make it into an array.
            src = Array.isArray(src) ? flatten(src) : [src];
            // Expand src files, memoizing result.
            fn.result = file.expand(expandOptions, src);
          }
          return fn.result;
        }
      });
    }

    if ('dest' in result) {
      result.dest = obj.dest;
    }

    return result;
  }).flatten().value();

  return files;
};


/***/ }),

/***/ 13672:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * archiver-utils
 *
 * Copyright (c) 2015 Chris Talkington.
 * Licensed under the MIT license.
 * https://github.com/archiverjs/archiver-utils/blob/master/LICENSE
 */
var fs = __webpack_require__(20077);
var path = __webpack_require__(71017);
var nutil = __webpack_require__(73837);
var lazystream = __webpack_require__(84150);
var normalizePath = __webpack_require__(13171);
var defaults = __webpack_require__(55402);

var Stream = (__webpack_require__(12781).Stream);
var PassThrough = (__webpack_require__(69754).PassThrough);

var utils = module.exports = {};
utils.file = __webpack_require__(74154);

function assertPath(path) {
  if (typeof path !== 'string') {
    throw new TypeError('Path must be a string. Received ' + nutils.inspect(path));
  }
}

utils.collectStream = function(source, callback) {
  var collection = [];
  var size = 0;

  source.on('error', callback);

  source.on('data', function(chunk) {
    collection.push(chunk);
    size += chunk.length;
  });

  source.on('end', function() {
    var buf = new Buffer(size);
    var offset = 0;

    collection.forEach(function(data) {
      data.copy(buf, offset);
      offset += data.length;
    });

    callback(null, buf);
  });
};

utils.dateify = function(dateish) {
  dateish = dateish || new Date();

  if (dateish instanceof Date) {
    dateish = dateish;
  } else if (typeof dateish === 'string') {
    dateish = new Date(dateish);
  } else {
    dateish = new Date();
  }

  return dateish;
};

// this is slightly different from lodash version
utils.defaults = function(object, source, guard) {
  var args = arguments;
  args[0] = args[0] || {};

  return defaults(...args);
};

utils.isStream = function(source) {
  return source instanceof Stream;
};

utils.lazyReadStream = function(filepath) {
  return new lazystream.Readable(function() {
    return fs.createReadStream(filepath);
  });
};

utils.normalizeInputSource = function(source) {
  if (source === null) {
    return new Buffer(0);
  } else if (typeof source === 'string') {
    return new Buffer(source);
  } else if (utils.isStream(source) && !source._readableState) {
    var normalized = new PassThrough();
    source.pipe(normalized);

    return normalized;
  }

  return source;
};

utils.sanitizePath = function(filepath) {
  return normalizePath(filepath, false).replace(/^\w+:/, '').replace(/^(\.\.\/|\/)+/, '');
};

utils.trailingSlashIt = function(str) {
  return str.slice(-1) !== '/' ? str + '/' : str;
};

utils.unixifyPath = function(filepath) {
  return normalizePath(filepath, false).replace(/^\w+:/, '');
};

utils.walkdir = function(dirpath, base, callback) {
  var results = [];

  if (typeof base === 'function') {
    callback = base;
    base = dirpath;
  }

  fs.readdir(dirpath, function(err, list) {
    var i = 0;
    var file;
    var filepath;

    if (err) {
      return callback(err);
    }

    (function next() {
      file = list[i++];

      if (!file) {
        return callback(null, results);
      }

      filepath = path.join(dirpath, file);

      fs.stat(filepath, function(err, stats) {
        results.push({
          path: filepath,
          relative: path.relative(base, filepath).replace(/\\/g, '/'),
          stats: stats
        });

        if (stats && stats.isDirectory()) {
          utils.walkdir(filepath, base, function(err, res) {
            res.forEach(function(dirEntry) {
              results.push(dirEntry);
            });
            next();
          });
        } else {
          next();
        }
      });
    })();
  });
};


/***/ }),

/***/ 66106:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a duplex stream is just a stream that is both readable and writable.
// Since JS doesn't have multiple prototypal inheritance, this class
// prototypally inherits from Readable, and then parasitically from
// Writable.



/*<replacement>*/

var pna = __webpack_require__(88212);
/*</replacement>*/

/*<replacement>*/
var objectKeys = Object.keys || function (obj) {
  var keys = [];
  for (var key in obj) {
    keys.push(key);
  }return keys;
};
/*</replacement>*/

module.exports = Duplex;

/*<replacement>*/
var util = Object.create(__webpack_require__(16497));
util.inherits = __webpack_require__(94378);
/*</replacement>*/

var Readable = __webpack_require__(97190);
var Writable = __webpack_require__(88223);

util.inherits(Duplex, Readable);

{
  // avoid scope creep, the keys array can then be collected
  var keys = objectKeys(Writable.prototype);
  for (var v = 0; v < keys.length; v++) {
    var method = keys[v];
    if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
  }
}

function Duplex(options) {
  if (!(this instanceof Duplex)) return new Duplex(options);

  Readable.call(this, options);
  Writable.call(this, options);

  if (options && options.readable === false) this.readable = false;

  if (options && options.writable === false) this.writable = false;

  this.allowHalfOpen = true;
  if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;

  this.once('end', onend);
}

Object.defineProperty(Duplex.prototype, 'writableHighWaterMark', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function () {
    return this._writableState.highWaterMark;
  }
});

// the no-half-open enforcer
function onend() {
  // if we allow half-open state, or if the writable side ended,
  // then we're ok.
  if (this.allowHalfOpen || this._writableState.ended) return;

  // no more data can be written.
  // But allow more writes to happen in this tick.
  pna.nextTick(onEndNT, this);
}

function onEndNT(self) {
  self.end();
}

Object.defineProperty(Duplex.prototype, 'destroyed', {
  get: function () {
    if (this._readableState === undefined || this._writableState === undefined) {
      return false;
    }
    return this._readableState.destroyed && this._writableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (this._readableState === undefined || this._writableState === undefined) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._readableState.destroyed = value;
    this._writableState.destroyed = value;
  }
});

Duplex.prototype._destroy = function (err, cb) {
  this.push(null);
  this.end();

  pna.nextTick(cb, err);
};

/***/ }),

/***/ 37592:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a passthrough stream.
// basically just the most minimal sort of Transform stream.
// Every written chunk gets output as-is.



module.exports = PassThrough;

var Transform = __webpack_require__(31289);

/*<replacement>*/
var util = Object.create(__webpack_require__(16497));
util.inherits = __webpack_require__(94378);
/*</replacement>*/

util.inherits(PassThrough, Transform);

function PassThrough(options) {
  if (!(this instanceof PassThrough)) return new PassThrough(options);

  Transform.call(this, options);
}

PassThrough.prototype._transform = function (chunk, encoding, cb) {
  cb(null, chunk);
};

/***/ }),

/***/ 97190:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



/*<replacement>*/

var pna = __webpack_require__(88212);
/*</replacement>*/

module.exports = Readable;

/*<replacement>*/
var isArray = __webpack_require__(5826);
/*</replacement>*/

/*<replacement>*/
var Duplex;
/*</replacement>*/

Readable.ReadableState = ReadableState;

/*<replacement>*/
var EE = (__webpack_require__(82361).EventEmitter);

var EElistenerCount = function (emitter, type) {
  return emitter.listeners(type).length;
};
/*</replacement>*/

/*<replacement>*/
var Stream = __webpack_require__(91581);
/*</replacement>*/

/*<replacement>*/

var Buffer = (__webpack_require__(89509).Buffer);
var OurUint8Array = (typeof global !== 'undefined' ? global : typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : {}).Uint8Array || function () {};
function _uint8ArrayToBuffer(chunk) {
  return Buffer.from(chunk);
}
function _isUint8Array(obj) {
  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
}

/*</replacement>*/

/*<replacement>*/
var util = Object.create(__webpack_require__(16497));
util.inherits = __webpack_require__(94378);
/*</replacement>*/

/*<replacement>*/
var debugUtil = __webpack_require__(73837);
var debug = void 0;
if (debugUtil && debugUtil.debuglog) {
  debug = debugUtil.debuglog('stream');
} else {
  debug = function () {};
}
/*</replacement>*/

var BufferList = __webpack_require__(25553);
var destroyImpl = __webpack_require__(1280);
var StringDecoder;

util.inherits(Readable, Stream);

var kProxyEvents = ['error', 'close', 'destroy', 'pause', 'resume'];

function prependListener(emitter, event, fn) {
  // Sadly this is not cacheable as some libraries bundle their own
  // event emitter implementation with them.
  if (typeof emitter.prependListener === 'function') return emitter.prependListener(event, fn);

  // This is a hack to make sure that our error handler is attached before any
  // userland ones.  NEVER DO THIS. This is here only because this code needs
  // to continue to work with older versions of Node.js that do not include
  // the prependListener() method. The goal is to eventually remove this hack.
  if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);else if (isArray(emitter._events[event])) emitter._events[event].unshift(fn);else emitter._events[event] = [fn, emitter._events[event]];
}

function ReadableState(options, stream) {
  Duplex = Duplex || __webpack_require__(66106);

  options = options || {};

  // Duplex streams are both readable and writable, but share
  // the same options object.
  // However, some cases require setting options to different
  // values for the readable and the writable sides of the duplex stream.
  // These options can be provided separately as readableXXX and writableXXX.
  var isDuplex = stream instanceof Duplex;

  // object stream flag. Used to make read(n) ignore n and to
  // make all the buffer merging and length checks go away
  this.objectMode = !!options.objectMode;

  if (isDuplex) this.objectMode = this.objectMode || !!options.readableObjectMode;

  // the point at which it stops calling _read() to fill the buffer
  // Note: 0 is a valid value, means "don't call _read preemptively ever"
  var hwm = options.highWaterMark;
  var readableHwm = options.readableHighWaterMark;
  var defaultHwm = this.objectMode ? 16 : 16 * 1024;

  if (hwm || hwm === 0) this.highWaterMark = hwm;else if (isDuplex && (readableHwm || readableHwm === 0)) this.highWaterMark = readableHwm;else this.highWaterMark = defaultHwm;

  // cast to ints.
  this.highWaterMark = Math.floor(this.highWaterMark);

  // A linked list is used to store data chunks instead of an array because the
  // linked list can remove elements from the beginning faster than
  // array.shift()
  this.buffer = new BufferList();
  this.length = 0;
  this.pipes = null;
  this.pipesCount = 0;
  this.flowing = null;
  this.ended = false;
  this.endEmitted = false;
  this.reading = false;

  // a flag to be able to tell if the event 'readable'/'data' is emitted
  // immediately, or on a later tick.  We set this to true at first, because
  // any actions that shouldn't happen until "later" should generally also
  // not happen before the first read call.
  this.sync = true;

  // whenever we return null, then we set a flag to say
  // that we're awaiting a 'readable' event emission.
  this.needReadable = false;
  this.emittedReadable = false;
  this.readableListening = false;
  this.resumeScheduled = false;

  // has it been destroyed
  this.destroyed = false;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // the number of writers that are awaiting a drain event in .pipe()s
  this.awaitDrain = 0;

  // if true, a maybeReadMore has been scheduled
  this.readingMore = false;

  this.decoder = null;
  this.encoding = null;
  if (options.encoding) {
    if (!StringDecoder) StringDecoder = (__webpack_require__(32553)/* .StringDecoder */ .s);
    this.decoder = new StringDecoder(options.encoding);
    this.encoding = options.encoding;
  }
}

function Readable(options) {
  Duplex = Duplex || __webpack_require__(66106);

  if (!(this instanceof Readable)) return new Readable(options);

  this._readableState = new ReadableState(options, this);

  // legacy
  this.readable = true;

  if (options) {
    if (typeof options.read === 'function') this._read = options.read;

    if (typeof options.destroy === 'function') this._destroy = options.destroy;
  }

  Stream.call(this);
}

Object.defineProperty(Readable.prototype, 'destroyed', {
  get: function () {
    if (this._readableState === undefined) {
      return false;
    }
    return this._readableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (!this._readableState) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._readableState.destroyed = value;
  }
});

Readable.prototype.destroy = destroyImpl.destroy;
Readable.prototype._undestroy = destroyImpl.undestroy;
Readable.prototype._destroy = function (err, cb) {
  this.push(null);
  cb(err);
};

// Manually shove something into the read() buffer.
// This returns true if the highWaterMark has not been hit yet,
// similar to how Writable.write() returns true if you should
// write() some more.
Readable.prototype.push = function (chunk, encoding) {
  var state = this._readableState;
  var skipChunkCheck;

  if (!state.objectMode) {
    if (typeof chunk === 'string') {
      encoding = encoding || state.defaultEncoding;
      if (encoding !== state.encoding) {
        chunk = Buffer.from(chunk, encoding);
        encoding = '';
      }
      skipChunkCheck = true;
    }
  } else {
    skipChunkCheck = true;
  }

  return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
};

// Unshift should *always* be something directly out of read()
Readable.prototype.unshift = function (chunk) {
  return readableAddChunk(this, chunk, null, true, false);
};

function readableAddChunk(stream, chunk, encoding, addToFront, skipChunkCheck) {
  var state = stream._readableState;
  if (chunk === null) {
    state.reading = false;
    onEofChunk(stream, state);
  } else {
    var er;
    if (!skipChunkCheck) er = chunkInvalid(state, chunk);
    if (er) {
      stream.emit('error', er);
    } else if (state.objectMode || chunk && chunk.length > 0) {
      if (typeof chunk !== 'string' && !state.objectMode && Object.getPrototypeOf(chunk) !== Buffer.prototype) {
        chunk = _uint8ArrayToBuffer(chunk);
      }

      if (addToFront) {
        if (state.endEmitted) stream.emit('error', new Error('stream.unshift() after end event'));else addChunk(stream, state, chunk, true);
      } else if (state.ended) {
        stream.emit('error', new Error('stream.push() after EOF'));
      } else {
        state.reading = false;
        if (state.decoder && !encoding) {
          chunk = state.decoder.write(chunk);
          if (state.objectMode || chunk.length !== 0) addChunk(stream, state, chunk, false);else maybeReadMore(stream, state);
        } else {
          addChunk(stream, state, chunk, false);
        }
      }
    } else if (!addToFront) {
      state.reading = false;
    }
  }

  return needMoreData(state);
}

function addChunk(stream, state, chunk, addToFront) {
  if (state.flowing && state.length === 0 && !state.sync) {
    stream.emit('data', chunk);
    stream.read(0);
  } else {
    // update the buffer info.
    state.length += state.objectMode ? 1 : chunk.length;
    if (addToFront) state.buffer.unshift(chunk);else state.buffer.push(chunk);

    if (state.needReadable) emitReadable(stream);
  }
  maybeReadMore(stream, state);
}

function chunkInvalid(state, chunk) {
  var er;
  if (!_isUint8Array(chunk) && typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
    er = new TypeError('Invalid non-string/buffer chunk');
  }
  return er;
}

// if it's past the high water mark, we can push in some more.
// Also, if we have no data yet, we can stand some
// more bytes.  This is to work around cases where hwm=0,
// such as the repl.  Also, if the push() triggered a
// readable event, and the user called read(largeNumber) such that
// needReadable was set, then we ought to push more, so that another
// 'readable' event will be triggered.
function needMoreData(state) {
  return !state.ended && (state.needReadable || state.length < state.highWaterMark || state.length === 0);
}

Readable.prototype.isPaused = function () {
  return this._readableState.flowing === false;
};

// backwards compatibility.
Readable.prototype.setEncoding = function (enc) {
  if (!StringDecoder) StringDecoder = (__webpack_require__(32553)/* .StringDecoder */ .s);
  this._readableState.decoder = new StringDecoder(enc);
  this._readableState.encoding = enc;
  return this;
};

// Don't raise the hwm > 8MB
var MAX_HWM = 0x800000;
function computeNewHighWaterMark(n) {
  if (n >= MAX_HWM) {
    n = MAX_HWM;
  } else {
    // Get the next highest power of 2 to prevent increasing hwm excessively in
    // tiny amounts
    n--;
    n |= n >>> 1;
    n |= n >>> 2;
    n |= n >>> 4;
    n |= n >>> 8;
    n |= n >>> 16;
    n++;
  }
  return n;
}

// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function howMuchToRead(n, state) {
  if (n <= 0 || state.length === 0 && state.ended) return 0;
  if (state.objectMode) return 1;
  if (n !== n) {
    // Only flow one buffer at a time
    if (state.flowing && state.length) return state.buffer.head.data.length;else return state.length;
  }
  // If we're asking for more than the current hwm, then raise the hwm.
  if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
  if (n <= state.length) return n;
  // Don't have enough
  if (!state.ended) {
    state.needReadable = true;
    return 0;
  }
  return state.length;
}

// you can override either this method, or the async _read(n) below.
Readable.prototype.read = function (n) {
  debug('read', n);
  n = parseInt(n, 10);
  var state = this._readableState;
  var nOrig = n;

  if (n !== 0) state.emittedReadable = false;

  // if we're doing read(0) to trigger a readable event, but we
  // already have a bunch of data in the buffer, then just trigger
  // the 'readable' event and move on.
  if (n === 0 && state.needReadable && (state.length >= state.highWaterMark || state.ended)) {
    debug('read: emitReadable', state.length, state.ended);
    if (state.length === 0 && state.ended) endReadable(this);else emitReadable(this);
    return null;
  }

  n = howMuchToRead(n, state);

  // if we've ended, and we're now clear, then finish it up.
  if (n === 0 && state.ended) {
    if (state.length === 0) endReadable(this);
    return null;
  }

  // All the actual chunk generation logic needs to be
  // *below* the call to _read.  The reason is that in certain
  // synthetic stream cases, such as passthrough streams, _read
  // may be a completely synchronous operation which may change
  // the state of the read buffer, providing enough data when
  // before there was *not* enough.
  //
  // So, the steps are:
  // 1. Figure out what the state of things will be after we do
  // a read from the buffer.
  //
  // 2. If that resulting state will trigger a _read, then call _read.
  // Note that this may be asynchronous, or synchronous.  Yes, it is
  // deeply ugly to write APIs this way, but that still doesn't mean
  // that the Readable class should behave improperly, as streams are
  // designed to be sync/async agnostic.
  // Take note if the _read call is sync or async (ie, if the read call
  // has returned yet), so that we know whether or not it's safe to emit
  // 'readable' etc.
  //
  // 3. Actually pull the requested chunks out of the buffer and return.

  // if we need a readable event, then we need to do some reading.
  var doRead = state.needReadable;
  debug('need readable', doRead);

  // if we currently have less than the highWaterMark, then also read some
  if (state.length === 0 || state.length - n < state.highWaterMark) {
    doRead = true;
    debug('length less than watermark', doRead);
  }

  // however, if we've ended, then there's no point, and if we're already
  // reading, then it's unnecessary.
  if (state.ended || state.reading) {
    doRead = false;
    debug('reading or ended', doRead);
  } else if (doRead) {
    debug('do read');
    state.reading = true;
    state.sync = true;
    // if the length is currently zero, then we *need* a readable event.
    if (state.length === 0) state.needReadable = true;
    // call internal read method
    this._read(state.highWaterMark);
    state.sync = false;
    // If _read pushed data synchronously, then `reading` will be false,
    // and we need to re-evaluate how much data we can return to the user.
    if (!state.reading) n = howMuchToRead(nOrig, state);
  }

  var ret;
  if (n > 0) ret = fromList(n, state);else ret = null;

  if (ret === null) {
    state.needReadable = true;
    n = 0;
  } else {
    state.length -= n;
  }

  if (state.length === 0) {
    // If we have nothing in the buffer, then we want to know
    // as soon as we *do* get something into the buffer.
    if (!state.ended) state.needReadable = true;

    // If we tried to read() past the EOF, then emit end on the next tick.
    if (nOrig !== n && state.ended) endReadable(this);
  }

  if (ret !== null) this.emit('data', ret);

  return ret;
};

function onEofChunk(stream, state) {
  if (state.ended) return;
  if (state.decoder) {
    var chunk = state.decoder.end();
    if (chunk && chunk.length) {
      state.buffer.push(chunk);
      state.length += state.objectMode ? 1 : chunk.length;
    }
  }
  state.ended = true;

  // emit 'readable' now to make sure it gets picked up.
  emitReadable(stream);
}

// Don't emit readable right away in sync mode, because this can trigger
// another read() call => stack overflow.  This way, it might trigger
// a nextTick recursion warning, but that's not so bad.
function emitReadable(stream) {
  var state = stream._readableState;
  state.needReadable = false;
  if (!state.emittedReadable) {
    debug('emitReadable', state.flowing);
    state.emittedReadable = true;
    if (state.sync) pna.nextTick(emitReadable_, stream);else emitReadable_(stream);
  }
}

function emitReadable_(stream) {
  debug('emit readable');
  stream.emit('readable');
  flow(stream);
}

// at this point, the user has presumably seen the 'readable' event,
// and called read() to consume some data.  that may have triggered
// in turn another _read(n) call, in which case reading = true if
// it's in progress.
// However, if we're not ended, or reading, and the length < hwm,
// then go ahead and try to read some more preemptively.
function maybeReadMore(stream, state) {
  if (!state.readingMore) {
    state.readingMore = true;
    pna.nextTick(maybeReadMore_, stream, state);
  }
}

function maybeReadMore_(stream, state) {
  var len = state.length;
  while (!state.reading && !state.flowing && !state.ended && state.length < state.highWaterMark) {
    debug('maybeReadMore read 0');
    stream.read(0);
    if (len === state.length)
      // didn't get any data, stop spinning.
      break;else len = state.length;
  }
  state.readingMore = false;
}

// abstract method.  to be overridden in specific implementation classes.
// call cb(er, data) where data is <= n in length.
// for virtual (non-string, non-buffer) streams, "length" is somewhat
// arbitrary, and perhaps not very meaningful.
Readable.prototype._read = function (n) {
  this.emit('error', new Error('_read() is not implemented'));
};

Readable.prototype.pipe = function (dest, pipeOpts) {
  var src = this;
  var state = this._readableState;

  switch (state.pipesCount) {
    case 0:
      state.pipes = dest;
      break;
    case 1:
      state.pipes = [state.pipes, dest];
      break;
    default:
      state.pipes.push(dest);
      break;
  }
  state.pipesCount += 1;
  debug('pipe count=%d opts=%j', state.pipesCount, pipeOpts);

  var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;

  var endFn = doEnd ? onend : unpipe;
  if (state.endEmitted) pna.nextTick(endFn);else src.once('end', endFn);

  dest.on('unpipe', onunpipe);
  function onunpipe(readable, unpipeInfo) {
    debug('onunpipe');
    if (readable === src) {
      if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
        unpipeInfo.hasUnpiped = true;
        cleanup();
      }
    }
  }

  function onend() {
    debug('onend');
    dest.end();
  }

  // when the dest drains, it reduces the awaitDrain counter
  // on the source.  This would be more elegant with a .once()
  // handler in flow(), but adding and removing repeatedly is
  // too slow.
  var ondrain = pipeOnDrain(src);
  dest.on('drain', ondrain);

  var cleanedUp = false;
  function cleanup() {
    debug('cleanup');
    // cleanup event handlers once the pipe is broken
    dest.removeListener('close', onclose);
    dest.removeListener('finish', onfinish);
    dest.removeListener('drain', ondrain);
    dest.removeListener('error', onerror);
    dest.removeListener('unpipe', onunpipe);
    src.removeListener('end', onend);
    src.removeListener('end', unpipe);
    src.removeListener('data', ondata);

    cleanedUp = true;

    // if the reader is waiting for a drain event from this
    // specific writer, then it would cause it to never start
    // flowing again.
    // So, if this is awaiting a drain, then we just call it now.
    // If we don't know, then assume that we are waiting for one.
    if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
  }

  // If the user pushes more data while we're writing to dest then we'll end up
  // in ondata again. However, we only want to increase awaitDrain once because
  // dest will only emit one 'drain' event for the multiple writes.
  // => Introduce a guard on increasing awaitDrain.
  var increasedAwaitDrain = false;
  src.on('data', ondata);
  function ondata(chunk) {
    debug('ondata');
    increasedAwaitDrain = false;
    var ret = dest.write(chunk);
    if (false === ret && !increasedAwaitDrain) {
      // If the user unpiped during `dest.write()`, it is possible
      // to get stuck in a permanently paused state if that write
      // also returned false.
      // => Check whether `dest` is still a piping destination.
      if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
        debug('false write response, pause', state.awaitDrain);
        state.awaitDrain++;
        increasedAwaitDrain = true;
      }
      src.pause();
    }
  }

  // if the dest has an error, then stop piping into it.
  // however, don't suppress the throwing behavior for this.
  function onerror(er) {
    debug('onerror', er);
    unpipe();
    dest.removeListener('error', onerror);
    if (EElistenerCount(dest, 'error') === 0) dest.emit('error', er);
  }

  // Make sure our error handler is attached before userland ones.
  prependListener(dest, 'error', onerror);

  // Both close and finish should trigger unpipe, but only once.
  function onclose() {
    dest.removeListener('finish', onfinish);
    unpipe();
  }
  dest.once('close', onclose);
  function onfinish() {
    debug('onfinish');
    dest.removeListener('close', onclose);
    unpipe();
  }
  dest.once('finish', onfinish);

  function unpipe() {
    debug('unpipe');
    src.unpipe(dest);
  }

  // tell the dest that it's being piped to
  dest.emit('pipe', src);

  // start the flow if it hasn't been started already.
  if (!state.flowing) {
    debug('pipe resume');
    src.resume();
  }

  return dest;
};

function pipeOnDrain(src) {
  return function () {
    var state = src._readableState;
    debug('pipeOnDrain', state.awaitDrain);
    if (state.awaitDrain) state.awaitDrain--;
    if (state.awaitDrain === 0 && EElistenerCount(src, 'data')) {
      state.flowing = true;
      flow(src);
    }
  };
}

Readable.prototype.unpipe = function (dest) {
  var state = this._readableState;
  var unpipeInfo = { hasUnpiped: false };

  // if we're not piping anywhere, then do nothing.
  if (state.pipesCount === 0) return this;

  // just one destination.  most common case.
  if (state.pipesCount === 1) {
    // passed in one, but it's not the right one.
    if (dest && dest !== state.pipes) return this;

    if (!dest) dest = state.pipes;

    // got a match.
    state.pipes = null;
    state.pipesCount = 0;
    state.flowing = false;
    if (dest) dest.emit('unpipe', this, unpipeInfo);
    return this;
  }

  // slow case. multiple pipe destinations.

  if (!dest) {
    // remove all.
    var dests = state.pipes;
    var len = state.pipesCount;
    state.pipes = null;
    state.pipesCount = 0;
    state.flowing = false;

    for (var i = 0; i < len; i++) {
      dests[i].emit('unpipe', this, { hasUnpiped: false });
    }return this;
  }

  // try to find the right one.
  var index = indexOf(state.pipes, dest);
  if (index === -1) return this;

  state.pipes.splice(index, 1);
  state.pipesCount -= 1;
  if (state.pipesCount === 1) state.pipes = state.pipes[0];

  dest.emit('unpipe', this, unpipeInfo);

  return this;
};

// set up data events if they are asked for
// Ensure readable listeners eventually get something
Readable.prototype.on = function (ev, fn) {
  var res = Stream.prototype.on.call(this, ev, fn);

  if (ev === 'data') {
    // Start flowing on next tick if stream isn't explicitly paused
    if (this._readableState.flowing !== false) this.resume();
  } else if (ev === 'readable') {
    var state = this._readableState;
    if (!state.endEmitted && !state.readableListening) {
      state.readableListening = state.needReadable = true;
      state.emittedReadable = false;
      if (!state.reading) {
        pna.nextTick(nReadingNextTick, this);
      } else if (state.length) {
        emitReadable(this);
      }
    }
  }

  return res;
};
Readable.prototype.addListener = Readable.prototype.on;

function nReadingNextTick(self) {
  debug('readable nexttick read 0');
  self.read(0);
}

// pause() and resume() are remnants of the legacy readable stream API
// If the user uses them, then switch into old mode.
Readable.prototype.resume = function () {
  var state = this._readableState;
  if (!state.flowing) {
    debug('resume');
    state.flowing = true;
    resume(this, state);
  }
  return this;
};

function resume(stream, state) {
  if (!state.resumeScheduled) {
    state.resumeScheduled = true;
    pna.nextTick(resume_, stream, state);
  }
}

function resume_(stream, state) {
  if (!state.reading) {
    debug('resume read 0');
    stream.read(0);
  }

  state.resumeScheduled = false;
  state.awaitDrain = 0;
  stream.emit('resume');
  flow(stream);
  if (state.flowing && !state.reading) stream.read(0);
}

Readable.prototype.pause = function () {
  debug('call pause flowing=%j', this._readableState.flowing);
  if (false !== this._readableState.flowing) {
    debug('pause');
    this._readableState.flowing = false;
    this.emit('pause');
  }
  return this;
};

function flow(stream) {
  var state = stream._readableState;
  debug('flow', state.flowing);
  while (state.flowing && stream.read() !== null) {}
}

// wrap an old-style stream as the async data source.
// This is *not* part of the readable stream interface.
// It is an ugly unfortunate mess of history.
Readable.prototype.wrap = function (stream) {
  var _this = this;

  var state = this._readableState;
  var paused = false;

  stream.on('end', function () {
    debug('wrapped end');
    if (state.decoder && !state.ended) {
      var chunk = state.decoder.end();
      if (chunk && chunk.length) _this.push(chunk);
    }

    _this.push(null);
  });

  stream.on('data', function (chunk) {
    debug('wrapped data');
    if (state.decoder) chunk = state.decoder.write(chunk);

    // don't skip over falsy values in objectMode
    if (state.objectMode && (chunk === null || chunk === undefined)) return;else if (!state.objectMode && (!chunk || !chunk.length)) return;

    var ret = _this.push(chunk);
    if (!ret) {
      paused = true;
      stream.pause();
    }
  });

  // proxy all the other methods.
  // important when wrapping filters and duplexes.
  for (var i in stream) {
    if (this[i] === undefined && typeof stream[i] === 'function') {
      this[i] = function (method) {
        return function () {
          return stream[method].apply(stream, arguments);
        };
      }(i);
    }
  }

  // proxy certain important events.
  for (var n = 0; n < kProxyEvents.length; n++) {
    stream.on(kProxyEvents[n], this.emit.bind(this, kProxyEvents[n]));
  }

  // when we try to consume some more bytes, simply unpause the
  // underlying stream.
  this._read = function (n) {
    debug('wrapped _read', n);
    if (paused) {
      paused = false;
      stream.resume();
    }
  };

  return this;
};

Object.defineProperty(Readable.prototype, 'readableHighWaterMark', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function () {
    return this._readableState.highWaterMark;
  }
});

// exposed for testing purposes only.
Readable._fromList = fromList;

// Pluck off n bytes from an array of buffers.
// Length is the combined lengths of all the buffers in the list.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function fromList(n, state) {
  // nothing buffered
  if (state.length === 0) return null;

  var ret;
  if (state.objectMode) ret = state.buffer.shift();else if (!n || n >= state.length) {
    // read it all, truncate the list
    if (state.decoder) ret = state.buffer.join('');else if (state.buffer.length === 1) ret = state.buffer.head.data;else ret = state.buffer.concat(state.length);
    state.buffer.clear();
  } else {
    // read part of list
    ret = fromListPartial(n, state.buffer, state.decoder);
  }

  return ret;
}

// Extracts only enough buffered data to satisfy the amount requested.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function fromListPartial(n, list, hasStrings) {
  var ret;
  if (n < list.head.data.length) {
    // slice is the same for buffers and strings
    ret = list.head.data.slice(0, n);
    list.head.data = list.head.data.slice(n);
  } else if (n === list.head.data.length) {
    // first chunk is a perfect match
    ret = list.shift();
  } else {
    // result spans more than one buffer
    ret = hasStrings ? copyFromBufferString(n, list) : copyFromBuffer(n, list);
  }
  return ret;
}

// Copies a specified amount of characters from the list of buffered data
// chunks.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function copyFromBufferString(n, list) {
  var p = list.head;
  var c = 1;
  var ret = p.data;
  n -= ret.length;
  while (p = p.next) {
    var str = p.data;
    var nb = n > str.length ? str.length : n;
    if (nb === str.length) ret += str;else ret += str.slice(0, n);
    n -= nb;
    if (n === 0) {
      if (nb === str.length) {
        ++c;
        if (p.next) list.head = p.next;else list.head = list.tail = null;
      } else {
        list.head = p;
        p.data = str.slice(nb);
      }
      break;
    }
    ++c;
  }
  list.length -= c;
  return ret;
}

// Copies a specified amount of bytes from the list of buffered data chunks.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function copyFromBuffer(n, list) {
  var ret = Buffer.allocUnsafe(n);
  var p = list.head;
  var c = 1;
  p.data.copy(ret);
  n -= p.data.length;
  while (p = p.next) {
    var buf = p.data;
    var nb = n > buf.length ? buf.length : n;
    buf.copy(ret, ret.length - n, 0, nb);
    n -= nb;
    if (n === 0) {
      if (nb === buf.length) {
        ++c;
        if (p.next) list.head = p.next;else list.head = list.tail = null;
      } else {
        list.head = p;
        p.data = buf.slice(nb);
      }
      break;
    }
    ++c;
  }
  list.length -= c;
  return ret;
}

function endReadable(stream) {
  var state = stream._readableState;

  // If we get here before consuming all the bytes, then that is a
  // bug in node.  Should never happen.
  if (state.length > 0) throw new Error('"endReadable()" called on non-empty stream');

  if (!state.endEmitted) {
    state.ended = true;
    pna.nextTick(endReadableNT, state, stream);
  }
}

function endReadableNT(state, stream) {
  // Check that we didn't get one last unshift.
  if (!state.endEmitted && state.length === 0) {
    state.endEmitted = true;
    stream.readable = false;
    stream.emit('end');
  }
}

function indexOf(xs, x) {
  for (var i = 0, l = xs.length; i < l; i++) {
    if (xs[i] === x) return i;
  }
  return -1;
}

/***/ }),

/***/ 31289:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a transform stream is a readable/writable stream where you do
// something with the data.  Sometimes it's called a "filter",
// but that's not a great name for it, since that implies a thing where
// some bits pass through, and others are simply ignored.  (That would
// be a valid example of a transform, of course.)
//
// While the output is causally related to the input, it's not a
// necessarily symmetric or synchronous transformation.  For example,
// a zlib stream might take multiple plain-text writes(), and then
// emit a single compressed chunk some time in the future.
//
// Here's how this works:
//
// The Transform stream has all the aspects of the readable and writable
// stream classes.  When you write(chunk), that calls _write(chunk,cb)
// internally, and returns false if there's a lot of pending writes
// buffered up.  When you call read(), that calls _read(n) until
// there's enough pending readable data buffered up.
//
// In a transform stream, the written data is placed in a buffer.  When
// _read(n) is called, it transforms the queued up data, calling the
// buffered _write cb's as it consumes chunks.  If consuming a single
// written chunk would result in multiple output chunks, then the first
// outputted bit calls the readcb, and subsequent chunks just go into
// the read buffer, and will cause it to emit 'readable' if necessary.
//
// This way, back-pressure is actually determined by the reading side,
// since _read has to be called to start processing a new chunk.  However,
// a pathological inflate type of transform can cause excessive buffering
// here.  For example, imagine a stream where every byte of input is
// interpreted as an integer from 0-255, and then results in that many
// bytes of output.  Writing the 4 bytes {ff,ff,ff,ff} would result in
// 1kb of data being output.  In this case, you could write a very small
// amount of input, and end up with a very large amount of output.  In
// such a pathological inflating mechanism, there'd be no way to tell
// the system to stop doing the transform.  A single 4MB write could
// cause the system to run out of memory.
//
// However, even in such a pathological case, only a single written chunk
// would be consumed, and then the rest would wait (un-transformed) until
// the results of the previous transformed chunk were consumed.



module.exports = Transform;

var Duplex = __webpack_require__(66106);

/*<replacement>*/
var util = Object.create(__webpack_require__(16497));
util.inherits = __webpack_require__(94378);
/*</replacement>*/

util.inherits(Transform, Duplex);

function afterTransform(er, data) {
  var ts = this._transformState;
  ts.transforming = false;

  var cb = ts.writecb;

  if (!cb) {
    return this.emit('error', new Error('write callback called multiple times'));
  }

  ts.writechunk = null;
  ts.writecb = null;

  if (data != null) // single equals check for both `null` and `undefined`
    this.push(data);

  cb(er);

  var rs = this._readableState;
  rs.reading = false;
  if (rs.needReadable || rs.length < rs.highWaterMark) {
    this._read(rs.highWaterMark);
  }
}

function Transform(options) {
  if (!(this instanceof Transform)) return new Transform(options);

  Duplex.call(this, options);

  this._transformState = {
    afterTransform: afterTransform.bind(this),
    needTransform: false,
    transforming: false,
    writecb: null,
    writechunk: null,
    writeencoding: null
  };

  // start out asking for a readable event once data is transformed.
  this._readableState.needReadable = true;

  // we have implemented the _read method, and done the other things
  // that Readable wants before the first _read call, so unset the
  // sync guard flag.
  this._readableState.sync = false;

  if (options) {
    if (typeof options.transform === 'function') this._transform = options.transform;

    if (typeof options.flush === 'function') this._flush = options.flush;
  }

  // When the writable side finishes, then flush out anything remaining.
  this.on('prefinish', prefinish);
}

function prefinish() {
  var _this = this;

  if (typeof this._flush === 'function') {
    this._flush(function (er, data) {
      done(_this, er, data);
    });
  } else {
    done(this, null, null);
  }
}

Transform.prototype.push = function (chunk, encoding) {
  this._transformState.needTransform = false;
  return Duplex.prototype.push.call(this, chunk, encoding);
};

// This is the part where you do stuff!
// override this function in implementation classes.
// 'chunk' is an input chunk.
//
// Call `push(newChunk)` to pass along transformed output
// to the readable side.  You may call 'push' zero or more times.
//
// Call `cb(err)` when you are done with this chunk.  If you pass
// an error, then that'll put the hurt on the whole operation.  If you
// never call cb(), then you'll never get another chunk.
Transform.prototype._transform = function (chunk, encoding, cb) {
  throw new Error('_transform() is not implemented');
};

Transform.prototype._write = function (chunk, encoding, cb) {
  var ts = this._transformState;
  ts.writecb = cb;
  ts.writechunk = chunk;
  ts.writeencoding = encoding;
  if (!ts.transforming) {
    var rs = this._readableState;
    if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
  }
};

// Doesn't matter what the args are here.
// _transform does all the work.
// That we got here means that the readable side wants more data.
Transform.prototype._read = function (n) {
  var ts = this._transformState;

  if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
    ts.transforming = true;
    this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
  } else {
    // mark that we need a transform, so that any data that comes in
    // will get processed, now that we've asked for it.
    ts.needTransform = true;
  }
};

Transform.prototype._destroy = function (err, cb) {
  var _this2 = this;

  Duplex.prototype._destroy.call(this, err, function (err2) {
    cb(err2);
    _this2.emit('close');
  });
};

function done(stream, er, data) {
  if (er) return stream.emit('error', er);

  if (data != null) // single equals check for both `null` and `undefined`
    stream.push(data);

  // if there's nothing in the write buffer, then that means
  // that nothing more will ever be provided
  if (stream._writableState.length) throw new Error('Calling transform done when ws.length != 0');

  if (stream._transformState.transforming) throw new Error('Calling transform done when still transforming');

  return stream.push(null);
}

/***/ }),

/***/ 88223:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// A bit simpler than readable streams.
// Implement an async ._write(chunk, encoding, cb), and it'll handle all
// the drain event emission and buffering.



/*<replacement>*/

var pna = __webpack_require__(88212);
/*</replacement>*/

module.exports = Writable;

/* <replacement> */
function WriteReq(chunk, encoding, cb) {
  this.chunk = chunk;
  this.encoding = encoding;
  this.callback = cb;
  this.next = null;
}

// It seems a linked list but it is not
// there will be only 2 of these for each stream
function CorkedRequest(state) {
  var _this = this;

  this.next = null;
  this.entry = null;
  this.finish = function () {
    onCorkedFinish(_this, state);
  };
}
/* </replacement> */

/*<replacement>*/
var asyncWrite = !process.browser && ['v0.10', 'v0.9.'].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : pna.nextTick;
/*</replacement>*/

/*<replacement>*/
var Duplex;
/*</replacement>*/

Writable.WritableState = WritableState;

/*<replacement>*/
var util = Object.create(__webpack_require__(16497));
util.inherits = __webpack_require__(94378);
/*</replacement>*/

/*<replacement>*/
var internalUtil = {
  deprecate: __webpack_require__(41159)
};
/*</replacement>*/

/*<replacement>*/
var Stream = __webpack_require__(91581);
/*</replacement>*/

/*<replacement>*/

var Buffer = (__webpack_require__(89509).Buffer);
var OurUint8Array = (typeof global !== 'undefined' ? global : typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : {}).Uint8Array || function () {};
function _uint8ArrayToBuffer(chunk) {
  return Buffer.from(chunk);
}
function _isUint8Array(obj) {
  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
}

/*</replacement>*/

var destroyImpl = __webpack_require__(1280);

util.inherits(Writable, Stream);

function nop() {}

function WritableState(options, stream) {
  Duplex = Duplex || __webpack_require__(66106);

  options = options || {};

  // Duplex streams are both readable and writable, but share
  // the same options object.
  // However, some cases require setting options to different
  // values for the readable and the writable sides of the duplex stream.
  // These options can be provided separately as readableXXX and writableXXX.
  var isDuplex = stream instanceof Duplex;

  // object stream flag to indicate whether or not this stream
  // contains buffers or objects.
  this.objectMode = !!options.objectMode;

  if (isDuplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

  // the point at which write() starts returning false
  // Note: 0 is a valid value, means that we always return false if
  // the entire buffer is not flushed immediately on write()
  var hwm = options.highWaterMark;
  var writableHwm = options.writableHighWaterMark;
  var defaultHwm = this.objectMode ? 16 : 16 * 1024;

  if (hwm || hwm === 0) this.highWaterMark = hwm;else if (isDuplex && (writableHwm || writableHwm === 0)) this.highWaterMark = writableHwm;else this.highWaterMark = defaultHwm;

  // cast to ints.
  this.highWaterMark = Math.floor(this.highWaterMark);

  // if _final has been called
  this.finalCalled = false;

  // drain event flag.
  this.needDrain = false;
  // at the start of calling end()
  this.ending = false;
  // when end() has been called, and returned
  this.ended = false;
  // when 'finish' is emitted
  this.finished = false;

  // has it been destroyed
  this.destroyed = false;

  // should we decode strings into buffers before passing to _write?
  // this is here so that some node-core streams can optimize string
  // handling at a lower level.
  var noDecode = options.decodeStrings === false;
  this.decodeStrings = !noDecode;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // not an actual buffer we keep track of, but a measurement
  // of how much we're waiting to get pushed to some underlying
  // socket or file.
  this.length = 0;

  // a flag to see when we're in the middle of a write.
  this.writing = false;

  // when true all writes will be buffered until .uncork() call
  this.corked = 0;

  // a flag to be able to tell if the onwrite cb is called immediately,
  // or on a later tick.  We set this to true at first, because any
  // actions that shouldn't happen until "later" should generally also
  // not happen before the first write call.
  this.sync = true;

  // a flag to know if we're processing previously buffered items, which
  // may call the _write() callback in the same tick, so that we don't
  // end up in an overlapped onwrite situation.
  this.bufferProcessing = false;

  // the callback that's passed to _write(chunk,cb)
  this.onwrite = function (er) {
    onwrite(stream, er);
  };

  // the callback that the user supplies to write(chunk,encoding,cb)
  this.writecb = null;

  // the amount that is being written when _write is called.
  this.writelen = 0;

  this.bufferedRequest = null;
  this.lastBufferedRequest = null;

  // number of pending user-supplied write callbacks
  // this must be 0 before 'finish' can be emitted
  this.pendingcb = 0;

  // emit prefinish if the only thing we're waiting for is _write cbs
  // This is relevant for synchronous Transform streams
  this.prefinished = false;

  // True if the error was already emitted and should not be thrown again
  this.errorEmitted = false;

  // count buffered requests
  this.bufferedRequestCount = 0;

  // allocate the first CorkedRequest, there is always
  // one allocated and free to use, and we maintain at most two
  this.corkedRequestsFree = new CorkedRequest(this);
}

WritableState.prototype.getBuffer = function getBuffer() {
  var current = this.bufferedRequest;
  var out = [];
  while (current) {
    out.push(current);
    current = current.next;
  }
  return out;
};

(function () {
  try {
    Object.defineProperty(WritableState.prototype, 'buffer', {
      get: internalUtil.deprecate(function () {
        return this.getBuffer();
      }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
    });
  } catch (_) {}
})();

// Test _writableState for inheritance to account for Duplex streams,
// whose prototype chain only points to Readable.
var realHasInstance;
if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
  realHasInstance = Function.prototype[Symbol.hasInstance];
  Object.defineProperty(Writable, Symbol.hasInstance, {
    value: function (object) {
      if (realHasInstance.call(this, object)) return true;
      if (this !== Writable) return false;

      return object && object._writableState instanceof WritableState;
    }
  });
} else {
  realHasInstance = function (object) {
    return object instanceof this;
  };
}

function Writable(options) {
  Duplex = Duplex || __webpack_require__(66106);

  // Writable ctor is applied to Duplexes, too.
  // `realHasInstance` is necessary because using plain `instanceof`
  // would return false, as no `_writableState` property is attached.

  // Trying to use the custom `instanceof` for Writable here will also break the
  // Node.js LazyTransform implementation, which has a non-trivial getter for
  // `_writableState` that would lead to infinite recursion.
  if (!realHasInstance.call(Writable, this) && !(this instanceof Duplex)) {
    return new Writable(options);
  }

  this._writableState = new WritableState(options, this);

  // legacy.
  this.writable = true;

  if (options) {
    if (typeof options.write === 'function') this._write = options.write;

    if (typeof options.writev === 'function') this._writev = options.writev;

    if (typeof options.destroy === 'function') this._destroy = options.destroy;

    if (typeof options.final === 'function') this._final = options.final;
  }

  Stream.call(this);
}

// Otherwise people can pipe Writable streams, which is just wrong.
Writable.prototype.pipe = function () {
  this.emit('error', new Error('Cannot pipe, not readable'));
};

function writeAfterEnd(stream, cb) {
  var er = new Error('write after end');
  // TODO: defer error events consistently everywhere, not just the cb
  stream.emit('error', er);
  pna.nextTick(cb, er);
}

// Checks that a user-supplied chunk is valid, especially for the particular
// mode the stream is in. Currently this means that `null` is never accepted
// and undefined/non-string values are only allowed in object mode.
function validChunk(stream, state, chunk, cb) {
  var valid = true;
  var er = false;

  if (chunk === null) {
    er = new TypeError('May not write null values to stream');
  } else if (typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
    er = new TypeError('Invalid non-string/buffer chunk');
  }
  if (er) {
    stream.emit('error', er);
    pna.nextTick(cb, er);
    valid = false;
  }
  return valid;
}

Writable.prototype.write = function (chunk, encoding, cb) {
  var state = this._writableState;
  var ret = false;
  var isBuf = !state.objectMode && _isUint8Array(chunk);

  if (isBuf && !Buffer.isBuffer(chunk)) {
    chunk = _uint8ArrayToBuffer(chunk);
  }

  if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;

  if (typeof cb !== 'function') cb = nop;

  if (state.ended) writeAfterEnd(this, cb);else if (isBuf || validChunk(this, state, chunk, cb)) {
    state.pendingcb++;
    ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
  }

  return ret;
};

Writable.prototype.cork = function () {
  var state = this._writableState;

  state.corked++;
};

Writable.prototype.uncork = function () {
  var state = this._writableState;

  if (state.corked) {
    state.corked--;

    if (!state.writing && !state.corked && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
  }
};

Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
  // node::ParseEncoding() requires lower case.
  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
  this._writableState.defaultEncoding = encoding;
  return this;
};

function decodeChunk(state, chunk, encoding) {
  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
    chunk = Buffer.from(chunk, encoding);
  }
  return chunk;
}

Object.defineProperty(Writable.prototype, 'writableHighWaterMark', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function () {
    return this._writableState.highWaterMark;
  }
});

// if we're already writing something, then just put this
// in the queue, and wait our turn.  Otherwise, call _write
// If we return false, then we need a drain event, so set that flag.
function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
  if (!isBuf) {
    var newChunk = decodeChunk(state, chunk, encoding);
    if (chunk !== newChunk) {
      isBuf = true;
      encoding = 'buffer';
      chunk = newChunk;
    }
  }
  var len = state.objectMode ? 1 : chunk.length;

  state.length += len;

  var ret = state.length < state.highWaterMark;
  // we must ensure that previous needDrain will not be reset to false.
  if (!ret) state.needDrain = true;

  if (state.writing || state.corked) {
    var last = state.lastBufferedRequest;
    state.lastBufferedRequest = {
      chunk: chunk,
      encoding: encoding,
      isBuf: isBuf,
      callback: cb,
      next: null
    };
    if (last) {
      last.next = state.lastBufferedRequest;
    } else {
      state.bufferedRequest = state.lastBufferedRequest;
    }
    state.bufferedRequestCount += 1;
  } else {
    doWrite(stream, state, false, len, chunk, encoding, cb);
  }

  return ret;
}

function doWrite(stream, state, writev, len, chunk, encoding, cb) {
  state.writelen = len;
  state.writecb = cb;
  state.writing = true;
  state.sync = true;
  if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
  state.sync = false;
}

function onwriteError(stream, state, sync, er, cb) {
  --state.pendingcb;

  if (sync) {
    // defer the callback if we are being called synchronously
    // to avoid piling up things on the stack
    pna.nextTick(cb, er);
    // this can emit finish, and it will always happen
    // after error
    pna.nextTick(finishMaybe, stream, state);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
  } else {
    // the caller expect this to happen before if
    // it is async
    cb(er);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
    // this can emit finish, but finish must
    // always follow error
    finishMaybe(stream, state);
  }
}

function onwriteStateUpdate(state) {
  state.writing = false;
  state.writecb = null;
  state.length -= state.writelen;
  state.writelen = 0;
}

function onwrite(stream, er) {
  var state = stream._writableState;
  var sync = state.sync;
  var cb = state.writecb;

  onwriteStateUpdate(state);

  if (er) onwriteError(stream, state, sync, er, cb);else {
    // Check if we're actually ready to finish, but don't emit yet
    var finished = needFinish(state);

    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
      clearBuffer(stream, state);
    }

    if (sync) {
      /*<replacement>*/
      asyncWrite(afterWrite, stream, state, finished, cb);
      /*</replacement>*/
    } else {
      afterWrite(stream, state, finished, cb);
    }
  }
}

function afterWrite(stream, state, finished, cb) {
  if (!finished) onwriteDrain(stream, state);
  state.pendingcb--;
  cb();
  finishMaybe(stream, state);
}

// Must force callback to be called on nextTick, so that we don't
// emit 'drain' before the write() consumer gets the 'false' return
// value, and has a chance to attach a 'drain' listener.
function onwriteDrain(stream, state) {
  if (state.length === 0 && state.needDrain) {
    state.needDrain = false;
    stream.emit('drain');
  }
}

// if there's something in the buffer waiting, then process it
function clearBuffer(stream, state) {
  state.bufferProcessing = true;
  var entry = state.bufferedRequest;

  if (stream._writev && entry && entry.next) {
    // Fast case, write everything using _writev()
    var l = state.bufferedRequestCount;
    var buffer = new Array(l);
    var holder = state.corkedRequestsFree;
    holder.entry = entry;

    var count = 0;
    var allBuffers = true;
    while (entry) {
      buffer[count] = entry;
      if (!entry.isBuf) allBuffers = false;
      entry = entry.next;
      count += 1;
    }
    buffer.allBuffers = allBuffers;

    doWrite(stream, state, true, state.length, buffer, '', holder.finish);

    // doWrite is almost always async, defer these to save a bit of time
    // as the hot path ends with doWrite
    state.pendingcb++;
    state.lastBufferedRequest = null;
    if (holder.next) {
      state.corkedRequestsFree = holder.next;
      holder.next = null;
    } else {
      state.corkedRequestsFree = new CorkedRequest(state);
    }
    state.bufferedRequestCount = 0;
  } else {
    // Slow case, write chunks one-by-one
    while (entry) {
      var chunk = entry.chunk;
      var encoding = entry.encoding;
      var cb = entry.callback;
      var len = state.objectMode ? 1 : chunk.length;

      doWrite(stream, state, false, len, chunk, encoding, cb);
      entry = entry.next;
      state.bufferedRequestCount--;
      // if we didn't call the onwrite immediately, then
      // it means that we need to wait until it does.
      // also, that means that the chunk and cb are currently
      // being processed, so move the buffer counter past them.
      if (state.writing) {
        break;
      }
    }

    if (entry === null) state.lastBufferedRequest = null;
  }

  state.bufferedRequest = entry;
  state.bufferProcessing = false;
}

Writable.prototype._write = function (chunk, encoding, cb) {
  cb(new Error('_write() is not implemented'));
};

Writable.prototype._writev = null;

Writable.prototype.end = function (chunk, encoding, cb) {
  var state = this._writableState;

  if (typeof chunk === 'function') {
    cb = chunk;
    chunk = null;
    encoding = null;
  } else if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

  // .end() fully uncorks
  if (state.corked) {
    state.corked = 1;
    this.uncork();
  }

  // ignore unnecessary end() calls.
  if (!state.ending) endWritable(this, state, cb);
};

function needFinish(state) {
  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
}
function callFinal(stream, state) {
  stream._final(function (err) {
    state.pendingcb--;
    if (err) {
      stream.emit('error', err);
    }
    state.prefinished = true;
    stream.emit('prefinish');
    finishMaybe(stream, state);
  });
}
function prefinish(stream, state) {
  if (!state.prefinished && !state.finalCalled) {
    if (typeof stream._final === 'function') {
      state.pendingcb++;
      state.finalCalled = true;
      pna.nextTick(callFinal, stream, state);
    } else {
      state.prefinished = true;
      stream.emit('prefinish');
    }
  }
}

function finishMaybe(stream, state) {
  var need = needFinish(state);
  if (need) {
    prefinish(stream, state);
    if (state.pendingcb === 0) {
      state.finished = true;
      stream.emit('finish');
    }
  }
  return need;
}

function endWritable(stream, state, cb) {
  state.ending = true;
  finishMaybe(stream, state);
  if (cb) {
    if (state.finished) pna.nextTick(cb);else stream.once('finish', cb);
  }
  state.ended = true;
  stream.writable = false;
}

function onCorkedFinish(corkReq, state, err) {
  var entry = corkReq.entry;
  corkReq.entry = null;
  while (entry) {
    var cb = entry.callback;
    state.pendingcb--;
    cb(err);
    entry = entry.next;
  }

  // reuse the free corkReq.
  state.corkedRequestsFree.next = corkReq;
}

Object.defineProperty(Writable.prototype, 'destroyed', {
  get: function () {
    if (this._writableState === undefined) {
      return false;
    }
    return this._writableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (!this._writableState) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._writableState.destroyed = value;
  }
});

Writable.prototype.destroy = destroyImpl.destroy;
Writable.prototype._undestroy = destroyImpl.undestroy;
Writable.prototype._destroy = function (err, cb) {
  this.end();
  cb(err);
};

/***/ }),

/***/ 25553:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Buffer = (__webpack_require__(89509).Buffer);
var util = __webpack_require__(73837);

function copyBuffer(src, target, offset) {
  src.copy(target, offset);
}

module.exports = function () {
  function BufferList() {
    _classCallCheck(this, BufferList);

    this.head = null;
    this.tail = null;
    this.length = 0;
  }

  BufferList.prototype.push = function push(v) {
    var entry = { data: v, next: null };
    if (this.length > 0) this.tail.next = entry;else this.head = entry;
    this.tail = entry;
    ++this.length;
  };

  BufferList.prototype.unshift = function unshift(v) {
    var entry = { data: v, next: this.head };
    if (this.length === 0) this.tail = entry;
    this.head = entry;
    ++this.length;
  };

  BufferList.prototype.shift = function shift() {
    if (this.length === 0) return;
    var ret = this.head.data;
    if (this.length === 1) this.head = this.tail = null;else this.head = this.head.next;
    --this.length;
    return ret;
  };

  BufferList.prototype.clear = function clear() {
    this.head = this.tail = null;
    this.length = 0;
  };

  BufferList.prototype.join = function join(s) {
    if (this.length === 0) return '';
    var p = this.head;
    var ret = '' + p.data;
    while (p = p.next) {
      ret += s + p.data;
    }return ret;
  };

  BufferList.prototype.concat = function concat(n) {
    if (this.length === 0) return Buffer.alloc(0);
    var ret = Buffer.allocUnsafe(n >>> 0);
    var p = this.head;
    var i = 0;
    while (p) {
      copyBuffer(p.data, ret, i);
      i += p.data.length;
      p = p.next;
    }
    return ret;
  };

  return BufferList;
}();

if (util && util.inspect && util.inspect.custom) {
  module.exports.prototype[util.inspect.custom] = function () {
    var obj = util.inspect({ length: this.length });
    return this.constructor.name + ' ' + obj;
  };
}

/***/ }),

/***/ 1280:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


/*<replacement>*/

var pna = __webpack_require__(88212);
/*</replacement>*/

// undocumented cb() API, needed for core, not for public API
function destroy(err, cb) {
  var _this = this;

  var readableDestroyed = this._readableState && this._readableState.destroyed;
  var writableDestroyed = this._writableState && this._writableState.destroyed;

  if (readableDestroyed || writableDestroyed) {
    if (cb) {
      cb(err);
    } else if (err) {
      if (!this._writableState) {
        pna.nextTick(emitErrorNT, this, err);
      } else if (!this._writableState.errorEmitted) {
        this._writableState.errorEmitted = true;
        pna.nextTick(emitErrorNT, this, err);
      }
    }

    return this;
  }

  // we set destroyed to true before firing error callbacks in order
  // to make it re-entrance safe in case destroy() is called within callbacks

  if (this._readableState) {
    this._readableState.destroyed = true;
  }

  // if this is a duplex stream mark the writable part as destroyed as well
  if (this._writableState) {
    this._writableState.destroyed = true;
  }

  this._destroy(err || null, function (err) {
    if (!cb && err) {
      if (!_this._writableState) {
        pna.nextTick(emitErrorNT, _this, err);
      } else if (!_this._writableState.errorEmitted) {
        _this._writableState.errorEmitted = true;
        pna.nextTick(emitErrorNT, _this, err);
      }
    } else if (cb) {
      cb(err);
    }
  });

  return this;
}

function undestroy() {
  if (this._readableState) {
    this._readableState.destroyed = false;
    this._readableState.reading = false;
    this._readableState.ended = false;
    this._readableState.endEmitted = false;
  }

  if (this._writableState) {
    this._writableState.destroyed = false;
    this._writableState.ended = false;
    this._writableState.ending = false;
    this._writableState.finalCalled = false;
    this._writableState.prefinished = false;
    this._writableState.finished = false;
    this._writableState.errorEmitted = false;
  }
}

function emitErrorNT(self, err) {
  self.emit('error', err);
}

module.exports = {
  destroy: destroy,
  undestroy: undestroy
};

/***/ }),

/***/ 91581:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(12781);


/***/ }),

/***/ 69754:
/***/ ((module, exports, __webpack_require__) => {

var Stream = __webpack_require__(12781);
if (process.env.READABLE_STREAM === 'disable' && Stream) {
  module.exports = Stream;
  exports = module.exports = Stream.Readable;
  exports.Readable = Stream.Readable;
  exports.Writable = Stream.Writable;
  exports.Duplex = Stream.Duplex;
  exports.Transform = Stream.Transform;
  exports.PassThrough = Stream.PassThrough;
  exports.Stream = Stream;
} else {
  exports = module.exports = __webpack_require__(97190);
  exports.Stream = Stream || exports;
  exports.Readable = exports;
  exports.Writable = __webpack_require__(88223);
  exports.Duplex = __webpack_require__(66106);
  exports.Transform = __webpack_require__(31289);
  exports.PassThrough = __webpack_require__(37592);
}


/***/ }),

/***/ 83833:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * Archiver Vending
 *
 * @ignore
 * @license [MIT]{@link https://github.com/archiverjs/node-archiver/blob/master/LICENSE}
 * @copyright (c) 2012-2014 Chris Talkington, contributors.
 */
var Archiver = __webpack_require__(79878);

var formats = {};

/**
 * Dispenses a new Archiver instance.
 *
 * @constructor
 * @param  {String} format The archive format to use.
 * @param  {Object} options See [Archiver]{@link Archiver}
 * @return {Archiver}
 */
var vending = function(format, options) {
  return vending.create(format, options);
};

/**
 * Creates a new Archiver instance.
 *
 * @param  {String} format The archive format to use.
 * @param  {Object} options See [Archiver]{@link Archiver}
 * @return {Archiver}
 */
vending.create = function(format, options) {
  if (formats[format]) {
    var instance = new Archiver(format, options);
    instance.setFormat(format);
    instance.setModule(new formats[format](options));

    return instance;
  } else {
    throw new Error('create(' + format + '): format not registered');
  }
};

/**
 * Registers a format for use with archiver.
 *
 * @param  {String} format The name of the format.
 * @param  {Function} module The function for archiver to interact with.
 * @return void
 */
vending.registerFormat = function(format, module) {
  if (formats[format]) {
    throw new Error('register(' + format + '): format already registered');
  }

  if (typeof module !== 'function') {
    throw new Error('register(' + format + '): format module invalid');
  }

  if (typeof module.prototype.append !== 'function' || typeof module.prototype.finalize !== 'function') {
    throw new Error('register(' + format + '): format module missing methods');
  }

  formats[format] = module;
};

/**
 * Check if the format is already registered.
 * 
 * @param {String} format the name of the format.
 * @return boolean
 */
vending.isRegisteredFormat = function (format) {
  if (formats[format]) {
    return true;
  }
  
  return false;
};

vending.registerFormat('zip', __webpack_require__(10907));
vending.registerFormat('tar', __webpack_require__(60062));
vending.registerFormat('json', __webpack_require__(81072));

module.exports = vending;

/***/ }),

/***/ 79878:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * Archiver Core
 *
 * @ignore
 * @license [MIT]{@link https://github.com/archiverjs/node-archiver/blob/master/LICENSE}
 * @copyright (c) 2012-2014 Chris Talkington, contributors.
 */
var fs = __webpack_require__(57147);
var glob = __webpack_require__(92141);
var async = __webpack_require__(1641);
var path = __webpack_require__(71017);
var util = __webpack_require__(13672);

var inherits = (__webpack_require__(73837).inherits);
var ArchiverError = __webpack_require__(91175);
var Transform = (__webpack_require__(11451).Transform);

var win32 = process.platform === 'win32';

/**
 * @constructor
 * @param {String} format The archive format to use.
 * @param {(CoreOptions|TransformOptions)} options See also {@link ZipOptions} and {@link TarOptions}.
 */
var Archiver = function(format, options) {
  if (!(this instanceof Archiver)) {
    return new Archiver(format, options);
  }

  if (typeof format !== 'string') {
    options = format;
    format = 'zip';
  }

  options = this.options = util.defaults(options, {
    highWaterMark: 1024 * 1024,
    statConcurrency: 4
  });

  Transform.call(this, options);

  this._format = false;
  this._module = false;
  this._pending = 0;
  this._pointer = 0;

  this._entriesCount = 0;
  this._entriesProcessedCount = 0;
  this._fsEntriesTotalBytes = 0;
  this._fsEntriesProcessedBytes = 0;

  this._queue = async.queue(this._onQueueTask.bind(this), 1);
  this._queue.drain(this._onQueueDrain.bind(this));

  this._statQueue = async.queue(this._onStatQueueTask.bind(this), options.statConcurrency);
  this._statQueue.drain(this._onQueueDrain.bind(this));

  this._state = {
    aborted: false,
    finalize: false,
    finalizing: false,
    finalized: false,
    modulePiped: false
  };

  this._streams = [];
};

inherits(Archiver, Transform);

/**
 * Internal logic for `abort`.
 *
 * @private
 * @return void
 */
Archiver.prototype._abort = function() {
  this._state.aborted = true;
  this._queue.kill();
  this._statQueue.kill();

  if (this._queue.idle()) {
    this._shutdown();
  }
};

/**
 * Internal helper for appending files.
 *
 * @private
 * @param  {String} filepath The source filepath.
 * @param  {EntryData} data The entry data.
 * @return void
 */
Archiver.prototype._append = function(filepath, data) {
  data = data || {};

  var task = {
    source: null,
    filepath: filepath
  };

  if (!data.name) {
    data.name = filepath;
  }

  data.sourcePath = filepath;
  task.data = data;
  this._entriesCount++;

  if (data.stats && data.stats instanceof fs.Stats) {
    task = this._updateQueueTaskWithStats(task, data.stats);
    if (task) {
      if (data.stats.size) {
        this._fsEntriesTotalBytes += data.stats.size;
      }

      this._queue.push(task);
    }
  } else {
    this._statQueue.push(task);
  }
};

/**
 * Internal logic for `finalize`.
 *
 * @private
 * @return void
 */
Archiver.prototype._finalize = function() {
  if (this._state.finalizing || this._state.finalized || this._state.aborted) {
    return;
  }

  this._state.finalizing = true;

  this._moduleFinalize();

  this._state.finalizing = false;
  this._state.finalized = true;
};

/**
 * Checks the various state variables to determine if we can `finalize`.
 *
 * @private
 * @return {Boolean}
 */
Archiver.prototype._maybeFinalize = function() {
  if (this._state.finalizing || this._state.finalized || this._state.aborted) {
    return false;
  }

  if (this._state.finalize && this._pending === 0 && this._queue.idle() && this._statQueue.idle()) {
    this._finalize();
    return true;
  }

  return false;
};

/**
 * Appends an entry to the module.
 *
 * @private
 * @fires  Archiver#entry
 * @param  {(Buffer|Stream)} source
 * @param  {EntryData} data
 * @param  {Function} callback
 * @return void
 */
Archiver.prototype._moduleAppend = function(source, data, callback) {
  if (this._state.aborted) {
    callback();
    return;
  }

  this._module.append(source, data, function(err) {
    this._task = null;

    if (this._state.aborted) {
      this._shutdown();
      return;
    }

    if (err) {
      this.emit('error', err);
      setImmediate(callback);
      return;
    }

    /**
     * Fires when the entry's input has been processed and appended to the archive.
     *
     * @event Archiver#entry
     * @type {EntryData}
     */
    this.emit('entry', data);
    this._entriesProcessedCount++;

    if (data.stats && data.stats.size) {
      this._fsEntriesProcessedBytes += data.stats.size;
    }

    /**
     * @event Archiver#progress
     * @type {ProgressData}
     */
    this.emit('progress', {
      entries: {
        total: this._entriesCount,
        processed: this._entriesProcessedCount
      },
      fs: {
        totalBytes: this._fsEntriesTotalBytes,
        processedBytes: this._fsEntriesProcessedBytes
      }
    });

    setImmediate(callback);
  }.bind(this));
};

/**
 * Finalizes the module.
 *
 * @private
 * @return void
 */
Archiver.prototype._moduleFinalize = function() {
  if (typeof this._module.finalize === 'function') {
    this._module.finalize();
  } else if (typeof this._module.end === 'function') {
    this._module.end();
  } else {
    this.emit('error', new ArchiverError('NOENDMETHOD'));
  }
};

/**
 * Pipes the module to our internal stream with error bubbling.
 *
 * @private
 * @return void
 */
Archiver.prototype._modulePipe = function() {
  this._module.on('error', this._onModuleError.bind(this));
  this._module.pipe(this);
  this._state.modulePiped = true;
};

/**
 * Determines if the current module supports a defined feature.
 *
 * @private
 * @param  {String} key
 * @return {Boolean}
 */
Archiver.prototype._moduleSupports = function(key) {
  if (!this._module.supports || !this._module.supports[key]) {
    return false;
  }

  return this._module.supports[key];
};

/**
 * Unpipes the module from our internal stream.
 *
 * @private
 * @return void
 */
Archiver.prototype._moduleUnpipe = function() {
  this._module.unpipe(this);
  this._state.modulePiped = false;
};

/**
 * Normalizes entry data with fallbacks for key properties.
 *
 * @private
 * @param  {Object} data
 * @param  {fs.Stats} stats
 * @return {Object}
 */
Archiver.prototype._normalizeEntryData = function(data, stats) {
  data = util.defaults(data, {
    type: 'file',
    name: null,
    date: null,
    mode: null,
    prefix: null,
    sourcePath: null,
    stats: false
  });

  if (stats && data.stats === false) {
    data.stats = stats;
  }

  var isDir = data.type === 'directory';

  if (data.name) {
    if (typeof data.prefix === 'string' && '' !== data.prefix) {
      data.name = data.prefix + '/' + data.name;
      data.prefix = null;
    }

    data.name = util.sanitizePath(data.name);

    if (data.type !== 'symlink' && data.name.slice(-1) === '/') {
      isDir = true;
      data.type = 'directory';
    } else if (isDir) {
      data.name += '/';
    }
  }

  // 511 === 0777; 493 === 0755; 438 === 0666; 420 === 0644
  if (typeof data.mode === 'number') {
    if (win32) {
      data.mode &= 511;
    } else {
      data.mode &= 4095
    }
  } else if (data.stats && data.mode === null) {
    if (win32) {
      data.mode = data.stats.mode & 511;
    } else {
      data.mode = data.stats.mode & 4095;
    }

    // stat isn't reliable on windows; force 0755 for dir
    if (win32 && isDir) {
      data.mode = 493;
    }
  } else if (data.mode === null) {
    data.mode = isDir ? 493 : 420;
  }

  if (data.stats && data.date === null) {
    data.date = data.stats.mtime;
  } else {
    data.date = util.dateify(data.date);
  }

  return data;
};

/**
 * Error listener that re-emits error on to our internal stream.
 *
 * @private
 * @param  {Error} err
 * @return void
 */
Archiver.prototype._onModuleError = function(err) {
  /**
   * @event Archiver#error
   * @type {ErrorData}
   */
  this.emit('error', err);
};

/**
 * Checks the various state variables after queue has drained to determine if
 * we need to `finalize`.
 *
 * @private
 * @return void
 */
Archiver.prototype._onQueueDrain = function() {
  if (this._state.finalizing || this._state.finalized || this._state.aborted) {
    return;
  }

  if (this._state.finalize && this._pending === 0 && this._queue.idle() && this._statQueue.idle()) {
    this._finalize();
  }
};

/**
 * Appends each queue task to the module.
 *
 * @private
 * @param  {Object} task
 * @param  {Function} callback
 * @return void
 */
Archiver.prototype._onQueueTask = function(task, callback) {
  var fullCallback = () => {
    if(task.data.callback) {
      task.data.callback();
    }
    callback();
  }

  if (this._state.finalizing || this._state.finalized || this._state.aborted) {
    fullCallback();
    return;
  }

  this._task = task;
  this._moduleAppend(task.source, task.data, fullCallback);
};

/**
 * Performs a file stat and reinjects the task back into the queue.
 *
 * @private
 * @param  {Object} task
 * @param  {Function} callback
 * @return void
 */
Archiver.prototype._onStatQueueTask = function(task, callback) {
  if (this._state.finalizing || this._state.finalized || this._state.aborted) {
    callback();
    return;
  }

  fs.lstat(task.filepath, function(err, stats) {
    if (this._state.aborted) {
      setImmediate(callback);
      return;
    }

    if (err) {
      this._entriesCount--;

      /**
       * @event Archiver#warning
       * @type {ErrorData}
       */
      this.emit('warning', err);
      setImmediate(callback);
      return;
    }

    task = this._updateQueueTaskWithStats(task, stats);

    if (task) {
      if (stats.size) {
        this._fsEntriesTotalBytes += stats.size;
      }

      this._queue.push(task);
    }

    setImmediate(callback);
  }.bind(this));
};

/**
 * Unpipes the module and ends our internal stream.
 *
 * @private
 * @return void
 */
Archiver.prototype._shutdown = function() {
  this._moduleUnpipe();
  this.end();
};

/**
 * Tracks the bytes emitted by our internal stream.
 *
 * @private
 * @param  {Buffer} chunk
 * @param  {String} encoding
 * @param  {Function} callback
 * @return void
 */
Archiver.prototype._transform = function(chunk, encoding, callback) {
  if (chunk) {
    this._pointer += chunk.length;
  }

  callback(null, chunk);
};

/**
 * Updates and normalizes a queue task using stats data.
 *
 * @private
 * @param  {Object} task
 * @param  {fs.Stats} stats
 * @return {Object}
 */
Archiver.prototype._updateQueueTaskWithStats = function(task, stats) {
  if (stats.isFile()) {
    task.data.type = 'file';
    task.data.sourceType = 'stream';
    task.source = util.lazyReadStream(task.filepath);
  } else if (stats.isDirectory() && this._moduleSupports('directory')) {
    task.data.name = util.trailingSlashIt(task.data.name);
    task.data.type = 'directory';
    task.data.sourcePath = util.trailingSlashIt(task.filepath);
    task.data.sourceType = 'buffer';
    task.source = Buffer.concat([]);
  } else if (stats.isSymbolicLink() && this._moduleSupports('symlink')) {
    var linkPath = fs.readlinkSync(task.filepath);
    var dirName = path.dirname(task.filepath);
    task.data.type = 'symlink';
    task.data.linkname = path.relative(dirName, path.resolve(dirName, linkPath));
    task.data.sourceType = 'buffer';
    task.source = Buffer.concat([]);
  } else {
    if (stats.isDirectory()) {
      this.emit('warning', new ArchiverError('DIRECTORYNOTSUPPORTED', task.data));
    } else if (stats.isSymbolicLink()) {
      this.emit('warning', new ArchiverError('SYMLINKNOTSUPPORTED', task.data));
    } else {
      this.emit('warning', new ArchiverError('ENTRYNOTSUPPORTED', task.data));
    }

    return null;
  }

  task.data = this._normalizeEntryData(task.data, stats);

  return task;
};

/**
 * Aborts the archiving process, taking a best-effort approach, by:
 *
 * - removing any pending queue tasks
 * - allowing any active queue workers to finish
 * - detaching internal module pipes
 * - ending both sides of the Transform stream
 *
 * It will NOT drain any remaining sources.
 *
 * @return {this}
 */
Archiver.prototype.abort = function() {
  if (this._state.aborted || this._state.finalized) {
    return this;
  }

  this._abort();

  return this;
};

/**
 * Appends an input source (text string, buffer, or stream) to the instance.
 *
 * When the instance has received, processed, and emitted the input, the `entry`
 * event is fired.
 *
 * @fires  Archiver#entry
 * @param  {(Buffer|Stream|String)} source The input source.
 * @param  {EntryData} data See also {@link ZipEntryData} and {@link TarEntryData}.
 * @return {this}
 */
Archiver.prototype.append = function(source, data) {
  if (this._state.finalize || this._state.aborted) {
    this.emit('error', new ArchiverError('QUEUECLOSED'));
    return this;
  }

  data = this._normalizeEntryData(data);

  if (typeof data.name !== 'string' || data.name.length === 0) {
    this.emit('error', new ArchiverError('ENTRYNAMEREQUIRED'));
    return this;
  }

  if (data.type === 'directory' && !this._moduleSupports('directory')) {
    this.emit('error', new ArchiverError('DIRECTORYNOTSUPPORTED', { name: data.name }));
    return this;
  }

  source = util.normalizeInputSource(source);

  if (Buffer.isBuffer(source)) {
    data.sourceType = 'buffer';
  } else if (util.isStream(source)) {
    data.sourceType = 'stream';
  } else {
    this.emit('error', new ArchiverError('INPUTSTEAMBUFFERREQUIRED', { name: data.name }));
    return this;
  }

  this._entriesCount++;
  this._queue.push({
    data: data,
    source: source
  });

  return this;
};

/**
 * Appends a directory and its files, recursively, given its dirpath.
 *
 * @param  {String} dirpath The source directory path.
 * @param  {String} destpath The destination path within the archive.
 * @param  {(EntryData|Function)} data See also [ZipEntryData]{@link ZipEntryData} and
 * [TarEntryData]{@link TarEntryData}.
 * @return {this}
 */
Archiver.prototype.directory = function(dirpath, destpath, data) {
  if (this._state.finalize || this._state.aborted) {
    this.emit('error', new ArchiverError('QUEUECLOSED'));
    return this;
  }

  if (typeof dirpath !== 'string' || dirpath.length === 0) {
    this.emit('error', new ArchiverError('DIRECTORYDIRPATHREQUIRED'));
    return this;
  }

  this._pending++;

  if (destpath === false) {
    destpath = '';
  } else if (typeof destpath !== 'string'){
    destpath = dirpath;
  }

  var dataFunction = false;
  if (typeof data === 'function') {
    dataFunction = data;
    data = {};
  } else if (typeof data !== 'object') {
    data = {};
  }

  var globOptions = {
    stat: true,
    dot: true
  };

  function onGlobEnd() {
    this._pending--;
    this._maybeFinalize();
  }

  function onGlobError(err) {
    this.emit('error', err);
  }

  function onGlobMatch(match){
    globber.pause();

    var ignoreMatch = false;
    var entryData = Object.assign({}, data);
    entryData.name = match.relative;
    entryData.prefix = destpath;
    entryData.stats = match.stat;
    entryData.callback = globber.resume.bind(globber);

    try {
      if (dataFunction) {
        entryData = dataFunction(entryData);

        if (entryData === false) {
          ignoreMatch = true;
        } else if (typeof entryData !== 'object') {
          throw new ArchiverError('DIRECTORYFUNCTIONINVALIDDATA', { dirpath: dirpath });
        }
      }
    } catch(e) {
      this.emit('error', e);
      return;
    }

    if (ignoreMatch) {
      globber.resume();
      return;
    }

    this._append(match.absolute, entryData);
  }

  var globber = glob(dirpath, globOptions);
  globber.on('error', onGlobError.bind(this));
  globber.on('match', onGlobMatch.bind(this));
  globber.on('end', onGlobEnd.bind(this));

  return this;
};

/**
 * Appends a file given its filepath using a
 * [lazystream]{@link https://github.com/jpommerening/node-lazystream} wrapper to
 * prevent issues with open file limits.
 *
 * When the instance has received, processed, and emitted the file, the `entry`
 * event is fired.
 *
 * @param  {String} filepath The source filepath.
 * @param  {EntryData} data See also [ZipEntryData]{@link ZipEntryData} and
 * [TarEntryData]{@link TarEntryData}.
 * @return {this}
 */
Archiver.prototype.file = function(filepath, data) {
  if (this._state.finalize || this._state.aborted) {
    this.emit('error', new ArchiverError('QUEUECLOSED'));
    return this;
  }

  if (typeof filepath !== 'string' || filepath.length === 0) {
    this.emit('error', new ArchiverError('FILEFILEPATHREQUIRED'));
    return this;
  }

  this._append(filepath, data);

  return this;
};

/**
 * Appends multiple files that match a glob pattern.
 *
 * @param  {String} pattern The [glob pattern]{@link https://github.com/isaacs/minimatch} to match.
 * @param  {Object} options See [node-readdir-glob]{@link https://github.com/yqnn/node-readdir-glob#options}.
 * @param  {EntryData} data See also [ZipEntryData]{@link ZipEntryData} and
 * [TarEntryData]{@link TarEntryData}.
 * @return {this}
 */
Archiver.prototype.glob = function(pattern, options, data) {
  this._pending++;

  options = util.defaults(options, {
    stat: true,
    pattern: pattern
  });

  function onGlobEnd() {
    this._pending--;
    this._maybeFinalize();
  }

  function onGlobError(err) {
    this.emit('error', err);
  }

  function onGlobMatch(match){
    globber.pause();
    var entryData = Object.assign({}, data);
    entryData.callback = globber.resume.bind(globber);
    entryData.stats = match.stat;
    entryData.name = match.relative;

    this._append(match.absolute, entryData);
  }

  var globber = glob(options.cwd || '.', options);
  globber.on('error', onGlobError.bind(this));
  globber.on('match', onGlobMatch.bind(this));
  globber.on('end', onGlobEnd.bind(this));

  return this;
};

/**
 * Finalizes the instance and prevents further appending to the archive
 * structure (queue will continue til drained).
 *
 * The `end`, `close` or `finish` events on the destination stream may fire
 * right after calling this method so you should set listeners beforehand to
 * properly detect stream completion.
 *
 * @return {Promise}
 */
Archiver.prototype.finalize = function() {
  if (this._state.aborted) {
    var abortedError = new ArchiverError('ABORTED');
    this.emit('error', abortedError);
    return Promise.reject(abortedError);
  }

  if (this._state.finalize) {
    var finalizingError = new ArchiverError('FINALIZING');
    this.emit('error', finalizingError);
    return Promise.reject(finalizingError);
  }

  this._state.finalize = true;

  if (this._pending === 0 && this._queue.idle() && this._statQueue.idle()) {
    this._finalize();
  }

  var self = this;

  return new Promise(function(resolve, reject) {
    var errored;

    self._module.on('end', function() {
      if (!errored) {
        resolve();
      }
    })

    self._module.on('error', function(err) {
      errored = true;
      reject(err);
    })
  })
};

/**
 * Sets the module format name used for archiving.
 *
 * @param {String} format The name of the format.
 * @return {this}
 */
Archiver.prototype.setFormat = function(format) {
  if (this._format) {
    this.emit('error', new ArchiverError('FORMATSET'));
    return this;
  }

  this._format = format;

  return this;
};

/**
 * Sets the module used for archiving.
 *
 * @param {Function} module The function for archiver to interact with.
 * @return {this}
 */
Archiver.prototype.setModule = function(module) {
  if (this._state.aborted) {
    this.emit('error', new ArchiverError('ABORTED'));
    return this;
  }

  if (this._state.module) {
    this.emit('error', new ArchiverError('MODULESET'));
    return this;
  }

  this._module = module;
  this._modulePipe();

  return this;
};

/**
 * Appends a symlink to the instance.
 *
 * This does NOT interact with filesystem and is used for programmatically creating symlinks.
 *
 * @param  {String} filepath The symlink path (within archive).
 * @param  {String} target The target path (within archive).
 * @param  {Number} mode Sets the entry permissions.
 * @return {this}
 */
Archiver.prototype.symlink = function(filepath, target, mode) {
  if (this._state.finalize || this._state.aborted) {
    this.emit('error', new ArchiverError('QUEUECLOSED'));
    return this;
  }

  if (typeof filepath !== 'string' || filepath.length === 0) {
    this.emit('error', new ArchiverError('SYMLINKFILEPATHREQUIRED'));
    return this;
  }

  if (typeof target !== 'string' || target.length === 0) {
    this.emit('error', new ArchiverError('SYMLINKTARGETREQUIRED', { filepath: filepath }));
    return this;
  }

  if (!this._moduleSupports('symlink')) {
    this.emit('error', new ArchiverError('SYMLINKNOTSUPPORTED', { filepath: filepath }));
    return this;
  }

  var data = {};
  data.type = 'symlink';
  data.name = filepath.replace(/\\/g, '/');
  data.linkname = target.replace(/\\/g, '/');
  data.sourceType = 'buffer';

  if (typeof mode === "number") {
    data.mode = mode;
  }

  this._entriesCount++;
  this._queue.push({
    data: data,
    source: Buffer.concat([])
  });

  return this;
};

/**
 * Returns the current length (in bytes) that has been emitted.
 *
 * @return {Number}
 */
Archiver.prototype.pointer = function() {
  return this._pointer;
};

/**
 * Middleware-like helper that has yet to be fully implemented.
 *
 * @private
 * @param  {Function} plugin
 * @return {this}
 */
Archiver.prototype.use = function(plugin) {
  this._streams.push(plugin);
  return this;
};

module.exports = Archiver;

/**
 * @typedef {Object} CoreOptions
 * @global
 * @property {Number} [statConcurrency=4] Sets the number of workers used to
 * process the internal fs stat queue.
 */

/**
 * @typedef {Object} TransformOptions
 * @property {Boolean} [allowHalfOpen=true] If set to false, then the stream
 * will automatically end the readable side when the writable side ends and vice
 * versa.
 * @property {Boolean} [readableObjectMode=false] Sets objectMode for readable
 * side of the stream. Has no effect if objectMode is true.
 * @property {Boolean} [writableObjectMode=false] Sets objectMode for writable
 * side of the stream. Has no effect if objectMode is true.
 * @property {Boolean} [decodeStrings=true] Whether or not to decode strings
 * into Buffers before passing them to _write(). `Writable`
 * @property {String} [encoding=NULL] If specified, then buffers will be decoded
 * to strings using the specified encoding. `Readable`
 * @property {Number} [highWaterMark=16kb] The maximum number of bytes to store
 * in the internal buffer before ceasing to read from the underlying resource.
 * `Readable` `Writable`
 * @property {Boolean} [objectMode=false] Whether this stream should behave as a
 * stream of objects. Meaning that stream.read(n) returns a single value instead
 * of a Buffer of size n. `Readable` `Writable`
 */

/**
 * @typedef {Object} EntryData
 * @property {String} name Sets the entry name including internal path.
 * @property {(String|Date)} [date=NOW()] Sets the entry date.
 * @property {Number} [mode=D:0755/F:0644] Sets the entry permissions.
 * @property {String} [prefix] Sets a path prefix for the entry name. Useful
 * when working with methods like `directory` or `glob`.
 * @property {fs.Stats} [stats] Sets the fs stat data for this entry allowing
 * for reduction of fs stat calls when stat data is already known.
 */

/**
 * @typedef {Object} ErrorData
 * @property {String} message The message of the error.
 * @property {String} code The error code assigned to this error.
 * @property {String} data Additional data provided for reporting or debugging (where available).
 */

/**
 * @typedef {Object} ProgressData
 * @property {Object} entries
 * @property {Number} entries.total Number of entries that have been appended.
 * @property {Number} entries.processed Number of entries that have been processed.
 * @property {Object} fs
 * @property {Number} fs.totalBytes Number of bytes that have been appended. Calculated asynchronously and might not be accurate: it growth while entries are added. (based on fs.Stats)
 * @property {Number} fs.processedBytes Number of bytes that have been processed. (based on fs.Stats)
 */


/***/ }),

/***/ 91175:
/***/ ((module, exports, __webpack_require__) => {

/**
 * Archiver Core
 *
 * @ignore
 * @license [MIT]{@link https://github.com/archiverjs/node-archiver/blob/master/LICENSE}
 * @copyright (c) 2012-2014 Chris Talkington, contributors.
 */

var util = __webpack_require__(73837);

const ERROR_CODES = {
  'ABORTED': 'archive was aborted',
  'DIRECTORYDIRPATHREQUIRED': 'diretory dirpath argument must be a non-empty string value',
  'DIRECTORYFUNCTIONINVALIDDATA': 'invalid data returned by directory custom data function',
  'ENTRYNAMEREQUIRED': 'entry name must be a non-empty string value',
  'FILEFILEPATHREQUIRED': 'file filepath argument must be a non-empty string value',
  'FINALIZING': 'archive already finalizing',
  'QUEUECLOSED': 'queue closed',
  'NOENDMETHOD': 'no suitable finalize/end method defined by module',
  'DIRECTORYNOTSUPPORTED': 'support for directory entries not defined by module',
  'FORMATSET': 'archive format already set',
  'INPUTSTEAMBUFFERREQUIRED': 'input source must be valid Stream or Buffer instance',
  'MODULESET': 'module already set',
  'SYMLINKNOTSUPPORTED': 'support for symlink entries not defined by module',
  'SYMLINKFILEPATHREQUIRED': 'symlink filepath argument must be a non-empty string value',
  'SYMLINKTARGETREQUIRED': 'symlink target argument must be a non-empty string value',
  'ENTRYNOTSUPPORTED': 'entry not supported'
};

function ArchiverError(code, data) {
  Error.captureStackTrace(this, this.constructor);
  //this.name = this.constructor.name;
  this.message = ERROR_CODES[code] || code;
  this.code = code;
  this.data = data;
}

util.inherits(ArchiverError, Error);

exports = module.exports = ArchiverError;

/***/ }),

/***/ 81072:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * JSON Format Plugin
 *
 * @module plugins/json
 * @license [MIT]{@link https://github.com/archiverjs/node-archiver/blob/master/LICENSE}
 * @copyright (c) 2012-2014 Chris Talkington, contributors.
 */
var inherits = (__webpack_require__(73837).inherits);
var Transform = (__webpack_require__(11451).Transform);

var crc32 = __webpack_require__(82779);
var util = __webpack_require__(13672);

/**
 * @constructor
 * @param {(JsonOptions|TransformOptions)} options
 */
var Json = function(options) {
  if (!(this instanceof Json)) {
    return new Json(options);
  }

  options = this.options = util.defaults(options, {});

  Transform.call(this, options);

  this.supports = {
    directory: true,
    symlink: true
  };

  this.files = [];
};

inherits(Json, Transform);

/**
 * [_transform description]
 *
 * @private
 * @param  {Buffer}   chunk
 * @param  {String}   encoding
 * @param  {Function} callback
 * @return void
 */
Json.prototype._transform = function(chunk, encoding, callback) {
  callback(null, chunk);
};

/**
 * [_writeStringified description]
 *
 * @private
 * @return void
 */
Json.prototype._writeStringified = function() {
  var fileString = JSON.stringify(this.files);
  this.write(fileString);
};

/**
 * [append description]
 *
 * @param  {(Buffer|Stream)}   source
 * @param  {EntryData}   data
 * @param  {Function} callback
 * @return void
 */
Json.prototype.append = function(source, data, callback) {
  var self = this;

  data.crc32 = 0;

  function onend(err, sourceBuffer) {
    if (err) {
      callback(err);
      return;
    }

    data.size = sourceBuffer.length || 0;
    data.crc32 = crc32.unsigned(sourceBuffer);

    self.files.push(data);

    callback(null, data);
  }

  if (data.sourceType === 'buffer') {
    onend(null, source);
  } else if (data.sourceType === 'stream') {
    util.collectStream(source, onend);
  }
};

/**
 * [finalize description]
 *
 * @return void
 */
Json.prototype.finalize = function() {
  this._writeStringified();
  this.end();
};

module.exports = Json;

/**
 * @typedef {Object} JsonOptions
 * @global
 */


/***/ }),

/***/ 60062:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * TAR Format Plugin
 *
 * @module plugins/tar
 * @license [MIT]{@link https://github.com/archiverjs/node-archiver/blob/master/LICENSE}
 * @copyright (c) 2012-2014 Chris Talkington, contributors.
 */
var zlib = __webpack_require__(59796);

var engine = __webpack_require__(53871);
var util = __webpack_require__(13672);

/**
 * @constructor
 * @param {TarOptions} options
 */
var Tar = function(options) {
  if (!(this instanceof Tar)) {
    return new Tar(options);
  }

  options = this.options = util.defaults(options, {
    gzip: false
  });

  if (typeof options.gzipOptions !== 'object') {
    options.gzipOptions = {};
  }

  this.supports = {
    directory: true,
    symlink: true
  };

  this.engine = engine.pack(options);
  this.compressor = false;

  if (options.gzip) {
    this.compressor = zlib.createGzip(options.gzipOptions);
    this.compressor.on('error', this._onCompressorError.bind(this));
  }
};

/**
 * [_onCompressorError description]
 *
 * @private
 * @param  {Error} err
 * @return void
 */
Tar.prototype._onCompressorError = function(err) {
  this.engine.emit('error', err);
};

/**
 * [append description]
 *
 * @param  {(Buffer|Stream)} source
 * @param  {TarEntryData} data
 * @param  {Function} callback
 * @return void
 */
Tar.prototype.append = function(source, data, callback) {
  var self = this;

  data.mtime = data.date;

  function append(err, sourceBuffer) {
    if (err) {
      callback(err);
      return;
    }

    self.engine.entry(data, sourceBuffer, function(err) {
      callback(err, data);
    });
  }

  if (data.sourceType === 'buffer') {
    append(null, source);
  } else if (data.sourceType === 'stream' && data.stats) {
    data.size = data.stats.size;

    var entry = self.engine.entry(data, function(err) {
      callback(err, data);
    });

    source.pipe(entry);
  } else if (data.sourceType === 'stream') {
    util.collectStream(source, append);
  }
};

/**
 * [finalize description]
 *
 * @return void
 */
Tar.prototype.finalize = function() {
  this.engine.finalize();
};

/**
 * [on description]
 *
 * @return this.engine
 */
Tar.prototype.on = function() {
  return this.engine.on.apply(this.engine, arguments);
};

/**
 * [pipe description]
 *
 * @param  {String} destination
 * @param  {Object} options
 * @return this.engine
 */
Tar.prototype.pipe = function(destination, options) {
  if (this.compressor) {
    return this.engine.pipe.apply(this.engine, [this.compressor]).pipe(destination, options);
  } else {
    return this.engine.pipe.apply(this.engine, arguments);
  }
};

/**
 * [unpipe description]
 *
 * @return this.engine
 */
Tar.prototype.unpipe = function() {
  if (this.compressor) {
    return this.compressor.unpipe.apply(this.compressor, arguments);
  } else {
    return this.engine.unpipe.apply(this.engine, arguments);
  }
};

module.exports = Tar;

/**
 * @typedef {Object} TarOptions
 * @global
 * @property {Boolean} [gzip=false] Compress the tar archive using gzip.
 * @property {Object} [gzipOptions] Passed to [zlib]{@link https://nodejs.org/api/zlib.html#zlib_class_options}
 * to control compression.
 * @property {*} [*] See [tar-stream]{@link https://github.com/mafintosh/tar-stream} documentation for additional properties.
 */

/**
 * @typedef {Object} TarEntryData
 * @global
 * @property {String} name Sets the entry name including internal path.
 * @property {(String|Date)} [date=NOW()] Sets the entry date.
 * @property {Number} [mode=D:0755/F:0644] Sets the entry permissions.
 * @property {String} [prefix] Sets a path prefix for the entry name. Useful
 * when working with methods like `directory` or `glob`.
 * @property {fs.Stats} [stats] Sets the fs stat data for this entry allowing
 * for reduction of fs stat calls when stat data is already known.
 */

/**
 * TarStream Module
 * @external TarStream
 * @see {@link https://github.com/mafintosh/tar-stream}
 */


/***/ }),

/***/ 10907:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * ZIP Format Plugin
 *
 * @module plugins/zip
 * @license [MIT]{@link https://github.com/archiverjs/node-archiver/blob/master/LICENSE}
 * @copyright (c) 2012-2014 Chris Talkington, contributors.
 */
var engine = __webpack_require__(7380);
var util = __webpack_require__(13672);

/**
 * @constructor
 * @param {ZipOptions} [options]
 * @param {String} [options.comment] Sets the zip archive comment.
 * @param {Boolean} [options.forceLocalTime=false] Forces the archive to contain local file times instead of UTC.
 * @param {Boolean} [options.forceZip64=false] Forces the archive to contain ZIP64 headers.
 * @param {Boolean} [options.namePrependSlash=false] Prepends a forward slash to archive file paths.
 * @param {Boolean} [options.store=false] Sets the compression method to STORE.
 * @param {Object} [options.zlib] Passed to [zlib]{@link https://nodejs.org/api/zlib.html#zlib_class_options}
 */
var Zip = function(options) {
  if (!(this instanceof Zip)) {
    return new Zip(options);
  }

  options = this.options = util.defaults(options, {
    comment: '',
    forceUTC: false,
    namePrependSlash: false,
    store: false
  });

  this.supports = {
    directory: true,
    symlink: true
  };

  this.engine = new engine(options);
};

/**
 * @param  {(Buffer|Stream)} source
 * @param  {ZipEntryData} data
 * @param  {String} data.name Sets the entry name including internal path.
 * @param  {(String|Date)} [data.date=NOW()] Sets the entry date.
 * @param  {Number} [data.mode=D:0755/F:0644] Sets the entry permissions.
 * @param  {String} [data.prefix] Sets a path prefix for the entry name. Useful
 * when working with methods like `directory` or `glob`.
 * @param  {fs.Stats} [data.stats] Sets the fs stat data for this entry allowing
 * for reduction of fs stat calls when stat data is already known.
 * @param  {Boolean} [data.store=ZipOptions.store] Sets the compression method to STORE.
 * @param  {Function} callback
 * @return void
 */
Zip.prototype.append = function(source, data, callback) {
  this.engine.entry(source, data, callback);
};

/**
 * @return void
 */
Zip.prototype.finalize = function() {
  this.engine.finalize();
};

/**
 * @return this.engine
 */
Zip.prototype.on = function() {
  return this.engine.on.apply(this.engine, arguments);
};

/**
 * @return this.engine
 */
Zip.prototype.pipe = function() {
  return this.engine.pipe.apply(this.engine, arguments);
};

/**
 * @return this.engine
 */
Zip.prototype.unpipe = function() {
  return this.engine.unpipe.apply(this.engine, arguments);
};

module.exports = Zip;

/**
 * @typedef {Object} ZipOptions
 * @global
 * @property {String} [comment] Sets the zip archive comment.
 * @property {Boolean} [forceLocalTime=false] Forces the archive to contain local file times instead of UTC.
 * @property {Boolean} [forceZip64=false] Forces the archive to contain ZIP64 headers.
 * @prpperty {Boolean} [namePrependSlash=false] Prepends a forward slash to archive file paths.
 * @property {Boolean} [store=false] Sets the compression method to STORE.
 * @property {Object} [zlib] Passed to [zlib]{@link https://nodejs.org/api/zlib.html#zlib_class_options}
 * to control compression.
 * @property {*} [*] See [zip-stream]{@link https://archiverjs.com/zip-stream/ZipStream.html} documentation for current list of properties.
 */

/**
 * @typedef {Object} ZipEntryData
 * @global
 * @property {String} name Sets the entry name including internal path.
 * @property {(String|Date)} [date=NOW()] Sets the entry date.
 * @property {Number} [mode=D:0755/F:0644] Sets the entry permissions.
 * @property {Boolean} [namePrependSlash=ZipOptions.namePrependSlash] Prepends a forward slash to archive file paths.
 * @property {String} [prefix] Sets a path prefix for the entry name. Useful
 * when working with methods like `directory` or `glob`.
 * @property {fs.Stats} [stats] Sets the fs stat data for this entry allowing
 * for reduction of fs stat calls when stat data is already known.
 * @property {Boolean} [store=ZipOptions.store] Sets the compression method to STORE.
 */

/**
 * ZipStream Module
 * @external ZipStream
 * @see {@link https://www.archiverjs.com/zip-stream/ZipStream.html}
 */


/***/ }),

/***/ 83407:
/***/ ((module) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.


module.exports = {

  newInvalidAsn1Error: function (msg) {
    var e = new Error();
    e.name = 'InvalidAsn1Error';
    e.message = msg || '';
    return e;
  }

};


/***/ }),

/***/ 20279:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.

var errors = __webpack_require__(83407);
var types = __webpack_require__(34478);

var Reader = __webpack_require__(24578);
var Writer = __webpack_require__(3609);


// --- Exports

module.exports = {

  Reader: Reader,

  Writer: Writer

};

for (var t in types) {
  if (types.hasOwnProperty(t))
    module.exports[t] = types[t];
}
for (var e in errors) {
  if (errors.hasOwnProperty(e))
    module.exports[e] = errors[e];
}


/***/ }),

/***/ 24578:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.

var assert = __webpack_require__(39491);
var Buffer = (__webpack_require__(2399).Buffer);

var ASN1 = __webpack_require__(34478);
var errors = __webpack_require__(83407);


// --- Globals

var newInvalidAsn1Error = errors.newInvalidAsn1Error;



// --- API

function Reader(data) {
  if (!data || !Buffer.isBuffer(data))
    throw new TypeError('data must be a node Buffer');

  this._buf = data;
  this._size = data.length;

  // These hold the "current" state
  this._len = 0;
  this._offset = 0;
}

Object.defineProperty(Reader.prototype, 'length', {
  enumerable: true,
  get: function () { return (this._len); }
});

Object.defineProperty(Reader.prototype, 'offset', {
  enumerable: true,
  get: function () { return (this._offset); }
});

Object.defineProperty(Reader.prototype, 'remain', {
  get: function () { return (this._size - this._offset); }
});

Object.defineProperty(Reader.prototype, 'buffer', {
  get: function () { return (this._buf.slice(this._offset)); }
});


/**
 * Reads a single byte and advances offset; you can pass in `true` to make this
 * a "peek" operation (i.e., get the byte, but don't advance the offset).
 *
 * @param {Boolean} peek true means don't move offset.
 * @return {Number} the next byte, null if not enough data.
 */
Reader.prototype.readByte = function (peek) {
  if (this._size - this._offset < 1)
    return null;

  var b = this._buf[this._offset] & 0xff;

  if (!peek)
    this._offset += 1;

  return b;
};


Reader.prototype.peek = function () {
  return this.readByte(true);
};


/**
 * Reads a (potentially) variable length off the BER buffer.  This call is
 * not really meant to be called directly, as callers have to manipulate
 * the internal buffer afterwards.
 *
 * As a result of this call, you can call `Reader.length`, until the
 * next thing called that does a readLength.
 *
 * @return {Number} the amount of offset to advance the buffer.
 * @throws {InvalidAsn1Error} on bad ASN.1
 */
Reader.prototype.readLength = function (offset) {
  if (offset === undefined)
    offset = this._offset;

  if (offset >= this._size)
    return null;

  var lenB = this._buf[offset++] & 0xff;
  if (lenB === null)
    return null;

  if ((lenB & 0x80) === 0x80) {
    lenB &= 0x7f;

    if (lenB === 0)
      throw newInvalidAsn1Error('Indefinite length not supported');

    if (lenB > 4)
      throw newInvalidAsn1Error('encoding too long');

    if (this._size - offset < lenB)
      return null;

    this._len = 0;
    for (var i = 0; i < lenB; i++)
      this._len = (this._len << 8) + (this._buf[offset++] & 0xff);

  } else {
    // Wasn't a variable length
    this._len = lenB;
  }

  return offset;
};


/**
 * Parses the next sequence in this BER buffer.
 *
 * To get the length of the sequence, call `Reader.length`.
 *
 * @return {Number} the sequence's tag.
 */
Reader.prototype.readSequence = function (tag) {
  var seq = this.peek();
  if (seq === null)
    return null;
  if (tag !== undefined && tag !== seq)
    throw newInvalidAsn1Error('Expected 0x' + tag.toString(16) +
                              ': got 0x' + seq.toString(16));

  var o = this.readLength(this._offset + 1); // stored in `length`
  if (o === null)
    return null;

  this._offset = o;
  return seq;
};


Reader.prototype.readInt = function () {
  return this._readTag(ASN1.Integer);
};


Reader.prototype.readBoolean = function () {
  return (this._readTag(ASN1.Boolean) === 0 ? false : true);
};


Reader.prototype.readEnumeration = function () {
  return this._readTag(ASN1.Enumeration);
};


Reader.prototype.readString = function (tag, retbuf) {
  if (!tag)
    tag = ASN1.OctetString;

  var b = this.peek();
  if (b === null)
    return null;

  if (b !== tag)
    throw newInvalidAsn1Error('Expected 0x' + tag.toString(16) +
                              ': got 0x' + b.toString(16));

  var o = this.readLength(this._offset + 1); // stored in `length`

  if (o === null)
    return null;

  if (this.length > this._size - o)
    return null;

  this._offset = o;

  if (this.length === 0)
    return retbuf ? Buffer.alloc(0) : '';

  var str = this._buf.slice(this._offset, this._offset + this.length);
  this._offset += this.length;

  return retbuf ? str : str.toString('utf8');
};

Reader.prototype.readOID = function (tag) {
  if (!tag)
    tag = ASN1.OID;

  var b = this.readString(tag, true);
  if (b === null)
    return null;

  var values = [];
  var value = 0;

  for (var i = 0; i < b.length; i++) {
    var byte = b[i] & 0xff;

    value <<= 7;
    value += byte & 0x7f;
    if ((byte & 0x80) === 0) {
      values.push(value);
      value = 0;
    }
  }

  value = values.shift();
  values.unshift(value % 40);
  values.unshift((value / 40) >> 0);

  return values.join('.');
};


Reader.prototype._readTag = function (tag) {
  assert.ok(tag !== undefined);

  var b = this.peek();

  if (b === null)
    return null;

  if (b !== tag)
    throw newInvalidAsn1Error('Expected 0x' + tag.toString(16) +
                              ': got 0x' + b.toString(16));

  var o = this.readLength(this._offset + 1); // stored in `length`
  if (o === null)
    return null;

  if (this.length > 4)
    throw newInvalidAsn1Error('Integer too long: ' + this.length);

  if (this.length > this._size - o)
    return null;
  this._offset = o;

  var fb = this._buf[this._offset];
  var value = 0;

  for (var i = 0; i < this.length; i++) {
    value <<= 8;
    value |= (this._buf[this._offset++] & 0xff);
  }

  if ((fb & 0x80) === 0x80 && i !== 4)
    value -= (1 << (i * 8));

  return value >> 0;
};



// --- Exported API

module.exports = Reader;


/***/ }),

/***/ 34478:
/***/ ((module) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.


module.exports = {
  EOC: 0,
  Boolean: 1,
  Integer: 2,
  BitString: 3,
  OctetString: 4,
  Null: 5,
  OID: 6,
  ObjectDescriptor: 7,
  External: 8,
  Real: 9, // float
  Enumeration: 10,
  PDV: 11,
  Utf8String: 12,
  RelativeOID: 13,
  Sequence: 16,
  Set: 17,
  NumericString: 18,
  PrintableString: 19,
  T61String: 20,
  VideotexString: 21,
  IA5String: 22,
  UTCTime: 23,
  GeneralizedTime: 24,
  GraphicString: 25,
  VisibleString: 26,
  GeneralString: 28,
  UniversalString: 29,
  CharacterString: 30,
  BMPString: 31,
  Constructor: 32,
  Context: 128
};


/***/ }),

/***/ 3609:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.

var assert = __webpack_require__(39491);
var Buffer = (__webpack_require__(2399).Buffer);
var ASN1 = __webpack_require__(34478);
var errors = __webpack_require__(83407);


// --- Globals

var newInvalidAsn1Error = errors.newInvalidAsn1Error;

var DEFAULT_OPTS = {
  size: 1024,
  growthFactor: 8
};


// --- Helpers

function merge(from, to) {
  assert.ok(from);
  assert.equal(typeof (from), 'object');
  assert.ok(to);
  assert.equal(typeof (to), 'object');

  var keys = Object.getOwnPropertyNames(from);
  keys.forEach(function (key) {
    if (to[key])
      return;

    var value = Object.getOwnPropertyDescriptor(from, key);
    Object.defineProperty(to, key, value);
  });

  return to;
}



// --- API

function Writer(options) {
  options = merge(DEFAULT_OPTS, options || {});

  this._buf = Buffer.alloc(options.size || 1024);
  this._size = this._buf.length;
  this._offset = 0;
  this._options = options;

  // A list of offsets in the buffer where we need to insert
  // sequence tag/len pairs.
  this._seq = [];
}

Object.defineProperty(Writer.prototype, 'buffer', {
  get: function () {
    if (this._seq.length)
      throw newInvalidAsn1Error(this._seq.length + ' unended sequence(s)');

    return (this._buf.slice(0, this._offset));
  }
});

Writer.prototype.writeByte = function (b) {
  if (typeof (b) !== 'number')
    throw new TypeError('argument must be a Number');

  this._ensure(1);
  this._buf[this._offset++] = b;
};


Writer.prototype.writeInt = function (i, tag) {
  if (typeof (i) !== 'number')
    throw new TypeError('argument must be a Number');
  if (typeof (tag) !== 'number')
    tag = ASN1.Integer;

  var sz = 4;

  while ((((i & 0xff800000) === 0) || ((i & 0xff800000) === 0xff800000 >> 0)) &&
        (sz > 1)) {
    sz--;
    i <<= 8;
  }

  if (sz > 4)
    throw newInvalidAsn1Error('BER ints cannot be > 0xffffffff');

  this._ensure(2 + sz);
  this._buf[this._offset++] = tag;
  this._buf[this._offset++] = sz;

  while (sz-- > 0) {
    this._buf[this._offset++] = ((i & 0xff000000) >>> 24);
    i <<= 8;
  }

};


Writer.prototype.writeNull = function () {
  this.writeByte(ASN1.Null);
  this.writeByte(0x00);
};


Writer.prototype.writeEnumeration = function (i, tag) {
  if (typeof (i) !== 'number')
    throw new TypeError('argument must be a Number');
  if (typeof (tag) !== 'number')
    tag = ASN1.Enumeration;

  return this.writeInt(i, tag);
};


Writer.prototype.writeBoolean = function (b, tag) {
  if (typeof (b) !== 'boolean')
    throw new TypeError('argument must be a Boolean');
  if (typeof (tag) !== 'number')
    tag = ASN1.Boolean;

  this._ensure(3);
  this._buf[this._offset++] = tag;
  this._buf[this._offset++] = 0x01;
  this._buf[this._offset++] = b ? 0xff : 0x00;
};


Writer.prototype.writeString = function (s, tag) {
  if (typeof (s) !== 'string')
    throw new TypeError('argument must be a string (was: ' + typeof (s) + ')');
  if (typeof (tag) !== 'number')
    tag = ASN1.OctetString;

  var len = Buffer.byteLength(s);
  this.writeByte(tag);
  this.writeLength(len);
  if (len) {
    this._ensure(len);
    this._buf.write(s, this._offset);
    this._offset += len;
  }
};


Writer.prototype.writeBuffer = function (buf, tag) {
  if (typeof (tag) !== 'number')
    throw new TypeError('tag must be a number');
  if (!Buffer.isBuffer(buf))
    throw new TypeError('argument must be a buffer');

  this.writeByte(tag);
  this.writeLength(buf.length);
  this._ensure(buf.length);
  buf.copy(this._buf, this._offset, 0, buf.length);
  this._offset += buf.length;
};


Writer.prototype.writeStringArray = function (strings) {
  if ((!strings instanceof Array))
    throw new TypeError('argument must be an Array[String]');

  var self = this;
  strings.forEach(function (s) {
    self.writeString(s);
  });
};

// This is really to solve DER cases, but whatever for now
Writer.prototype.writeOID = function (s, tag) {
  if (typeof (s) !== 'string')
    throw new TypeError('argument must be a string');
  if (typeof (tag) !== 'number')
    tag = ASN1.OID;

  if (!/^([0-9]+\.){3,}[0-9]+$/.test(s))
    throw new Error('argument is not a valid OID string');

  function encodeOctet(bytes, octet) {
    if (octet < 128) {
        bytes.push(octet);
    } else if (octet < 16384) {
        bytes.push((octet >>> 7) | 0x80);
        bytes.push(octet & 0x7F);
    } else if (octet < 2097152) {
      bytes.push((octet >>> 14) | 0x80);
      bytes.push(((octet >>> 7) | 0x80) & 0xFF);
      bytes.push(octet & 0x7F);
    } else if (octet < 268435456) {
      bytes.push((octet >>> 21) | 0x80);
      bytes.push(((octet >>> 14) | 0x80) & 0xFF);
      bytes.push(((octet >>> 7) | 0x80) & 0xFF);
      bytes.push(octet & 0x7F);
    } else {
      bytes.push(((octet >>> 28) | 0x80) & 0xFF);
      bytes.push(((octet >>> 21) | 0x80) & 0xFF);
      bytes.push(((octet >>> 14) | 0x80) & 0xFF);
      bytes.push(((octet >>> 7) | 0x80) & 0xFF);
      bytes.push(octet & 0x7F);
    }
  }

  var tmp = s.split('.');
  var bytes = [];
  bytes.push(parseInt(tmp[0], 10) * 40 + parseInt(tmp[1], 10));
  tmp.slice(2).forEach(function (b) {
    encodeOctet(bytes, parseInt(b, 10));
  });

  var self = this;
  this._ensure(2 + bytes.length);
  this.writeByte(tag);
  this.writeLength(bytes.length);
  bytes.forEach(function (b) {
    self.writeByte(b);
  });
};


Writer.prototype.writeLength = function (len) {
  if (typeof (len) !== 'number')
    throw new TypeError('argument must be a Number');

  this._ensure(4);

  if (len <= 0x7f) {
    this._buf[this._offset++] = len;
  } else if (len <= 0xff) {
    this._buf[this._offset++] = 0x81;
    this._buf[this._offset++] = len;
  } else if (len <= 0xffff) {
    this._buf[this._offset++] = 0x82;
    this._buf[this._offset++] = len >> 8;
    this._buf[this._offset++] = len;
  } else if (len <= 0xffffff) {
    this._buf[this._offset++] = 0x83;
    this._buf[this._offset++] = len >> 16;
    this._buf[this._offset++] = len >> 8;
    this._buf[this._offset++] = len;
  } else {
    throw newInvalidAsn1Error('Length too long (> 4 bytes)');
  }
};

Writer.prototype.startSequence = function (tag) {
  if (typeof (tag) !== 'number')
    tag = ASN1.Sequence | ASN1.Constructor;

  this.writeByte(tag);
  this._seq.push(this._offset);
  this._ensure(3);
  this._offset += 3;
};


Writer.prototype.endSequence = function () {
  var seq = this._seq.pop();
  var start = seq + 3;
  var len = this._offset - start;

  if (len <= 0x7f) {
    this._shift(start, len, -2);
    this._buf[seq] = len;
  } else if (len <= 0xff) {
    this._shift(start, len, -1);
    this._buf[seq] = 0x81;
    this._buf[seq + 1] = len;
  } else if (len <= 0xffff) {
    this._buf[seq] = 0x82;
    this._buf[seq + 1] = len >> 8;
    this._buf[seq + 2] = len;
  } else if (len <= 0xffffff) {
    this._shift(start, len, 1);
    this._buf[seq] = 0x83;
    this._buf[seq + 1] = len >> 16;
    this._buf[seq + 2] = len >> 8;
    this._buf[seq + 3] = len;
  } else {
    throw newInvalidAsn1Error('Sequence too long');
  }
};


Writer.prototype._shift = function (start, len, shift) {
  assert.ok(start !== undefined);
  assert.ok(len !== undefined);
  assert.ok(shift);

  this._buf.copy(this._buf, start + shift, start, start + len);
  this._offset += shift;
};

Writer.prototype._ensure = function (len) {
  assert.ok(len);

  if (this._size - this._offset < len) {
    var sz = this._size * this._options.growthFactor;
    if (sz - this._offset < len)
      sz += len;

    var buf = Buffer.alloc(sz);

    this._buf.copy(buf, 0, 0, this._offset);
    this._buf = buf;
    this._size = sz;
  }
};



// --- Exported API

module.exports = Writer;


/***/ }),

/***/ 90476:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.

// If you have no idea what ASN.1 or BER is, see this:
// ftp://ftp.rsa.com/pub/pkcs/ascii/layman.asc

var Ber = __webpack_require__(20279);



// --- Exported API

module.exports = {

  Ber: Ber,

  BerReader: Ber.Reader,

  BerWriter: Ber.Writer

};


/***/ }),

/***/ 6144:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Copyright (c) 2012, Mark Cavage. All rights reserved.
// Copyright 2015 Joyent, Inc.

var assert = __webpack_require__(39491);
var Stream = (__webpack_require__(12781).Stream);
var util = __webpack_require__(73837);


///--- Globals

/* JSSTYLED */
var UUID_REGEXP = /^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/;


///--- Internal

function _capitalize(str) {
    return (str.charAt(0).toUpperCase() + str.slice(1));
}

function _toss(name, expected, oper, arg, actual) {
    throw new assert.AssertionError({
        message: util.format('%s (%s) is required', name, expected),
        actual: (actual === undefined) ? typeof (arg) : actual(arg),
        expected: expected,
        operator: oper || '===',
        stackStartFunction: _toss.caller
    });
}

function _getClass(arg) {
    return (Object.prototype.toString.call(arg).slice(8, -1));
}

function noop() {
    // Why even bother with asserts?
}


///--- Exports

var types = {
    bool: {
        check: function (arg) { return typeof (arg) === 'boolean'; }
    },
    func: {
        check: function (arg) { return typeof (arg) === 'function'; }
    },
    string: {
        check: function (arg) { return typeof (arg) === 'string'; }
    },
    object: {
        check: function (arg) {
            return typeof (arg) === 'object' && arg !== null;
        }
    },
    number: {
        check: function (arg) {
            return typeof (arg) === 'number' && !isNaN(arg);
        }
    },
    finite: {
        check: function (arg) {
            return typeof (arg) === 'number' && !isNaN(arg) && isFinite(arg);
        }
    },
    buffer: {
        check: function (arg) { return Buffer.isBuffer(arg); },
        operator: 'Buffer.isBuffer'
    },
    array: {
        check: function (arg) { return Array.isArray(arg); },
        operator: 'Array.isArray'
    },
    stream: {
        check: function (arg) { return arg instanceof Stream; },
        operator: 'instanceof',
        actual: _getClass
    },
    date: {
        check: function (arg) { return arg instanceof Date; },
        operator: 'instanceof',
        actual: _getClass
    },
    regexp: {
        check: function (arg) { return arg instanceof RegExp; },
        operator: 'instanceof',
        actual: _getClass
    },
    uuid: {
        check: function (arg) {
            return typeof (arg) === 'string' && UUID_REGEXP.test(arg);
        },
        operator: 'isUUID'
    }
};

function _setExports(ndebug) {
    var keys = Object.keys(types);
    var out;

    /* re-export standard assert */
    if (process.env.NODE_NDEBUG) {
        out = noop;
    } else {
        out = function (arg, msg) {
            if (!arg) {
                _toss(msg, 'true', arg);
            }
        };
    }

    /* standard checks */
    keys.forEach(function (k) {
        if (ndebug) {
            out[k] = noop;
            return;
        }
        var type = types[k];
        out[k] = function (arg, msg) {
            if (!type.check(arg)) {
                _toss(msg, k, type.operator, arg, type.actual);
            }
        };
    });

    /* optional checks */
    keys.forEach(function (k) {
        var name = 'optional' + _capitalize(k);
        if (ndebug) {
            out[name] = noop;
            return;
        }
        var type = types[k];
        out[name] = function (arg, msg) {
            if (arg === undefined || arg === null) {
                return;
            }
            if (!type.check(arg)) {
                _toss(msg, k, type.operator, arg, type.actual);
            }
        };
    });

    /* arrayOf checks */
    keys.forEach(function (k) {
        var name = 'arrayOf' + _capitalize(k);
        if (ndebug) {
            out[name] = noop;
            return;
        }
        var type = types[k];
        var expected = '[' + k + ']';
        out[name] = function (arg, msg) {
            if (!Array.isArray(arg)) {
                _toss(msg, expected, type.operator, arg, type.actual);
            }
            var i;
            for (i = 0; i < arg.length; i++) {
                if (!type.check(arg[i])) {
                    _toss(msg, expected, type.operator, arg, type.actual);
                }
            }
        };
    });

    /* optionalArrayOf checks */
    keys.forEach(function (k) {
        var name = 'optionalArrayOf' + _capitalize(k);
        if (ndebug) {
            out[name] = noop;
            return;
        }
        var type = types[k];
        var expected = '[' + k + ']';
        out[name] = function (arg, msg) {
            if (arg === undefined || arg === null) {
                return;
            }
            if (!Array.isArray(arg)) {
                _toss(msg, expected, type.operator, arg, type.actual);
            }
            var i;
            for (i = 0; i < arg.length; i++) {
                if (!type.check(arg[i])) {
                    _toss(msg, expected, type.operator, arg, type.actual);
                }
            }
        };
    });

    /* re-export built-in assertions */
    Object.keys(assert).forEach(function (k) {
        if (k === 'AssertionError') {
            out[k] = assert[k];
            return;
        }
        if (ndebug) {
            out[k] = noop;
            return;
        }
        out[k] = assert[k];
    });

    /* export ourselves (for unit tests _only_) */
    out._setExports = _setExports;

    return out;
}

module.exports = _setExports(process.env.NODE_NDEBUG);


/***/ }),

/***/ 64658:
/***/ ((module) => {

"use strict";

const regex = '[\uD800-\uDBFF][\uDC00-\uDFFF]';

const astralRegex = options => options && options.exact ? new RegExp(`^${regex}$`) : new RegExp(regex, 'g');

module.exports = astralRegex;


/***/ }),

/***/ 59118:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports =
{
  parallel      : __webpack_require__(19162),
  serial        : __webpack_require__(31357),
  serialOrdered : __webpack_require__(69087)
};


/***/ }),

/***/ 37651:
/***/ ((module) => {

// API
module.exports = abort;

/**
 * Aborts leftover active jobs
 *
 * @param {object} state - current state object
 */
function abort(state)
{
  Object.keys(state.jobs).forEach(clean.bind(state));

  // reset leftover jobs
  state.jobs = {};
}

/**
 * Cleans up leftover job by invoking abort function for the provided job id
 *
 * @this  state
 * @param {string|number} key - job id to abort
 */
function clean(key)
{
  if (typeof this.jobs[key] == 'function')
  {
    this.jobs[key]();
  }
}


/***/ }),

/***/ 55912:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var defer = __webpack_require__(9265);

// API
module.exports = async;

/**
 * Runs provided callback asynchronously
 * even if callback itself is not
 *
 * @param   {function} callback - callback to invoke
 * @returns {function} - augmented callback
 */
function async(callback)
{
  var isAsync = false;

  // check if async happened
  defer(function() { isAsync = true; });

  return function async_callback(err, result)
  {
    if (isAsync)
    {
      callback(err, result);
    }
    else
    {
      defer(function nextTick_callback()
      {
        callback(err, result);
      });
    }
  };
}


/***/ }),

/***/ 9265:
/***/ ((module) => {

module.exports = defer;

/**
 * Runs provided function on next iteration of the event loop
 *
 * @param {function} fn - function to run
 */
function defer(fn)
{
  var nextTick = typeof setImmediate == 'function'
    ? setImmediate
    : (
      typeof process == 'object' && typeof process.nextTick == 'function'
      ? process.nextTick
      : null
    );

  if (nextTick)
  {
    nextTick(fn);
  }
  else
  {
    setTimeout(fn, 0);
  }
}


/***/ }),

/***/ 97594:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var async = __webpack_require__(55912)
  , abort = __webpack_require__(37651)
  ;

// API
module.exports = iterate;

/**
 * Iterates over each job object
 *
 * @param {array|object} list - array or object (named list) to iterate over
 * @param {function} iterator - iterator to run
 * @param {object} state - current job status
 * @param {function} callback - invoked when all elements processed
 */
function iterate(list, iterator, state, callback)
{
  // store current index
  var key = state['keyedList'] ? state['keyedList'][state.index] : state.index;

  state.jobs[key] = runJob(iterator, key, list[key], function(error, output)
  {
    // don't repeat yourself
    // skip secondary callbacks
    if (!(key in state.jobs))
    {
      return;
    }

    // clean up jobs
    delete state.jobs[key];

    if (error)
    {
      // don't process rest of the results
      // stop still active jobs
      // and reset the list
      abort(state);
    }
    else
    {
      state.results[key] = output;
    }

    // return salvaged results
    callback(error, state.results);
  });
}

/**
 * Runs iterator over provided job element
 *
 * @param   {function} iterator - iterator to invoke
 * @param   {string|number} key - key/index of the element in the list of jobs
 * @param   {mixed} item - job description
 * @param   {function} callback - invoked after iterator is done with the job
 * @returns {function|mixed} - job abort function or something else
 */
function runJob(iterator, key, item, callback)
{
  var aborter;

  // allow shortcut if iterator expects only two arguments
  if (iterator.length == 2)
  {
    aborter = iterator(item, async(callback));
  }
  // otherwise go with full three arguments
  else
  {
    aborter = iterator(item, key, async(callback));
  }

  return aborter;
}


/***/ }),

/***/ 94528:
/***/ ((module) => {

// API
module.exports = state;

/**
 * Creates initial state object
 * for iteration over list
 *
 * @param   {array|object} list - list to iterate over
 * @param   {function|null} sortMethod - function to use for keys sort,
 *                                     or `null` to keep them as is
 * @returns {object} - initial state object
 */
function state(list, sortMethod)
{
  var isNamedList = !Array.isArray(list)
    , initState =
    {
      index    : 0,
      keyedList: isNamedList || sortMethod ? Object.keys(list) : null,
      jobs     : {},
      results  : isNamedList ? {} : [],
      size     : isNamedList ? Object.keys(list).length : list.length
    }
    ;

  if (sortMethod)
  {
    // sort array keys based on it's values
    // sort object's keys just on own merit
    initState.keyedList.sort(isNamedList ? sortMethod : function(a, b)
    {
      return sortMethod(list[a], list[b]);
    });
  }

  return initState;
}


/***/ }),

/***/ 25353:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var abort = __webpack_require__(37651)
  , async = __webpack_require__(55912)
  ;

// API
module.exports = terminator;

/**
 * Terminates jobs in the attached state context
 *
 * @this  AsyncKitState#
 * @param {function} callback - final callback to invoke after termination
 */
function terminator(callback)
{
  if (!Object.keys(this.jobs).length)
  {
    return;
  }

  // fast forward iteration index
  this.index = this.size;

  // abort jobs
  abort(this);

  // send back results we have so far
  async(callback)(null, this.results);
}


/***/ }),

/***/ 19162:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var iterate    = __webpack_require__(97594)
  , initState  = __webpack_require__(94528)
  , terminator = __webpack_require__(25353)
  ;

// Public API
module.exports = parallel;

/**
 * Runs iterator over provided array elements in parallel
 *
 * @param   {array|object} list - array or object (named list) to iterate over
 * @param   {function} iterator - iterator to run
 * @param   {function} callback - invoked when all elements processed
 * @returns {function} - jobs terminator
 */
function parallel(list, iterator, callback)
{
  var state = initState(list);

  while (state.index < (state['keyedList'] || list).length)
  {
    iterate(list, iterator, state, function(error, result)
    {
      if (error)
      {
        callback(error, result);
        return;
      }

      // looks like it's the last one
      if (Object.keys(state.jobs).length === 0)
      {
        callback(null, state.results);
        return;
      }
    });

    state.index++;
  }

  return terminator.bind(state, callback);
}


/***/ }),

/***/ 31357:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var serialOrdered = __webpack_require__(69087);

// Public API
module.exports = serial;

/**
 * Runs iterator over provided array elements in series
 *
 * @param   {array|object} list - array or object (named list) to iterate over
 * @param   {function} iterator - iterator to run
 * @param   {function} callback - invoked when all elements processed
 * @returns {function} - jobs terminator
 */
function serial(list, iterator, callback)
{
  return serialOrdered(list, iterator, null, callback);
}


/***/ }),

/***/ 69087:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var iterate    = __webpack_require__(97594)
  , initState  = __webpack_require__(94528)
  , terminator = __webpack_require__(25353)
  ;

// Public API
module.exports = serialOrdered;
// sorting helpers
module.exports.ascending  = ascending;
module.exports.descending = descending;

/**
 * Runs iterator over provided sorted array elements in series
 *
 * @param   {array|object} list - array or object (named list) to iterate over
 * @param   {function} iterator - iterator to run
 * @param   {function} sortMethod - custom sort function
 * @param   {function} callback - invoked when all elements processed
 * @returns {function} - jobs terminator
 */
function serialOrdered(list, iterator, sortMethod, callback)
{
  var state = initState(list, sortMethod);

  iterate(list, iterator, state, function iteratorHandler(error, result)
  {
    if (error)
    {
      callback(error, result);
      return;
    }

    state.index++;

    // are we there yet?
    if (state.index < (state['keyedList'] || list).length)
    {
      iterate(list, iterator, state, iteratorHandler);
      return;
    }

    // done here
    callback(null, state.results);
  });

  return terminator.bind(state, callback);
}

/*
 * -- Sort methods
 */

/**
 * sort helper to sort array elements in ascending order
 *
 * @param   {mixed} a - an item to compare
 * @param   {mixed} b - an item to compare
 * @returns {number} - comparison result
 */
function ascending(a, b)
{
  return a < b ? -1 : a > b ? 1 : 0;
}

/**
 * sort helper to sort array elements in descending order
 *
 * @param   {mixed} a - an item to compare
 * @param   {mixed} b - an item to compare
 * @returns {number} - comparison result
 */
function descending(a, b)
{
  return -1 * ascending(a, b);
}


/***/ }),

/***/ 17555:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


/*!
 *  Copyright 2010 LearnBoost <dev@learnboost.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Module dependencies.
 */

var crypto = __webpack_require__(6113)
  , parse = (__webpack_require__(57310).parse)
  ;

/**
 * Valid keys.
 */

var keys = 
  [ 'acl'
  , 'location'
  , 'logging'
  , 'notification'
  , 'partNumber'
  , 'policy'
  , 'requestPayment'
  , 'torrent'
  , 'uploadId'
  , 'uploads'
  , 'versionId'
  , 'versioning'
  , 'versions'
  , 'website'
  ]

/**
 * Return an "Authorization" header value with the given `options`
 * in the form of "AWS <key>:<signature>"
 *
 * @param {Object} options
 * @return {String}
 * @api private
 */

function authorization (options) {
  return 'AWS ' + options.key + ':' + sign(options)
}

module.exports = authorization
module.exports.authorization = authorization

/**
 * Simple HMAC-SHA1 Wrapper
 *
 * @param {Object} options
 * @return {String}
 * @api private
 */ 

function hmacSha1 (options) {
  return crypto.createHmac('sha1', options.secret).update(options.message).digest('base64')
}

module.exports.hmacSha1 = hmacSha1

/**
 * Create a base64 sha1 HMAC for `options`. 
 * 
 * @param {Object} options
 * @return {String}
 * @api private
 */

function sign (options) {
  options.message = stringToSign(options)
  return hmacSha1(options)
}
module.exports.sign = sign

/**
 * Create a base64 sha1 HMAC for `options`. 
 *
 * Specifically to be used with S3 presigned URLs
 * 
 * @param {Object} options
 * @return {String}
 * @api private
 */

function signQuery (options) {
  options.message = queryStringToSign(options)
  return hmacSha1(options)
}
module.exports.signQuery= signQuery

/**
 * Return a string for sign() with the given `options`.
 *
 * Spec:
 * 
 *    <verb>\n
 *    <md5>\n
 *    <content-type>\n
 *    <date>\n
 *    [headers\n]
 *    <resource>
 *
 * @param {Object} options
 * @return {String}
 * @api private
 */

function stringToSign (options) {
  var headers = options.amazonHeaders || ''
  if (headers) headers += '\n'
  var r = 
    [ options.verb
    , options.md5
    , options.contentType
    , options.date ? options.date.toUTCString() : ''
    , headers + options.resource
    ]
  return r.join('\n')
}
module.exports.stringToSign = stringToSign

/**
 * Return a string for sign() with the given `options`, but is meant exclusively
 * for S3 presigned URLs
 *
 * Spec:
 * 
 *    <date>\n
 *    <resource>
 *
 * @param {Object} options
 * @return {String}
 * @api private
 */

function queryStringToSign (options){
  return 'GET\n\n\n' + options.date + '\n' + options.resource
}
module.exports.queryStringToSign = queryStringToSign

/**
 * Perform the following:
 *
 *  - ignore non-amazon headers
 *  - lowercase fields
 *  - sort lexicographically
 *  - trim whitespace between ":"
 *  - join with newline
 *
 * @param {Object} headers
 * @return {String}
 * @api private
 */

function canonicalizeHeaders (headers) {
  var buf = []
    , fields = Object.keys(headers)
    ;
  for (var i = 0, len = fields.length; i < len; ++i) {
    var field = fields[i]
      , val = headers[field]
      , field = field.toLowerCase()
      ;
    if (0 !== field.indexOf('x-amz')) continue
    buf.push(field + ':' + val)
  }
  return buf.sort().join('\n')
}
module.exports.canonicalizeHeaders = canonicalizeHeaders

/**
 * Perform the following:
 *
 *  - ignore non sub-resources
 *  - sort lexicographically
 *
 * @param {String} resource
 * @return {String}
 * @api private
 */

function canonicalizeResource (resource) {
  var url = parse(resource, true)
    , path = url.pathname
    , buf = []
    ;

  Object.keys(url.query).forEach(function(key){
    if (!~keys.indexOf(key)) return
    var val = '' == url.query[key] ? '' : '=' + encodeURIComponent(url.query[key])
    buf.push(key + val)
  })

  return path + (buf.length ? '?' + buf.sort().join('&') : '')
}
module.exports.canonicalizeResource = canonicalizeResource


/***/ }),

/***/ 95195:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var aws4 = exports,
    url = __webpack_require__(57310),
    querystring = __webpack_require__(63477),
    crypto = __webpack_require__(6113),
    lru = __webpack_require__(59864),
    credentialsCache = lru(1000)

// http://docs.amazonwebservices.com/general/latest/gr/signature-version-4.html

function hmac(key, string, encoding) {
  return crypto.createHmac('sha256', key).update(string, 'utf8').digest(encoding)
}

function hash(string, encoding) {
  return crypto.createHash('sha256').update(string, 'utf8').digest(encoding)
}

// This function assumes the string has already been percent encoded
function encodeRfc3986(urlEncodedString) {
  return urlEncodedString.replace(/[!'()*]/g, function(c) {
    return '%' + c.charCodeAt(0).toString(16).toUpperCase()
  })
}

function encodeRfc3986Full(str) {
  return encodeRfc3986(encodeURIComponent(str))
}

// A bit of a combination of:
// https://github.com/aws/aws-sdk-java-v2/blob/dc695de6ab49ad03934e1b02e7263abbd2354be0/core/auth/src/main/java/software/amazon/awssdk/auth/signer/internal/AbstractAws4Signer.java#L59
// https://github.com/aws/aws-sdk-js/blob/18cb7e5b463b46239f9fdd4a65e2ff8c81831e8f/lib/signers/v4.js#L191-L199
// https://github.com/mhart/aws4fetch/blob/b3aed16b6f17384cf36ea33bcba3c1e9f3bdfefd/src/main.js#L25-L34
var HEADERS_TO_IGNORE = {
  'authorization': true,
  'connection': true,
  'x-amzn-trace-id': true,
  'user-agent': true,
  'expect': true,
  'presigned-expires': true,
  'range': true,
}

// request: { path | body, [host], [method], [headers], [service], [region] }
// credentials: { accessKeyId, secretAccessKey, [sessionToken] }
function RequestSigner(request, credentials) {

  if (typeof request === 'string') request = url.parse(request)

  var headers = request.headers = (request.headers || {}),
      hostParts = (!this.service || !this.region) && this.matchHost(request.hostname || request.host || headers.Host || headers.host)

  this.request = request
  this.credentials = credentials || this.defaultCredentials()

  this.service = request.service || hostParts[0] || ''
  this.region = request.region || hostParts[1] || 'us-east-1'

  // SES uses a different domain from the service name
  if (this.service === 'email') this.service = 'ses'

  if (!request.method && request.body)
    request.method = 'POST'

  if (!headers.Host && !headers.host) {
    headers.Host = request.hostname || request.host || this.createHost()

    // If a port is specified explicitly, use it as is
    if (request.port)
      headers.Host += ':' + request.port
  }
  if (!request.hostname && !request.host)
    request.hostname = headers.Host || headers.host

  this.isCodeCommitGit = this.service === 'codecommit' && request.method === 'GIT'

  this.extraHeadersToIgnore = request.extraHeadersToIgnore || Object.create(null)
  this.extraHeadersToInclude = request.extraHeadersToInclude || Object.create(null)
}

RequestSigner.prototype.matchHost = function(host) {
  var match = (host || '').match(/([^\.]+)\.(?:([^\.]*)\.)?amazonaws\.com(\.cn)?$/)
  var hostParts = (match || []).slice(1, 3)

  // ES's hostParts are sometimes the other way round, if the value that is expected
  // to be region equals ‘es’ switch them back
  // e.g. search-cluster-name-aaaa00aaaa0aaa0aaaaaaa0aaa.us-east-1.es.amazonaws.com
  if (hostParts[1] === 'es' || hostParts[1] === 'aoss')
    hostParts = hostParts.reverse()

  if (hostParts[1] == 's3') {
    hostParts[0] = 's3'
    hostParts[1] = 'us-east-1'
  } else {
    for (var i = 0; i < 2; i++) {
      if (/^s3-/.test(hostParts[i])) {
        hostParts[1] = hostParts[i].slice(3)
        hostParts[0] = 's3'
        break
      }
    }
  }

  return hostParts
}

// http://docs.aws.amazon.com/general/latest/gr/rande.html
RequestSigner.prototype.isSingleRegion = function() {
  // Special case for S3 and SimpleDB in us-east-1
  if (['s3', 'sdb'].indexOf(this.service) >= 0 && this.region === 'us-east-1') return true

  return ['cloudfront', 'ls', 'route53', 'iam', 'importexport', 'sts']
    .indexOf(this.service) >= 0
}

RequestSigner.prototype.createHost = function() {
  var region = this.isSingleRegion() ? '' : '.' + this.region,
      subdomain = this.service === 'ses' ? 'email' : this.service
  return subdomain + region + '.amazonaws.com'
}

RequestSigner.prototype.prepareRequest = function() {
  this.parsePath()

  var request = this.request, headers = request.headers, query

  if (request.signQuery) {

    this.parsedPath.query = query = this.parsedPath.query || {}

    if (this.credentials.sessionToken)
      query['X-Amz-Security-Token'] = this.credentials.sessionToken

    if (this.service === 's3' && !query['X-Amz-Expires'])
      query['X-Amz-Expires'] = 86400

    if (query['X-Amz-Date'])
      this.datetime = query['X-Amz-Date']
    else
      query['X-Amz-Date'] = this.getDateTime()

    query['X-Amz-Algorithm'] = 'AWS4-HMAC-SHA256'
    query['X-Amz-Credential'] = this.credentials.accessKeyId + '/' + this.credentialString()
    query['X-Amz-SignedHeaders'] = this.signedHeaders()

  } else {

    if (!request.doNotModifyHeaders && !this.isCodeCommitGit) {
      if (request.body && !headers['Content-Type'] && !headers['content-type'])
        headers['Content-Type'] = 'application/x-www-form-urlencoded; charset=utf-8'

      if (request.body && !headers['Content-Length'] && !headers['content-length'])
        headers['Content-Length'] = Buffer.byteLength(request.body)

      if (this.credentials.sessionToken && !headers['X-Amz-Security-Token'] && !headers['x-amz-security-token'])
        headers['X-Amz-Security-Token'] = this.credentials.sessionToken

      if (this.service === 's3' && !headers['X-Amz-Content-Sha256'] && !headers['x-amz-content-sha256'])
        headers['X-Amz-Content-Sha256'] = hash(this.request.body || '', 'hex')

      if (headers['X-Amz-Date'] || headers['x-amz-date'])
        this.datetime = headers['X-Amz-Date'] || headers['x-amz-date']
      else
        headers['X-Amz-Date'] = this.getDateTime()
    }

    delete headers.Authorization
    delete headers.authorization
  }
}

RequestSigner.prototype.sign = function() {
  if (!this.parsedPath) this.prepareRequest()

  if (this.request.signQuery) {
    this.parsedPath.query['X-Amz-Signature'] = this.signature()
  } else {
    this.request.headers.Authorization = this.authHeader()
  }

  this.request.path = this.formatPath()

  return this.request
}

RequestSigner.prototype.getDateTime = function() {
  if (!this.datetime) {
    var headers = this.request.headers,
      date = new Date(headers.Date || headers.date || new Date)

    this.datetime = date.toISOString().replace(/[:\-]|\.\d{3}/g, '')

    // Remove the trailing 'Z' on the timestamp string for CodeCommit git access
    if (this.isCodeCommitGit) this.datetime = this.datetime.slice(0, -1)
  }
  return this.datetime
}

RequestSigner.prototype.getDate = function() {
  return this.getDateTime().substr(0, 8)
}

RequestSigner.prototype.authHeader = function() {
  return [
    'AWS4-HMAC-SHA256 Credential=' + this.credentials.accessKeyId + '/' + this.credentialString(),
    'SignedHeaders=' + this.signedHeaders(),
    'Signature=' + this.signature(),
  ].join(', ')
}

RequestSigner.prototype.signature = function() {
  var date = this.getDate(),
      cacheKey = [this.credentials.secretAccessKey, date, this.region, this.service].join(),
      kDate, kRegion, kService, kCredentials = credentialsCache.get(cacheKey)
  if (!kCredentials) {
    kDate = hmac('AWS4' + this.credentials.secretAccessKey, date)
    kRegion = hmac(kDate, this.region)
    kService = hmac(kRegion, this.service)
    kCredentials = hmac(kService, 'aws4_request')
    credentialsCache.set(cacheKey, kCredentials)
  }
  return hmac(kCredentials, this.stringToSign(), 'hex')
}

RequestSigner.prototype.stringToSign = function() {
  return [
    'AWS4-HMAC-SHA256',
    this.getDateTime(),
    this.credentialString(),
    hash(this.canonicalString(), 'hex'),
  ].join('\n')
}

RequestSigner.prototype.canonicalString = function() {
  if (!this.parsedPath) this.prepareRequest()

  var pathStr = this.parsedPath.path,
      query = this.parsedPath.query,
      headers = this.request.headers,
      queryStr = '',
      normalizePath = this.service !== 's3',
      decodePath = this.service === 's3' || this.request.doNotEncodePath,
      decodeSlashesInPath = this.service === 's3',
      firstValOnly = this.service === 's3',
      bodyHash

  if (this.service === 's3' && this.request.signQuery) {
    bodyHash = 'UNSIGNED-PAYLOAD'
  } else if (this.isCodeCommitGit) {
    bodyHash = ''
  } else {
    bodyHash = headers['X-Amz-Content-Sha256'] || headers['x-amz-content-sha256'] ||
      hash(this.request.body || '', 'hex')
  }

  if (query) {
    var reducedQuery = Object.keys(query).reduce(function(obj, key) {
      if (!key) return obj
      obj[encodeRfc3986Full(key)] = !Array.isArray(query[key]) ? query[key] :
        (firstValOnly ? query[key][0] : query[key])
      return obj
    }, {})
    var encodedQueryPieces = []
    Object.keys(reducedQuery).sort().forEach(function(key) {
      if (!Array.isArray(reducedQuery[key])) {
        encodedQueryPieces.push(key + '=' + encodeRfc3986Full(reducedQuery[key]))
      } else {
        reducedQuery[key].map(encodeRfc3986Full).sort()
          .forEach(function(val) { encodedQueryPieces.push(key + '=' + val) })
      }
    })
    queryStr = encodedQueryPieces.join('&')
  }
  if (pathStr !== '/') {
    if (normalizePath) pathStr = pathStr.replace(/\/{2,}/g, '/')
    pathStr = pathStr.split('/').reduce(function(path, piece) {
      if (normalizePath && piece === '..') {
        path.pop()
      } else if (!normalizePath || piece !== '.') {
        if (decodePath) piece = decodeURIComponent(piece.replace(/\+/g, ' '))
        path.push(encodeRfc3986Full(piece))
      }
      return path
    }, []).join('/')
    if (pathStr[0] !== '/') pathStr = '/' + pathStr
    if (decodeSlashesInPath) pathStr = pathStr.replace(/%2F/g, '/')
  }

  return [
    this.request.method || 'GET',
    pathStr,
    queryStr,
    this.canonicalHeaders() + '\n',
    this.signedHeaders(),
    bodyHash,
  ].join('\n')
}

RequestSigner.prototype.canonicalHeaders = function() {
  var headers = this.request.headers
  function trimAll(header) {
    return header.toString().trim().replace(/\s+/g, ' ')
  }
  return Object.keys(headers)
    .filter(function(key) { return HEADERS_TO_IGNORE[key.toLowerCase()] == null })
    .sort(function(a, b) { return a.toLowerCase() < b.toLowerCase() ? -1 : 1 })
    .map(function(key) { return key.toLowerCase() + ':' + trimAll(headers[key]) })
    .join('\n')
}

RequestSigner.prototype.signedHeaders = function() {
  var extraHeadersToInclude = this.extraHeadersToInclude,
      extraHeadersToIgnore = this.extraHeadersToIgnore
  return Object.keys(this.request.headers)
    .map(function(key) { return key.toLowerCase() })
    .filter(function(key) {
      return extraHeadersToInclude[key] ||
        (HEADERS_TO_IGNORE[key] == null && !extraHeadersToIgnore[key])
    })
    .sort()
    .join(';')
}

RequestSigner.prototype.credentialString = function() {
  return [
    this.getDate(),
    this.region,
    this.service,
    'aws4_request',
  ].join('/')
}

RequestSigner.prototype.defaultCredentials = function() {
  var env = process.env
  return {
    accessKeyId: env.AWS_ACCESS_KEY_ID || env.AWS_ACCESS_KEY,
    secretAccessKey: env.AWS_SECRET_ACCESS_KEY || env.AWS_SECRET_KEY,
    sessionToken: env.AWS_SESSION_TOKEN,
  }
}

RequestSigner.prototype.parsePath = function() {
  var path = this.request.path || '/'

  // S3 doesn't always encode characters > 127 correctly and
  // all services don't encode characters > 255 correctly
  // So if there are non-reserved chars (and it's not already all % encoded), just encode them all
  if (/[^0-9A-Za-z;,/?:@&=+$\-_.!~*'()#%]/.test(path)) {
    path = encodeURI(decodeURI(path))
  }

  var queryIx = path.indexOf('?'),
      query = null

  if (queryIx >= 0) {
    query = querystring.parse(path.slice(queryIx + 1))
    path = path.slice(0, queryIx)
  }

  this.parsedPath = {
    path: path,
    query: query,
  }
}

RequestSigner.prototype.formatPath = function() {
  var path = this.parsedPath.path,
      query = this.parsedPath.query

  if (!query) return path

  // Services don't support empty query string keys
  if (query[''] != null) delete query['']

  return path + '?' + encodeRfc3986(querystring.stringify(query))
}

aws4.RequestSigner = RequestSigner

aws4.sign = function(request, credentials) {
  return new RequestSigner(request, credentials).sign()
}


/***/ }),

/***/ 59864:
/***/ ((module) => {

module.exports = function(size) {
  return new LruCache(size)
}

function LruCache(size) {
  this.capacity = size | 0
  this.map = Object.create(null)
  this.list = new DoublyLinkedList()
}

LruCache.prototype.get = function(key) {
  var node = this.map[key]
  if (node == null) return undefined
  this.used(node)
  return node.val
}

LruCache.prototype.set = function(key, val) {
  var node = this.map[key]
  if (node != null) {
    node.val = val
  } else {
    if (!this.capacity) this.prune()
    if (!this.capacity) return false
    node = new DoublyLinkedNode(key, val)
    this.map[key] = node
    this.capacity--
  }
  this.used(node)
  return true
}

LruCache.prototype.used = function(node) {
  this.list.moveToFront(node)
}

LruCache.prototype.prune = function() {
  var node = this.list.pop()
  if (node != null) {
    delete this.map[node.key]
    this.capacity++
  }
}


function DoublyLinkedList() {
  this.firstNode = null
  this.lastNode = null
}

DoublyLinkedList.prototype.moveToFront = function(node) {
  if (this.firstNode == node) return

  this.remove(node)

  if (this.firstNode == null) {
    this.firstNode = node
    this.lastNode = node
    node.prev = null
    node.next = null
  } else {
    node.prev = null
    node.next = this.firstNode
    node.next.prev = node
    this.firstNode = node
  }
}

DoublyLinkedList.prototype.pop = function() {
  var lastNode = this.lastNode
  if (lastNode != null) {
    this.remove(lastNode)
  }
  return lastNode
}

DoublyLinkedList.prototype.remove = function(node) {
  if (this.firstNode == node) {
    this.firstNode = node.next
  } else if (node.prev != null) {
    node.prev.next = node.next
  }
  if (this.lastNode == node) {
    this.lastNode = node.prev
  } else if (node.next != null) {
    node.next.prev = node.prev
  }
}


function DoublyLinkedNode(key, val) {
  this.key = key
  this.val = val
  this.prev = null
  this.next = null
}


/***/ }),

/***/ 88620:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


/**
 * Handles CLI operations.
 *
 * Note that VW calls the CLI with -I and -S params.
 * The updater will use -I (installdir) param if it's passed.
 * If not passed, it will try to look up the installdir, and failing that, will use a path relative to the updater itself.
 *
*/
var _documents, _documentPaths, _documents2, _documentPaths2;
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i["return"] && (_r = _i["return"](), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var commander_1 = __webpack_require__(27461);
var path = __importStar(__webpack_require__(71017));
var fs = __importStar(__webpack_require__(55674));
//import * as os from 'os';
var sprintf_js_1 = __webpack_require__(8975);
var table_1 = __webpack_require__(83573);
var childProcess = __importStar(__webpack_require__(32081));
var os_1 = __webpack_require__(22037);
var verify_installation_1 = __webpack_require__(4706);
//import { fetchMacUserFolder } from '../../../libraries/fs-utils';
var license_description_1 = __importStar(__webpack_require__(31199));
var license_info_1 = __importDefault(__webpack_require__(31507));
var document_type_getter_1 = __webpack_require__(19739);
var types_1 = __webpack_require__(45627);
var enums_1 = __webpack_require__(38261);
var errors_1 = __webpack_require__(94515);
var getSettings_1 = __importDefault(__webpack_require__(82143));
var getLogger_1 = __importDefault(__webpack_require__(14449));
var createUpdater_1 = __importDefault(__webpack_require__(53212));
var getStrings_1 = __importDefault(__webpack_require__(10084));
var formatError_1 = __importDefault(__webpack_require__(68717));
var updateHooks_1 = __webpack_require__(97559);
var mainProcessUtils_1 = __webpack_require__(74641);
var cliHooks_1 = __webpack_require__(81687);
var SelfUpdater_1 = __importDefault(__webpack_require__(57789));
var webUtils_1 = __webpack_require__(76779);
process.noDeprecation = true;
// relativeInstallDir is the installDir that cliDriver.ts provides to runCli -- which is the install dir relative to the updater itself
var relativeInstallDir = '';
var providedProxyInfo = null;
var productInfo = __webpack_require__(4147);
var debug = __webpack_require__(15158)('updater-cli');
var program = new commander_1.Command();
var printErrorAndExit = function printErrorAndExit(error) {
  // Log the error
  (0, getLogger_1["default"])().error('An error has occurred', {
    error: error
  });
  if (error === undefined || !error.type || !(0, getStrings_1["default"])().errors[error.type]) {
    // Unknown error
    (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().errors.unknownError);
  } else {
    // Display mapped error
    (0, getLogger_1["default"])().stdout((0, formatError_1["default"])(error, (0, getStrings_1["default"])().errors[error.type]));
  }
  (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().generic.closingError, error);
  (0, mainProcessUtils_1.exitCli)(1);
};
var stepToString = function stepToString(step) {
  switch (step) {
    case 'fetching-build-info':
      return (0, getStrings_1["default"])().repair.fetchingBuildInfo;
    case 'cleaning-up':
      return (0, getStrings_1["default"])().generic.cleaningUp;
    default:
      return '';
  }
};
// Given a uid return the user's home dir or '' if not found.
var getHomeFromUid = function getHomeFromUid(uid) {
  try {
    var userInfo = childProcess.execSync("id -P ".concat(uid), {
      encoding: 'utf8'
    });
    // This returns something like tim:********:503:20::0:0:Tim:/Users/tim:/bin/zsh . We want to pull out the 9th entry.
    var userInfoParts = userInfo.trim().split(':');
    if (userInfoParts.length >= 9) {
      return userInfoParts[8];
    }
    return '';
  } catch (err) {
    return '';
  }
};
// logFilePath can be empty if we're doing an operation that shouldn't be logged to installdir, such as downloading an offline update.
var createCliUpdater = function createCliUpdater() {
  var startMsg = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var offlineUpdateFilepath = arguments.length > 1 ? arguments[1] : undefined;
  var proxyInfo = arguments.length > 2 ? arguments[2] : undefined;
  var updater = (0, createUpdater_1["default"])((0, getSettings_1["default"])().rootUrl, offlineUpdateFilepath, (0, getSettings_1["default"])().sslVerification, (0, getSettings_1["default"])().localCurlPath, proxyInfo);
  var BaseError = null;
  updater.setDownloadRetryCount(20);
  updater.on('done', function () {
    if (BaseError) {
      printErrorAndExit(BaseError);
    }
  }).on('error', function (error) {
    (0, getLogger_1["default"])().stdout('\n');
    (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().generic.errorHasOccured);
    BaseError = error;
  }).on('start-process', function () {
    if (startMsg !== '') {
      (0, getLogger_1["default"])().stdout(startMsg);
    }
  }).on('start-step', function (step) {
    var stepString = stepToString(step);
    if (stepString.length > 0) {
      (0, getLogger_1["default"])().stdout(stepString);
    }
  }).on('downloads-complete', function () {
    process.stdout.write('\n');
  }).on('zip-downloads-complete', function () {
    process.stdout.write('\n');
  }).on('blank-update', function () {
    (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().progressBar.updatingFileGeneric);
  }).on('retrying-file', function (url, numRetries, maxRetries) {
    var tryCountString = '';
    if (maxRetries >= 0) {
      // Limited retries.
      tryCountString = " (".concat(numRetries, "/").concat(maxRetries, ")");
    } else if (maxRetries < 0) {
      // Infinite retries.
      tryCountString = " (".concat(numRetries, ")");
    }
    process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().generic.retryingDownload, url)).concat(tryCountString, "\n"));
  }).on('updating-complete', function () {
    process.stdout.write('\n');
  });
  return updater;
};
var CLIDownloadOfflineUpdate = function CLIDownloadOfflineUpdate(params) {
  var updater = params.updater,
    versionInfo = params.versionInfo,
    destination = params.destination,
    target = params.target;
  var zipFilesToDownload = 0;
  var zipFilesDownloaded = 0;
  updater.on('success', function (updatedFileCount) {
    (0, getLogger_1["default"])().stdout((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().update.downloadComplete, updatedFileCount));
    (0, mainProcessUtils_1.exitCli)(0);
  }).on('to-download', function (fileList) {
    zipFilesToDownload = fileList.zipFiles.length;
    zipFilesDownloaded = 0;
    if (zipFilesToDownload > 0) {
      process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().generic.downloadingPackageFiles, zipFilesDownloaded, zipFilesToDownload), "\r"));
    }
  }).on('file-downloaded', function () {
    zipFilesDownloaded += 1;
    if (zipFilesToDownload > 0) {
      process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().generic.downloadingPackageFiles, zipFilesDownloaded, zipFilesToDownload), "\r"));
    }
  }).on('package-progress', function (data) {
    // Subtract 2 here to account for two extra files that we package into a .vwupdate
    process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().downloadOffline.packagingFiles, data.entries.processed, data.entries.total), "\r"));
    if (data.entries.processed === data.entries.total) {
      process.stdout.write('\n');
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().downloadOffline.packagingUpdateInfo);
    }
  });
  updater.downloadOfflineUpdate({
    destination: destination,
    target: target,
    extension: (0, getSettings_1["default"])().fileExt,
    versionInfo: versionInfo,
    logger: (0, getLogger_1["default"])()
  });
};
var getUpdateParams = function getUpdateParams() {
  var regexes = [];
  if ((0, getSettings_1["default"])().serialNumberRe) {
    regexes.push((0, getSettings_1["default"])().serialNumberRe);
  }
  if ((0, getSettings_1["default"])().evalSerialRe) {
    regexes.push((0, getSettings_1["default"])().evalSerialRe);
  }
  if ((0, getSettings_1["default"])().demoRe) {
    regexes.push((0, getSettings_1["default"])().demoRe);
  }
  if ((0, getSettings_1["default"])().viewerRe) {
    regexes.push((0, getSettings_1["default"])().viewerRe);
  }
  var fullRegexes = [regexes];
  var lookupParams = {
    platform: process.platform,
    serialNumberPlistLookups: (0, getSettings_1["default"])().serialNumberLocation.mac,
    serialNumberRegistry: (0, getSettings_1["default"])().serialNumberLocation.win.registry,
    serialNumberRegistryKey: (0, getSettings_1["default"])().serialNumberLocation.win.key,
    serialNumberRegistryValues: (0, getSettings_1["default"])().serialNumberLocation.win.values,
    serialNumberRegexes: fullRegexes
  };
  return lookupParams;
};
var printAppInfo = function printAppInfo(logger, toStdOut) {
  var appVersionString;
  try {
    var packageJsonPath = path.join(__dirname, 'app.asar', 'package.json');
    var packageJsonData = fs.readFileSync(packageJsonPath, 'utf8');
    var _JSON$parse = JSON.parse(packageJsonData),
      version = _JSON$parse.version;
    if (version !== '') {
      appVersionString = version;
    } else {
      appVersionString = 'Unknown';
    }
  } catch (_a) {
    appVersionString = 'Unknown';
  }
  var headerString = 'App Version';
  try {
    headerString = (0, getStrings_1["default"])().cli.versionInfo;
  } catch (_b) {}
  var appVersionToLog = "".concat(headerString, " ").concat(appVersionString);
  if (toStdOut) {
    logger.stdout(appVersionToLog);
  } else {
    // Do not print to stdout (for example for check, check-simple)
    logger.info(appVersionToLog);
  }
};
var printOSInfo = function printOSInfo(logger) {
  // Get some details about the system
  var sysInfo = 'Empty system info.';
  if (process.platform === 'darwin') {
    try {
      sysInfo = childProcess.execSync('sw_vers', {
        'encoding': 'utf-8'
      }); // eg 'ProductName:\t\tmacOS\nProductVersion:\t\t14.5\nBuildVersion:\t\t23F79\n'
    } catch (err) {
      sysInfo = "Error getting system info: ".concat(err.message, ".\nStderr: ").concat(err.stderr.toString(), "\n");
    }
    sysInfo += "\nArch: ".concat(process.arch, "\n");
    logger.info("CLI::printOSInfo() - macOS version info:\n".concat(sysInfo));
  } else {
    try {
      var psCommand = 'chcp 65001 && powershell -c "Get-CimInstance -query \'select * from Win32_OperatingSystem\' | Format-List BuildNumber,Caption,Locale,OSLanguage,CurrentTimeZone,LocalDateTime,LastBootUpTime,SystemDirectory,TotalVisibleMemorySize"';
      sysInfo = childProcess.execSync(psCommand, {
        'encoding': 'utf-8'
      });
      sysInfo = sysInfo.split('\n').filter(function (line) {
        return line.trim().length > 0;
      }).join('\n').replaceAll('\r', ''); // Trim empty lines and \r's
    } catch (err) {
      sysInfo = "Error getting system info: ".concat(err.message, ".\nStderr: ").concat(err.stderr.toString(), "\n");
    }
    sysInfo += "\nArch: ".concat(process.arch, "\n");
    logger.info("CLI::printOSInfo() - Windows version info:\n".concat(sysInfo));
  }
};
var documentsState = {
  eula: {
    accepted: false,
    toUse: enums_1.EulaTypes.professional,
    documents: (_documents = {}, _defineProperty(_documents, enums_1.EulaTypes.educational, ''), _defineProperty(_documents, enums_1.EulaTypes.eval, ''), _defineProperty(_documents, enums_1.EulaTypes.nfr, ''), _defineProperty(_documents, enums_1.EulaTypes.professional, ''), _defineProperty(_documents, enums_1.EulaTypes.viewer, ''), _documents),
    documentPaths: (_documentPaths = {}, _defineProperty(_documentPaths, enums_1.EulaTypes.educational, ''), _defineProperty(_documentPaths, enums_1.EulaTypes.eval, ''), _defineProperty(_documentPaths, enums_1.EulaTypes.nfr, ''), _defineProperty(_documentPaths, enums_1.EulaTypes.professional, ''), _defineProperty(_documentPaths, enums_1.EulaTypes.viewer, ''), _documentPaths)
  },
  readMe: {
    toUse: enums_1.ReadMeTypes.generic,
    documents: (_documents2 = {}, _defineProperty(_documents2, enums_1.ReadMeTypes.b, ''), _defineProperty(_documents2, enums_1.ReadMeTypes.e, ''), _defineProperty(_documents2, enums_1.ReadMeTypes.generic, ''), _defineProperty(_documents2, enums_1.ReadMeTypes.v, ''), _defineProperty(_documents2, enums_1.ReadMeTypes.g, ''), _documents2),
    documentPaths: (_documentPaths2 = {}, _defineProperty(_documentPaths2, enums_1.ReadMeTypes.b, ''), _defineProperty(_documentPaths2, enums_1.ReadMeTypes.e, ''), _defineProperty(_documentPaths2, enums_1.ReadMeTypes.generic, ''), _defineProperty(_documentPaths2, enums_1.ReadMeTypes.v, ''), _defineProperty(_documentPaths2, enums_1.ReadMeTypes.g, ''), _documentPaths2)
  }
};
var getDocs = function getDocs(root, regex, isEula) {
  return fs.readdir(root).then(function (files) {
    var toRead = files.map(function (f) {
      return f.toLowerCase();
    }).map(function (file) {
      (0, getLogger_1["default"])().info("Checking doc file \"".concat(file, "\""));
      var matches = file.match(regex);
      if (matches) {
        (0, getLogger_1["default"])().info('  Document matches.');
        var type = matches[1].toUpperCase();
        var validator;
        if (isEula) {
          validator = document_type_getter_1.DocumentTypeGetter.isEulaType;
        } else {
          validator = document_type_getter_1.DocumentTypeGetter.isReadMeType;
        }
        if (validator(type)) {
          (0, getLogger_1["default"])().info('  Document validation succeeded.');
          // Read File
          return {
            type: type,
            file: file
          };
        } else {
          (0, getLogger_1["default"])().info('  Document validation failed.');
        }
      } else {
        (0, getLogger_1["default"])().info('  Document did not match regex. Ignoring.');
      }
      return null;
    });
    // These always resolve
    return Promise.all(toRead.map(function (item) {
      if (!item) {
        return Promise.resolve();
      }
      var file = item.file,
        type = item.type;
      var toReadPath = path.join(root, file);
      return fs.readFile(toReadPath, 'utf8').then(function (contents) {
        if (isEula) {
          (0, getLogger_1["default"])().info("Setting eula documentsState.eula.documentPaths[".concat(type, "] to ").concat(toReadPath, "."));
          documentsState.eula.documents[type] = contents;
          documentsState.eula.documentPaths[type] = toReadPath;
        } else {
          // readme
          (0, getLogger_1["default"])().info("Setting readme documentsState.eula.documentPaths[".concat(type, "] to ").concat(toReadPath, "."));
          documentsState.readMe.documents[type] = contents;
          documentsState.readMe.documentPaths[type] = toReadPath;
        }
      })["catch"](function (error) {
        (0, getLogger_1["default"])().error("An error has occurred trying to read \"".concat(toReadPath, "\""), {
          error: error,
          toReadPath: toReadPath
        });
        return Promise.resolve();
      });
    })).then(function () {
      return Promise.resolve();
    });
  })["catch"](function (error) {
    (0, getLogger_1["default"])().error("An error has occurred scanning directory ".concat(root), {
      error: error
    });
  });
};
var readDocuments = function readDocuments() {
  var _ref = (0, getSettings_1["default"])(),
    defaultEula = _ref.defaultEula,
    defaultReadMe = _ref.defaultReadMe,
    eulaRoot = _ref.eulaRoot,
    readMeRoot = _ref.readMeRoot;
  documentsState.eula.toUse = defaultEula;
  documentsState.readMe.toUse = defaultReadMe;
  return getDocs(readMeRoot, /readme_(.*?)\.html/, false).then(function () {
    return getDocs(eulaRoot, /eula_(.*?)\.html/, true);
  });
};
var runUpdate = function runUpdate(params) {
  var updater = params.updater,
    pathToUpdate = params.pathToUpdate,
    versionInfo = params.versionInfo,
    licenseInfo = params.licenseInfo,
    updateInfo = params.updateInfo,
    locationInfo = params.locationInfo,
    offlineUpdateFilepath = params.offlineUpdateFilepath;
  var filesToUpdate = 0;
  var filesToDownload = 0;
  var downloadedFiles = 0;
  updater.on('success', function () {
    (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().update.updateComplete);
    (0, mainProcessUtils_1.exitCli)(0);
  }).on('start-step', function (step) {
    if (step === enums_1.UpdaterSteps.preparingOperation) {
      process.stdout.write("".concat((0, getStrings_1["default"])().update.settingUp, "\n"));
    }
  }).on('files-to-update', function (fileList) {
    filesToUpdate = fileList.length;
    if (filesToUpdate > 0) {
      process.stdout.write("".concat((0, getStrings_1["default"])().install.installingFiles, "\r"));
    }
  }).on('updated-file', function () {
    if (filesToUpdate > 0) {
      process.stdout.write("".concat((0, getStrings_1["default"])().install.installingFiles, "\r"));
    }
  }).on('zip-extracted', function (file) {
    downloadedFiles += file.files.length;
    process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().generic.downloadingFiles, downloadedFiles, filesToDownload), "\r"));
  }).on('to-download', function (payload) {
    var filesFromZips = payload.zipFiles.reduce(function (val, file) {
      return val + file.files.length;
    }, 0);
    var filesToCount = payload.individualFiles.length + filesFromZips;
    filesToDownload = filesToCount;
    downloadedFiles = 0;
  }).on('all-files-extracted', function () {
    process.stdout.write('\n');
  });
  if (!offlineUpdateFilepath) {
    if (!pathToUpdate) {
      (0, getLogger_1["default"])().error('No path to update passed even though update is online');
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().errors.unknownError);
      (0, mainProcessUtils_1.exitCli)(1);
      return;
    }
  }
  var latestUpdate = pathToUpdate[pathToUpdate.length - 1];
  (0, getLogger_1["default"])().stdout((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().check.latestUpdate, latestUpdate));
  updater.updateProcess({
    versionInfo: versionInfo,
    licenseInfo: licenseInfo,
    updateInfo: updateInfo,
    locationInfo: locationInfo,
    initialReleaseList: (0, getSettings_1["default"])().initialReleaseIdentifiers,
    logger: (0, getLogger_1["default"])(),
    registrations: params.registrationInfo,
    uid: params.uid,
    gid: params.gid,
    helperAppPath: (0, getSettings_1["default"])().vwimHelperPath,
    mainPid: process.pid,
    dllsToRegister: (0, getSettings_1["default"])().dllsToRegister,
    localizedValues: (0, getSettings_1["default"])().localizedValues,
    targetIdentifier: latestUpdate,
    appSettings: (0, getSettings_1["default"])(),
    preApply: updateHooks_1.preApply,
    postApply: updateHooks_1.postApply,
    preUpdate: updateHooks_1.preOperation
  });
};
var runInstall = function runInstall(params) {
  var updater = params.updater,
    versionInfo = params.versionInfo,
    licenseInfo = params.licenseInfo,
    locationInfo = params.locationInfo,
    registrationInfo = params.registrationInfo,
    eulaPath = params.eulaPath,
    eulaDestPath = params.eulaDestPath,
    readmePath = params.readmePath,
    readmeDestPath = params.readmeDestPath,
    uid = params.uid,
    gid = params.gid;
  var filesToInstall = 0;
  var filesToDownload = 0;
  var downloadedFiles = 0;
  updater.on('success', function () {
    (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.updateComplete);
    (0, mainProcessUtils_1.exitCli)(0);
  }).on('start-step', function (step) {
    if (step === enums_1.UpdaterSteps.preparingOperation) {
      process.stdout.write("".concat((0, getStrings_1["default"])().install.settingUp, "\n"));
    }
  }).on('files-to-update', function (fileList) {
    filesToInstall = fileList.length;
    if (filesToInstall > 0) {
      process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().install.installingFiles), "\r"));
    }
  }).on('updated-file', function () {
    if (filesToInstall > 0) {
      process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().install.installingFiles), "\r"));
    }
  }).on('zip-extracted', function (file) {
    downloadedFiles += file.files.length;
    process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().generic.downloadingFiles, downloadedFiles, filesToDownload), "\r"));
  }).on('to-download', function (payload) {
    var filesFromZips = payload.zipFiles.reduce(function (val, file) {
      return val + file.files.length;
    }, 0);
    var filesToCount = payload.individualFiles.length + filesFromZips;
    filesToDownload = filesToCount;
  }).on('all-files-extracted', function () {
    process.stdout.write('\n');
  });
  // Set the document types
  var serialOrLIS = '';
  if (licenseInfo.LDFObject.LIS !== '') {
    serialOrLIS = licenseInfo.LDFObject.LIS;
  } else if (licenseInfo.serialNumber !== '') {
    serialOrLIS = licenseInfo.serialNumber;
  }
  var docTypeGetter = new document_type_getter_1.DocumentTypeGetter((0, getSettings_1["default"])().shouldInstallPath, false, (0, getLogger_1["default"])());
  var getEulaPromise = Promise.resolve(documentsState.eula.toUse);
  if (serialOrLIS !== '') {
    getEulaPromise = docTypeGetter.getEulaType(serialOrLIS);
  }
  var getReadMePromise = Promise.resolve(documentsState.readMe.toUse);
  if (serialOrLIS !== '') {
    getReadMePromise = docTypeGetter.getReadMeType(serialOrLIS);
  }
  Promise.resolve(getEulaPromise).then(function (eulaType) {
    (0, getLogger_1["default"])().info('getDocumentTypes() - Got Eula type', {
      eulaType: eulaType,
      serial: serialOrLIS
    });
    documentsState.eula.toUse = eulaType;
    return Promise.resolve(getReadMePromise);
  }).then(function (readMeType) {
    (0, getLogger_1["default"])().info('getDocumentTypes() - Got ReadMe type', {
      readMeType: readMeType,
      serial: serialOrLIS
    });
    documentsState.readMe.toUse = readMeType;
    docTypeGetter.getReadMeType(serialOrLIS);
    var mainDir = (0, types_1.getLocationData)(enums_1.MAIN_DIR, params.locationInfo).locationPath;
    return updater.setupVWIMHelper((0, getSettings_1["default"])().vwimHelperPath, process.pid, 'admin', false, mainDir);
  }).then(function () {
    updater.install({
      versionInfo: versionInfo,
      licenseInfo: licenseInfo,
      locationInfo: locationInfo,
      initialReleaseList: (0, getSettings_1["default"])().initialReleaseIdentifiers,
      readmePath: readmePath,
      eulaPath: eulaPath,
      readmeDestPath: readmeDestPath,
      eulaDestPath: eulaDestPath,
      registrations: registrationInfo,
      dllsToRegister: (0, getSettings_1["default"])().dllsToRegister,
      localizedValues: (0, getSettings_1["default"])().localizedValues,
      mainPid: process.pid,
      uid: uid,
      gid: gid,
      appSettings: (0, getSettings_1["default"])(),
      logger: (0, getLogger_1["default"])(),
      preApply: updateHooks_1.preApply,
      postApply: updateHooks_1.postApply,
      preInstall: updateHooks_1.preOperation
    });
  });
};
/*
* @returns updateInfo
* Only needs versionInfo.distributor, language, major.
*/
var cliGetUpdateInfo = function cliGetUpdateInfo(versionInfo, fileSource) {
  var startMsg = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  return new Promise(function (resolve, reject) {
    var updater = createCliUpdater(startMsg, fileSource, providedProxyInfo);
    var errorHandler = function errorHandler(error) {
      reject(error);
    };
    updater.getUpdateInfo({
      distributor: versionInfo.distributor,
      language: versionInfo.language,
      major: versionInfo.major,
      updateInfoFileName: (0, getSettings_1["default"])().updateInfoFileName
    }).once('error', errorHandler).once('success', function (updateInfo) {
      (0, getLogger_1["default"])().info("cliGetUpdateInfo() - got update info: ".concat(JSON.stringify(updateInfo)));
      resolve(updateInfo);
    });
  });
};
// This is useful for cases like check and check-simple where we don't need to.
// Of course, the better solution would be not cramming 87 side effects into one function...
//
var confirmInstall = function confirmInstall(params) {
  var versionFileName = (0, getSettings_1["default"])().localizedValues['versionFileName'] || '';
  var productGUIDFilePath = (0, getSettings_1["default"])().localizedValues['productGUIDFilePath'] || '';
  // Check for VWIMHelper present...
  var helperPath = (0, getSettings_1["default"])().vwimHelperPath;
  (0, getLogger_1["default"])().info("cli::confirmInstall() - Checking vwimHelper at ".concat(helperPath));
  if (params.operation !== 'check' && params.operation !== 'check-simple' && params.operation !== 'other' && !fs.existsSync(helperPath)) {
    (0, getLogger_1["default"])().info("cli::confirmInstall() - VWIMHelper was missing and needed. Exiting.");
    return Promise.reject(new errors_1.BaseError((0, getStrings_1["default"])().errors.noSerial, enums_1.ErrorTypes.appBroken));
  }
  var serialPromise;
  if ((0, getSettings_1["default"])().hasSerial) {
    var serialNumber = params.serialNumber;
    (0, getLogger_1["default"])().info('cli::confirmInstall() - Checking installation', {
      serialNumber: serialNumber
    });
    var serialRegexes = params.lookupParams['serialNumberRegexes'];
    serialPromise = (0, verify_installation_1.validateSerialNumberRegexes)(serialNumber, (0, getLogger_1["default"])(), serialRegexes).then(function (_valid) {
      return Promise.resolve(new license_info_1["default"](serialNumber, (0, getLogger_1["default"])(), new license_description_1["default"]((0, getLogger_1["default"])(), serialNumber), (0, getSettings_1["default"])().shouldInstallPath, (0, getSettings_1["default"])().allowedDistributors, (0, getSettings_1["default"])().excludedDistributors));
    });
  } else {
    (0, getLogger_1["default"])().info('cli::confirmInstall() - hasSerial is false, using default license info');
    serialPromise = Promise.resolve(new license_info_1["default"]('', (0, getLogger_1["default"])(), new license_description_1["default"]((0, getLogger_1["default"])()), (0, getSettings_1["default"])().shouldInstallPath, (0, getSettings_1["default"])().allowedDistributors, (0, getSettings_1["default"])().excludedDistributors));
  }
  var versionInfo = (0, types_1.emptyVersionInfo)();
  var licenseInfo;
  var mainDir = (0, types_1.getLocationData)(enums_1.MAIN_DIR, params.locationInfo).locationPath;
  var versionInfoPromise = Promise.resolve(versionInfo);
  if (params.operation !== 'install') {
    versionInfoPromise = (0, verify_installation_1.readVWVersionInfo)(mainDir, versionFileName, (0, getSettings_1["default"])().appRegex, (0, getLogger_1["default"])());
  } else {
    versionInfo.major = Number((0, getSettings_1["default"])().major);
  }
  var guidPromise = Promise.resolve('');
  if (productGUIDFilePath !== '') {
    if (params.operation !== 'install' && params.operation !== 'uninstall') {
      guidPromise = (0, verify_installation_1.readProductGUID)(path.join(mainDir, productGUIDFilePath), (0, getLogger_1["default"])());
    }
  }
  return serialPromise.then(function (resultLicenseInfo) {
    licenseInfo = resultLicenseInfo;
    return Promise.all([versionInfoPromise, guidPromise]);
  }).then(function (results) {
    var usePlatform = (0, enums_1.ProcessPlatformToPlatformsEnum)(process.platform);
    versionInfo = results[0];
    versionInfo.product = (0, getSettings_1["default"])().product;
    versionInfo.platform = usePlatform;
    versionInfo.productGUID = results[1];
    // Override distributor and language w/ the settings in the updater.
    versionInfo.distributor = (0, getSettings_1["default"])().distributor;
    versionInfo.language = (0, getSettings_1["default"])().language;
    // Force the channel if provided.
    if (params.forceChannel) {
      versionInfo.channel = params.forceChannel;
    }
    // Create a table to display. This is more for update to show what we have than for install
    // Thus some rows are not shown for install.
    var tableCells = [[(0, getStrings_1["default"])().generic.usingSerial, licenseInfo.serialNumber], [(0, getStrings_1["default"])().generic.usingInstallDir, mainDir]];
    if (params.operation !== 'install') {
      // For install, there is not yet an existing version so we skip display.
      tableCells.push([(0, getStrings_1["default"])().generic.onVersion, "".concat(versionInfo.major, ".").concat(versionInfo.minor, ".").concat(versionInfo.patch)]);
      tableCells.push([(0, getStrings_1["default"])().generic.onUpdate, versionInfo.identifier]);
    }
    tableCells.push([(0, getStrings_1["default"])().generic.onChannel, versionInfo.channel]);
    var tableOpts = {
      border: (0, table_1.getBorderCharacters)("void"),
      columnDefault: {
        paddingLeft: 0,
        paddingRight: 1
      },
      drawHorizontalLine: function drawHorizontalLine() {
        return false;
      }
    };
    var tableString = (0, table_1.table)(tableCells, tableOpts);
    if (!params.silent) {
      (0, getLogger_1["default"])().stdout(tableString);
    }
    return Promise.resolve(true);
  }).then(function (valid) {
    if (!valid) {
      (0, mainProcessUtils_1.exitCli)(1);
      // This does not hit but we keep typescript happy.
      return Promise.reject(new Error());
    }
    // If provided, override licenseInfo.ldf with the results of loading the passed-in ldf
    var ldfFilepath = params.ldfFilepath;
    var ldfPromise;
    // Just get the items for VersionInfo - we especially don't want logger which will cause stringify errors in getLDF below.
    if (!(0, getSettings_1["default"])().usesLDF) {
      (0, getLogger_1["default"])().info("cli::confirmInstall() - not getting a LDF for this command. Product does not use LDF.");
      ldfPromise = Promise.resolve(new license_description_1["default"]((0, getLogger_1["default"])(), licenseInfo.serialNumber, (0, getSettings_1["default"])().allowedDistributors, (0, getSettings_1["default"])().excludedDistributors));
    } else if (ldfFilepath) {
      (0, getLogger_1["default"])().info("cli::confirmInstall() - getting LDF - called with ldfFilepath=".concat(ldfFilepath));
      ldfPromise = (0, license_description_1.getLDFFromFile)(licenseInfo.serialNumber, ldfFilepath, versionInfo, (0, getLogger_1["default"])(), (0, getSettings_1["default"])().allowedDistributors, (0, getSettings_1["default"])().excludedDistributors);
    } else {
      // no ldf passed, so try to use the one in the user folder or if not found, download it.
      (0, getLogger_1["default"])().info("cli::confirmInstall() - getting LDF - called without ldfFilepath.");
      var userFolder = (0, getSettings_1["default"])().licenseDescriptionFilePath; // default location.
      var locDataUserFolder = (0, types_1.getLocationData)('userFolder', params.locationInfo);
      if (locDataUserFolder.valid) {
        userFolder = locDataUserFolder.locationPath;
        (0, getLogger_1["default"])().info("cli::confirmInstall() - userFolder was ".concat(userFolder));
      } else {
        (0, getLogger_1["default"])().info("cli::confirmInstall() - userFolder defaulted to: ".concat(userFolder));
      }
      ldfPromise = (0, license_description_1.getLDF)('preferFile', licenseInfo.serialNumber, userFolder, versionInfo, (0, getSettings_1["default"])().localCurlPath, (0, getLogger_1["default"])(), (0, getSettings_1["default"])().allowedDistributors, (0, getSettings_1["default"])().excludedDistributors, providedProxyInfo);
    }
    return ldfPromise;
  }).then(function (ldfObject) {
    (0, getLogger_1["default"])().info("cli::confirmInstall() - Got LDF: ".concat(JSON.stringify(ldfObject.licenseObject), "."));
    licenseInfo.LDFObject = ldfObject;
    if (!ldfObject.isEmpty()) {
      var ldfFilepath = params.ldfFilepath;
      if (ldfFilepath) {
        (0, getSettings_1["default"])().licenseDescriptionModalResult = 'FILE';
        (0, getSettings_1["default"])().licenseDescriptionFilePath = ldfFilepath;
      }
      return (0, license_description_1.getLISFromString)(ldfObject.fullText, (0, getSettings_1["default"])().shouldInstallPath, (0, getLogger_1["default"])());
    } else if (ldfObject.isViewer) {
      return Promise.resolve(ldfObject.LIS); // should be VIEWER
    } else {
      return Promise.resolve('');
    }
  }).then(function (LISString) {
    (0, getLogger_1["default"])().info("cli::confirmInstall() - Got LIS string: ".concat(LISString, "."));
    licenseInfo.LDFObject.LIS = LISString;
    return (0, cliHooks_1.cliTransformHook)(versionInfo, licenseInfo, params.locationInfo);
  })["catch"](function (error) {
    return Promise.reject(error);
  });
};
program.version(productInfo.version, '-v, --version').name((0, getStrings_1["default"])().name.cliName).option('-I, --installdir <installation directory>', (0, getStrings_1["default"])().globalOptions.installationDir).option('-o, --output <output directory>', 'Log file location');
if ((0, getSettings_1["default"])().hasSerial) {
  program.option('-S, --serial <serial>', (0, getStrings_1["default"])().globalOptions.serialNumber);
}
var updateLocationTransform = function updateLocationTransform(input) {
  var locations = input.split(',').map(function (s) {
    return s.split(':');
  });
  return locations.reduce(function (obj, entry) {
    if (entry.length !== 2) {
      throw new Error('Invalid Update Locations');
    }
    obj[entry[0]] = entry[1];
    return obj;
  }, {});
};
var sortOutMainDir = function sortOutMainDir(locationInfo, explicitDir, relativeDir, versionFileName, logger) {
  if (explicitDir && explicitDir !== '') {
    // An explicitly passed dir overrides anything else.
    logger.info("cli::sortOutMainDir() - Overriding mainDir from passed value: \"".concat(explicitDir, "\"."));
    var mainDirLocationData = (0, types_1.getLocationData)(enums_1.MAIN_DIR, locationInfo);
    mainDirLocationData.originalLocationPath = mainDirLocationData.locationPath;
    mainDirLocationData.locationPath = explicitDir;
    locationInfo.locationInfo[enums_1.MAIN_DIR] = mainDirLocationData;
  } else if (relativeDir) {
    var _mainDirLocationData = (0, types_1.getLocationData)(enums_1.MAIN_DIR, locationInfo);
    if (_mainDirLocationData.defaultUsed && fs.existsSync(path.join(relativeDir, versionFileName))) {
      logger.info("cli::sortOutMainDir() - Using relativeDir since ".concat(versionFileName, " is found there and we used a default mainDir: \"").concat(relativeDir, "\"."));
      _mainDirLocationData.originalLocationPath = _mainDirLocationData.locationPath;
      _mainDirLocationData.locationPath = relativeDir;
      locationInfo.locationInfo[enums_1.MAIN_DIR] = _mainDirLocationData;
    }
  }
  return locationInfo;
};
// Support supplying other update locations
program.option('-L, --locations <name:path>', (0, getStrings_1["default"])().globalOptions.updateLocations, updateLocationTransform);
// The "check" command which returns some JSON info about the update for VW to display to the user.
program.command('check').option('-l, --ldf <ldf file path>', '').description((0, getStrings_1["default"])().check.cmdDescription).action(function (localOpts) {
  // Set up logger location if passed
  if (program.opts().output) {
    var oldPath = (0, getSettings_1["default"])().logFilePath;
    (0, getSettings_1["default"])().logFilePath = path.join(program.opts().output, path.basename(oldPath));
  }
  printAppInfo((0, getLogger_1["default"])(), false);
  (0, getLogger_1["default"])().info('cli::check command called.');
  var versionFileName = (0, getSettings_1["default"])().localizedValues['versionFileName'] || '';
  var ldfFilepath;
  var serialNumber = "";
  var options = program.opts();
  if (options.serial) {
    serialNumber = options.serial;
    (0, getLogger_1["default"])().info("cli::check - serial number passed as argument: ".concat(serialNumber));
  }
  if (localOpts.ldf) {
    ldfFilepath = localOpts.ldf;
    (0, getLogger_1["default"])().info("cli::check - ldfFilepath passed as argument: ".concat(ldfFilepath));
  }
  var lookupParams = getUpdateParams();
  var serialNumberPromise;
  if ((0, getSettings_1["default"])().hasSerial && serialNumber === "") {
    (0, getLogger_1["default"])().info("cli::check - serial number empty. Attempting to fetch it.");
    serialNumberPromise = (0, verify_installation_1.fetchSerialNumber)(process.platform === 'win32' ? lookupParams : lookupParams, (0, getLogger_1["default"])());
  } else {
    serialNumberPromise = Promise.resolve(serialNumber);
  }
  var channelToUse = 'main';
  var startIdentifier = '';
  var platform = (0, enums_1.ProcessPlatformToPlatformsEnum)(process.platform);
  var versionInfo;
  var locationInfo;
  var licenseInfo;
  return (0, verify_installation_1.fetchLocations)((0, getSettings_1["default"])().locationLookupInfo, (0, getLogger_1["default"])(), (0, os_1.homedir)()).then(function (fetchedLocationInfo) {
    locationInfo = sortOutMainDir(fetchedLocationInfo, options.installdir, relativeInstallDir, versionFileName, (0, getLogger_1["default"])());
    return serialNumberPromise;
  }).then(function (useSerial) {
    serialNumber = useSerial || "";
    (0, getLogger_1["default"])().info("cli::check - serial number is now: ".concat(serialNumber));
    var product = (0, getSettings_1["default"])().product;
    return confirmInstall({
      serialNumber: serialNumber,
      locationInfo: locationInfo,
      platform: platform,
      product: product,
      ldfFilepath: ldfFilepath,
      silent: true,
      skipLocations: true,
      operation: 'check',
      lookupParams: lookupParams
    });
  }).then(function (results) {
    versionInfo = results[0];
    licenseInfo = results[1];
    channelToUse = versionInfo.channel;
    startIdentifier = versionInfo.identifier;
    return cliGetUpdateInfo(versionInfo, '');
  }).then(function (updateInfo) {
    var _ref2 = (0, webUtils_1.getLatestOnChannel)(updateInfo, channelToUse, platform, false, licenseInfo),
      _ref3 = _slicedToArray(_ref2, 2),
      targetToUse = _ref3[0],
      _latestOnChannelName = _ref3[1];
    if (targetToUse === '') {
      throw new Error("Unable to get latest for channel ".concat(channelToUse));
    } else {
      (0, getLogger_1["default"])().info("cli::check - Latest on channel was ".concat(targetToUse, "."));
    }
    var pathToUpdate = (0, webUtils_1.findPathToUpdate)(startIdentifier, targetToUse, updateInfo.updates);
    var result = {};
    if (pathToUpdate.length <= 1) {
      result['update-exists'] = false;
    } else {
      result['update-exists'] = true;
    }
    result['channel'] = channelToUse;
    result['current-version-identifier'] = '';
    result['latest-version-identifier'] = '';
    if (pathToUpdate.length > 0) {
      var curUpdate = pathToUpdate[0];
      var latestUpdate = pathToUpdate[pathToUpdate.length - 1];
      var isLatestUpdate = false;
      if ((0, getSettings_1["default"])().initialReleaseIdentifiers.indexOf(curUpdate.toLowerCase()) > -1) {
        isLatestUpdate = true;
      }
      result['is-initial-release'] = isLatestUpdate;
      result['current-version-identifier'] = curUpdate;
      result['current-version-text'] = updateInfo['updates'][curUpdate]['update-name'];
      result['latest-version-identifier'] = latestUpdate;
      result['latest-version-text'] = updateInfo['updates'][latestUpdate]['update-name'];
      // VW expects the "info" items to be either both present or both empty.
      if (latestUpdate in updateInfo['updates'] && 'update-info-url' in updateInfo['updates'][latestUpdate] && 'update-info-text' in updateInfo['updates'][latestUpdate]) {
        result['latest-version-info-url'] = encodeURI(updateInfo['updates'][latestUpdate]['update-info-url']);
        result['latest-version-info-text'] = updateInfo['updates'][latestUpdate]['update-info-text'];
      } else {
        result['latest-version-info-url'] = '';
        result['latest-version-info-text'] = '';
      }
    }
    (0, getLogger_1["default"])().stdout(JSON.stringify(result));
    (0, mainProcessUtils_1.exitCli)(0);
  })["catch"](function (e) {
    debug("Error", e.stack);
    debug("Error", e.name);
    debug("Error", e.message);
    (0, mainProcessUtils_1.exitCli)(1);
  });
});
// The 'check-simple' command, which just displays 0 or 1 based on if an update is detected.
program.command('check-simple').description((0, getStrings_1["default"])().check.cmdDescription).action(function (localOpts) {
  // Set up logger location if passed
  if (program.opts().output) {
    var oldPath = (0, getSettings_1["default"])().logFilePath;
    (0, getSettings_1["default"])().logFilePath = path.join(program.opts().output, path.basename(oldPath));
  }
  printAppInfo((0, getLogger_1["default"])(), false);
  (0, getLogger_1["default"])().info('cli::check-simple command called.');
  var ldfFilepath;
  var serialNumber = "";
  var options = program.opts();
  if (options.serial) {
    serialNumber = options.serial;
  }
  if (localOpts.ldf) {
    ldfFilepath = localOpts.ldf;
    (0, getLogger_1["default"])().info("cli::check - ldfFilepath passed as argument: ".concat(ldfFilepath));
  }
  var versionFileName = (0, getSettings_1["default"])().localizedValues['versionFileName'] || '';
  var lookupParams = getUpdateParams();
  var serialNumberPromise;
  if ((0, getSettings_1["default"])().hasSerial && serialNumber === "") {
    serialNumberPromise = (0, verify_installation_1.fetchSerialNumber)(process.platform === 'win32' ? lookupParams : lookupParams, (0, getLogger_1["default"])());
  } else {
    serialNumberPromise = Promise.resolve(serialNumber);
  }
  var locationInfo;
  return (0, verify_installation_1.fetchLocations)((0, getSettings_1["default"])().locationLookupInfo, (0, getLogger_1["default"])(), (0, os_1.homedir)()).then(function (fetchedLocationInfo) {
    locationInfo = sortOutMainDir(fetchedLocationInfo, options.installdir, relativeInstallDir, versionFileName, (0, getLogger_1["default"])());
    return serialNumberPromise;
  }).then(function (useSerial) {
    serialNumber = useSerial || "";
    var platform = (0, enums_1.ProcessPlatformToPlatformsEnum)(process.platform);
    var product = (0, getSettings_1["default"])().product;
    var channelToUse = 'main';
    var startIdentifier = '';
    var versionInfo;
    var licenseInfo;
    confirmInstall({
      serialNumber: serialNumber,
      locationInfo: locationInfo,
      platform: platform,
      product: product,
      ldfFilepath: ldfFilepath,
      silent: true,
      operation: 'check-simple',
      skipLocations: true,
      lookupParams: lookupParams
    }).then(function (results) {
      versionInfo = results[0];
      licenseInfo = results[1];
      channelToUse = versionInfo.channel;
      startIdentifier = versionInfo.identifier;
      return cliGetUpdateInfo(versionInfo, '');
    }).then(function (updateInfo) {
      var _ref4 = (0, webUtils_1.getLatestOnChannel)(updateInfo, channelToUse, platform, false, licenseInfo),
        _ref5 = _slicedToArray(_ref4, 2),
        targetToUse = _ref5[0],
        _latestOnChannelName = _ref5[1];
      if (targetToUse === '') {
        throw new Error("Unable to get latest for channel ".concat(channelToUse));
      }
      var pathToUpdate = (0, webUtils_1.findPathToUpdate)(startIdentifier, targetToUse, updateInfo.updates);
      if (pathToUpdate.length > 1) {
        (0, getLogger_1["default"])().stdout('1');
      } else {
        (0, getLogger_1["default"])().stdout('0');
      }
      (0, mainProcessUtils_1.exitCli)(0);
    });
  })["catch"](function () {
    (0, mainProcessUtils_1.exitCli)(1);
  });
});
program.command('repair').option('-l, --ldf <ldf file path>', '').option('-u, --uid <uid>', (0, getStrings_1["default"])().repair.uidDescription).option('-g, --gid <gid>', (0, getStrings_1["default"])().repair.gidDescription).description((0, getStrings_1["default"])().repair.cmdDescription).action(function (opts) {
  // Set up logger location if passed
  if (program.opts().output) {
    var oldPath = (0, getSettings_1["default"])().logFilePath;
    (0, getSettings_1["default"])().logFilePath = path.join(program.opts().output, path.basename(oldPath));
  }
  (0, getLogger_1["default"])().info('cli::repair command called.');
  printAppInfo((0, getLogger_1["default"])(), true);
  printOSInfo((0, getLogger_1["default"])());
  var serialNumber = "";
  var ldfFilepath;
  var uid = '';
  var gid = '';
  var options = program.opts();
  if (options.serial) {
    serialNumber = options.serial;
  }
  if (opts.ldf) {
    ldfFilepath = opts.ldf;
  }
  if (opts.gid) {
    gid = opts.gid.trim();
    if (process.platform !== 'darwin') {
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.gidPlatformErr);
      (0, mainProcessUtils_1.exitCli)(1);
      return;
    }
    // on Mac the UID will be digits, so check this.
    if (gid.match(/^[0-9]+$/) === null) {
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.gidInvalid);
      (0, mainProcessUtils_1.exitCli)(1);
      return;
    }
  }
  var homeToUse = (0, os_1.homedir)();
  if (process.platform === 'darwin' && process.getuid) {
    // On Mac...
    if (process.getuid() === 0) {
      // run as root
      if (uid === '' || gid === '') {
        // if this is run as root...
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.uidgidNeedsSpecified);
        (0, mainProcessUtils_1.exitCli)(1);
        return;
      } else {
        homeToUse = getHomeFromUid(uid);
        (0, getLogger_1["default"])().stdout("cli::install - Running as root. Using home directory from uid ".concat(uid, ": ").concat(homeToUse));
      }
    }
  }
  var lookupParams = getUpdateParams();
  var versionFileName = (0, getSettings_1["default"])().localizedValues['versionFileName'] || '';
  var serialNumberPromise;
  if ((0, getSettings_1["default"])().hasSerial && serialNumber === "") {
    serialNumberPromise = (0, verify_installation_1.fetchSerialNumber)(process.platform === 'win32' ? lookupParams : lookupParams, (0, getLogger_1["default"])());
  } else {
    serialNumberPromise = Promise.resolve(serialNumber);
  }
  var locationInfo;
  return (0, verify_installation_1.fetchLocations)((0, getSettings_1["default"])().locationLookupInfo, (0, getLogger_1["default"])(), homeToUse).then(function (fetchedLocationInfo) {
    locationInfo = sortOutMainDir(fetchedLocationInfo, options.installdir, relativeInstallDir, versionFileName, (0, getLogger_1["default"])());
    return serialNumberPromise;
  }).then(function (useSerial) {
    serialNumber = useSerial || "";
    var platform = (0, enums_1.ProcessPlatformToPlatformsEnum)(process.platform);
    var product = (0, getSettings_1["default"])().product;
    confirmInstall({
      serialNumber: serialNumber,
      locationInfo: locationInfo,
      platform: platform,
      product: product,
      ldfFilepath: ldfFilepath,
      lookupParams: lookupParams,
      operation: 'repair'
    }).then(function (results) {
      var updater = createCliUpdater((0, getStrings_1["default"])().repair.starting, '', providedProxyInfo);
      var filesToCheck = 0;
      var filesChecked = 0;
      var filesToRepair = 0;
      var repairedFiles = 0;
      updater.on('success', function (updatedFileCount) {
        if (updatedFileCount === 0) {
          (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().repair.noFilesToRepair);
        } else {
          (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().repair.repairedFiles);
        }
        (0, mainProcessUtils_1.exitCli)(0);
      }).on('start-step', function (step) {
        if (step === enums_1.UpdaterSteps.preparingOperation) {
          process.stdout.write("".concat((0, getStrings_1["default"])().repair.settingUp, "\n"));
        }
      }).on('files-to-check', function (count) {
        filesToCheck = count;
        process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().repair.checkingFiles, filesChecked, filesToCheck), "\r"));
      }).on('file-checked', function () {
        filesChecked += 1;
        process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().repair.checkingFiles, filesChecked, filesToCheck), "\r"));
      }).on('all-files-checked', function () {
        process.stdout.write('\n');
      }).on('files-to-update', function (fileList) {
        filesToRepair = fileList.length;
        process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().repair.copyingFiles, repairedFiles, filesToRepair), "\r"));
      }).on('updated-file', function () {
        repairedFiles += 1;
        process.stdout.write("".concat((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().repair.copyingFiles, repairedFiles, filesToRepair), "\r"));
      }).on('files-to-repair', function (files) {
        (0, getLogger_1["default"])().stdout((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().repair.filesToRepair, files.length));
      }).on('checking-extra-files', function () {
        process.stdout.write("\n".concat((0, getStrings_1["default"])().repair.verifyingApplicationSignature, "\n"));
      }).on('remove-empty-dir', function (dir) {
        process.stdout.write('Removing empty dir: ' + dir + '\n');
      });
      updater.repair({
        versionInfo: results[0],
        licenseInfo: results[1],
        locationInfo: locationInfo,
        initialReleaseList: (0, getSettings_1["default"])().initialReleaseIdentifiers,
        forceVersion: '',
        operation: 'repair',
        helperAppPath: (0, getSettings_1["default"])().vwimHelperPath,
        registrations: null,
        dllsToRegister: (0, getSettings_1["default"])().dllsToRegister,
        uid: '',
        gid: '',
        localizedValues: (0, getSettings_1["default"])().localizedValues,
        mainPid: process.pid,
        appSettings: (0, getSettings_1["default"])(),
        logger: (0, getLogger_1["default"])(),
        preApply: updateHooks_1.preApply,
        postApply: updateHooks_1.postApply,
        repairIgnorePrefixes: (0, getSettings_1["default"])().repairIgnorePrefixes,
        noExtraFileRegexMap: (0, getSettings_1["default"])().regexesToOnlyAllowExpectedFiles,
        preRepair: updateHooks_1.preOperation
      });
    });
  })["catch"](function (error) {
    printErrorAndExit(error);
  });
});
// Download a vwim file for a version
//
program.command('download').option('-d, --dest <path>', (0, getStrings_1["default"])().downloadOffline.destinationDescription).option('-t, --target <targetIdentifier>', (0, getStrings_1["default"])().downloadOffline.targetDescription).option('-l, --ls', (0, getStrings_1["default"])().downloadOffline.lsDescription).description((0, getStrings_1["default"])().downloadOffline.cmdDescription).action(function (opts) {
  var destination = opts.dest || '';
  var target = opts.target || '';
  // Set up logger location if passed
  if (program.opts().output) {
    var oldPath = (0, getSettings_1["default"])().logFilePath;
    (0, getSettings_1["default"])().logFilePath = path.join(program.opts().output, path.basename(oldPath));
  }
  (0, getLogger_1["default"])().info("cli::download command called with opts: ".concat(JSON.stringify(opts), "."));
  printAppInfo((0, getLogger_1["default"])(), true);
  printOSInfo((0, getLogger_1["default"])());
  var channel = 'main';
  //const startString = getStrings().downloadOffline.startPackage;
  var locationInfo;
  var updater;
  // Create a VersionInfo to be used for this operation. Note that initially this only needs dist, lang, major.
  var versionInfo = Object.assign((0, types_1.emptyVersionInfo)(), {
    channel: channel,
    identifier: target,
    name: target,
    product: (0, getSettings_1["default"])().product,
    major: parseInt((0, getSettings_1["default"])().major, 10),
    distributor: (0, getSettings_1["default"])().distributor,
    language: (0, getSettings_1["default"])().language,
    subKey: (0, getSettings_1["default"])().subKey
  });
  return (0, verify_installation_1.fetchLocations)((0, getSettings_1["default"])().locationLookupInfo, (0, getLogger_1["default"])(), (0, os_1.homedir)()).then(function (fetchedLocationInfo) {
    locationInfo = fetchedLocationInfo;
    return cliGetUpdateInfo(versionInfo, '');
  }).then(function (updateInfo) {
    if (updateInfo === null) {
      throw new Error('setupDownloaedUpdate() - updateInfo was null.');
    } else {
      (0, getLogger_1["default"])().info("setupDownloadUpdate() - Got updateInfo: ".concat(JSON.stringify(updateInfo)));
      updater = createCliUpdater('', '', providedProxyInfo);
      updater.updateInfo = updateInfo;
      return updateInfo;
    }
  }).then(function (updateInfo) {
    if (!updateInfo) {
      (0, getLogger_1["default"])().error('No update info on updater');
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().errors.unknownError);
      (0, mainProcessUtils_1.exitCli)(1);
      return;
    }
    var updates = updateInfo.updates;
    if (opts.ls) {
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().downloadOffline.lsHeader);
      Object.keys(updates).forEach(function (key) {
        (0, getLogger_1["default"])().stdout('    ' + key);
      });
      (0, mainProcessUtils_1.exitCli)(0);
      return;
    }
    if (target === '') {
      // choose a target.
      target = updateInfo.channels[channel].latest;
    }
    if (typeof updates[target] === 'undefined') {
      (0, getLogger_1["default"])().stdout((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().downloadOffline.noIdentifier, target));
      (0, mainProcessUtils_1.exitCli)(1);
      return;
    }
    versionInfo.identifier = target;
    (0, getLogger_1["default"])().stdout((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().downloadOffline.startupMessage, target));
    return CLIDownloadOfflineUpdate({
      updater: updater,
      versionInfo: versionInfo,
      locationInfo: locationInfo,
      destination: destination,
      target: target
    });
  })["catch"](function (error) {
    printErrorAndExit(error);
  });
});
// Run an update
program.command('update').description((0, getStrings_1["default"])().update.cmdDescription).option('-i, --input <input file>', (0, getStrings_1["default"])().update.inputDescription).option('-c, --code <update code>', (0, getStrings_1["default"])().update.codeDescription).option('-l, --ldf <ldf file path>', '').option('-u, --uid <uid>', (0, getStrings_1["default"])().update.uidDescription).option('-g, --gid <gid>', (0, getStrings_1["default"])().update.gidDescription).action(function (opts) {
  // Set up logger location if passed
  if (program.opts().output) {
    var oldPath = (0, getSettings_1["default"])().logFilePath;
    (0, getSettings_1["default"])().logFilePath = path.join(program.opts().output, path.basename(oldPath));
  }
  (0, getLogger_1["default"])().info('cli::update command called.');
  printAppInfo((0, getLogger_1["default"])(), true);
  printOSInfo((0, getLogger_1["default"])());
  var updateCode;
  var ldfFilepath;
  var offlineUpdateFilepath;
  var uid = '';
  var gid = '';
  if (opts.code) {
    updateCode = opts.code.toLowerCase();
  }
  if (opts.ldf) {
    ldfFilepath = opts.ldf;
  }
  if (opts.input) {
    offlineUpdateFilepath = opts.input;
  }
  if (opts.gid) {
    gid = opts.gid.trim();
    if (process.platform !== 'darwin') {
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.gidPlatformErr);
      (0, mainProcessUtils_1.exitCli)(1);
      return;
    }
    // on Mac the UID will be digits, so check this.
    if (gid.match(/^[0-9]+$/) === null) {
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.gidInvalid);
      (0, mainProcessUtils_1.exitCli)(1);
      return;
    }
  }
  var homeToUse = (0, os_1.homedir)();
  if (process.platform === 'darwin' && process.getuid) {
    // On Mac...
    if (process.getuid() === 0) {
      // run as root
      if (uid === '' || gid === '') {
        // if this is run as root...
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.uidgidNeedsSpecified);
        (0, mainProcessUtils_1.exitCli)(1);
        return;
      } else {
        homeToUse = getHomeFromUid(uid);
        (0, getLogger_1["default"])().stdout("cli::install - Running as root. Using home directory from uid ".concat(uid, ": ").concat(homeToUse));
      }
    }
  }
  var versionFileName = (0, getSettings_1["default"])().localizedValues['versionFileName'] || '';
  var UpdateModes;
  (function (UpdateModes) {
    UpdateModes[UpdateModes["normal"] = 0] = "normal";
    UpdateModes[UpdateModes["download"] = 1] = "download";
    UpdateModes[UpdateModes["fromOffline"] = 2] = "fromOffline";
    UpdateModes[UpdateModes["fromCode"] = 3] = "fromCode";
  })(UpdateModes || (UpdateModes = {}));
  var updateMode = UpdateModes.normal;
  // These options are mutually exclusive. Display an error otherwise.
  var allNull = true;
  var optMap = {
    updateCode: updateCode,
    offlineUpdateFilepath: offlineUpdateFilepath
  };
  Object.keys(optMap).forEach(function (key) {
    var arg = optMap[key];
    if (arg) {
      if (!allNull) {
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().update.mutuallyExclusiveOptions);
        (0, mainProcessUtils_1.exitCli)(0);
        return;
      }
      allNull = false;
      if (key === 'updateCode') {
        updateMode = UpdateModes.fromCode;
      } else if (key === 'offlineUpdateFilepath') {
        updateMode = UpdateModes.fromOffline;
      }
    }
  });
  var startMsg = '';
  switch (updateMode) {
    case UpdateModes.normal:
      {
        startMsg = (0, getStrings_1["default"])().update.startUpdate;
        break;
      }
    case UpdateModes.fromOffline:
      {
        startMsg = (0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().update.startOffline, offlineUpdateFilepath);
        break;
      }
    case UpdateModes.fromCode:
      {
        startMsg = (0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().update.startCode, updateCode);
        break;
      }
  }
  var serialNumber = "";
  var options = program.opts();
  if (options.serial) {
    serialNumber = options.serial;
  }
  var lookupParams = getUpdateParams();
  var serialNumberPromise;
  if ((0, getSettings_1["default"])().hasSerial && serialNumber === "") {
    serialNumberPromise = (0, verify_installation_1.fetchSerialNumber)(process.platform === 'win32' ? lookupParams : lookupParams, (0, getLogger_1["default"])());
  } else {
    serialNumberPromise = Promise.resolve(serialNumber);
  }
  var locationInfo;
  return (0, verify_installation_1.fetchLocations)((0, getSettings_1["default"])().locationLookupInfo, (0, getLogger_1["default"])(), homeToUse).then(function (fetchedLocationInfo) {
    locationInfo = sortOutMainDir(fetchedLocationInfo, options.installdir, relativeInstallDir, versionFileName, (0, getLogger_1["default"])());
    return serialNumberPromise;
  }).then(function (useSerial) {
    serialNumber = useSerial || "";
    var platform = (0, enums_1.ProcessPlatformToPlatformsEnum)(process.platform);
    var product = (0, getSettings_1["default"])().product;
    var channelToUse = 'main';
    var startIdentifier = '';
    var versionInfo;
    var licenseInfo;
    return confirmInstall({
      serialNumber: serialNumber,
      locationInfo: locationInfo,
      platform: platform,
      product: product,
      ldfFilepath: ldfFilepath,
      lookupParams: lookupParams,
      operation: 'update',
      forceChannel: updateCode
    }).then(function (results) {
      versionInfo = results[0];
      licenseInfo = results[1];
      if (updateMode === UpdateModes.fromCode && updateCode) {
        (0, getLogger_1["default"])().info("cli::update - using update code: ".concat(updateCode));
        versionInfo.channel = updateCode;
      }
      channelToUse = versionInfo.channel;
      startIdentifier = versionInfo.identifier;
      return cliGetUpdateInfo(versionInfo, offlineUpdateFilepath || '');
    })["catch"](function (error) {
      printErrorAndExit(error);
      return Promise.reject(error); // This doesn't get called but is required to compile cleanly.
    }).then(function (updateInfo) {
      var isLocalSource = offlineUpdateFilepath !== undefined;
      var _ref6 = (0, webUtils_1.getLatestOnChannel)(updateInfo, channelToUse, platform, isLocalSource, licenseInfo),
        _ref7 = _slicedToArray(_ref6, 2),
        targetToUse = _ref7[0],
        _latestOnChannelName = _ref7[1];
      if (targetToUse === '') {
        throw new Error("Unable to get latest for channel ".concat(channelToUse));
      }
      var pathToUpdate = (0, webUtils_1.findPathToUpdate)(startIdentifier, targetToUse, updateInfo.updates);
      var updater = createCliUpdater(startMsg, offlineUpdateFilepath || '', providedProxyInfo);
      if (!pathToUpdate || pathToUpdate.length <= 1) {
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().check.updateNotAvailable);
        (0, mainProcessUtils_1.exitCli)(0);
        return;
      }
      // Check for any required items
      if ((0, getSettings_1["default"])().hasSerial && serialNumber == '') {
        printErrorAndExit(new errors_1.BaseError((0, getStrings_1["default"])().errors.noSerial, enums_1.ErrorTypes.noSerial));
      } else if ((0, getSettings_1["default"])().usesLDF && licenseInfo.LDFObject.isEmpty()) {
        var LDFErrorString = (0, getStrings_1["default"])().errors.noSerial;
        if ('noLDF' in (0, getStrings_1["default"])().errors) {
          LDFErrorString = (0, getStrings_1["default"])().errors.noLDF;
        }
        printErrorAndExit(new errors_1.BaseError(LDFErrorString, enums_1.ErrorTypes.noLDF));
      } else {
        updater.updateInfo = updateInfo;
        var updateParams = {
          updater: updater,
          pathToUpdate: pathToUpdate,
          versionInfo: versionInfo,
          licenseInfo: licenseInfo
        };
        runUpdate(Object.assign({}, {
          updateInfo: updateInfo,
          locationInfo: locationInfo,
          registrationInfo: (0, getSettings_1["default"])().registrationInfo,
          uid: uid,
          gid: gid,
          offlineUpdateFilepath: offlineUpdateFilepath,
          ldfFilepath: ldfFilepath
        }, updateParams));
      }
    })["catch"](function (error) {
      printErrorAndExit(error);
    });
  })["catch"](function (error) {
    printErrorAndExit(error);
  });
});
// Run an install
program.command('install').description((0, getStrings_1["default"])().install.cmdDescription).option('-i, --input <input file>', (0, getStrings_1["default"])().install.inputDescription).option('-c, --code <update code>', (0, getStrings_1["default"])().install.codeDescription).option('-l, --ldf <ldf file path>', (0, getStrings_1["default"])().install.ldfDescription).option('-u, --uid <uid>', (0, getStrings_1["default"])().install.uidDescription).option('-g, --gid <gid>', (0, getStrings_1["default"])().install.gidDescription).option('--identifier <identifier>', (0, getStrings_1["default"])().install.identifierDescription).action(function (opts) {
  // Set up logger location if passed
  if (program.opts().output) {
    var oldPath = (0, getSettings_1["default"])().logFilePath;
    (0, getSettings_1["default"])().logFilePath = path.join(program.opts().output, path.basename(oldPath));
  }
  (0, getLogger_1["default"])().info('cli::install command called.');
  printAppInfo((0, getLogger_1["default"])(), true);
  printOSInfo((0, getLogger_1["default"])());
  var updateCode;
  var ldfFilepath;
  var uid = '';
  var gid = '';
  var desiredIdentifier = '';
  var offlineUpdateFilepath;
  if (opts.code) {
    updateCode = opts.code.toLowerCase();
  }
  if (opts.identifier) {
    desiredIdentifier = opts.identifier.trim();
  }
  if (opts.ldf) {
    ldfFilepath = opts.ldf;
  }
  if (opts.input) {
    offlineUpdateFilepath = opts.input;
  }
  if (opts.uid) {
    uid = opts.uid.trim();
    if (process.platform !== 'darwin') {
      // Check here for win SID format (todo)
    } else {
      // on Mac the UID will be digits, so check this.
      if (uid.match(/^[0-9]+$/) === null) {
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.uidInvalid);
        (0, mainProcessUtils_1.exitCli)(1);
        return;
      }
    }
  }
  if (opts.gid) {
    gid = opts.gid.trim();
    if (process.platform !== 'darwin') {
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.gidPlatformErr);
      (0, mainProcessUtils_1.exitCli)(1);
      return;
    }
    // on Mac the UID will be digits, so check this.
    if (gid.match(/^[0-9]+$/) === null) {
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.gidInvalid);
      (0, mainProcessUtils_1.exitCli)(1);
      return;
    }
  }
  var homeToUse = (0, os_1.homedir)();
  if (process.platform === 'darwin' && process.getuid) {
    // On Mac...
    if (process.getuid() === 0) {
      // run as root
      if (uid === '' || gid === '') {
        // if this is run as root...
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.uidgidNeedsSpecified);
        (0, mainProcessUtils_1.exitCli)(1);
        return;
      } else {
        homeToUse = getHomeFromUid(uid);
        (0, getLogger_1["default"])().stdout("cli::install - Running as root. Using home directory from uid ".concat(uid, ": ").concat(homeToUse));
      }
    }
  }
  var versionFileName = (0, getSettings_1["default"])().localizedValues['versionFileName'] || '';
  var UpdateModes;
  (function (UpdateModes) {
    UpdateModes[UpdateModes["normal"] = 0] = "normal";
    UpdateModes[UpdateModes["download"] = 1] = "download";
    UpdateModes[UpdateModes["fromOffline"] = 2] = "fromOffline";
    UpdateModes[UpdateModes["fromCode"] = 3] = "fromCode";
  })(UpdateModes || (UpdateModes = {}));
  var updateMode = UpdateModes.normal;
  // These options are mutually exclusive. Display an error otherwise.
  var allNull = true;
  var optMap = {
    updateCode: updateCode,
    offlineUpdateFilepath: offlineUpdateFilepath
  };
  Object.keys(optMap).forEach(function (key) {
    var arg = optMap[key];
    if (arg) {
      if (!allNull) {
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().update.mutuallyExclusiveOptions);
        (0, mainProcessUtils_1.exitCli)(0);
        return;
      }
      allNull = false;
      if (key === 'updateCode') {
        updateMode = UpdateModes.fromCode;
      } else if (key === 'offlineUpdateFilepath') {
        updateMode = UpdateModes.fromOffline;
      }
    }
  });
  var startMsg = '';
  switch (updateMode) {
    case UpdateModes.normal:
      {
        startMsg = (0, getStrings_1["default"])().install.startInstall;
        break;
      }
    case UpdateModes.fromOffline:
      {
        startMsg = (0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().install.startOffline, offlineUpdateFilepath);
        break;
      }
    case UpdateModes.fromCode:
      {
        startMsg = (0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().install.startCode, updateCode);
        break;
      }
  }
  var serialNumber = "";
  var options = program.opts();
  if (options.serial) {
    serialNumber = options.serial;
  }
  var lookupParams = getUpdateParams();
  var serialNumberPromise;
  if ((0, getSettings_1["default"])().hasSerial && serialNumber === "") {
    serialNumberPromise = (0, verify_installation_1.fetchSerialNumber)(process.platform === 'win32' ? lookupParams : lookupParams, (0, getLogger_1["default"])());
  } else {
    serialNumberPromise = Promise.resolve(serialNumber);
  }
  var locationInfo;
  return (0, verify_installation_1.fetchLocations)((0, getSettings_1["default"])().locationLookupInfo, (0, getLogger_1["default"])(), homeToUse).then(function (fetchedLocationInfo) {
    locationInfo = sortOutMainDir(fetchedLocationInfo, options.installdir, relativeInstallDir, versionFileName, (0, getLogger_1["default"])());
    return serialNumberPromise;
  }).then(function (useSerial) {
    serialNumber = useSerial || "";
    var platform = (0, enums_1.ProcessPlatformToPlatformsEnum)(process.platform);
    var product = (0, getSettings_1["default"])().product;
    var channelToUse = 'main';
    if (updateMode === UpdateModes.fromCode && updateCode) {
      (0, getLogger_1["default"])().info("cli::install() - Using passed channel: ".concat(channelToUse, "."));
      channelToUse = updateCode;
    } else if ((0, getSettings_1["default"])().specialChannel !== '') {
      channelToUse = (0, getSettings_1["default"])().specialChannel;
      (0, getLogger_1["default"])().info("cli::install() - Using special channel: ".concat(channelToUse, "."));
    }
    var versionInfo;
    var licenseInfo;
    readDocuments().then(function () {
      return confirmInstall({
        serialNumber: serialNumber,
        locationInfo: locationInfo,
        platform: platform,
        product: product,
        ldfFilepath: ldfFilepath,
        lookupParams: lookupParams,
        operation: 'install',
        forceChannel: channelToUse
      });
    }).then(function (results) {
      versionInfo = results[0];
      licenseInfo = results[1];
      channelToUse = versionInfo.channel;
      versionInfo.macExecutableName = (0, getSettings_1["default"])().defaultApplicationNames.darwin;
      versionInfo.winExecutableName = (0, getSettings_1["default"])().defaultApplicationNames.win32;
      if ((0, getSettings_1["default"])().usesLDF && !licenseInfo.LDFObject.isViewer && licenseInfo.LDFObject.isEmpty()) {
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.couldNotGetLDF);
        printErrorAndExit(new errors_1.BaseError((0, getStrings_1["default"])().errors.noLDF, enums_1.ErrorTypes.noLDF));
        return Promise.reject();
      }
      return Promise.all([cliGetUpdateInfo(versionInfo, offlineUpdateFilepath || '', ''), Promise.resolve(versionInfo)]);
    })["catch"](function (error) {
      printErrorAndExit(error);
      return Promise.reject(error); // This doesn't get called but is required to compile cleanly.
    }).then(function (promiseArray) {
      var updateInfo = promiseArray[0];
      versionInfo = promiseArray[1];
      var isLocalSource = offlineUpdateFilepath !== undefined;
      var targetToUse = '';
      // Ensure that channel is in the updateInfo structure.
      if (!(channelToUse in updateInfo.channels)) {
        (0, getLogger_1["default"])().stdout((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().install.channelNotFound, channelToUse));
        (0, mainProcessUtils_1.exitCli)(1);
        return;
      }
      if (!isLocalSource && desiredIdentifier !== '') {
        var updateIdentifiers = Object.keys(updateInfo.updates);
        if (updateIdentifiers.indexOf(desiredIdentifier) === -1) {
          (0, getLogger_1["default"])().stdout((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().install.identifierNotFound, desiredIdentifier));
          (0, mainProcessUtils_1.exitCli)(1);
          return;
        }
        targetToUse = desiredIdentifier;
      } else {
        var _ref8 = (0, webUtils_1.getLatestOnChannel)(updateInfo, channelToUse, platform, isLocalSource, licenseInfo),
          _ref9 = _slicedToArray(_ref8, 2),
          latestIdentifier = _ref9[0],
          _latestOnChannelName = _ref9[1];
        if (latestIdentifier === '') {
          throw new Error("Unable to get latest for channel ".concat(channelToUse));
        }
        (0, getLogger_1["default"])().info("Installing from latest version: ".concat(latestIdentifier));
        targetToUse = latestIdentifier;
      }
      versionInfo.identifier = targetToUse;
      // Check for any required items
      if ((0, getSettings_1["default"])().hasSerial && serialNumber == '') {
        printErrorAndExit(new errors_1.BaseError((0, getStrings_1["default"])().errors.noSerial, enums_1.ErrorTypes.noSerial));
      } else if ((0, getSettings_1["default"])().usesLDF && !licenseInfo.LDFObject.isViewer && licenseInfo.LDFObject.isEmpty()) {
        var LDFErrorString = (0, getStrings_1["default"])().errors.noSerial;
        if ('noLDF' in (0, getStrings_1["default"])().errors) {
          LDFErrorString = (0, getStrings_1["default"])().errors.noLDF;
        }
        printErrorAndExit(new errors_1.BaseError(LDFErrorString, enums_1.ErrorTypes.noLDF));
      } else {
        var updater = createCliUpdater(startMsg, offlineUpdateFilepath || '', providedProxyInfo);
        updater.updateInfo = updateInfo;
        // A bit hard coded but I think it works for now.
        var readmeDestPath = path.join('${mainDir}/ReleaseNotes/README.html');
        var eulaDestPath = path.join('${mainDir}/ReleaseNotes/License Agreement.html');
        // Set up the VWVersion.txt path since this will be blank up until now.
        var mainDir = (0, types_1.getLocationData)(enums_1.MAIN_DIR, locationInfo).locationPath;
        versionInfo.versionFilePath = path.join(mainDir, versionFileName);
        (0, getLogger_1["default"])().info("Setting version Info path to: ".concat(versionInfo.versionFilePath));
        var installParams = {
          updater: updater,
          versionInfo: versionInfo,
          licenseInfo: licenseInfo,
          readmePath: documentsState.readMe.documentPaths[documentsState.readMe.toUse],
          eulaPath: documentsState.eula.documentPaths[documentsState.eula.toUse],
          readmeDestPath: readmeDestPath,
          eulaDestPath: eulaDestPath,
          registrationInfo: (0, getSettings_1["default"])().registrationInfo
        };
        runInstall(Object.assign({}, {
          updateInfo: updateInfo,
          locationInfo: locationInfo,
          target: targetToUse,
          offlineUpdateFilepath: offlineUpdateFilepath,
          ldfFilepath: ldfFilepath,
          uid: uid,
          gid: gid
        }, installParams));
      }
    })["catch"](function (error) {
      printErrorAndExit(error);
    });
  })["catch"](function (error) {
    printErrorAndExit(error);
  });
});
// Run an uninstall
program.command('uninstall').description((0, getStrings_1["default"])().uninstall.cmdDescription).option('-d, --dryrun', (0, getStrings_1["default"])().uninstall.dryRunDescription).option('-u, --uid <uid>', (0, getStrings_1["default"])().uninstall.uidDescription).option('-g, --gid <gid>', (0, getStrings_1["default"])().uninstall.gidDescription).action(function (opts) {
  // Set up logger location if passed
  if (program.opts().output) {
    var oldPath = (0, getSettings_1["default"])().logFilePath;
    (0, getSettings_1["default"])().logFilePath = path.join(program.opts().output, path.basename(oldPath));
  }
  (0, getLogger_1["default"])().info("cli::uninstall command called.");
  printAppInfo((0, getLogger_1["default"])(), true);
  printOSInfo((0, getLogger_1["default"])());
  var serialNumber = "";
  var ldfFilepath;
  var options = program.opts();
  var dryRun = opts.dryrun;
  var uid = '';
  var gid = '';
  var dryRunReplace = dryRun ? (0, getStrings_1["default"])().uninstall.dryRunTrue : (0, getStrings_1["default"])().uninstall.dryRunFalse;
  var startupString = (0, getStrings_1["default"])().uninstall.settingUp.replaceAll('${dryRun}', dryRunReplace);
  process.stdout.write("".concat(startupString, "\n"));
  if (options.serial) {
    serialNumber = options.serial;
  }
  if (opts.ldf) {
    ldfFilepath = opts.ldf;
  }
  if (opts.uid) {
    uid = opts.uid.trim();
    if (process.platform !== 'darwin') {
      // Check here for win SID format (todo)
    } else {
      // on Mac the UID will be digits, so check this.
      if (uid.match(/^[0-9]+$/) === null) {
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.uidInvalid);
        (0, mainProcessUtils_1.exitCli)(1);
        return;
      }
    }
  }
  if (opts.gid) {
    gid = opts.gid.trim();
    if (process.platform !== 'darwin') {
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.gidPlatformErr);
      (0, mainProcessUtils_1.exitCli)(1);
      return;
    }
    // on Mac the UID will be digits, so check this.
    if (gid.match(/^[0-9]+$/) === null) {
      (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.gidInvalid);
      (0, mainProcessUtils_1.exitCli)(1);
      return;
    }
  }
  var homeToUse = (0, os_1.homedir)();
  if (process.platform === 'darwin' && process.getuid) {
    // On Mac...
    if (process.getuid() === 0) {
      // run as root
      if (uid === '' || gid === '') {
        // if this is run as root...
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().install.uidgidNeedsSpecified);
        (0, mainProcessUtils_1.exitCli)(1);
        return;
      } else {
        homeToUse = getHomeFromUid(uid);
        (0, getLogger_1["default"])().info("cli::install - Running as root. Using home directory from uid ".concat(uid, ": ").concat(homeToUse));
      }
    }
  }
  var lookupParams = getUpdateParams();
  var versionFileName = (0, getSettings_1["default"])().localizedValues['versionFileName'] || '';
  var serialNumberPromise;
  if ((0, getSettings_1["default"])().hasSerial && serialNumber === "") {
    serialNumberPromise = (0, verify_installation_1.fetchSerialNumber)(process.platform === 'win32' ? lookupParams : lookupParams, (0, getLogger_1["default"])());
  } else {
    serialNumberPromise = Promise.resolve(serialNumber);
  }
  var locationInfo;
  return (0, verify_installation_1.fetchLocations)((0, getSettings_1["default"])().locationLookupInfo, (0, getLogger_1["default"])(), homeToUse).then(function (fetchedLocationInfo) {
    locationInfo = sortOutMainDir(fetchedLocationInfo, options.installdir, relativeInstallDir, versionFileName, (0, getLogger_1["default"])());
    return serialNumberPromise;
  }).then(function (useSerial) {
    serialNumber = useSerial || "";
    var platform = (0, enums_1.ProcessPlatformToPlatformsEnum)(process.platform);
    var product = (0, getSettings_1["default"])().product;
    confirmInstall({
      serialNumber: serialNumber,
      locationInfo: locationInfo,
      platform: platform,
      product: product,
      ldfFilepath: ldfFilepath,
      lookupParams: lookupParams,
      operation: 'uninstall'
    }).then(function (results) {
      // Print the folder locations and collect them into uninstallFolders...
      var uninstallFolders = [];
      // While we print out the folder locations, collect them in uninstallFolders to pass to uninstall.
      process.stdout.write("".concat((0, getStrings_1["default"])().uninstall.folderLocationsHeading, "\n"));
      for (var key in locationInfo.locationInfo) {
        var location = (0, types_1.getLocationData)(key, locationInfo);
        if (location && location.valid && location.canUninstall) {
          var locationItemString = (0, getStrings_1["default"])().uninstall.singleFolderLocation;
          locationItemString = locationItemString.replaceAll('${locationName}', location.userFriendlyName);
          locationItemString = locationItemString.replaceAll('${locationPath}', location.locationPath);
          process.stdout.write("".concat(locationItemString, "\n"));
          uninstallFolders.push(key);
        }
      }
      var updater = createCliUpdater((0, getStrings_1["default"])().uninstall.starting, '', providedProxyInfo);
      updater.on('error', function (error) {
        printErrorAndExit(error);
      }).on('start-step', function (step) {
        var stepString = stepToString(step);
        if (stepString.length > 0) {
          (0, getLogger_1["default"])().stdout(stepString);
        }
      }).on('removed-file', function (item) {
        var location = item.location,
          filePath = item.filePath;
        // EG "Removed item: ${locationName} at: ${locationPath}"
        var removeString = location === '' ? dryRun ? (0, getStrings_1["default"])().uninstall.removedItemNoLocationDryRun : (0, getStrings_1["default"])().uninstall.removedItemNoLocation : dryRun ? (0, getStrings_1["default"])().uninstall.removedItemDryRun : (0, getStrings_1["default"])().uninstall.removedItem;
        var locationName = location; // FIX - use location's userFriendlyString
        removeString = removeString.replaceAll('${locationName}', locationName);
        removeString = removeString.replaceAll('${locationPath}', filePath);
        (0, getLogger_1["default"])().stdout(removeString);
        (0, getLogger_1["default"])().info(removeString);
      }).on('unregistered-item', function (itemName) {
        var unregisterString = dryRun ? (0, getStrings_1["default"])().uninstall.unregisterItemDryRun : (0, getStrings_1["default"])().uninstall.unregisterItem;
        unregisterString = unregisterString.replaceAll('${item}', itemName);
        (0, getLogger_1["default"])().stdout(unregisterString);
        (0, getLogger_1["default"])().info(unregisterString);
      }).on('success', function () {
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().uninstall.uninstallComplete);
      }).on('done', function () {
        (0, mainProcessUtils_1.exitCli)(0);
      });
      updater.uninstall({
        versionInfo: results[0],
        locationInfo: locationInfo,
        uninstallFolders: uninstallFolders,
        uid: uid,
        gid: gid,
        helperAppPath: (0, getSettings_1["default"])().vwimHelperPath,
        unRegistrations: (0, getSettings_1["default"])().unRegistrationInfo,
        extraFolders: (0, getSettings_1["default"])().uninstallExtraFolders,
        dryRun: dryRun,
        mainPid: process.pid,
        logger: (0, getLogger_1["default"])()
      });
    });
  })["catch"](function (error) {
    printErrorAndExit(error);
  });
});
// Do not expose this in legacy CLI
program.command('download-latest-updater <destination>').description((0, getStrings_1["default"])().selfUpdate.cmdDescription).option('-p, --platform <m/w>', (0, getStrings_1["default"])().selfUpdate.platformDescription).action(function (destination, opts) {
  // Set up logger location if passed
  if (program.opts().output) {
    var oldPath = (0, getSettings_1["default"])().logFilePath;
    (0, getSettings_1["default"])().logFilePath = path.join(program.opts().output, path.basename(oldPath));
  }
  (0, getLogger_1["default"])().info('cli::download-latest-updater command called.');
  printAppInfo((0, getLogger_1["default"])(), true);
  printOSInfo((0, getLogger_1["default"])());
  var platform = opts.platform;
  if (!['m', 'M', 'w', 'W'].includes(platform)) {
    (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().selfUpdate.invalidPlatform);
    (0, mainProcessUtils_1.exitCli)(1);
    return;
  }
  var selfUpdater = new SelfUpdater_1["default"]((0, getSettings_1["default"])().selfUpdateUrl, providedProxyInfo, platform.toLowerCase() === 'm' ? 'darwin' : 'win32', (0, getSettings_1["default"])().sslVerification, (0, getSettings_1["default"])().localCurlPath, (0, getLogger_1["default"])());
  // Get the version of our application
  (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().selfUpdate.checking);
  selfUpdater.getLatestVersionInfo().then(function (latestInfo) {
    (0, getLogger_1["default"])().stdout((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().selfUpdate.downloading, latestInfo.version, path.join(destination, latestInfo.path)));
    var currentPercentage = 0 .toFixed(0);
    selfUpdater.on('download-progress', function (progress) {
      if (typeof progress.contentLength !== 'undefined') {
        var length = Number.parseInt(progress.contentLength, 10);
        if (!Number.isNaN(length)) {
          var percentage = (progress.downloadedBytes / length * 100).toFixed(0);
          if (percentage !== currentPercentage) {
            currentPercentage = percentage;
            process.stdout.write("".concat((0, getStrings_1["default"])().silentUpdaterUpdate.progress).concat(percentage, "%\r"));
            (0, getLogger_1["default"])().info('Updater update download progress', progress);
          }
        }
      }
    }).on('error', function (error) {
      printErrorAndExit(error);
    }).on('download-url', function (url) {
      (0, getLogger_1["default"])().info("Downloading self update from \"".concat(url, "\""));
    }).on('downloaded-update', function (location) {
      process.stdout.write('\n');
      (0, getLogger_1["default"])().info("Update downloaded to \"".concat(location, "\""));
      (0, getLogger_1["default"])().stdout((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().selfUpdate.done, location));
      if (platform.toLowerCase() === 'm') {
        (0, getLogger_1["default"])().stdout((0, getStrings_1["default"])().selfUpdate.installInstructionsMac);
      } else {
        (0, getLogger_1["default"])().stdout((0, sprintf_js_1.sprintf)((0, getStrings_1["default"])().selfUpdate.installInstructionsWin, path.basename(location)));
      }
      (0, mainProcessUtils_1.exitCli)(0);
    });
    (0, getLogger_1["default"])().info("Latest updater available is ".concat(latestInfo.version), {
      latestInfo: latestInfo
    });
    selfUpdater.downloadUpdater(destination);
  })["catch"](function (error) {
    printErrorAndExit(error);
  });
});
var runCli = function runCli(inputRelativeInstallDir, argv, proxyInfo) {
  if (inputRelativeInstallDir) {
    relativeInstallDir = inputRelativeInstallDir;
  }
  providedProxyInfo = proxyInfo;
  // On any unknown commands bail
  program.on('command:*', function () {
    (0, getLogger_1["default"])().stdout("Invalid command: ".concat(program.args.join(' '), "\nSee --help for a list of available commands.\n"));
    (0, mainProcessUtils_1.exitCli)(1);
  });
  try {
    program.parse(argv);
  } catch (error) {
    if (error.message === 'Invalid Update Locations') {
      (0, getLogger_1["default"])().stdout('Invalid -L,--locations argument. Please use the form locationKey1:path1,locationKey2:path2,...');
    }
    (0, getLogger_1["default"])().error('An error has occurred parsing the arguments', {
      error: error,
      argv: argv
    });
    (0, mainProcessUtils_1.exitCli)(1);
    return;
  }
  // If there is nothing passed say we need something
  if (program.args.length === 0) {
    (0, getLogger_1["default"])().stdout('No command has been passed.\nSee --help for a list of available commands.\n');
    (0, mainProcessUtils_1.exitCli)(1);
  }
};
exports["default"] = runCli;

/***/ }),

/***/ 36757:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var path = __importStar(__webpack_require__(71017));
var cli_1 = __importDefault(__webpack_require__(88620));
var mainProcessUtils = __importStar(__webpack_require__(74641));
var getLogger_1 = __importDefault(__webpack_require__(14449));
// Get the installation directory
var installDir = null;
if (true) {
  // These are relative to where this file exists in the resources folder in the build electorn app
  if (process.platform === 'darwin') {
    installDir = path.resolve(__dirname, '..', '..', '..');
  } else if (process.platform === 'win32') {
    installDir = path.resolve(__dirname, '..', '..');
  }
}
var _mainProcessUtils$get = mainProcessUtils.getProxyInfo(),
  proxyInfo = _mainProcessUtils$get.proxyInfo,
  proxyInfoError = _mainProcessUtils$get.proxyInfoError;
if (proxyInfoError) {
  (0, getLogger_1["default"])().error('An error has occurred fetching proxy info', {
    proxyInfoError: proxyInfoError
  });
}
(0, cli_1["default"])(installDir, process.argv, proxyInfo);

/***/ }),

/***/ 82143:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


/**
 * Handles application settings.
 *
 * BaseSettings are items that are in both the JSON settings file and the final settings. It exists to
 * easily copy this set of items between JSONSettings and AppSettings.
 *
 * JsonSettings are items inside the settings.json file. Some of these may not end up in AppSettings
 * (typically if they're not in BaseSettings), or they may be transformed into another form before being
 * stored in AppSettings.
 *
 * AppSettings are what is retrieved whenever anyone calls getSettings() which is the default export of this file.
 *
 * cachedSettings is a mechanism to store AppSettings so it doesn't have to be built each time.
 *
 * Note that there are two items used somewhat interchangeably in the source:
 * getSettings() calls this module's default export, returning an AppSettings object (likely the cachedSettings).
 * getGlobals() is a redux construct in renderIndex.tsx that returns the AppSettings object (via a call to getSettings),
 *     as well as some other items: a logger, getStrings(), appPath (the path to this app), and mainPid. In code where
 *     getGlobals() is there, it's fine to call that. But if that's absent getSettings is nearly the same except for those
 *     extra items.
 *
 * Similar to getGlobals, App.tsx adds ContainerProps which I think is the mechanism where mapStateToProps can call getSettings.
 *
 * One convention here is that settings get setup on launch, and don't typically change. So if there's an item that changes
 *     based on application state, that should go to its own redux item with reducer etc. A good example is locationInfo:
 *     The locationLookupInfo is set at launch, but the actual locations can change (based on user input) so the
 *     locationLookupInfo is stored here where the locationInfo is a redux object in the state (that has a setter etc).
 *
*/
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i["return"] && (_r = _i["return"](), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var path = __importStar(__webpack_require__(71017));
var fs = __importStar(__webpack_require__(57147));
var os = __importStar(__webpack_require__(22037));
var plist_editor_1 = __webpack_require__(45637);
var replaceSubKeyValues = function replaceSubKeyValues(val_in, subKey, major, year) {
  var val = val_in;
  var subKeyPreBackslash = subKey === '' ? '' : "\\".concat(subKey);
  var subKeyPreSlash = subKey === '' ? '' : "/".concat(subKey);
  var subKeyPreDot = subKey === '' ? '' : ".".concat(subKey);
  var subKeyPreSpace = subKey === '' ? '' : " ".concat(subKey);
  val = val.replaceAll('${subKey}', subKey);
  val = val.replaceAll('${subKeyPreBackslash}', subKeyPreBackslash);
  val = val.replaceAll('${subKeyPreSlash}', subKeyPreSlash);
  val = val.replaceAll('${subKeyPreDot}', subKeyPreDot);
  val = val.replaceAll('${subKeyPreSpace}', subKeyPreSpace);
  val = val.replaceAll('${major}', major); // eg 30
  val = val.replaceAll('${year}', year); // eg 2025
  return val;
};
var cachedSettings;
exports["default"] = function () {
  if (cachedSettings && Object.keys(cachedSettings).length > 0) {
    return cachedSettings;
  }
  var settingFile = process.env.UPDATER_CLI_PROD === '1' ? 'cli-settings.json' : '../dist/settings.json';
  var settingsFileLoc = path.join(__dirname, settingFile);
  var jsonSettings = JSON.parse(fs.readFileSync(settingsFileLoc, 'utf-8'));
  var date = new Date();
  // Vectorworks_2025_VWIM_2024_5_17_20_51_52
  var sessionDate = "".concat(jsonSettings.product, "_").concat(jsonSettings.year, "_VWIM_").concat(date.getFullYear(), "_").concat(date.getMonth() + 1, "_").concat(date.getDate(), "_").concat(date.getHours(), "_").concat(date.getMinutes(), "_").concat(date.getSeconds());
  var logFileName = "".concat(sessionDate, ".log");
  var logFailureFileName = "".concat(sessionDate, "_log_errors.log");
  var tmpdir = os.tmpdir(); // Something like this on macOS: /var/folders/x2/k6c927014flc1d22bb87vl_40000gq/T, and on Win: %TEMP% or possibly %TMP%
  var licenseDescriptionFolder = "".concat(sessionDate, "_LDF");
  var defaultLicenseDescriptionFilePath = path.resolve(tmpdir, licenseDescriptionFolder);
  var logFileDirectory = process.platform === 'darwin' ? path.join(os.homedir(), 'Library', 'Logs') : path.join(os.tmpdir());
  // Add to JSON settings the paths of plists
  var product = jsonSettings.product,
    year = jsonSettings.year,
    major = jsonSettings.major,
    distributor = jsonSettings.distributor,
    language = jsonSettings.language,
    bundleName = jsonSettings.bundleName,
    subKey = jsonSettings.subKey,
    fileExt = jsonSettings.fileExt,
    fileDesc = jsonSettings.fileDesc,
    updaterLogName = jsonSettings.updaterLogName,
    dllsToRegister = jsonSettings.dllsToRegister,
    repairIgnorePrefixes = jsonSettings.repairIgnorePrefixes,
    rootUrl = jsonSettings.rootUrl,
    jsonSerialNumberLocation = jsonSettings.serialNumberLocation,
    updaterInstallLocation = jsonSettings.updaterInstallLocation,
    allowedDistributors = jsonSettings.allowedDistributors,
    excludedDistributors = jsonSettings.excludedDistributors,
    retiredChannels = jsonSettings.retiredChannels,
    initialReleaseIdentifiers = jsonSettings.initialReleaseIdentifiers,
    mainChannels = jsonSettings.mainChannels,
    updateInfoFileName = jsonSettings.updateInfoFileName,
    localizedValues = jsonSettings.localizedValues,
    workspacesFolderName = jsonSettings.workspacesFolderName,
    installerDownloadURLWin = jsonSettings.installerDownloadURLWin,
    installerDownloadURLMac = jsonSettings.installerDownloadURLMac,
    smallHeaderLogo = jsonSettings.smallHeaderLogo,
    applicationBaseName = jsonSettings.applicationBaseName,
    directoriesToChmod = jsonSettings.directoriesToChmod,
    locationLookupInfo = jsonSettings.locationLookupInfo,
    uninstallExtraFolders = jsonSettings.uninstallExtraFolders,
    registrationInfo = jsonSettings.registrationInfo,
    unRegistrationInfo = jsonSettings.unRegistrationInfo,
    onlyAllowExpectedFileStrings = jsonSettings.regexesToOnlyAllowExpectedFiles,
    runningAppExceptionsRaw = jsonSettings.runningAppExceptions,
    usesLDF = jsonSettings.usesLDF,
    hasViewer = jsonSettings.hasViewer,
    hasDemo = jsonSettings.hasDemo,
    specialBuild = jsonSettings.specialBuild,
    specialChannel = jsonSettings.specialChannel,
    showLaunchButton = jsonSettings.showLaunchButton,
    disallowMultibyteDirs = jsonSettings.disallowMultibyteDirs,
    showErrorReporting = jsonSettings.showErrorReporting,
    macAppRegex = jsonSettings.macAppRegex,
    winAppRegex = jsonSettings.winAppRegex;
  // For serialNumberLocations, substitute for ${year}, ${major}, and ${subKey*} items...
  jsonSerialNumberLocation.mac.forEach(function (plist) {
    plist.name = replaceSubKeyValues(plist.name, subKey, major, year);
  });
  jsonSerialNumberLocation.win.key = replaceSubKeyValues(jsonSerialNumberLocation.win.key, subKey, major, year);
  // On Windows, updaterInstallLocation is used for self-updates.
  updaterInstallLocation.win.key = replaceSubKeyValues(updaterInstallLocation.win.key, '', major, year);
  // Plist settings have a "path" variable embedded inside that has to be set up. We do that here.
  var serialNumberLocation = {
    mac: [],
    win: jsonSerialNumberLocation.win
  };
  jsonSerialNumberLocation.mac.forEach(function (plist) {
    var macSerialPlistPath = path.join(plist_editor_1.PlistLocations[plist.scope], plist.name);
    serialNumberLocation.mac.push(Object.assign({
      path: macSerialPlistPath
    }, plist));
  });
  // Substitute for items inside locationLookupInfo...
  for (var key in locationLookupInfo) {
    for (var i = 0; i < locationLookupInfo[key].mac.length; i++) {
      locationLookupInfo[key].mac[i].name = replaceSubKeyValues(locationLookupInfo[key].mac[i].name, subKey, major, year);
    }
    for (var _i = 0; _i < locationLookupInfo[key].win.length; _i++) {
      locationLookupInfo[key].win[_i].key = replaceSubKeyValues(locationLookupInfo[key].win[_i].key, subKey, major, year);
    }
  }
  // Set paths for locationLookupInfo (on Mac)
  if (process.platform === 'darwin') {
    for (var _key in locationLookupInfo) {
      for (var _i2 = 0; _i2 < locationLookupInfo[_key].mac.length; _i2++) {
        var macSerialPlistPath = path.join(plist_editor_1.PlistLocations[locationLookupInfo[_key].mac[_i2].scope], locationLookupInfo[_key].mac[_i2].name);
        locationLookupInfo[_key].mac[_i2].path = macSerialPlistPath;
      }
    }
  }
  // Different modes lead to different values for "__dirname" so we have to carefully normalize it all to get to the tools.
  var foundResourcesPath = '';
  if (false) {} else {
    // __dirname will be the InstallDir/Updater.app/Contents/Resources/aapp.asar/app/dist (bundle.js)
    foundResourcesPath = path.resolve(__dirname, '..', '..', '..');
  }
  var resourcesPath = foundResourcesPath;
  // For CLI, __dirname is the location of "cli.js" which is in the "resources" folder.
  if (process.env.UPDATER_CLI_PROD == '1') {
    resourcesPath = path.resolve(__dirname);
  }
  var toolsPath = path.join(resourcesPath, 'tools', process.platform === 'darwin' ? 'mac' : 'win');
  var configPath = path.join(resourcesPath, 'config');
  var operatingSystemFolder = process.platform === 'darwin' ? 'mac' : 'win';
  var documentPath = path.join(resourcesPath, 'docs');
  var readMeRoot = path.join(documentPath, 'README', operatingSystemFolder);
  var eulaRoot = path.join(documentPath, 'EULA');
  var localCurlName = process.platform === 'darwin' ? 'curl' : 'curl.exe';
  var localCurlPath = process.platform === 'darwin' ? localCurlName : path.resolve(toolsPath, localCurlName);
  var proxyToolName = process.platform === 'darwin' ? 'VWProxyMgr' : 'VWProxyMgr.exe';
  var proxyToolPath = path.resolve(toolsPath, proxyToolName);
  // Read the customValues file if present or just use an empty object by default.
  var customValues = {};
  var customValuesFilepath = path.join(configPath, 'customValues.json');
  if (fs.existsSync(customValuesFilepath)) {
    customValues = JSON.parse(fs.readFileSync(customValuesFilepath, 'utf-8'));
  }
  var appRegex = /^.*$/;
  if (process.platform === 'darwin') {
    appRegex = new RegExp(macAppRegex);
  } else {
    appRegex = new RegExp(winAppRegex);
  }
  var shouldInstallName = process.platform === 'darwin' ? 'ShouldInstall' : 'ShouldInstall.exe';
  var shouldInstallPath = path.resolve(toolsPath, shouldInstallName);
  var vwimHelperName = process.platform === 'darwin' ? 'VWIMHelper' : 'VWIMHelper.exe';
  var vwimHelperPath = path.resolve(toolsPath, vwimHelperName);
  var largeAdvancedOptions = jsonSettings.largeAdvancedOptions;
  var upperCasedProduct = product.replace(/^\w/, function (c) {
    return c.toUpperCase();
  });
  var regexesToOnlyAllowExpectedFiles = {};
  Object.keys(onlyAllowExpectedFileStrings).forEach(function (location) {
    regexesToOnlyAllowExpectedFiles[location] = onlyAllowExpectedFileStrings[location].map(function (s) {
      return new RegExp(s);
    });
  });
  // This converts the platform: [string] style settings to an array of regexp's for the current platform.
  var runningAppExceptionsConvertedToRegexes = [];
  var platformKey = process.platform === 'darwin' ? 'mac' : 'win';
  for (var _i3 = 0; _i3 < runningAppExceptionsRaw[platformKey].length; ++_i3) {
    runningAppExceptionsConvertedToRegexes.push(new RegExp(runningAppExceptionsRaw[platformKey][_i3]));
  }
  // This substitues any localized items within localized items...
  for (var _i4 = 0; _i4 < Object.keys(localizedValues).length; ++_i4) {
    var mainKey = Object.keys(localizedValues)[_i4];
    var mainVal = localizedValues[mainKey];
    if (!mainVal.includes('${')) {
      continue; // short-circuit as there are no replacement items
    }

    for (var j = 0; j < Object.keys(localizedValues).length; ++j) {
      if (_i4 == j) {
        continue;
      }
      var secondKey = Object.keys(localizedValues)[j];
      var replaceToken = '${' + secondKey + '}';
      var secondVal = localizedValues[secondKey];
      if (mainVal.includes(replaceToken)) {
        mainVal = mainVal.replaceAll(replaceToken, secondVal);
        localizedValues[mainKey] = mainVal;
      }
    }
  }
  // repairIgnorePrefixes can have ${} items from localizedValues, so substitute them here.
  for (var _i5 = 0, _Object$entries = Object.entries(repairIgnorePrefixes); _i5 < _Object$entries.length; _i5++) {
    var _Object$entries$_i = _slicedToArray(_Object$entries[_i5], 2),
      _location = _Object$entries$_i[0],
      pathValue = _Object$entries$_i[1];
    for (var _i6 = 0; _i6 < pathValue.length; ++_i6) {
      if (!pathValue) {
        continue;
      }
      var thePath = pathValue[_i6];
      if (!thePath.includes('${')) {
        continue; // short-circuit as there are no replacement items
      }

      for (var _j = 0; _j < Object.keys(localizedValues).length; ++_j) {
        var _secondKey = Object.keys(localizedValues)[_j];
        var _replaceToken = '${' + _secondKey + '}';
        var _secondVal = localizedValues[_secondKey];
        if (thePath.includes(_secondKey)) {
          thePath = thePath.replaceAll(_replaceToken, _secondVal);
          pathValue[_i6] = thePath;
        }
      }
    }
  }
  cachedSettings = {
    year: year,
    major: major,
    distributor: distributor,
    language: language,
    bundleName: bundleName,
    subKey: subKey,
    fileExt: fileExt,
    fileDesc: fileDesc,
    updaterLogName: updaterLogName,
    dllsToRegister: dllsToRegister,
    repairIgnorePrefixes: repairIgnorePrefixes,
    rootUrl: rootUrl,
    serialNumberLocation: serialNumberLocation,
    updaterInstallLocation: updaterInstallLocation,
    allowedDistributors: allowedDistributors,
    excludedDistributors: excludedDistributors,
    appRegex: appRegex,
    macAppRegex: macAppRegex,
    winAppRegex: winAppRegex,
    largeAdvancedOptions: largeAdvancedOptions,
    retiredChannels: retiredChannels,
    initialReleaseIdentifiers: initialReleaseIdentifiers,
    mainChannels: mainChannels,
    updateInfoFileName: updateInfoFileName,
    localizedValues: localizedValues,
    workspacesFolderName: workspacesFolderName,
    installerDownloadURLWin: installerDownloadURLWin,
    installerDownloadURLMac: installerDownloadURLMac,
    upperCasedProduct: upperCasedProduct,
    smallHeaderLogo: smallHeaderLogo,
    applicationBaseName: applicationBaseName,
    directoriesToChmod: directoriesToChmod,
    locationLookupInfo: locationLookupInfo,
    uninstallExtraFolders: uninstallExtraFolders,
    registrationInfo: registrationInfo,
    unRegistrationInfo: unRegistrationInfo,
    regexesToOnlyAllowExpectedFiles: regexesToOnlyAllowExpectedFiles,
    runningAppExceptions: runningAppExceptionsConvertedToRegexes,
    selfUpdateUrl: jsonSettings.selfUpdateUrl,
    hasSerial: jsonSettings.hasSerial,
    macProxyPath: path.join(os.homedir(), jsonSettings.macProxyRelativePath),
    winProxyPath: path.join(os.homedir(), jsonSettings.winProxyRelativePath),
    product: product.toLowerCase(),
    platform: process.platform,
    serialCheck: /^.*/,
    serialNumberRe: /^\s*([A-Za-z0-9]{6}-[A-Za-z0-9]{6}-[A-Za-z0-9]{6}-[A-Za-z0-9]{6})\s*$/,
    evalSerialRe: /^\s*([Vv][Ww][Ee][Vv][Aa][Ll]-[A-Za-z0-9]{2}-[A-Za-z0-9]{4}-[A-Za-z0-9]{4}-[A-Za-z0-9]{4})\s*$/,
    demoRe: /[dD][eE][mM][oO]/,
    viewerRe: /[vV][iI][eE][wW][eE][rR]/,
    logFilePath: path.join(logFileDirectory, logFileName),
    logFailureLogFilePath: path.join(logFileDirectory, logFailureFileName),
    applicationName: "".concat(jsonSettings.applicationBaseName).concat(process.platform === 'darwin' ? '.app' : '.exe'),
    resourcesPath: resourcesPath,
    licenseDescriptionFilePath: defaultLicenseDescriptionFilePath,
    licenseDescriptionModalResult: 'NONE',
    usesLDF: usesLDF,
    hasViewer: hasViewer,
    hasDemo: hasDemo,
    specialBuild: specialBuild,
    specialChannel: specialChannel,
    localCurlPath: localCurlPath,
    proxyToolPath: proxyToolPath,
    shouldInstallPath: shouldInstallPath,
    vwimHelperPath: vwimHelperPath,
    showLaunchButton: showLaunchButton,
    disallowMultibyteDirs: disallowMultibyteDirs,
    showErrorReporting: showErrorReporting,
    defaultEula: jsonSettings.defaultEula,
    defaultReadMe: jsonSettings.defaultReadMe,
    defaultApplicationNames: jsonSettings.defaultApplicationNames,
    readMeRoot: readMeRoot,
    eulaRoot: eulaRoot,
    customValues: customValues,
    sslVerification: true
  };
  return cachedSettings;
};

/***/ }),

/***/ 10084:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var fs = __importStar(__webpack_require__(55674));
var path = __importStar(__webpack_require__(71017));
var vwstring_translator_1 = __webpack_require__(42884);
var cachedStrings = {};
exports["default"] = function () {
  if (Object.keys(cachedStrings).length > 0) {
    return cachedStrings;
  }
  var stringFile;
  if (process.env.UPDATER_CLI_PROD === '1') {
    stringFile = path.join(__dirname, 'cli-strings.vwstrings');
  } else {
    stringFile = path.join(__dirname, '../dist/strings.vwstrings');
  }
  cachedStrings = (0, vwstring_translator_1.toJSON)(fs.readFileSync(stringFile, 'utf16le'));
  return cachedStrings;
};

/***/ }),

/***/ 45954:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var childProcess = __importStar(__webpack_require__(32081));
var path_1 = __importDefault(__webpack_require__(71017));
var doLog = function doLog(msg, logger) {
  if (logger) {
    logger.info(msg);
  } else {
    console.log(msg);
  }
};
/**
 * Log a message on successful completion
 *
 * @returns {void}
 */
var healthCheck = function healthCheck(functionName, logger) {
  var msg = "Stub function: ".concat(functionName, " called successfully...");
  doLog(msg, logger);
};
/**
 * Log a message on successful completion
 *
 * @returns {void}
 */
var runStub = function runStub(logger) {
  healthCheck('runStub', logger);
};
/**
 * Log a message on successful completion
 *
 * @returns {void}
 */
var beforeUpdateStub = function beforeUpdateStub(_versionInfo, logger) {
  healthCheck('beforeUpdateStub', logger);
};
var fixVCS = function fixVCS(versionInfo, logger) {
  // FIX - this will not work. Need to carry LocationInfo in.
  var VCSPath = path_1["default"].join(versionInfo['installDir'], 'Vectorworks Cloud Services', 'Vectorworks Cloud Services.app', 'Contents', 'MacOS', 'Vectorworks Cloud Services');
  doLog("Fixing VCS app: ".concat(VCSPath), logger);
  var cmd = "chmod a+x \"".concat(VCSPath, "\"");
  try {
    childProcess.execSync(cmd, {
      stdio: 'ignore'
    });
    doLog("fixVCS: chmod command completed", logger);
  } catch (error) {
    doLog("fixVCS() - chmod command failed ".concat(cmd));
  }
  doLog("fixVCS: Ending override for Windows.", logger);
};
/**
 * Log a message on successful completion
 *
 * @returns {void}
 */
var afterUpdateStub = function afterUpdateStub(versionInfo, logger) {
  healthCheck('afterUpdateStub - override for VCS fix', logger);
  if (process.platform === 'darwin') {
    fixVCS(versionInfo, logger);
  }
};
/**
 * Log a message on successful completion
 *
 * @returns {void}
 */
var beforeRepairStub = function beforeRepairStub(_installInfo, logger) {
  healthCheck('beforeRepairStub', logger);
};
/**
 * Log a message on successful completion
 *
 * @returns {void}
 */
var afterRepairStub = function afterRepairStub(installInfo, logger) {
  healthCheck('afterRepairStub - override for VCS fix', logger);
  if (process.platform === 'darwin') {
    fixVCS(installInfo, logger);
  }
};
exports["default"] = {
  runStub: runStub,
  beforeUpdateStub: beforeUpdateStub,
  afterUpdateStub: afterUpdateStub,
  beforeRepairStub: beforeRepairStub,
  afterRepairStub: afterRepairStub
};

/***/ }),

/***/ 57789:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SelfUpdater = exports.SelfUpdaterError = void 0;
var path = __importStar(__webpack_require__(71017));
var yaml = __importStar(__webpack_require__(93320));
var Request = __importStar(__webpack_require__(34079));
var events_1 = __webpack_require__(82361);
var downloader_1 = __importDefault(__webpack_require__(66912));
var errors_1 = __webpack_require__(94515);
var enums_1 = __webpack_require__(38261);
/**
 * An error that occurs during self update process
 *
 * @extends BaseError
 */
var SelfUpdaterError = /*#__PURE__*/function (_errors_1$BaseError) {
  _inherits(SelfUpdaterError, _errors_1$BaseError);
  var _super = _createSuper(SelfUpdaterError);
  function SelfUpdaterError() {
    _classCallCheck(this, SelfUpdaterError);
    return _super.apply(this, arguments);
  }
  return _createClass(SelfUpdaterError);
}(errors_1.BaseError);
exports.SelfUpdaterError = SelfUpdaterError;
/**
 * Verifies parsed XML is a LatestInfo object
 *
 * @param {any} item - The item to test.
 *
 * @returns {boolean} - true if item is a LatestInfo object, false otherwise.
 */
var isLatestInfo = function isLatestInfo(item) {
  if (_typeof(item) !== 'object' || item === null) {
    return false;
  }
  if (typeof item.version !== 'string' || typeof item.path !== 'string' || typeof item.sha512 !== 'string' || typeof item.releaseDate !== 'string') {
    return false;
  }
  if (!Array.isArray(item.files)) {
    return false;
  }
  if (!item.files.every(function (f) {
    if (!f || _typeof(f) !== 'object') {
      return false;
    }
    if (typeof f.url !== 'string' || typeof f.sha512 !== 'string') {
      return false;
    }
    return true;
  })) {
    return false;
  }
  return true;
};
var SelfUpdater = /*#__PURE__*/function (_events_1$EventEmitte) {
  _inherits(SelfUpdater, _events_1$EventEmitte);
  var _super2 = _createSuper(SelfUpdater);
  /**
   * Create a SelfUpdater
   *
   * @param {string} selfUpdateUrl - The base URL for the root of updates.
   * @param {ProxyInfo | null} proxyInfo - The proxy information to use.
   */
  function SelfUpdater(selfUpdateUrl, proxyInfo) {
    var _this;
    var platform = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : process.platform;
    var sslVerification = arguments.length > 3 ? arguments[3] : undefined;
    var curlPath = arguments.length > 4 ? arguments[4] : undefined;
    var logger = arguments.length > 5 ? arguments[5] : undefined;
    _classCallCheck(this, SelfUpdater);
    _this = _super2.call(this);
    _this.selfUpdateUrl = selfUpdateUrl;
    _this.proxyInfo = proxyInfo;
    _this.latestFileName = platform === 'darwin' ? 'latest-mac.yml' : 'latest.yml';
    _this.latestInfo = null;
    _this.sslVerification = sslVerification;
    _this.curlPath = curlPath;
    _this.logger = logger;
    return _this;
  }
  /**
   * Gets the latest version information
   *
   * Get the latest YML file from online and returns its parsed contents. Will return any errors
   * if the YML is invalid and cannot be parsed.
   *
   * @returns {Promise<LatestInfo>} - A promise for the latest update information.
   */
  _createClass(SelfUpdater, [{
    key: "getLatestVersionInfo",
    value: function getLatestVersionInfo() {
      var _this2 = this;
      var ymlFileUrl = '';
      if (this.selfUpdateUrl.endsWith('/')) {
        ymlFileUrl = "".concat(this.selfUpdateUrl).concat(this.latestFileName);
      } else {
        ymlFileUrl = "".concat(this.selfUpdateUrl, "/").concat(this.latestFileName);
      }
      return this.getFileAsString(ymlFileUrl).then(function (rawYaml) {
        try {
          // Parse body as YAML and return
          var item = yaml.load(rawYaml);
          if (isLatestInfo(item)) {
            _this2.latestInfo = item;
            return Promise.resolve(item);
          }
          return Promise.reject(new SelfUpdaterError('Latest YML is not in the correct format', enums_1.ErrorTypes.invalidLatestYml, {
            item: item
          }));
        } catch (error) {
          return Promise.reject(error);
        }
      });
    }
  }, {
    key: "downloadUpdater",
    value: function downloadUpdater(destination) {
      var _this3 = this;
      if (!this.latestInfo) {
        throw new SelfUpdaterError('Latest Info is Null', enums_1.ErrorTypes.invalidLatestYml);
      }
      var selfUpdateUrl = this.selfUpdateUrl;
      if (!this.selfUpdateUrl.endsWith('/')) {
        selfUpdateUrl = "".concat(selfUpdateUrl, "/");
      }
      var downloadUrl = "".concat(selfUpdateUrl).concat(encodeURIComponent(this.latestInfo.path));
      this.emit('download-url', downloadUrl);
      var downloader = new downloader_1["default"]('', 0, '', this.sslVerification, this.curlPath, this.logger, this.proxyInfo);
      var finalPath = path.join(destination, this.latestInfo.path);
      downloader.on('download-progress', function (progress) {
        _this3.emit('download-progress', progress);
      });
      downloader.downloadSingleFileCurl(downloadUrl, '', finalPath, false, 0).then(function () {
        _this3.emit('downloaded-update', finalPath);
      })["catch"](function (error) {
        _this3.emit('error', error);
      });
      return this;
    }
    /**
     * Downloads a text file and returns its contents as a string
     *
     * Assumes a utf-8 encoding and fails on any request errors or non 2XX status codes.
     *
     * @param {string} uri - The full URL to get the body of.
     *
     * @returns {Promise<string>} - A promise for the full body of the contents at uri.
     */
  }, {
    key: "getFileAsString",
    value: function getFileAsString(uri) {
      var _this4 = this;
      return new Promise(function (resolve, reject) {
        Request.get({
          uri: uri,
          encoding: 'utf8',
          proxy: _this4.proxyInfo ? _this4.proxyInfo.getProxyUrl() : null,
          headers: {
            'Proxy-Authorization': _this4.proxyInfo ? _this4.proxyInfo.getAuthentication() : null
          },
          timeout: 1000 * 60 // If this request takes more than 60 seconds something is wrong.
        }, function (error, response) {
          if (error) {
            return reject(new SelfUpdaterError("An error has occurred fetching ".concat(uri), enums_1.ErrorTypes.updaterUpdateError, {
              error: error
            }));
          }
          if (response.statusCode < 200 || response.statusCode > 299) {
            reject(new SelfUpdaterError("Got a non-2XX (".concat(response.statusCode, ") status code downloading ").concat(uri), enums_1.ErrorTypes.updaterUpdateError));
          }
          return resolve(response.body);
        });
      });
    }
  }]);
  return SelfUpdater;
}(events_1.EventEmitter);
exports.SelfUpdater = SelfUpdater;
exports["default"] = SelfUpdater;

/***/ }),

/***/ 81687:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.cliTransformHook = void 0;
var cliTransformHook = function cliTransformHook(versionInfo, licenseInfo, locationInfo) {
  return Promise.resolve([versionInfo, licenseInfo, locationInfo]);
};
exports.cliTransformHook = cliTransformHook;

/***/ }),

/***/ 53212:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var updater_1 = __importDefault(__webpack_require__(77681));
var enums_1 = __webpack_require__(38261);
var getLogger_1 = __importDefault(__webpack_require__(14449));
var stubUtility_1 = __importDefault(__webpack_require__(45954));
/*
 * Creates and returns an Updater object.
 * Also creates a logger and wires it up
 */
var createUpdater = function createUpdater(rootUrl, fileSource,
// empty if none. Otherwise the location of a .vwim file to use.
sslVerification, curlPath, proxyInfo) {
  var _silent = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
  var logger = (0, getLogger_1["default"])();
  var updater = new updater_1["default"](rootUrl, fileSource, sslVerification, logger, curlPath, proxyInfo);
  updater.setDownloadRetryCount(20); // A default retry count which is high but not unlimited.
  updater.on('error', function (error) {
    logger.error('An error has occurred in Updater', {
      error: error
    });
  }).on('done', function () {
    logger.info('Updater is done (done emitted)');
    // FIX - possibly copy the log over to maindir here.
  }).on('success', function () {
    logger.info('Updater ran its job successfully (success emitted).');
  }).on('fetching-update-info', function (uri) {
    logger.info("Fetching update info from ".concat(uri));
  }).on('cancelled', function () {
    logger.info('Updater cancellation completed successfully');
  }).on('start-process', function (data) {
    var stepName = data.stepName;
    logger.info("Updater is starting process \"".concat(stepName, "\""), data);
  }).on('start-step', function (step) {
    logger.info("Updater is starting step \"".concat(step, "\""));
  }).on('cancel-disabled', function () {
    logger.info('Updater no longer allowing cancel');
  }).on('cancel-requested', function () {
    logger.info('A request has been made to cancel updating');
  }).on('cancelling', function () {
    logger.info('Updater is cancelling its operation');
  }).on('cancel-denied', function () {
    logger.info('Updater has denied the cancel request');
  }).on('created-staging-dir', function (directory) {
    logger.info("Creating a staging directory at \"".concat(directory, "\""));
  }).on('updating-file', function (file) {
    switch (file.operation) {
      case enums_1.FileOperations.added:
        logger.info("OP ".concat(file.opIdentifier, ": Adding \"").concat(file.downloadedFilePath, "\" to \"").concat(file.filePath, "\""));
        break;
      case enums_1.FileOperations.changed:
        logger.info("OP ".concat(file.opIdentifier, ": Changing \"").concat(file.downloadedFilePath, "\" to \"").concat(file.filePath, "\""));
        break;
      case enums_1.FileOperations.deleted:
        logger.info("OP ".concat(file.opIdentifier, ": Deleting \"").concat(file.filePath, "\""));
        break;
      case enums_1.FileOperations.renamed:
        logger.info("OP ".concat(file.opIdentifier, ": Renaming \"").concat(file.filePath, "\" to \"").concat(file.newPath, "\""));
        break;
      case enums_1.FileOperations["volatile"]:
        logger.info("OP ".concat(file.opIdentifier, ": Resetting volatile file \"").concat(file.downloadedFilePath, "\" to \"").concat(file.filePath, "\""));
        break;
    }
  }).on('linking-file', function (file) {
    logger.info("OP ".concat(file.opIdentifier, ": Linking ").concat(file.to, " to ").concat(file.filePath));
  }).on('updated-file', function (file) {
    logger.info("OP ".concat(file.opIdentifier, " completed."));
  }).on('remove-empty-dir', function (dir) {
    logger.info('Removing empty dir: ' + dir + '.');
  }).on('updating-complete', function () {
    logger.info('Update operation has completed successfully');
  }).on('swapping-file-names', function (tuple) {
    logger.info("Swapping files \"".concat(tuple[0].name, "\" and \"").concat(tuple[1].name, "\""));
  }).on('start-zip-downloads', function (zipFiles) {
    logger.info("Downloading ".concat(zipFiles.length, " zip files"));
  }).on('found-files', function (files) {
    logger.info("Found-files found ".concat(files.length, " to download"));
  }).on('cleaning-downloads', function () {
    logger.info('Cleaning up temporary files');
  }).on('downloads-complete', function () {
    logger.info('Downloads have been completed');
  }).on('downloading-file', function (data) {
    logger.info("Downloading file from \"".concat(data.from, "\" to \"").concat(data.dest, "\""));
  }).on('file-downloaded', function (data) {
    logger.info("File downloaded to \"".concat(data, "\""));
  }).on('extracting-zip', function (data) {
    logger.info("Extracting zip from \"".concat(data.from, "\" to \"").concat(data.dest, "\". Expected hash: ").concat(data.expectedHash));
  }).on('zip-extracted', function (file) {
    logger.info("Extracted \"".concat(file.targetName, "\" to \"").concat(file.path, "\""));
  })
  // Packaging update specific
  .on('package-progress', function (data) {
    var entryStr = "".concat(data.entries.processed, "/").concat(data.entries.total);
    var byteStr = "".concat(data.fs.processedBytes, "/").concat(data.fs.totalBytes);
    logger.info("Package update processed (".concat(entryStr, ") files, (").concat(byteStr, ") bytes"));
  })
  // Update from Offline Update specific
  .on('extracting-file', function (fileName) {
    logger.info("Extracting ".concat(fileName, " from offline update"));
  }).on('files-to-extract', function (count) {
    logger.info("There are ".concat(count, " files to extract from the offline update"));
  }).on('all-files-extracted', function () {
    logger.info('Offline update extraction complete');
  })
  // Repair specific
  .on('checking-file', function (file) {
    logger.info("Checking \"".concat(file.filePath, "\", expecting md5 \"").concat(file.expectedMd5, "\""));
  }).on('file-checked', function (file) {
    if (file.needsRepair) {
      logger.info("Hash mismatch: \"".concat(file.fileInfo.name, "\". Expected: \"").concat(file.fileInfo.md5, "\", Found: \"").concat(file.fileInfo.foundMd5, "\""));
    }
  }).on('blank-update', function () {
    logger.info('Update is blank, busy waiting to fake progress');
  }).on('files-to-repair', function (files) {
    logger.info("Updater found ".concat(files.length, " files to repair"));
  }).on('retrying-file', function (url, numRetries, maxRetries, error) {
    logger.warn("Retrying to download ".concat(url, " (").concat(numRetries, "/").concat(maxRetries, ")"), {
      error: error
    });
  }).on('error-after-download', function (data) {
    logger.warn('A RequestError has occurred AFTER a file has downloaded', data);
  }).on('checking-extra-files', function () {
    logger.info('Repair has started checking for extraneous files');
  }).on('removing-item', function (params) {
    logger.info('Found extra item to remove', params);
  }).on('repair-stub', function (_ref) {
    var versionInfo = _ref.versionInfo,
      beforeRepair = _ref.beforeRepair;
    if (beforeRepair) {
      stubUtility_1["default"].beforeRepairStub(versionInfo, logger);
    } else {
      stubUtility_1["default"].afterRepairStub(versionInfo, logger);
    }
  }).on('update-stub', function (_ref2) {
    var versionInfo = _ref2.versionInfo,
      beforeUpdate = _ref2.beforeUpdate;
    if (beforeUpdate) {
      stubUtility_1["default"].beforeUpdateStub(versionInfo, logger);
    } else {
      stubUtility_1["default"].afterUpdateStub(versionInfo, logger);
    }
  }).on('run-stub', function () {
    stubUtility_1["default"].runStub(logger);
  });
  return updater;
};
exports["default"] = createUpdater;

/***/ }),

/***/ 68717:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var sprintf_js_1 = __webpack_require__(8975);
var path_1 = __webpack_require__(71017);
var enums_1 = __webpack_require__(38261);
var formatString = function formatString(error, format) {
  switch (error.type) {
    case enums_1.ErrorTypes.downloadHttpResponseError:
      return (0, sprintf_js_1.sprintf)(format, (0, path_1.basename)(error.target));
    case enums_1.ErrorTypes.downloadHttpRequestError:
      return (0, sprintf_js_1.sprintf)(format, (0, path_1.basename)(error.target));
    case enums_1.ErrorTypes.downloadHttpWriteStreamError:
      return (0, sprintf_js_1.sprintf)(format, (0, path_1.basename)(error.target));
    case enums_1.ErrorTypes.zipExtractionError:
      return (0, sprintf_js_1.sprintf)(format, error.zipName);
    case enums_1.ErrorTypes.versionMismatch:
      return (0, sprintf_js_1.sprintf)(format, error.install.major, error.install.minor, error.install.changelist, error.from.major, error.from.minor, error.from.changelist);
    default:
      return format;
  }
};
exports["default"] = formatString;

/***/ }),

/***/ 14449:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createSink = exports.createLogger = void 0;
var fs = __importStar(__webpack_require__(55674));
var getSettings_1 = __importDefault(__webpack_require__(82143));
var LoggerLib = __importStar(__webpack_require__(70181));
var theRealLogger;
var createLogger = function createLogger() {
  var newLogger = new LoggerLib.Logger();
  var updaterFileSink = new LoggerLib.FileTransport({
    filePath: (0, getSettings_1["default"])().logFilePath,
    formatter: LoggerLib.logFileFormat,
    level: LoggerLib.LogLevels.info,
    name: LoggerLib.LogFileSinks.main,
    silent: LoggerLib.disableLogging,
    parentLogger: newLogger
  });
  var stdoutSink = new LoggerLib.StdoutTransport({
    formatter: LoggerLib.stdoutFormat,
    level: LoggerLib.LogLevels.stdout,
    name: LoggerLib.LogFileSinks.cli,
    silent: LoggerLib.disableLogging,
    parentLogger: newLogger
  });
  newLogger.add(updaterFileSink, ['ready']);
  newLogger.add(stdoutSink);
  if (false) {}
  return newLogger;
};
exports.createLogger = createLogger;
var getLogger = function getLogger() {
  if (theRealLogger) {
    return theRealLogger;
  }
  theRealLogger = createLogger();
  theRealLogger.on('error', function (error, transport) {
    // Write this as sync to prevent any errors, this error needs to be logged
    if (transport) {
      var didOpenFail = transport.didOpenFail();
      if (didOpenFail) {
        theRealLogger.remove(transport.name);
      }
      try {
        var errorMsg = "An error has occurred writing a log in ".concat(transport.name, "\ndidOpenFail=").concat(didOpenFail, "\n").concat(error.stack);
        fs.writeFileSync((0, getSettings_1["default"])().logFailureLogFilePath, errorMsg, {
          encoding: 'utf8'
        });
      } catch (_error) {
        // This is bad
      }
    } else {
      try {
        var _errorMsg = "An error has occurred writing a log - no transport\n".concat(error.stack);
        fs.writeFileSync((0, getSettings_1["default"])().logFailureLogFilePath, _errorMsg, {
          encoding: 'utf8'
        });
      } catch (_error) {
        // This is bad
      }
    }
  });
  return theRealLogger;
};
// Export this so we can create this in the installation directory
var createSink = LoggerLib.createSink;
exports.createSink = createSink;
exports["default"] = getLogger;

/***/ }),

/***/ 74641:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.exitCli = exports.getProxyInfo = void 0;
var getSettings_1 = __importDefault(__webpack_require__(82143));
var getLogger_1 = __importDefault(__webpack_require__(14449));
var index_1 = __importDefault(__webpack_require__(20254));
var debug = __webpack_require__(15158)('main-process-utils');
var getProxyInfo = function getProxyInfo() {
  var proxyPath = process.platform === 'win32' ? (0, getSettings_1["default"])().winProxyPath : (0, getSettings_1["default"])().macProxyPath;
  var proxyInfoError = null;
  var proxyInfo = null;
  var proxyToolPath = (0, getSettings_1["default"])().proxyToolPath;
  try {
    proxyInfo = (0, index_1["default"])(proxyPath, true, proxyToolPath);
  } catch (error) {
    proxyInfoError = error;
  }
  return {
    proxyInfo: proxyInfo,
    proxyInfoError: proxyInfoError
  };
};
exports.getProxyInfo = getProxyInfo;
var exitCli = function exitCli(code) {
  // Compiler is being stupid and thinks eos just is not correct even though it is, hence the any.
  debug('Exit CLI called');
  (0, getLogger_1["default"])().once('finish', function () {
    // Make sure streams get a chance to flush 100% by delaying a few miliseconds.
    setTimeout(function () {
      process.exit(code);
    }, 100);
  });
  (0, getLogger_1["default"])().info("exitCLI called with code ".concat(code));
  (0, getLogger_1["default"])().end();
};
exports.exitCli = exitCli;

/***/ }),

/***/ 97559:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, defineProperty = Object.defineProperty || function (obj, key, desc) { obj[key] = desc.value; }, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return defineProperty(generator, "_invoke", { value: makeInvokeMethod(innerFn, self, context) }), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; defineProperty(this, "_invoke", { value: function value(method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; } function maybeInvokeDelegate(delegate, context) { var methodName = context.method, method = delegate.iterator[methodName]; if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel; var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), defineProperty(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (val) { var object = Object(val), keys = []; for (var key in object) keys.push(key); return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __awaiter = this && this.__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }
  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.preOperation = exports.postApply = exports.preApply = void 0;
var path = __importStar(__webpack_require__(71017));
var fs = __importStar(__webpack_require__(55674));
var enums_1 = __webpack_require__(38261);
var types_1 = __webpack_require__(45627);
var getLogger_1 = __importDefault(__webpack_require__(14449));
// Before applying the update/repair/etc, run this, which:
// Deregister dll's that are indicated in deregisterDlls (settings) so they can be hopefully overwritten if needed.
// Saves important preferences to a global: gXmlPrefs, in preparation to be restored in postApply.
//
var preApply = function preApply(_params) {
  return Promise.all([]).then(function () {
    return Promise.resolve();
  })["catch"](function () {
    return Promise.resolve();
  });
};
exports.preApply = preApply;
var makeAppExecutable = function makeAppExecutable(params) {
  if (process.platform !== 'darwin') {
    return Promise.resolve();
  }
  var macExecutableName = params.versionInfo.macExecutableName;
  var installDir = (0, types_1.getLocationData)(enums_1.MAIN_DIR, params.locationInfo).locationPath;
  if (!macExecutableName) {
    (0, getLogger_1["default"])().warn('No mac executable name, cannnot make the app executable');
    return Promise.resolve();
  }
  var pathToAddExecutableBit = path.join(installDir, macExecutableName);
  (0, getLogger_1["default"])().info("Calling chmod on \"".concat(pathToAddExecutableBit, "\" to 755"));
  return fs.chmod(pathToAddExecutableBit, 493).then(function () {
    (0, getLogger_1["default"])().info('Set file permissions');
    return Promise.resolve();
  })["catch"](function (error) {
    (0, getLogger_1["default"])().error('An error has occurred attempting to set the executable bit', {
      error: error,
      pathToAddExecutableBit: pathToAddExecutableBit
    });
    return Promise.resolve();
  });
};
// After the repair/update/install, this runs and:
// registers dll's based on deregisterDlls in settings
// restores the XML preferences saved in preApply.
// Ensures the application is executable
// 
var postApply = function postApply(params) {
  var promiseArray = [];
  var logger = (0, getLogger_1["default"])();
  logger.info("postApply(".concat(params.operation, ") - Starting..."));
  if (params.operation === 'install') {
    promiseArray.push(makeAppExecutable(params));
  } else {
    promiseArray.push(makeAppExecutable(params));
  }
  return Promise.all(promiseArray).then(function () {
    return Promise.resolve();
  });
};
exports.postApply = postApply;
// Run before the operation, ie, before repair, update, etc even starts
// This function:
// Ensures the user can write to the commondir.
//
var preOperation = function preOperation(params) {
  return __awaiter(void 0, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
    var logger;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          logger = (0, getLogger_1["default"])();
          logger.info("preOperation(".concat(params.operation, ") - Starting..."));
          return _context.abrupt("return", Promise.resolve());
        case 3:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
};
exports.preOperation = preOperation;

/***/ }),

/***/ 2228:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


/**
 * Contains a class used to run, close, and communicate with the VWIMHelper utility
 */
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.VWIMHelperRunner = void 0;
var sudo_prompt_vw_1 = __importDefault(__webpack_require__(35637));
var path = __importStar(__webpack_require__(71017));
var fs = __importStar(__webpack_require__(55674));
var childProcess = __importStar(__webpack_require__(32081));
var events_1 = __webpack_require__(82361);
var VWIMHelperRunner = /*#__PURE__*/function (_events_1$EventEmitte) {
  _inherits(VWIMHelperRunner, _events_1$EventEmitte);
  var _super = _createSuper(VWIMHelperRunner);
  /**
   * Create the class
   *
   * @param {string} VWIMHelperPath - The path to should install.
   * @param {string} VWIMHelperCommRoot - The root dir for a folder used to communicate with this process
   * @param {number} VWIMHelperElectronMainPID - The electron app's pid. The helper scans for this to self-shutdown if electron does.
   * @param {LoggerLib.Logger} logger - A logger object
   */
  function VWIMHelperRunner(VWIMHelperPath, VWIMHelperCommRoot, logger, VWIMHelperElectronMainPID, launchType, copyToComm) {
    var _this;
    _classCallCheck(this, VWIMHelperRunner);
    _this = _super.call(this);
    _this.OriginalVWIMHelperPath = VWIMHelperPath;
    _this.copiedToComm = copyToComm;
    if (copyToComm) {
      _this.VWIMHelperPath = path.join(VWIMHelperCommRoot, path.basename(VWIMHelperPath));
      fs.copyFileSync(_this.OriginalVWIMHelperPath, _this.VWIMHelperPath);
    } else {
      _this.VWIMHelperPath = _this.OriginalVWIMHelperPath;
    }
    _this.VWIMHelperCommRoot = VWIMHelperCommRoot;
    _this.VWIMHelperElectronMainPID = VWIMHelperElectronMainPID;
    _this.logger = logger;
    _this.nextVWCmd = 1; // The tool expects 1 to be the first one.
    _this.launchType = launchType;
    _this.logger.info('VWIMHelperRunner - constructor');
    _this.logNameAdmin = 'VWIMLog.txt';
    _this.logNameUser = 'VWIMLog.txt'; // FIX - handle admin vs user logs.
    return _this;
  }
  _createClass(VWIMHelperRunner, [{
    key: "logInfo",
    value: function logInfo(msg) {
      if (this.logger !== null) {
        this.logger.info(msg);
      }
    }
    // Returns {cmdFilePath, sigFilePath, finFilePath, commandNum }
    //
  }, {
    key: "allocateCommFile",
    value: function allocateCommFile() {
      var commandNum = this.nextVWCmd;
      this.nextVWCmd += 1;
      var cmdFilePath = path.join(this.VWIMHelperCommRoot, "VWCmd".concat(commandNum, ".txt"));
      var sigFilePath = path.join(this.VWIMHelperCommRoot, "VWCmd".concat(commandNum, ".vwsig"));
      var progressFilePath = path.join(this.VWIMHelperCommRoot, "VWCmd".concat(commandNum, ".progress"));
      var finFilePath = path.join(this.VWIMHelperCommRoot, "VWCmd".concat(commandNum, ".vwfin"));
      var errFilePath = path.join(this.VWIMHelperCommRoot, "VWCmd".concat(commandNum, ".err"));
      return {
        commandNum: commandNum,
        cmdFilePath: cmdFilePath,
        sigFilePath: sigFilePath,
        progressFilePath: progressFilePath,
        errFilePath: errFilePath,
        finFilePath: finFilePath
      };
    }
  }, {
    key: "waitForFinFile",
    value: function waitForFinFile(finFilePath, progressFilePath, timeoutMS) {
      var _this2 = this;
      this.logger.info("VWIMHelper-runner: waiting for Fin File.");
      return new Promise(function (resolve, reject) {
        var timeoutHandler = function timeoutHandler() {
          _this2.logger.info("VWIMHelper-runner: timeout.");
          watcher.close();
          reject(new Error("File did not exist and was not created during the timeout: ".concat(finFilePath, ".")));
        };
        var timer = setTimeout(timeoutHandler, timeoutMS);
        fs.access(finFilePath, fs.constants.R_OK, function (err) {
          if (!err) {
            _this2.logger.info("VWIMHelper-runner: found Fin file already.");
            clearTimeout(timer);
            watcher.close();
            resolve();
          }
        });
        var dir = path.dirname(finFilePath);
        var basename = path.basename(finFilePath);
        var progressBasename = path.basename(progressFilePath);
        var watcher = fs.watch(dir, function (eventType, filename) {
          if (eventType === 'rename' && filename === basename) {
            _this2.logger.info("VWIMHelper-runner: found Fin file.");
            clearTimeout(timer);
            watcher.close();
            resolve();
          } else if ((eventType === 'rename' || eventType === 'change') && filename === progressBasename) {
            try {
              // Reset the timeout since we know it's still working...
              clearTimeout(timer);
              timer = setTimeout(timeoutHandler, timeoutMS);
              // Attempt to read the % and if successful, emit a progress event.
              var contents = fs.readFileSync(progressFilePath, 'utf-8');
              if (contents.includes('%')) {
                // We check for this to make sure we had a completed file written
                var progress = parseInt(contents);
                _this2.emit('helper-progress', {
                  percentage: progress
                });
                _this2.logger.info("VWIMHelper-runner: Got progress value of ".concat(progress));
              } else {
                _this2.logger.info("VWIMHelper-runner: Got unknown string: ".concat(contents));
              }
            } catch (_a) {
              _this2.logger.info("VWIMHelper-runner: Exception reading or parsing progress file.");
            } // Just ignore, we'll get it next time (this might happen on bad timing)
          } else {
            if (eventType !== 'rename' && eventType !== 'change') {
              // Log this unknown event, but ignore changes to other files we don't care about.
              _this2.logger.info("VWIMHelper-runner: Got unknown event: ".concat(eventType, " for ").concat(filename));
            }
          }
        });
      });
    }
    // Signals that helper that command file is ready to process
  }, {
    key: "signalReady",
    value: function signalReady(sigFilePath) {
      fs.writeFileSync(sigFilePath, "Ready\n");
    }
    // Writes an exit command file and waits for fin file.
  }, {
    key: "closeHelper",
    value: function closeHelper() {
      this.logger.info("VWIMHelperRunner::closeHelper() - Starting.");
      var _this$allocateCommFil = this.allocateCommFile(),
        cmdFilePath = _this$allocateCommFil.cmdFilePath,
        sigFilePath = _this$allocateCommFil.sigFilePath,
        progressFilePath = _this$allocateCommFil.progressFilePath,
        finFilePath = _this$allocateCommFil.finFilePath;
      this.logger.info("VWIMHelperRunner::closeHelper() - Comm file allocated. cmdFilePath at: ".concat(cmdFilePath, "."));
      fs.writeFileSync(cmdFilePath, "exit\n");
      this.signalReady(sigFilePath);
      this.logger.info("VWIMHelperRunner::closeHelper() - Waiting for fin file at: ".concat(finFilePath));
      return this.waitForFinFile(finFilePath, progressFilePath, 1000 * 60 * 15);
    }
    /**
     * Runs VWIMHelper
     *
     * Does not return any value, so this is kind of a "Fire and forget" style run, not recommended
     *
     */
  }, {
    key: "runVWIMHelper",
    value: function runVWIMHelper() {
      var _this3 = this;
      this.logInfo("VWIMHelperRunner() - running VWIMHelper at: ".concat(this.VWIMHelperPath));
      if (this.launchType === 'admin' || this.launchType === 'both') {
        var command = "\"".concat(this.VWIMHelperPath, "\" -p ").concat(this.VWIMHelperElectronMainPID, " -c \"").concat(this.VWIMHelperCommRoot, "\"");
        this.logger.info("Starting VWIMHelper (admin) with: ".concat(command));
        var options = {
          name: "Vectorworks Install Manager",
          // noClean: true, // Uncomment to not clean up the folder when done (for testing/debugging)
          logger: this.logger
        };
        sudo_prompt_vw_1["default"].exec(command, options, function (_error, stdout, stderr) {
          _this3.logger.info("Command ".concat(command, " completed with:\nstdout: ").concat(stdout, "\nstderr: ").concat(stderr));
        });
      }
      if (this.launchType === 'user' || this.launchType === 'both') {
        var _command = "".concat(this.VWIMHelperPath);
        var args = ['-p', "".concat(this.VWIMHelperElectronMainPID), '-c', "".concat(this.VWIMHelperCommRoot)];
        this.logger.info("Starting VWIMHelper (user) with: ".concat(_command, " [").concat(args, "]"));
        childProcess.execFile(_command, args, function (_error, stdout, stderr) {
          _this3.logger.info("Command ".concat(_command, " completed with:\nstdout: ").concat(stdout, "\nstderr: ").concat(stderr));
        });
      }
    }
    // Waits timeout_in_seconds for a file to exist.
    // Checks for the file every second.
    // Returns a promise that resolves to true if the file exists, false if it does not within the timeout period.
    //
  }, {
    key: "checkExistsWithTimeout",
    value: function checkExistsWithTimeout(filePath, timeout_in_seconds) {
      var _this4 = this;
      this.logger.info("checkExistsWithTimeout() - Checking for file at: ".concat(filePath));
      return new Promise(function (resolve, _reject) {
        // Do a quick first check to see if the file already exists using existsSync...
        try {
          if (fs.existsSync(filePath)) {
            _this4.logger.info("checkExistsWithTimeout() - Instantly found file at: ".concat(filePath));
            resolve(true);
          } else {
            _this4.logger.info("checkExistsWithTimeout() - File did not instantly exist at: ".concat(filePath));
          }
        } catch (_a) {
          _this4.logger.info("checkExistsWithTimeout() - Exception on immediate check for file at: ".concat(filePath));
          // Do nothing, we'll poll for it.
        }
        // Poll for the file to exist...
        var totalTime = 0;
        var timer = setInterval(function () {
          try {
            if (fs.existsSync(filePath)) {
              _this4.logger.info("checkExistsWithTimeout() - Found file at: ".concat(filePath));
              clearInterval(timer);
              resolve(true);
            } else {
              _this4.logger.info("checkExistsWithTimeout() - File did not yet exist at: ".concat(filePath));
            }
          } catch (_a) {
            _this4.logger.info("checkExistsWithTimeout() - Exception on interval check for file at: ".concat(filePath));
            // Do nothing, we'll keep polling
          }

          totalTime += 1;
          if (totalTime >= timeout_in_seconds) {
            _this4.logger.info("checkExistsWithTimeout() - Timeout (".concat(timeout_in_seconds, " reached waiting for file: ").concat(filePath));
            clearInterval(timer);
            resolve(false);
          }
        }, 1000); // (SetInterval call every 1 second)
      });
    }
    /**
     * Runs VWIMHelper
     * Returns success/fail to launch in a promise, so we can wait for it
     * This is determined by looking for the log file created when VWIM launches.
     * @return {Promise<boolean>} - A promise for a boolean, true if successfully launched, false if not.
     */
  }, {
    key: "runVWIMHelperWithConfirmationAdmin",
    value: function runVWIMHelperWithConfirmationAdmin() {
      var _this5 = this;
      var processFinished = false;
      this.logInfo("runVWIMHelperWithConfirmationAdmin() - running VWIMHelper with confirmation at: ".concat(this.VWIMHelperPath));
      var command = "\"".concat(this.VWIMHelperPath, "\" -p ").concat(this.VWIMHelperElectronMainPID, " -c \"").concat(this.VWIMHelperCommRoot, "\"");
      this.logInfo("runVWIMHelperWithConfirmationAdmin() - Starting VWIMHelper with: ".concat(command));
      var options = {
        name: "Vectorworks Install Manager",
        // noClean: true, // Uncomment to not clean up the folder when done (for testing/debugging)
        logger: this.logger
      };
      sudo_prompt_vw_1["default"].exec(command, options, function (_error, stdout, stderr) {
        _this5.logInfo("runVWIMHelperWithConfirmationAdmin() - Command ".concat(command, " completed with:\nstdout: ").concat(stdout, "\nstderr: ").concat(stderr));
        processFinished = true;
      });
      // Wait for log file or processFinished.
      var waitForProcessEnd = new Promise(function (resolve, _reject) {
        (function waitForFoo() {
          if (processFinished) {
            return resolve(false);
          }
          setTimeout(waitForFoo, 100);
        })();
      });
      return Promise.race([this.checkExistsWithTimeout(path.join(this.VWIMHelperCommRoot, this.logNameAdmin), 120), waitForProcessEnd // returns false when it happens
      ]);
    }
    /**
     * Runs VWIMHelper
     * Returns success/fail to launch in a promise, so we can wait for it
     * This is determined by looking for the log file created when VWIM launches.
     * @return {Promise<boolean>} - A promise for a boolean, true if successfully launched, false if not.
     */
  }, {
    key: "runVWIMHelperWithConfirmationUser",
    value: function runVWIMHelperWithConfirmationUser(argumentsIn) {
      var _this6 = this;
      var processFinished = false;
      this.logInfo("runVWIMHelperWithConfirmationUser() - running VWIMHelper with confirmation at: ".concat(this.VWIMHelperPath));
      var command = "".concat(this.VWIMHelperPath);
      var args = [];
      if (argumentsIn !== undefined) {
        args = argumentsIn;
      } else {
        args = ['-p', "".concat(this.VWIMHelperElectronMainPID), '-c', "".concat(this.VWIMHelperCommRoot)];
      }
      this.logInfo("runVWIMHelperWithConfirmationUser() - Starting VWIMHelper with: ".concat(command, " [").concat(args, "]"));
      childProcess.execFile(command, args, function (_error, stdout, stderr) {
        _this6.logInfo("runVWIMHelperWithConfirmationUser() - Command ".concat(command, " [").concat(args, "] completed with:\nstdout: ").concat(stdout, "\nstderr: ").concat(stderr));
        processFinished = true;
      });
      // Wait for log file or processFinished.
      var waitForProcessEnd = new Promise(function (resolve, _reject) {
        (function waitForFoo() {
          if (processFinished) {
            return resolve(false);
          }
          setTimeout(waitForFoo, 100);
        })();
      });
      return Promise.race([this.checkExistsWithTimeout(path.join(this.VWIMHelperCommRoot, this.logNameUser), 120), waitForProcessEnd // returns false when it happens
      ]);
    }
    // Runs admin, user, or both VWIMHelper processes.
  }, {
    key: "runVWIMHelperWithConfirmation",
    value: function runVWIMHelperWithConfirmation(argumentsIn) {
      var adminRun = Promise.resolve(true);
      var userRun = Promise.resolve(true);
      var forceUser = false;
      if (process.platform === 'darwin' && process.getuid && process.getuid() === 0) {
        // run as root on Mac - no need for admin. Typically this is a cli run with sudo.
        this.logInfo("runVWIMHelperWithConfirmation() - Forcing User run due to running as root.");
        forceUser = true;
      }
      if (this.launchType === 'admin' && !forceUser || this.launchType === 'both') {
        adminRun = this.runVWIMHelperWithConfirmationAdmin();
      }
      if (this.launchType === 'user' || forceUser || this.launchType === 'both') {
        userRun = this.runVWIMHelperWithConfirmationUser(argumentsIn);
      }
      return Promise.all([adminRun, userRun]).then(function (result) {
        var finalResult = result[0] && result[1];
        return Promise.resolve(finalResult);
      });
    }
  }]);
  return VWIMHelperRunner;
}(events_1.EventEmitter);
exports.VWIMHelperRunner = VWIMHelperRunner;

/***/ }),

/***/ 19739:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DocumentTypeGetter = void 0;
/**
 * Contains a class used to validate a serial number against the should install binary.
 *
 * Also contains tools to run serial finder.
 */
var shouldinstall_runner_1 = __webpack_require__(18772);
var enums_1 = __webpack_require__(38261);
var errors_1 = __webpack_require__(94515);
/**
 * Translate the output from ShouldInstall's eula command to a EulaType
 *
 * @param {string} input - The output from ShouldInstall's eula command.
 *
 * @return {EulaType | null} - The corresponding EulaType or null if not found.
 */
var translateEula = function translateEula(input) {
  switch (input.toLowerCase()) {
    case 'student':
      return enums_1.EulaTypes.educational;
    case 'professional':
      return enums_1.EulaTypes.professional;
    case 'nfr':
      return enums_1.EulaTypes.nfr;
    case 'eval':
      return enums_1.EulaTypes.eval;
    case 'beta':
      return enums_1.EulaTypes.nfr;
    case 'development':
      return enums_1.EulaTypes.nfr;
    default:
      return null;
  }
};
/**
 * A class that will handle determining which document to show, for readme and eula.
 *
 */
var DocumentTypeGetter = /*#__PURE__*/function () {
  /**
   * Create a new document getter
   *
   * @param {string} shouldInstallPath - The path to should install.
   * @param {boolean} allowBlank - To allow blank serials or not.
   * @param {LoggerLib.Logger} logger - for logging
   */
  function DocumentTypeGetter(shouldInstallPath, allowBlank, logger) {
    _classCallCheck(this, DocumentTypeGetter);
    this.shouldInstallPath = shouldInstallPath;
    this.logger = logger;
    this.allowBlank = allowBlank;
  }
  /**
   * Typeguard to check output is a EulaType
   *
   * @static
   * @param {unknown} toTest- The item to test.
   *
   * @returns {boolean} - true if toTest is a EulaTypes, false otherwise.
   */
  _createClass(DocumentTypeGetter, [{
    key: "getReadMeType",
    value:
    /**
     * Gets readme type.
     * This needs to work the same as ShouldInstall's vw_readme call because the IB Installer is what ultimately copies the readme into place
     * and that's what it uses.
     *
     * @param {string} serialOrLIS - The serial number or LIS to use
     *
     * @returns {Promise<ReadMeTypes>} - A promise for the ReadMeTypes value associated with the
     * serial.
     */
    function getReadMeType(serialOrLIS) {
      var _this = this;
      this.logger.info("DocumentTypeGetter::getReadMeType() - Getting ReadMe from input: ".concat(serialOrLIS, "."));
      if (serialOrLIS === '') {
        // As a default show the generic readme...
        this.logger.info("DocumentTypeGetter::getReadMeType() - Using default generic readme.");
        return Promise.resolve(enums_1.ReadMeTypes.generic);
      }
      var args = [serialOrLIS.trim(), 'VW_readme'];
      var shouldInstallRunner = new shouldinstall_runner_1.ShouldInstallRunner(this.shouldInstallPath, this.logger);
      return shouldInstallRunner.runShouldInstall(args).then(function (output) {
        var stdout = output.stdout.trim();
        if (DocumentTypeGetter.isReadMeType(stdout)) {
          _this.logger.info("DocumentTypeGetter::getReadMeType() - Returning ReadMe type ".concat(stdout, "."));
          return Promise.resolve(stdout);
        }
        _this.logger.info("DocumentTypeGetter::getReadMeType() - Got unknown stdout ".concat(stdout, ". Returning generic."));
        return Promise.resolve(enums_1.ReadMeTypes.generic);
      });
    }
    /**
     * Gets Eula type by running ShouldInstall
     *
     * @param {string} serialOrLIS - The serial number or LIS to use
     *
     * @returns {Promise<EulaTypes>} - A promise for the EulaTypes value associated with the
     * serial.
     */
  }, {
    key: "getEulaType",
    value: function getEulaType(serialOrLIS) {
      if (this.allowBlank && serialOrLIS.trim().length === 0) {
        return Promise.resolve(enums_1.EulaTypes.professional);
      }
      var args = [serialOrLIS.trim(), 'VW_eula'];
      this.logger.info("DocumentTypeGetter::getReadMeType() - Getting EULA from input: ".concat(serialOrLIS, "."));
      var shouldInstallRunner = new shouldinstall_runner_1.ShouldInstallRunner(this.shouldInstallPath, this.logger);
      return shouldInstallRunner.runShouldInstall(args).then(function (output) {
        var stdout = output.stdout.trim();
        if (!DocumentTypeGetter.isEulaType(stdout)) {
          // Some should installs give different output so key off that
          // Important to note vision does this only
          var translatedEula = translateEula(stdout);
          if (!translatedEula) {
            return Promise.reject(new errors_1.BaseError('The output from getEulaType is invalid', enums_1.ErrorTypes.invalidEulaOutput, {
              args: args,
              stdout: stdout
            }));
          }
          return Promise.resolve(translatedEula);
        }
        return Promise.resolve(stdout);
      });
    }
  }], [{
    key: "isEulaType",
    value: function isEulaType(toTest) {
      if (typeof toTest !== 'string') {
        return false;
      }
      var found = Object.values(enums_1.EulaTypes).find(function (v) {
        return toTest === v;
      });
      return found !== undefined ? true : false;
    }
    /**
     * Typeguard to check output is a ReadMeTypes
     *
     * @static
     * @param {unknown} toTest- The item to test.
     *
     * @returns {boolean} - true if toTest is a ReadMeTypes, false otherwise.
     */
  }, {
    key: "isReadMeType",
    value: function isReadMeType(toTest) {
      if (typeof toTest !== 'string') {
        return false;
      }
      var found = Object.values(enums_1.ReadMeTypes).find(function (v) {
        return toTest === v;
      });
      return found !== undefined ? true : false;
    }
  }]);
  return DocumentTypeGetter;
}();
exports.DocumentTypeGetter = DocumentTypeGetter;

/***/ }),

/***/ 66912:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i["return"] && (_r = _i["return"](), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CancelError = exports.RequestError = void 0;
/*
 * Contains a class used to download files
 */
var events_1 = __webpack_require__(82361);
var fs = __importStar(__webpack_require__(55674));
var yauzl = __importStar(__webpack_require__(57766));
var tmp_1 = __importDefault(__webpack_require__(36276));
var path_1 = __webpack_require__(71017);
var childProcess = __importStar(__webpack_require__(32081));
var concurrent_promise_queue_1 = __webpack_require__(73389);
var md5_file_1 = __importDefault(__webpack_require__(16874));
var rimraf_1 = __webpack_require__(95469);
var enums_1 = __webpack_require__(38261);
var errors_1 = __webpack_require__(94515);
Object.defineProperty(exports, "CancelError", ({
  enumerable: true,
  get: function get() {
    return errors_1.CancelError;
  }
}));
/**
 * An error that occurs when an HTTP request fails
 *
 * @extends {BaseError}
 */
var RequestError = /*#__PURE__*/function (_errors_1$BaseError) {
  _inherits(RequestError, _errors_1$BaseError);
  var _super = _createSuper(RequestError);
  function RequestError() {
    _classCallCheck(this, RequestError);
    return _super.apply(this, arguments);
  }
  return _createClass(RequestError);
}(errors_1.BaseError);
exports.RequestError = RequestError;
/**
 * Get the MD5 of a file before rejecting with an Error
 *
 * @param {string} zipPath - The path to the zip file that failed to open.
 * @param {string} message - The error message.
 * @param {ErrorTypes} errorType - The error type.
 * @params {{ [key: string]: any }} - The parameters to attach.
 *
 * @returns {Promise<void>} - A promise that always rejects with a BaseError, the md5 of the file
 * is attached to the data or -1 if not found.
 */
var rejectExtract = function rejectExtract(zipPath, message, errorType, params) {
  return (0, md5_file_1["default"])(zipPath).then(function (md5) {
    return Promise.reject(new errors_1.BaseError(message, errorType, Object.assign({}, params, {
      md5: md5
    })));
  })["catch"](function (error) {
    if (error instanceof errors_1.BaseError) {
      return Promise.reject(error);
    }
    return Promise.reject(new errors_1.BaseError(message, errorType, Object.assign({}, params, {
      md5: -1
    })));
  });
};
/**
 * Class used to download updater files
 *
 * Emits events as defined in DownloaderEvents
 *
 * @extends {EventEmitter}
 */
var Downloader = /*#__PURE__*/function (_events_1$EventEmitte) {
  _inherits(Downloader, _events_1$EventEmitte);
  var _super2 = _createSuper(Downloader);
  /**
   * Create a new Downloader
   *
   * @param {number} [retryCountLimit=-1] - The maximum number of tries to retry downloading a file.
   * -1 means try forever
   * @param {ProxyInfo | null} proxyInfo - The ProxyInfo used by the downloader, if applicable.
   */
  function Downloader(fileSource) {
    var _this;
    var retryCountLimit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : -1;
    var rootUrl = arguments.length > 2 ? arguments[2] : undefined;
    var sslVerification = arguments.length > 3 ? arguments[3] : undefined;
    var curlPath = arguments.length > 4 ? arguments[4] : undefined;
    var logger = arguments.length > 5 ? arguments[5] : undefined;
    var proxyInfo = arguments.length > 6 ? arguments[6] : undefined;
    _classCallCheck(this, Downloader);
    _this = _super2.call(this);
    /**
     * Creates a temporary directory and returns it's path
     *
     * @returns {Promise<string>} - A promise for the path of the temporary directory
     */
    _this.createTempDirectory = function () {
      _this.logger.info("downloader::createTempDirectory() - Starting.");
      return new Promise(function (resolve, reject) {
        _this.logger.info("downloader::createTempDirectory() - In Promise.");
        var tempPathInfo = process.env['VWIM_TMP_PATH'] || undefined;
        tmp_1["default"].dir({
          unsafeCleanup: true,
          keep: true,
          tmpdir: tempPathInfo
        }, function (error, dirPath) {
          if (error) {
            _this.logger.info("downloader::createTempDirectory() - In Promise - Error.");
            return reject(new errors_1.BaseError('An error has occurred creating a temp directory', enums_1.ErrorTypes.failedCreateStageDir, error));
          }
          _this.logger.info("downloader::createTempDirectory() - dirPath was ".concat(dirPath, "."));
          resolve(dirPath);
          return resolve(dirPath);
        });
      });
    };
    /**
     * Recursively removes a directory, like rm -rf.
     *
     * Handles a strange bug on Windows where EPERM occurs. Windows file system can work in a queue
     * based system so the item is not removed immedaitely but is removed shortly after.
     * Because of this, we always resolve this promise, essentially ignoring errors on remove.
     *
     * @param {string | null} directory - The path of the directory to remove.
     *
     * @return {Promise<void>} - A promise that always resolves.
     */
    _this.removeDirectory = function (directory) {
      if (!directory) {
        return new Promise(function (resolve) {
          resolve();
          return;
        });
      }
      return new Promise(function (resolve) {
        (0, rimraf_1.rimraf)(directory).then(function () {
          resolve();
        })["catch"](function () {
          resolve();
        });
      });
    };
    _this.fileSource = fileSource;
    _this.localFileZipRoot = '@'; // This gets filled out lazily later. @ Means it has not been calculated yet.
    _this.downloadProcessCancelled = false;
    _this.anyDownloadFailed = false;
    _this.retryCountLimit = retryCountLimit;
    _this.proxyInfo = proxyInfo;
    _this.curlPath = curlPath;
    _this.logger = logger;
    _this.rootUrl = rootUrl;
    _this.sslVerification = sslVerification;
    _this.on('done', function () {
      _this.downloadProcessCancelled = false;
    });
    return _this;
  }
  _createClass(Downloader, [{
    key: "downloadAndExtractFileWorker",
    value: function downloadAndExtractFileWorker(zipFile, target, logger) {
      var _this2 = this;
      var downloadedFileMap = {};
      var destPath = '';
      var downloadedZipFilePath = '';
      var downloadedFilePath;
      var targetPath = (0, path_1.join)(target, zipFile.targetName);
      var sourceURL = zipFile.fileUrl;
      // check for cancel before we do anything.
      if (this.downloadProcessCancelled || this.anyDownloadFailed) {
        logger.info("downloadAndExtractFileWorker(".concat(sourceURL, " -> ").concat(targetPath, ") - Cancelling (1)."));
        return Promise.reject(new errors_1.CancelError());
      }
      return Promise.resolve().then(function () {
        _this2.emit('downloading-zip', zipFile);
        logger.info("downloadAndExtractFileWorker(".concat(sourceURL, " -> ").concat(targetPath, ") - Starting file download."));
        // Uncomment this to simulate a persistent failed download sourceURL = sourceURL.replace('darwin-support_1.zip', 'darwin-support_1X.zip');
        return _this2.downloadSingleFileCurl(sourceURL, zipFile.expectedHash, targetPath, false, 0);
      })["catch"](function (error) {
        // This should actually never happen because of how allSettled works.
        logger.info("downloadAndExtractFileWorker() - Error caught from downloadSingleFileCurl: ".concat(error, " - CancelError ? ").concat(error instanceof errors_1.CancelError, "."));
        if (!(error instanceof errors_1.CancelError)) {
          _this2.anyDownloadFailed = true;
        }
        return Promise.reject(error);
      }).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          filePath = _ref2[0],
          downloadedHash = _ref2[1];
        // check for cancel before we do anything.
        if (_this2.downloadProcessCancelled || _this2.anyDownloadFailed) {
          logger.info("downloadAndExtractFileWorker(".concat(sourceURL, " -> ").concat(targetPath, ") - Cancelling (2)."));
          return Promise.reject(new errors_1.CancelError());
        }
        downloadedFilePath = filePath;
        var fileSize = fs.statSync(filePath).size;
        logger.info("downloadAndExtractFileWorker(".concat(zipFile.targetName, ") - file download finished (").concat((fileSize / (1000 * 1000)).toFixed(1), " MB). MD5: ").concat(downloadedHash));
        return Promise.resolve(downloadedHash);
      }).then(function (downloadedHash) {
        // check for cancel before we do anything.
        if (_this2.downloadProcessCancelled || _this2.anyDownloadFailed) {
          logger.info("downloadAndExtractFileWorker(".concat(sourceURL, " -> ").concat(targetPath, ") - Cancelling (3)."));
          return Promise.reject(new errors_1.CancelError());
        }
        downloadedZipFilePath = downloadedFilePath;
        logger.info("downloadAndExtractFileWorker(".concat(zipFile.targetName, ") - hash was: ").concat(downloadedHash, " (expected: ").concat(zipFile.expectedHash, "). Extracting."));
        if (!zipFile.expectedHash || downloadedHash.toLowerCase() === zipFile.expectedHash.toLowerCase()) {
          _this2.emit('file-downloaded', (0, path_1.join)(target, zipFile.targetName));
          destPath = (0, path_1.join)(target, (0, path_1.basename)(downloadedZipFilePath, '.zip'));
          _this2.emit('extracting-zip', {
            from: downloadedZipFilePath,
            dest: destPath,
            expectedHash: zipFile.expectedHash
          });
          return _this2.extractZipFile(downloadedZipFilePath, destPath, zipFile.files, zipFile.packageName);
        } else {
          return Promise.reject(new errors_1.BaseError("An error has occurred downloading from \"".concat(zipFile.fileUrl, "\" to \"").concat(downloadedFilePath, "\""), enums_1.ErrorTypes.zipExtractionError, {
            expectedHash: zipFile.expectedHash,
            downloadedHash: downloadedHash
          }));
        }
      }).then(function (results) {
        _this2.emit('zip-extracted', Object.assign({
          path: destPath
        }, zipFile));
        logger.info("Downloader::downloadAndExtractFileWorker() - Zip Extracted to ".concat(destPath, ". Removing zip."));
        // Try to delete the zip. If it fails, retry a few times after a delay.
        try {
          fs.unlinkSync(downloadedZipFilePath);
          logger.info("Downloader::downloadAndExtractFileWorker() - Zip removed at ".concat(downloadedZipFilePath, "."));
        } catch (error) {
          logger.info("Downloader::downloadAndExtractFileWorker() - Error removing zip at ".concat(downloadedZipFilePath, ": ").concat(error, "."));
          var retries = 0;
          var deleteRetry = function deleteRetry() {
            if (retries > 2) {
              logger.info("Downloader::downloadAndExtractFileWorker() - Zip not removed after ".concat(retries - 1, " retries at ").concat(downloadedZipFilePath, "."));
              return;
            }
            retries++;
            setTimeout(function () {
              try {
                fs.unlinkSync(downloadedZipFilePath);
                logger.info("Downloader::downloadAndExtractFileWorker() - Zip removed after ".concat(retries, " retries at ").concat(downloadedZipFilePath, "."));
              } catch (error) {
                logger.info("Downloader::downloadAndExtractFileWorker() - Error on retry ".concat(retries, " removing zip at ").concat(downloadedZipFilePath, ": ").concat(error, "."));
                deleteRetry();
              }
            }, 5000); // This is a long(ish) delay because it should be rare.
          };

          deleteRetry();
        }
        return Promise.resolve(Object.assign(downloadedFileMap, results));
      });
    }
    // Just downloads the file. Does not extract. returns a DFM object of the downloaded zip (not its contents).
  }, {
    key: "downloadFileWorker",
    value: function downloadFileWorker(file, target, logger) {
      var _this3 = this;
      var downloadedFilePath;
      return Promise.resolve().then(function () {
        _this3.emit('downloading-file', {
          from: file.fileUrl,
          dest: target
        });
        logger.info("Downloader::downloadFileWorker(".concat(file.targetName, ") - starting file download to ").concat(target, "."));
        return _this3.downloadSingleFileCurl(file.fileUrl, file.expectedHash, (0, path_1.join)(target, file.targetName), false, 0);
      }).then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
          filePath = _ref4[0],
          fileHash = _ref4[1];
        if (_this3.downloadProcessCancelled || _this3.anyDownloadFailed) {
          return Promise.reject(new errors_1.CancelError());
        }
        downloadedFilePath = filePath;
        var fileSize = fs.statSync(filePath).size;
        logger.info("Downloader::downloadFileWorker(".concat(file.targetName, ") - file download finished (").concat((fileSize / (1000 * 1000)).toFixed(1), " MB). MD5: ").concat(fileHash));
        return Promise.resolve(fileHash);
      }).then(function (downloadedHash) {
        var filePath = downloadedFilePath;
        logger.info("Downloader::downloadFileWorker(".concat(file.targetName, ") - hash was: ").concat(downloadedHash, " (expected: ").concat(file.expectedHash, "). Extracting."));
        if (!file.expectedHash || downloadedHash.toLowerCase() === file.expectedHash.toLowerCase()) {
          // we're done
          var dfm = {};
          dfm[downloadedHash.toLowerCase()] = {
            type: "file",
            location: filePath
          };
          _this3.emit('file-downloaded', (0, path_1.join)(target, file.targetName));
          return Promise.resolve(dfm);
        } else {
          return Promise.reject(new errors_1.BaseError("An error has occurred downloading from \"".concat(file.fileUrl, "\" to \"").concat(downloadedFilePath, "\""), enums_1.ErrorTypes.zipExtractionError, {
            expectedHash: file.expectedHash,
            downloadedHash: downloadedHash
          }));
        }
      });
    }
    /**
     * Downloads a list of zip files and extract them
     *
     * @param {DownloadableZipFile[]} zipFiles - A list of zip files to download.
     * @param {string} target - The directory to download and extract the files to.
     *
     * @returns {string} - Returns empty string.
     */
  }, {
    key: "downloadAndExtractZipFilesParallel",
    value: function downloadAndExtractZipFilesParallel(zipFiles, target, concurrencyCount, logger) {
      var _this4 = this;
      this.emit('start-zip-downloads', zipFiles);
      logger.info("downloadAndExtractZipFilesParallel() - Starting download on ".concat(zipFiles.length, " zip files."));
      var queue = new concurrent_promise_queue_1.ConcurrentPromiseQueue({
        maxNumberOfConcurrentPromises: concurrencyCount
      });
      var allPromises = [];
      var _loop = function _loop(i) {
        logger.info("downloadAndExtractZipFilesParallel() - Adding file to queue: ".concat(zipFiles[i].targetName));
        allPromises.push(queue.addPromise(function () {
          return _this4.downloadAndExtractFileWorker(zipFiles[i], target, logger);
        }));
      };
      for (var i = 0; i < zipFiles.length; ++i) {
        _loop(i);
      }
      logger.info("downloadAndExtractZipFilesParallel() - Running promise.all");
      return Promise.allSettled(allPromises).then(function (results) {
        logger.info("downloadAndExtractZipFilesParallel() - All promises settled.");
        // Check for any failures...
        var failureCount = 0;
        var cancelCount = 0;
        for (var _i2 = 0; _i2 < results.length; ++_i2) {
          var result = results[_i2];
          var status = result.status;
          if (status === 'rejected') {
            failureCount++;
            if (result.reason instanceof errors_1.CancelError) {
              cancelCount++;
              // Cancels are different - we want to just know about them, and handle it later in one event.
            } else {
              // Log and handle the error
              logger.info("downloadAndExtractZipFilesParallel() - Error on thread ".concat(_i2, ": ").concat(result.reason, "."));
              _this4.emit('error', result.reason);
            }
          }
        }
        if (failureCount > 0) {
          logger.info("downloadAndExtractZipFilesParallel() - ".concat(failureCount, " failures (").concat(cancelCount, " cancels)."));
          if (cancelCount > 0) {
            logger.info("downloadAndExtractZipFilesParallel() - Emitting cancelled event.");
            _this4.emit('cancelled');
          }
          _this4.emit('done');
          return Promise.resolve("");
        } else {
          // Combine all the array elements into one map
          var fullResults = {};
          for (var _i3 = 0; _i3 < results.length; ++_i3) {
            var _result = results[_i3];
            var _status = _result.status;
            if (_status === 'fulfilled') {
              fullResults = Object.assign(fullResults, _result.value);
            }
          }
          _this4.emit('success', fullResults);
          _this4.emit('done');
          return Promise.resolve("");
        }
      })["catch"](function (error) {
        // This should actually never happen because of how allSettled works.
        logger.info("downloadAndExtractZipFilesParallel() - Error caught: ".concat(error, " - CancelError ? ").concat(error instanceof errors_1.CancelError, "."));
        _this4.handleError(error);
        return Promise.resolve("");
      });
    }
    /**
       * Downloads a list of zip files
       *
       * @param {DownloadableFile[]} files - A list of zip files to download.
       * @param {string} target - The directory to download and extract the files to.
       *
       * @returns {Downloader} - Returns this.
       */
  }, {
    key: "downloadFilesParallel",
    value: function downloadFilesParallel(files, target, concurrencyCount, logger) {
      var _this5 = this;
      this.emit('start-file-downloads', files);
      logger.info("downloadZipFilesParallel() - Starting download on ".concat(files.length, " zip files."));
      var queue = new concurrent_promise_queue_1.ConcurrentPromiseQueue({
        maxNumberOfConcurrentPromises: concurrencyCount
      });
      var allPromises = [];
      var _loop2 = function _loop2(i) {
        logger.info("downloadZipFilesParallel() - Adding file to queue: ".concat(files[i].targetName));
        allPromises.push(queue.addPromise(function () {
          return _this5.downloadFileWorker(files[i], target, logger);
        }));
      };
      for (var i = 0; i < files.length; ++i) {
        _loop2(i);
      }
      logger.info("downloadZipFilesParallel() - Running promise.all");
      return Promise.all(allPromises).then(function (results) {
        logger.info("downloadZipFilesParallel() - Done with all promises.");
        // Combine all the array elements into one map
        var fullResults = {};
        for (var _i4 = 0; _i4 < results.length; ++_i4) {
          fullResults = Object.assign(fullResults, results[_i4]);
        }
        _this5.emit('success', fullResults);
        _this5.emit('done');
        return Promise.resolve("");
      })["catch"](function (error) {
        _this5.handleError(error);
        return Promise.resolve("");
      });
    }
    /**
     * Downloads a list of zip files and extract them
     *
     * @param {DownloadableZipFile[]} zipFiles - A list of zip files to download.
     * @param {string} target - The directory to download and extract the files to.
     *
     * @returns {Downloader} - Returns this.
     */
  }, {
    key: "downloadAndExtractZipFiles",
    value: function downloadAndExtractZipFiles(zipFiles, target, logger) {
      var _this6 = this;
      this.emit('start-zip-downloads', zipFiles);
      zipFiles.reduce(function (promise, zipFileObj) {
        var downloadedFileMap = {};
        var destPath = '';
        var downloadedFilePath;
        return promise.then(function (fileMap) {
          _this6.emit('downloading-zip', zipFileObj);
          Object.assign(downloadedFileMap, fileMap);
          return _this6.downloadSingleFileCurl(zipFileObj.fileUrl, zipFileObj.expectedHash, (0, path_1.join)(target, zipFileObj.targetName), false, 0);
        }).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 2),
            filePath = _ref6[0],
            fileHash = _ref6[1];
          if (_this6.downloadProcessCancelled || _this6.anyDownloadFailed) {
            return Promise.reject(new errors_1.CancelError());
          }
          downloadedFilePath = filePath;
          return Promise.resolve(fileHash);
        }).then(function (downloadedHash) {
          var filePath = downloadedFilePath;
          if (!zipFileObj.expectedHash || downloadedHash.toLowerCase() === zipFileObj.expectedHash.toLowerCase()) {
            destPath = (0, path_1.join)(target, (0, path_1.basename)(filePath, '.zip'));
            _this6.emit('file-downloaded', destPath);
            logger.info("downloader::downloadAndExtractZipFiles() - expectedHash=".concat(zipFileObj.expectedHash, ", downloadedHash=").concat(downloadedHash, "."));
            _this6.emit('extracting-zip', {
              from: filePath,
              dest: destPath,
              expectedHash: zipFileObj.expectedHash
            });
            return _this6.extractZipFile(filePath, destPath, zipFileObj.files, zipFileObj.packageName);
          } else {
            return Promise.reject(new errors_1.BaseError("An error has occurred downloading from \"".concat(zipFileObj.fileUrl, "\" to \"").concat(downloadedFilePath, "\""), enums_1.ErrorTypes.zipExtractionError, {
              expectedHash: zipFileObj.expectedHash,
              downloadedHash: downloadedHash
            }));
          }
        }).then(function (results) {
          _this6.emit('zip-extracted', Object.assign({
            path: destPath
          }, zipFileObj));
          _this6.logger.info("Downloader::downloadAndExtractZipFiles() - Zip Extracted to ".concat(destPath, ", results: ").concat(results, "."));
          return Promise.resolve(Object.assign(downloadedFileMap, results));
        });
      }, Promise.resolve({})).then(function (downloadedFileMap) {
        _this6.emit('success', downloadedFileMap);
        _this6.emit('done');
      })["catch"](function (error) {
        _this6.handleError(error);
      });
      return this;
    }
    /**
     * Cancel download process
     *
     * Sets downloadProcessCancelled flag to true which other methods will react to depending
     * on the operating to cancel accordingly.
     */
  }, {
    key: "cancelDownload",
    value: function cancelDownload() {
      this.logger.info("downloader::cancelDownload called.");
      this.downloadProcessCancelled = true;
    }
    /**
     * Extract a zip file
     *
     * Files will be extracted to the path <target>/<file MD5> in a flat directory structure.
     *
     * @param {string} zipPath - The path to the zip file.
     * @param {string} target - The path of the directory to extract the files to.
     * @param {FileInfo[]} expectedFiles - A list of the files expected inside of the .zip archive.
     *
     * @returns {Promise<DownloadedFileMap>} - A promise for a DownloadedFileMap for the files inside
     * the extracted zip file
     */
  }, {
    key: "extractZipFile",
    value: function extractZipFile(zipPath, target, expectedFiles, packageName) {
      var _this7 = this;
      var expectedFilesPrintValue = "".concat(expectedFiles.length, " files");
      if (expectedFiles.length == 1) {
        expectedFilesPrintValue = JSON.stringify(expectedFiles);
      }
      this.logger.info("extractZipFile: expectedFiles is: ".concat(expectedFilesPrintValue, "."));
      var expectedFilesSimple = typeof expectedFiles[0] === 'string';
      this.logger.info("extractZipFile: simple? ".concat(expectedFilesSimple, "."));
      return new Promise(function (resolve, reject) {
        var downloadedFileMap = {};
        var extractedFileCount = 0;
        yauzl.open(zipPath, {
          autoClose: true,
          lazyEntries: true
        }, function (error, zipFile) {
          if (error) {
            rejectExtract(zipPath, "Error opening \"".concat(zipPath, "\" to extract"), enums_1.ErrorTypes.zipExtractionError, {
              zipPath: zipPath,
              target: target,
              zipName: (0, path_1.basename)(zipPath),
              originalError: error
            })["catch"](reject);
            return;
          }
          if (!zipFile) {
            reject(new errors_1.BaseError("Error opening \"".concat(zipPath, "\" to extract -- zipFile is undefined"), enums_1.ErrorTypes.zipExtractionError, {
              zipPath: zipPath,
              target: target,
              zipName: (0, path_1.basename)(zipPath),
              originalError: error
            }));
            return;
          }
          zipFile.on('error', function (zipError) {
            zipFile.close();
            reject(new errors_1.BaseError("An error has occurred extracting \"".concat(zipPath, "\""), enums_1.ErrorTypes.zipExtractionError, {
              zipPath: zipPath,
              target: target,
              zipName: (0, path_1.basename)(zipPath),
              originalError: zipError
            }));
          }).on('end', function () {
            zipFile.close();
            resolve(downloadedFileMap);
          }).on('entry', function (entry) {
            if (_this7.downloadProcessCancelled) {
              zipFile.close();
              reject(new errors_1.CancelError());
              return;
            }
            if (/\/$/.test(entry.fileName)) {
              // Skip item ending in slash (directory) eg "...bleh/bleh/"
              zipFile.readEntry();
              return;
            }
            zipFile.openReadStream(entry, function (readErr, readStream) {
              if (readErr) {
                reject(new errors_1.BaseError("Error opening a read stream to read zip file \"".concat(zipPath, "\""), enums_1.ErrorTypes.zipExtractionError, {
                  zipPath: zipPath,
                  target: target,
                  zipName: (0, path_1.basename)(zipPath),
                  originalError: readErr
                }));
                return;
              }
              if (!readStream) {
                reject(new errors_1.BaseError("Error opening a read stream to read zip file \"".concat(zipPath, "\" -- readStream undef"), enums_1.ErrorTypes.zipExtractionError, {
                  zipPath: zipPath,
                  target: target,
                  zipName: (0, path_1.basename)(zipPath),
                  originalError: readErr
                }));
                return;
              }
              var filePath = '';
              var fileIdentifier = '';
              if (expectedFilesSimple) {
                var matchingFile = expectedFiles.find(function (file) {
                  return file === entry.fileName;
                });
                if (!matchingFile) {
                  // This is fine. We always download zips that likely contain
                  // many files when we just need a subset of them.
                  zipFile.readEntry();
                  return;
                }
                filePath = (0, path_1.join)(target, (0, path_1.basename)(matchingFile));
                fileIdentifier = matchingFile;
                _this7.logger.info("extractZipFile: entry matches. Saving to: ".concat(filePath, "."));
              } else {
                var _matchingFile = expectedFiles.find(function (file) {
                  var fileName = entry.fileName; // eg darwin-core_11/bcc92d17337a0a489d2003261fa5c299
                  fileName = (0, path_1.basename)(fileName.toLowerCase());
                  if (entry.fileName.startsWith("".concat(packageName, "/"))) {
                    fileName = fileName.split('/').slice(1).join('/');
                  }
                  var validOperation = true;
                  if (typeof file !== 'string') {
                    validOperation = file.operation === enums_1.FileOperations.added || file.operation === enums_1.FileOperations.changed || file.operation === enums_1.FileOperations["volatile"];
                  }
                  return file.md5.toLowerCase().localeCompare(fileName) === 0 && validOperation;
                });
                if (!_matchingFile) {
                  // This is fine. We always download zips that likely contain
                  // many files when we just need a subset of them.
                  zipFile.readEntry();
                  return;
                }
                fileIdentifier = _matchingFile.md5;
                filePath = (0, path_1.join)(target, _matchingFile.md5);
              }
              var writeDir = (0, path_1.dirname)(filePath);
              fs.ensureDir(writeDir).then(function () {
                var savedFileMode = 438; // The default. r/w for all
                if ((entry.externalFileAttributes & 0x490000) !== 0) {
                  // This denotes executable in a zip
                  savedFileMode = 511; // r/w/x for all
                }

                var isSymlink = false;
                // This has to do with now JS handles Numbers + Bitwise operations
                if ((entry.externalFileAttributes & 0xA0000000) === -0x60000000) {
                  isSymlink = true;
                }
                var dest = fs.createWriteStream(filePath, {
                  mode: savedFileMode
                }).on('error', function (error) {
                  if (error.code === 'ENOSPC') {
                    reject(new errors_1.BaseError("Failed to extract zip file \"".concat(filePath, "\" due to no disk space"), enums_1.ErrorTypes.noDiskSpace, {
                      zipPath: zipPath,
                      target: target,
                      zipName: (0, path_1.basename)(zipPath),
                      originalError: error
                    }));
                    return;
                  }
                  reject(new errors_1.BaseError("Failed writing zip file to \"".concat(filePath, "\""), enums_1.ErrorTypes.zipExtractionError, {
                    zipPath: zipPath,
                    target: target,
                    zipName: (0, path_1.basename)(zipPath),
                    originalError: error
                  }));
                }).on('close', function () {
                  extractedFileCount += 1;
                  _this7.emit('zip-item-extracted', {
                    extracted: extractedFileCount,
                    total: expectedFiles.length
                  });
                  if (isSymlink) {
                    _this7.logger.info("extractZipFile: symlink.");
                    fs.readFile(filePath, 'utf-8').then(function (data) {
                      _this7.logger.info("Downloader::extractZip() - Creating a symlink to ".concat(data));
                      downloadedFileMap[fileIdentifier] = {
                        type: 'symlink',
                        to: data
                      };
                      zipFile.readEntry();
                    })["catch"](function (error) {
                      return reject(new errors_1.BaseError("Failed to read the symlink information", enums_1.ErrorTypes.zipExtractionError, {
                        zipPath: zipPath,
                        target: target,
                        zipName: (0, path_1.basename)(zipPath),
                        originalError: error
                      }));
                    });
                    return;
                  }
                  downloadedFileMap[fileIdentifier] = {
                    type: 'file',
                    location: filePath
                  };
                  zipFile.readEntry();
                });
                readStream.on('error', function (error) {
                  // dest.destroy() passes the error to dest's error handler.
                  dest.destroy(error);
                });
                readStream.pipe(dest);
              })["catch"](function (error) {
                zipFile.close();
                reject(new errors_1.BaseError('An error has occurred ensuring directory for zip extraction', enums_1.ErrorTypes.zipExtractionError, {
                  originalError: error
                }));
              });
            });
          });
          zipFile.readEntry();
        });
      });
    }
    /**
     * Handle errors/cancel events for emit to upper level
     *
     * @param  {BaseError} err - error object
     * @param  {string} target - target folder for downloaded files
     */
  }, {
    key: "handleError",
    value: function handleError(error) {
      if (error instanceof errors_1.CancelError) {
        this.emit('cancelled');
      } else {
        this.emit('error', error);
      }
      this.emit('done');
    }
    /**
     * Downloads a file from a url, into a string. This kind of wraps downloadSingleFileCurl with the
     * creation and removal of a temp folder/file for convenience.
     *
     * Can download a file to disk or to memory as a utf-8 string. If target is an empty string the
     * file will be downloaded as an utf-8 string.
     *
     * @param {string} url - The url to download the file from
     * @param {string} encoding - One of a few predefined encodings. Use null for binary.
     * @param {string} expectedHash - The expected hash of the file, if known, or empty string if none.
     * @param {boolean} notFoundOK - If true, a 404 result is ok, we will return an empty string in this case.
     * @return {Promise<string|Buffer>} - A promise for the data read in.
     */
  }, {
    key: "downloadToMemory",
    value: function downloadToMemory(url, encoding, expectedHash, notFoundOK) {
      var _this8 = this;
      this.logger.info("downloadToMemory() - Getting file from: ".concat(url));
      var tempDir = '';
      return this.createTempDirectory().then(function (createdTempDir) {
        tempDir = createdTempDir;
        var fileBase = 'SingleFileDownloaded.dat';
        var target = (0, path_1.join)(tempDir, fileBase);
        return _this8.downloadSingleFileCurl(url, expectedHash, target, notFoundOK, 0);
      }).then(function (_ref7) {
        var _ref8 = _slicedToArray(_ref7, 2),
          downloadedFilepath = _ref8[0],
          _downloadedFileHash = _ref8[1];
        return fs.promises.readFile(downloadedFilepath, encoding);
      }).then(function (readResult) {
        return Promise.all([Promise.resolve(readResult), _this8.removeDirectory(tempDir)]);
      }).then(function (results) {
        return Promise.resolve(results[0]); // readResult
      });
    }
    /**
     * Given an input url such as https://release.vectorworks.net/nnapub/vwim/30/NNA/eng/files/Beta1/full/common-core_2.zip
     * and a rootUrl value of eg https://release.vectorworks.net/nnapub/vwim/30/NNA/eng,
     * to for example: root/files/Beta1A/full/common-core_2.zip
     */
  }, {
    key: "urlToLocalPath",
    value: function urlToLocalPath(url, rootUrl) {
      var result = url;
      if (url.startsWith(rootUrl) && url.charAt(rootUrl.length) === '/') {
        if (this.localFileZipRoot === '') {
          // No root in zip
          result = url.slice(rootUrl.length + 1);
        } else {
          result = this.localFileZipRoot + '/' + url.slice(rootUrl.length + 1);
        }
      }
      return result;
    }
    /**
     * Given local fileSource and a file known to be at the root, return the root of the zip.
     * This will sometimes return an empty root if the file is at the zip's root.
     * This can be slow if there are many entries.
     *
     * @param {string} fileInRoot - A file known to be in the root, typically versioninfo.json
     * @returns The root folder inside the zip file, if it exists. Otherwise, an empty string.
     */
  }, {
    key: "getLocalZipRoot",
    value: function getLocalZipRoot(fileInRoot) {
      var _this9 = this;
      var zipPath = this.fileSource;
      this.logger.info("Downloader::getLocalZipRoot(".concat(zipPath, ") - Starting"));
      if (this.fileSource !== '') {
        // Using yauzl, get a listing of the root directories of the zip file.
        return new Promise(function (resolve, reject) {
          yauzl.open(zipPath, {
            autoClose: true,
            lazyEntries: true
          }, function (error, zipFile) {
            if (error) {
              rejectExtract(zipPath, "Error opening \"".concat(zipPath, "\" to extract"), enums_1.ErrorTypes.zipExtractionError, {
                zipPath: zipPath,
                target: '',
                zipName: (0, path_1.basename)(zipPath),
                originalError: error
              })["catch"](reject);
              return;
            }
            if (!zipFile) {
              reject(new errors_1.BaseError("Error opening \"".concat(zipPath, "\" to extract -- zipFile is undefined"), enums_1.ErrorTypes.zipExtractionError, {
                zipPath: zipPath,
                target: '',
                zipName: (0, path_1.basename)(zipPath),
                originalError: error
              }));
              return;
            }
            zipFile.on('error', function (zipError) {
              zipFile.close();
              reject(new errors_1.BaseError("An error has occurred extracting \"".concat(zipPath, "\""), enums_1.ErrorTypes.zipExtractionError, {
                zipPath: zipPath,
                target: '',
                zipName: (0, path_1.basename)(zipPath),
                originalError: zipError
              }));
            }).on('end', function () {
              zipFile.close();
              resolve('');
            }).on('entry', function (entry) {
              if (/\/$/.test(entry.fileName)) {
                // Skip item ending in slash (directory) eg "...bleh/bleh/"
                zipFile.readEntry();
                return;
              }
              // Get root from entry
              _this9.logger.info("Downloader::getLocalZipRoot() - Got entry file: ".concat(entry.fileName));
              var entrySplit = entry.fileName.split('/');
              // Get the last element of entrySplit
              var filename = entrySplit[entrySplit.length - 1];
              if (filename === fileInRoot && entrySplit.length <= 2) {
                // It's either at the root of the zip or in a single root folder.
                if (entrySplit.length === 2) {
                  _this9.logger.info("Downloader::getLocalZipRoot() - Got local zip root: ".concat(entrySplit[0]));
                  resolve(entrySplit[0]);
                  return;
                } else {
                  // It's in a single root folder.
                  _this9.logger.info("Downloader::getLocalZipRoot() - Local zip had no additional root.");
                  resolve('');
                  return;
                }
              } else {
                // Try the next entry.
                zipFile.readEntry();
              }
            });
            zipFile.readEntry();
          });
        });
      } else {
        // There was no zip file, so no root.
        return Promise.resolve('');
      }
    }
    /**
     * Extracts a single file from fileSource, either to disk or to memory
     *
     * If destination is not provided the file will be saved as a utf8 block of memory. If
     * destination is provided it is the path to download the file to, file name should be included.
     *
     * @param {string} url - The url of the file to download.
     * @param {string} rootUrl - The root URL of the file to "download" from the zip.
     * @param {string} [destination] - The path to download the file to. If empty
     * @returns {Promise<[string, string]>} - A promise for the absolute path of the downloaded file. Empty means no file was downloaded. Second string always empty (not hashed)
     */
  }, {
    key: "localDownloadFile",
    value: function localDownloadFile(url, rootUrl, destination) {
      var _this10 = this;
      this.logger.info("localDownloadFile(".concat(url, ") - Starting local download."));
      var zipFile = this.fileSource;
      var pathInsideZip = '';
      return Promise.resolve().then(function () {
        _this10.emit('downloading-file', {
          from: url,
          dest: destination
        });
        if (_this10.localFileZipRoot === '@') {
          return _this10.getLocalZipRoot('versioninfo.json'); // Note that this makes this function very specific to vwim files. Probably want to improve that later.
        } else {
          return Promise.resolve(_this10.localFileZipRoot);
        }
      }).then(function (foundZipRoot) {
        _this10.localFileZipRoot = foundZipRoot;
        pathInsideZip = _this10.urlToLocalPath(url, rootUrl);
        _this10.logger.info("localDownloadFile() - path in zip is now: ".concat(pathInsideZip));
        // Set up for call to extractZipFile
        var expectedSingleFile = _this10.urlToLocalPath(url, rootUrl);
        var expectedFiles = [expectedSingleFile];
        // The call to extract the file...
        return _this10.extractZipFile(zipFile, destination, expectedFiles, '');
      }).then(function (downloadedFileMap) {
        _this10.logger.info("localDownloadFile() - Extracted file: ".concat(JSON.stringify(downloadedFileMap)));
        // This should be an object with one item
        if (Object.keys(downloadedFileMap).length != 1) {
          _this10.logger.info("localDownloadFile(".concat(pathInsideZip, ") - Keys length was ").concat(Object.keys(downloadedFileMap).length, ". Expected length of 1."));
          return Promise.reject(new errors_1.BaseError("An error has occurred extracting from \"".concat(zipFile, "\" to \"").concat(destination, "\""), enums_1.ErrorTypes.zipExtractionError, {
            downloadedFileMap: downloadedFileMap
          }));
        }
        var downloadedObj = downloadedFileMap[Object.keys(downloadedFileMap)[0]];
        var absPathOfExtractedFile = '';
        if (downloadedObj.type === 'file') {
          absPathOfExtractedFile = downloadedObj.location;
        }
        _this10.logger.info("localDownloadFile() - Generating MD5 hash for ".concat(absPathOfExtractedFile));
        return Promise.all([Promise.resolve(absPathOfExtractedFile), (0, md5_file_1["default"])(absPathOfExtractedFile)]);
      }).then(function (promises) {
        return Promise.resolve([promises[0], promises[1]]);
      });
    }
    /**
     * Download a single file, either to disk or to memory
     *
     * If destination is not provided the file will be downloaded as a utf8 file to memory. If
     * destination is provided it is the path to download the file to, file name should be included.
     *
     * @param {string} url - The url of the file to download.
     * @param {string} expectedHash - The expected hash of the zip or empty string if none.
     * @param {string} [destination] - The path to download the file to.
     * @param {boolean} notFoundOK - If true, a 404 result is ok, we will return an empty string in this case.
     * @param {number} curRetries - Current retry count. Should be called with zero.
     * @returns {Promise<[string, string]>} - A promise for the absolute path of the downloaded file, and md5 hash of that file. Empty means no file was downloaded.
     */
  }, {
    key: "downloadSingleFileCurl",
    value: function downloadSingleFileCurl(urlIn, expectedHash, destination, notFoundOK, curRetries) {
      var _this11 = this;
      if (this.fileSource !== '') {
        return this.localDownloadFile(urlIn, this.rootUrl, destination);
      }
      var url = urlIn;
      var md5Hash = '';
      // Uncomment this and modify it to force a 404 and simulate a download error
      /*
      if (curRetries === 0 && urlIn.endsWith('common-core_d.zip')) {
        this.logger.info(`downloadSingleFileCurl(${urlIn}) - messing up URL`);
        url += 'x';
      }*/
      this.logger.info("downloadSingleFileCurl(".concat(url, ") - Starting curl download."));
      return new Promise(function (resolve, reject) {
        if (_this11.downloadProcessCancelled) {
          _this11.logger.info("downloadSingleFileCurl(".concat(url, ") - Cancelling 1."));
          return reject(new errors_1.CancelError());
        }
        var promise = Promise.resolve();
        var fileDir = (0, path_1.dirname)(destination);
        promise = fs.ensureDir(fileDir);
        promise.then(function () {
          // Run curl
          var cmd = "\"".concat(_this11.curlPath, "\"");
          var proxyInfo = _this11.proxyInfo;
          var curlEnv = {
            childEnv: process.env,
            prefix: ''
          };
          if (proxyInfo) {
            curlEnv = proxyInfo.getCURLEnv();
            //this.logInfo(`downloadLDF() - ProxyInfo was present. Using: ${proxyInfo.getProxyUrl()}`)
          } else {
            //this.logInfo('downloadLDF() - No Proxy present.')
          }
          var curlCA = process.platform === 'darwin' ? '' : '--ca-native';
          var args = [];
          if (curlCA !== '') {
            args.push(curlCA);
          }
          if (curlEnv.prefix !== '') {
            args.push(curlEnv.prefix);
          }
          if (_this11.sslVerification === false) {
            args.push('-k'); // aka --insecure
          }

          args.push('--url');
          args.push("".concat(url));
          args.push("-s");
          args.push("--retry");
          args.push("1");
          args.push("-v");
          // If the download falls under 100 bps for 30 seconds, abort.
          args.push('--speed-limit');
          args.push('100');
          args.push('--speed-time');
          args.push('30');
          args.push("--fail"); // If the file is not there, this will return 22 instead of zero with an html file.
          args.push("-o");
          args.push("\"".concat(destination, "\""));
          _this11.logger.info("downloadSingleFileCurl(".concat(url, ") - Command is: ").concat(cmd, ", Args are: ").concat(JSON.stringify(args)));
          var fullStdOut = '';
          var fullStdErr = '';
          var ps = childProcess.spawn(cmd, args, {
            shell: true
          });
          ps.stdout.on('data', function (data) {
            fullStdOut += data;
          });
          ps.stderr.on('data', function (data) {
            fullStdErr += data;
          });
          ps.on('error', function (error) {
            _this11.logger.info("downloadSingleFileCurl(".concat(url, ") - Got error event (").concat(error.code, ")."));
            // Handle write errors
            if (error.code === 'ENOSPC') {
              reject(new errors_1.BaseError("Ran out of disk space downloading ".concat(url), enums_1.ErrorTypes.noDiskSpace, {
                from: url,
                dest: destination,
                originalError: error
              }));
              return;
            }
            reject(new errors_1.BaseError('Error on write to stream during download', enums_1.ErrorTypes.downloadHttpWriteStreamError, {
              destination: destination,
              url: url,
              originalError: error
            }));
          }).on('close', function (code) {
            var shouldRetry = false;
            _this11.logger.info("downloadSingleFileCurl(".concat(url, ") - Got close event and code ").concat(code, "."));
            if (code !== 0) {
              if (code === 22 && notFoundOK) {
                _this11.logger.info("downloadSingleFileCurl(".concat(url, ") - not found, but this is OK."));
                resolve(['', '']);
              } else if (code !== null && [51, 53, 54, 58, 59, 60, 77, 83, 91, 98].includes(code)) {
                // Certificate-related errors.
                var error = new errors_1.BaseError("A ssl-related error has occurred downloading from \"".concat(url, "\" to \"").concat(destination, "\""), enums_1.ErrorTypes.downloadSSLOrCertificateError, {
                  curlErrorNum: code
                });
                // We log output here too.
                _this11.logger.error("downloadSingleFileCurl(".concat(url, ") - Error downloading file. retryCount=").concat(curRetries, ", retryCountLimit=").concat(_this11.retryCountLimit, "."));
                _this11.logger.error("downloadSingleFileCurl(".concat(url, ") - stdout was:\n").concat(fullStdOut));
                _this11.logger.error("downloadSingleFileCurl(".concat(url, ") - stderr was:\n").concat(fullStdErr));
                // Typically, cert errors don't go away, so don't retry.
                reject(error);
              } else {
                var _error = new errors_1.BaseError("An error has occurred downloading from \"".concat(url, "\" to \"").concat(destination, "\""), enums_1.ErrorTypes.downloadHttpRequestError, {
                  'target': url
                });
                _this11.logger.error("downloadSingleFileCurl(".concat(url, ") - Error downloading file. retryCount=").concat(curRetries, ", retryCountLimit=").concat(_this11.retryCountLimit, "."));
                _this11.logger.error("downloadSingleFileCurl(".concat(url, ") - stdout was:\n").concat(fullStdOut));
                _this11.logger.error("downloadSingleFileCurl(".concat(url, ") - stderr was:\n").concat(fullStdErr));
                shouldRetry = _this11.retryCountLimit === -1 || curRetries < _this11.retryCountLimit;
                if (shouldRetry) {
                  _this11.emit('retrying-file', url, curRetries + 1, _this11.retryCountLimit, _error);
                  setTimeout(function () {
                    _this11.downloadSingleFileCurl(urlIn, expectedHash, destination, notFoundOK, curRetries + 1).then(function (results) {
                      return resolve(results);
                    })["catch"](function (error) {
                      return reject(error);
                    });
                  }, 5000);
                } else {
                  if (_this11.downloadProcessCancelled) {
                    _this11.logger.info("downloadSingleFileCurl(".concat(url, ") - Cancelling 2."));
                    return reject(new errors_1.CancelError());
                  }
                  reject(_error);
                }
                return;
              }
            }
            if (_this11.downloadProcessCancelled) {
              _this11.logger.info("downloadSingleFileCurl(".concat(url, ") - Cancelling 3."));
              return reject(new errors_1.CancelError());
            }
            md5Hash = md5_file_1["default"].sync(destination);
            if (expectedHash !== '') {
              // Verify the MD5
              if (md5Hash.toLowerCase() !== expectedHash.toLowerCase()) {
                var _error2 = new RequestError("".concat(destination, ": Hash mismatch. Expected: ").concat(expectedHash, ", actual: ").concat(md5Hash, "."), enums_1.ErrorTypes.md5Error, {
                  from: url
                });
                shouldRetry = _this11.retryCountLimit === -1 || curRetries < _this11.retryCountLimit;
                if (shouldRetry) {
                  _this11.emit('retrying-file', url, curRetries + 1, _this11.retryCountLimit, _error2);
                  setTimeout(function () {
                    _this11.downloadSingleFileCurl(url, expectedHash, destination, notFoundOK, curRetries + 1).then(function (results) {
                      return resolve(results);
                    })["catch"](function (error) {
                      return reject(error);
                    });
                  }, 5000);
                } else {
                  reject(_error2);
                }
                return;
              }
            }
            resolve([destination, md5Hash]);
          });
        });
      });
    }
  }]);
  return Downloader;
}(events_1.EventEmitter);
exports["default"] = Downloader;

/***/ }),

/***/ 38261:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


/**
 * Contains enums and constants used by the installer and updater
 */
var _exports$productToStr;
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.InitialModes = exports.RegistryValueTypes = exports.productToString = exports.MAIN_DIR = exports.ReadMeTypes = exports.EulaTypes = exports.RegistryValues = exports.FAKE_UPDATE_WAIT = exports.FAKE_INTERVAL_TIME = exports.PlistScopes = exports.ErrorTypes = exports.UpdaterSteps = exports.LicenseFlags = exports.LicenseTypes = exports.ProductFlavors = exports.Protections = exports.ProcessPlatformToPlatformsEnum = exports.Platforms = exports.Products = exports.FileOperations = void 0;
/**
 * Enum for file operations
 *
 * @enum {string}
 */
var FileOperations;
(function (FileOperations) {
  /** The file is being added */
  FileOperations["added"] = "added";
  /** The file is being deleted */
  FileOperations["deleted"] = "deleted";
  /** The file is being changed */
  FileOperations["changed"] = "changed";
  /** The file is being renamed */
  FileOperations["renamed"] = "renamed";
  /** The file is volatile (which is basically "added") */
  FileOperations["volatile"] = "volatile";
  /** The file does not change, a no-op */
  FileOperations["none"] = "none";
})(FileOperations || (exports.FileOperations = FileOperations = {}));
/**
 * Enum for product names
 *
 * @enum {string}
 */
var Products;
(function (Products) {
  /** Vectorworks */
  Products["vectorworks"] = "vectorworks";
  /** Vision */
  Products["vision"] = "vision";
})(Products || (exports.Products = Products = {}));
/**
 * Enum for platforms. Each string value is the representation returned from process.platform.
 * @enum {string}
 */
var Platforms;
(function (Platforms) {
  /** OSX */
  Platforms["mac"] = "darwin";
  /** Windows */
  Platforms["win"] = "win32";
  /** All Platforms */
  Platforms["common"] = "common";
  /** Unknown */
  Platforms["unknown"] = "unknown";
})(Platforms || (exports.Platforms = Platforms = {}));
// Takes a value like from process.platform (darwin, win32) and returns
// the Platforms enum value from it.
var ProcessPlatformToPlatformsEnum = function ProcessPlatformToPlatformsEnum(sysPlatform) {
  switch (sysPlatform) {
    case 'win32':
      return Platforms.win;
    case 'darwin':
      return Platforms.mac;
    case 'common':
      return Platforms.common;
  }
  return Platforms.unknown;
};
exports.ProcessPlatformToPlatformsEnum = ProcessPlatformToPlatformsEnum;
/**
 * Enum for protections as used internally and in components strings.
 *
 * @enum {string}
 */
var Protections;
(function (Protections) {
  /** Series B Demo */
  Protections["protection_demo"] = "protection-demo";
  /** Series E */
  Protections["protection_internet"] = "protection-internet";
  /** Series B */
  Protections["protection_dongle"] = "protection-dongle";
  /** Series G */
  Protections["protection_site_protection"] = "protection-site-protection";
  /** Viewer */
  Protections["protection_viewer"] = "protection-viewer";
  /** No Protections */
  Protections["none"] = "none";
})(Protections || (exports.Protections = Protections = {}));
/**
 * Enum for product flavors
 *
 * This is only used by Vectorworks currently as Vision has all users get all files
 *
 * @enum {string}
 */
var ProductFlavors;
(function (ProductFlavors) {
  /** Renderworks */
  ProductFlavors["renderworks"] = "renderworks";
  /** Architect */
  ProductFlavors["architect"] = "architect";
  /** Landmark */
  ProductFlavors["landmark"] = "landmark";
  /** Spotlight */
  ProductFlavors["spotlight"] = "spotlight";
  /** Mechanical */
  ProductFlavors["mechanical"] = "mechanical";
  /** Pro */
  ProductFlavors["pro"] = "pro";
  /** Homebuilder */
  ProductFlavors["homebuilder"] = "homebuilder";
  /** Braceworks */
  ProductFlavors["braceworks"] = "braceworks";
  /** A reserved bit space */
  ProductFlavors["reserved2"] = "reserved2";
  /** Module 5 - Extra Space for Distributor specific needs */
  ProductFlavors["module5"] = "third-party-5";
  /** Module 4 - Extra Space for Distributor specific needs */
  ProductFlavors["module4"] = "third-party-4";
  /** Module 3 - Extra Space for Distributor specific needs */
  ProductFlavors["module3"] = "third-party-3";
  /** Module 2 - Extra Space for Distributor specific needs */
  ProductFlavors["module2"] = "third-party-2";
  /** Module 1 - Extra Space for Distributor specific needs */
  ProductFlavors["module1"] = "third-party-1";
})(ProductFlavors || (exports.ProductFlavors = ProductFlavors = {}));
/**
 * Enum for license types
 *
 * @enum {string}
 */
var LicenseTypes;
(function (LicenseTypes) {
  LicenseTypes["internal"] = "license-type-internal";
  LicenseTypes["professional"] = "license-type-professional";
  LicenseTypes["not_for_resale"] = "license-type-not-for-resale";
  LicenseTypes["educational_student_lab_seat"] = "license-type-educational-student-lab-seat";
  LicenseTypes["educational_student"] = "license-type-educational-student";
  LicenseTypes["educational_teacher"] = "license-type-educational-teacher";
  LicenseTypes["evaluation"] = "license-type-evaluation";
})(LicenseTypes || (exports.LicenseTypes = LicenseTypes = {}));
/**
 * Enum for license types
 *
 * @enum {string}
 */
var LicenseFlags;
(function (LicenseFlags) {
  LicenseFlags["educational_banner"] = "license-flags-educational-banner";
  LicenseFlags["new_files_are_watermarked"] = "license-flags-new-files-are-watermarked";
  LicenseFlags["print_with_watermark"] = "license-flags-print-with-watermark";
  LicenseFlags["save_as_professional_file_format"] = "license-flags-save-as-professional-file-format";
  LicenseFlags["open_professional_file_format"] = "license-flags-open-professional-file-format";
  LicenseFlags["save_as_educational_file_format"] = "license-flags-save-as-educational-file-format";
  LicenseFlags["open_educational_file_format"] = "license-flags-open-educational-file-format";
  LicenseFlags["allow_vectorscript_export"] = "license-flags-allow-vectorscript-export";
  LicenseFlags["subscription"] = "license-flags-subscription";
})(LicenseFlags || (exports.LicenseFlags = LicenseFlags = {}));
/**
 * Enum for updater steps
 *
 * These are the various stages an update can be in. These vary across normal updates, repairs,
 * and offline updates, both downloading and applying.
 *
 * @enum {string}
 */
var UpdaterSteps;
(function (UpdaterSteps) {
  /** Nothing is going on */
  UpdaterSteps["none"] = "none";
  /** Used by repair to fetch the build's MD5 Hashfile */
  UpdaterSteps["fetchingBuildInfo"] = "fetchingBuildInfo";
  /** Used by repair when files are being checked against the MD5 Hashfile */
  UpdaterSteps["checkingFiles"] = "checkingFiles";
  /** Used by repair, update, and download offline update when downloading files */
  UpdaterSteps["downloadingFiles"] = "downloadingFiles";
  /** When repair is repairing the files */
  UpdaterSteps["repairingFiles"] = "repairingFiles";
  /** When install is copying the files */
  UpdaterSteps["installingFiles"] = "installingFiles";
  /** When uninstaller is removing files */
  UpdaterSteps["uninstallingFiles"] = "uninstallingFiles";
  /** When the Updater is cleaning up temporary files after completion or during a cancel */
  UpdaterSteps["cleaningUp"] = "cleaningUp";
  /** When the Updater is cleaning up temporary directories after an error */
  UpdaterSteps["cleaningUpErr"] = "cleaningUpErr";
  /** When the offline update has been downloaded and is being packaged into a .vwupdate */
  UpdaterSteps["packagingUpdate"] = "packagingUpdate";
  /** Used by update when files are being copied over */
  UpdaterSteps["applyingUpdate"] = "applyingUpdate";
  /** We're in this state when fetching the LDF file which can take a second or so usually */
  UpdaterSteps["fetchingLDF"] = "fetchingLDF";
  /** The step when update information is being fetched from the internet */
  UpdaterSteps["fetchingUpdateInfo"] = "fetchingUpdateInfo";
  /** The step when the offline update is being extracted from the .vwupdate */
  UpdaterSteps["extractingOfflineUpdate"] = "extractingOfflineUpdate";
  /** When a blank update is occuring, fake progress will be emitted to provide a better UX */
  UpdaterSteps["fakingUpdate"] = "fakingUpdate";
  /** When the preOperation hook step runs */
  UpdaterSteps["preparingOperation"] = "preparingOperation";
  /** During guarantee (After update), we have to download the full MD5 file */
  UpdaterSteps["guarantee_fetchingBuildInfo"] = "guarantee_fetchingBuildInfo";
  /** During guarantee (After update), we have to check guarantee files */
  UpdaterSteps["guarantee_checkingFiles"] = "guarantee_checkingFiles";
  /** During guarantee, we're repairing files */
  UpdaterSteps["guarantee_downloadingFiles"] = "guarantee_downloadingFiles";
  /** During guarantee, we're repairing files */
  UpdaterSteps["guarantee_repairingFiles"] = "guarantee_repairingFiles";
})(UpdaterSteps || (exports.UpdaterSteps = UpdaterSteps = {}));
/**
 * Enum for error types
 *
 * These error types are used to map localized strings to error messages, so the key of the string
 * in .vwstrings file will be the value of these enums.
 *
 * @example "errors.downloadHttpResponseError" = "An error has occurred downloading a file";
 * This is used as the error message to ErrorTypes.downloadHttpRequestError
 *
 * @enum {string}
 */
var ErrorTypes;
(function (ErrorTypes) {
  /** A generic unknown error */
  ErrorTypes["unknownError"] = "unknownError";
  // Following occur in downloader
  /** When the downloader gets a non-2XX status code */
  ErrorTypes["downloadHttpResponseError"] = "downloadHttpResponseError";
  /** When the download request fails due to an 'error' event*/
  ErrorTypes["downloadHttpRequestError"] = "downloadHttpRequestError";
  /** When the download request fails due to a ssl or certificate related error */
  ErrorTypes["downloadSSLOrCertificateError"] = "downloadSSLOrCertificateError";
  /** When downloading a file fails due to a write stream issue */
  ErrorTypes["downloadHttpWriteStreamError"] = "downloadHttpWriteStreamError";
  /** When downloading a large package zip fails due to extraction errors */
  ErrorTypes["zipExtractionError"] = "zipExtractionError";
  /** When an error occurs checking the MD5 of a file before downloading */
  ErrorTypes["md5Error"] = "md5Error";
  // Following occurs in update-instance
  /** When the update does not match the passed in installInfo */
  ErrorTypes["versionMismatch"] = "versionMismatch";
  /** When there are duplicate files, generally indicates a shadowed file issue */
  ErrorTypes["duplicateOperationMismatch"] = "duplicateOperationMismatch";
  /** When the build MD5 file downloaded is invalid */
  ErrorTypes["invalidBuildMd5"] = "invalidBuildMd5";
  // Following occurs in updater
  /** When a job is started while another job is in progress */
  ErrorTypes["jobInProgress"] = "jobInProgress";
  /** When check for updates returns a non-2XX status code */
  ErrorTypes["checkUpdateStatusCode"] = "checkUpdateStatusCode";
  /** When check for updates fails due to emitting an 'error' event */
  ErrorTypes["checkUpdateReqErr"] = "checkUpdateReqErr";
  /** When check for update returns an invalid versioninfo.json */
  ErrorTypes["checkUpdateInvalidRes"] = "checkUpdateInvalidRes";
  /** When the delta file or build MD5 download returns a non-2XX status code */
  ErrorTypes["updateFileDownloadStatusCode"] = "updateFileDownloadStatusCode";
  /** When the delta file or build MD5 download fails due to an 'error' event */
  ErrorTypes["updateFileDownloadError"] = "updateFileDownloadError";
  /** When creating the temporary staging directory fails */
  ErrorTypes["failedCreateStageDir"] = "failedCreateStageDir";
  /** When a file that should have been downloaded is missing */
  ErrorTypes["missingDownloadedFile"] = "missingDownloadedFile";
  /** When the file operation is invalid and not a FileOperation */
  ErrorTypes["invalidFileOperation"] = "invalidFileOperation";
  /** When the update fails due to not enough disk space */
  ErrorTypes["noDiskSpace"] = "noDiskSpace";
  /** When the update fails to copy a file over */
  ErrorTypes["failToCopyFile"] = "failToCopyFile";
  /** When an error occurs writing the version file */
  ErrorTypes["failToWriteVersion"] = "failToWriteVersion";
  /** When there is a permission error working on a file */
  ErrorTypes["permissionError"] = "permissionError";
  /** When an error occurs deleting a file that is not a permission error */
  ErrorTypes["failToDelete"] = "failToDelete";
  /** When there is an error creating a symlink */
  ErrorTypes["symlinkError"] = "symlinkError";
  /** When there is an error generating a temporary file name */
  ErrorTypes["failToGenTempName"] = "failToGenTempName";
  /** When there is an error renaming a file due to the new name existing */
  ErrorTypes["fileExistsRename"] = "fileExistsRename";
  /** When there is not path to the target update from target to latest */
  ErrorTypes["noUpdatePath"] = "noUpdatePath";
  /** When there is an error serializing the update instance in an offline update */
  ErrorTypes["failToWriteUpdateInst"] = "failToWriteUpdateInst";
  /** When there an issue writing out the offline update as a zip */
  ErrorTypes["failToWriteZip"] = "failToWriteZip";
  /** When there is an issue writing out the updated file list */
  ErrorTypes["failToWriteUpdatedFileList"] = "failToWriteUpdatedFileList";
  /** When the vwupdate file to use does not exist */
  ErrorTypes["noVwupdateFile"] = "noVwupdateFile";
  /** When there is an issue extracting the offline update */
  ErrorTypes["offUpdateExtractionError"] = "offUpdateExtractionError";
  /** When there is an issue getting the serial number */
  ErrorTypes["cannotGetSerial"] = "cannotGetSerial";
  /** When there is an issue getting the install directory */
  ErrorTypes["cannotGetInstDir"] = "cannotGetInstDir";
  // The following occur in verify installation
  /** When an invalid platform is passed in */
  ErrorTypes["invalidPlatform"] = "invalidPlatform";
  /** When an invalid serial is passed in */
  ErrorTypes["invalidSerial"] = "invalidSerial";
  /** When a serial is passed in that does not match the regular expressions */
  ErrorTypes["invalidSerialRegex"] = "invalidSerialRegex";
  /** When the serial could not be found */
  ErrorTypes["noSerial"] = "noSerial";
  /** When the application is broken in some way */
  ErrorTypes["appBroken"] = "appBroken";
  /** When we can't get a LDF  */
  ErrorTypes["noLDF"] = "noLDF";
  /** When the install directory could not be found */
  ErrorTypes["noInstDir"] = "noInstDir";
  /** When the version file cannot be found in the installation directory */
  ErrorTypes["noVersionFile"] = "noVersionFile";
  /** When the updater fails to update itself */
  ErrorTypes["updaterUpdateError"] = "updaterUpdateError";
  /** When no update information is available, usually means check for updates hasnt been callde */
  ErrorTypes["noUpdateInfo"] = "noUpdateInfo";
  /** When an error occurs registering a dll in the update hooks */
  ErrorTypes["dllRegFailure"] = "dllRegFailure";
  /** When fetching an update location fails */
  ErrorTypes["cannotGetLookupLocation"] = "cannotGetLookupLocation";
  /** When the delta file does not parse to what is expected */
  ErrorTypes["invalidDeltaFile"] = "invalidDeltaFile";
  /** When the update location on the file is not in installInfo */
  ErrorTypes["missingLocation"] = "missingLocation";
  /** When shouldInstall fails */
  ErrorTypes["shouldInstallFailed"] = "shouldInstallFailed";
  /** When VWIMHelper run fails */
  ErrorTypes["VWIMHelperRunFailed"] = "VWIMHelperRunFailed";
  /** When the selected directory cannot be verified by os-utils */
  ErrorTypes["cannotVerifyInstDir"] = "cannotVerifyInstDir";
  /** When the output of getEulaType is invalid */
  ErrorTypes["invalidEulaOutput"] = "invalidEulaOutput";
  /** When the output of getReadmeType is invalid */
  ErrorTypes["invalidReadMeOutput"] = "invaliidReadMeOutput";
  /** When the latest YML data for an updater update is invalid*/
  ErrorTypes["invalidLatestYml"] = "invalidLatestYml";
  /** When the vwupdate file is incompatible with the current install */
  ErrorTypes["incompatibleVwupdate"] = "incompatibleVwupdate";
  /** When the user fails to give permissions to the Updater */
  ErrorTypes["elevateError"] = "elevateError";
  /** When the install directory (or any directory we need to write to) is read-only */
  ErrorTypes["directoryReadOnlyError"] = "directoryReadOnlyError";
  /** When the install directory (or any directory we need to write to) gives "operation not permitted" typically on Mac due to needing Full Disk Access */
  ErrorTypes["directoryWriteNotPermitted"] = "directoryWriteNotPermitted";
  /** When the install directory (or any directory we need to write to) test gives any other error */
  ErrorTypes["directoryWriteErrorOther"] = "directoryWriteErrorOther";
})(ErrorTypes || (exports.ErrorTypes = ErrorTypes = {}));
/**
 * Enum for the scopes of plists
 *
 * These are used to describe where a plist is, either in the user's scope or for the entire
 * machine. User scoped plists are in '~/Library/Preferences' and system scoped are in
 * '/Preferences'.
 *
 * @enum {string}
 */
var PlistScopes;
(function (PlistScopes) {
  /** A plist in the user folder */
  PlistScopes["user"] = "user";
  /** A plist for the OSX system */
  PlistScopes["system"] = "system";
})(PlistScopes || (exports.PlistScopes = PlistScopes = {}));
/**
 * The time in miliseconds each fake interval increment is emitted
 * @constant {number}
 */
exports.FAKE_INTERVAL_TIME = 150;
/**
 * The time in milisecond spent waiting for an empty update
 * @constant {number}
*/
exports.FAKE_UPDATE_WAIT = 15 * 1000;
/**
 * Enum for the registry locations on Windows
 *
 * Represents the registry hives on Windows
 *
 * @enum {string}
 */
var RegistryValues;
(function (RegistryValues) {
  /** Local Machine - HKEY_LOCAL_MACHINE */
  RegistryValues["HKLM"] = "HKLM";
  /** Current User - HKEY_CURRENT_USER*/
  RegistryValues["HKCU"] = "HKCU";
  /** Classes Root Registry - HKEY_CLASSES_ROOT*/
  RegistryValues["HKCR"] = "HKCR";
  /* Users registry (All users) - HKEY_USERS */
  RegistryValues["HKU"] = "HKU";
})(RegistryValues || (exports.RegistryValues = RegistryValues = {}));
/**
 * Enum for the types of Eulas that shouldInstall can return
 *
 * The value is what shouldInstall will output to stdout when ran depending on the inputted
 * serial number.
 *
 * @enum {string}
 */
var EulaTypes;
(function (EulaTypes) {
  /** Educational Eula */
  EulaTypes["educational"] = "EDUCATIONAL";
  /** Professional Eula */
  EulaTypes["professional"] = "PROFESSIONAL";
  /** Not For Resale Eula */
  EulaTypes["nfr"] = "NFR_AND_EVAL";
  /** Evaluation Eula */
  EulaTypes["eval"] = "TRIAL";
  /** Viewer Eula */
  EulaTypes["viewer"] = "VIEWER";
})(EulaTypes || (exports.EulaTypes = EulaTypes = {}));
/**
 * Enum for the type of readme that shouldInstall can return
 *
 * The value is what shouldInstall will output to stdout when ran depending on the serial number.
 *
 * @enum {string}
 */
var ReadMeTypes;
(function (ReadMeTypes) {
  /** Series B */
  ReadMeTypes["b"] = "B";
  /** Series E */
  ReadMeTypes["e"] = "E";
  /** Series G */
  ReadMeTypes["g"] = "G";
  /** Generic/Default Eula */
  ReadMeTypes["generic"] = "GENERIC";
  /** Viewer Readme */
  ReadMeTypes["v"] = "V";
})(ReadMeTypes || (exports.ReadMeTypes = ReadMeTypes = {}));
/**
 * The Update Location for the main directory.
 *
 * All files without a specificed updated location re updated here. The value is what should be
 * used in the updater settings file as the key in updateLocations.
 *
 * @constant {string}
 */
exports.MAIN_DIR = 'mainDir';
/**
 * Maps each product to an uppercased english name
 *
 * @enum {string}
 */
exports.productToString = (_exports$productToStr = {}, _defineProperty(_exports$productToStr, Products.vectorworks, 'Vectorworks'), _defineProperty(_exports$productToStr, Products.vision, 'Vision'), _exports$productToStr);
/**
 * The types of registry values to be fetched
 *
 * These are here for completeness but it is important to note only REG_SZ and REG_DWORD are used
 * currently.
 *
 * REG_DWORD will be read/wrote as an integer, REG_SZ is a null terminated string.
 *
 * @enum {string}
 */
var RegistryValueTypes;
(function (RegistryValueTypes) {
  /** UNUSED */
  RegistryValueTypes["REG_BINARY"] = "REG_BINARY";
  /** Integer */
  RegistryValueTypes["REG_DWORD"] = "REG_DWORD";
  /** UNUSED */
  RegistryValueTypes["REG_QWORD"] = "REG_QWORD";
  /** UNUSED */
  RegistryValueTypes["REG_DWORD_LITTLE_ENDIAN"] = "REG_DWORD_LITTLE_ENDIAN";
  /** UNUSED */
  RegistryValueTypes["REG_QWORD_LITTLE_ENDIAN"] = "REG_QWORD_LITTLE_ENDIAN";
  /** UNUSED */
  RegistryValueTypes["REG_DWORD_BIG_ENDIAN"] = "REG_DWORD_BIG_ENDIAN";
  /** UNUSED */
  RegistryValueTypes["REG_EXPAND_SZ"] = "REG_EXPAND_SZ";
  /** UNUSED */
  RegistryValueTypes["REG_LINK"] = "REG_LINK";
  /** UNUSED */
  RegistryValueTypes["REG_MULTI_SZ"] = "REG_MULTI_SZ";
  /** UNUSED */
  RegistryValueTypes["REG_NONE"] = "REG_NONE";
  /** UNUSED */
  RegistryValueTypes["REG_RESOURCE_LIST"] = "REG_RESOURCE_LIST";
  /** Null terminated string */
  RegistryValueTypes["REG_SZ"] = "REG_SZ";
})(RegistryValueTypes || (exports.RegistryValueTypes = RegistryValueTypes = {}));
var InitialModes;
(function (InitialModes) {
  InitialModes["none"] = "none";
  InitialModes["installer"] = "installer";
  InitialModes["updater"] = "updater";
})(InitialModes || (exports.InitialModes = InitialModes = {}));

/***/ }),

/***/ 94515:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }
function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct.bind(); } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _isNativeFunction(fn) { return Function.toString.call(fn).indexOf("[native code]") !== -1; }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CancelError = exports.isBaseError = exports.BaseError = exports.stripError = void 0;
/**
 * Removes environment variables from any errors.
 *
 * When child_process fails it will include the environment in the error. This can contain
 * sensitive data such as keys. This strips the error so none of that is logged.
 *
 * @param {{ [key: string]: any }} err - The error to strip.
 *
 * @return {{ [key: string]: any }} - The stripped error.
 */
var stripError = function stripError(err) {
  var newError = Object.assign({}, err);
  if (newError && newError.envPairs) {
    delete newError.envPairs;
  }
  if (newError && newError.options && newError.options.envPairs) {
    delete newError.options.envPairs;
  }
  return newError;
};
exports.stripError = stripError;
/**
 * The base error class other classes extend off of
 *
 * @extends {Error}
 */
var BaseError = /*#__PURE__*/function (_Error) {
  _inherits(BaseError, _Error);
  var _super = _createSuper(BaseError);
  /**
   * Create a base error
   *
   * @param {string} message - The error message.
   * @param {ErrorTypes} type - The type of the error. This is used to map the error to a localized
   * string.
   * @param {any} [params] - Optional. Any extra parameters/data to attach to the error.
   */
  function BaseError(message, type, params) {
    var _this;
    _classCallCheck(this, BaseError);
    _this = _super.call(this, message);
    _this.message = message;
    _this.type = type;
    _this.keyList = [];
    var errorNames = ['Error', 'TypeError', 'EvalError', 'InternalError', 'RangeError', 'SyntaxError', 'ReferenceError', 'URIError'];
    if (params && errorNames.includes(params.name)) {
      // Store errors in the value originalError
      _this.originalError = (0, exports.stripError)(params);
      _this.keyList.push('originalError');
    } else if (params && _typeof(params) === 'object') {
      Object.keys(params).forEach(function (key) {
        var value;
        if (params[key] instanceof Error) {
          value = (0, exports.stripError)(params[key]);
        } else {
          value = params[key];
        }
        _this[key] = value;
        _this.keyList.push(key);
      });
    }
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(_assertThisInitialized(_this), _this.constructor);
    } else {
      _this.stack = new Error(message).stack;
    }
    return _this;
  }
  return _createClass(BaseError);
}( /*#__PURE__*/_wrapNativeSuper(Error));
exports.BaseError = BaseError;
/**
 * Type Guard for Base Error
 *
 * @param {any} error - The item to test
 *
 * @return {boolean} - True if item is a BaseError, false otherwise.
 */
var isBaseError = function isBaseError(error) {
  if (!(error instanceof Error)) {
    return false;
  }
  return error.type !== undefined;
};
exports.isBaseError = isBaseError;
/**
 * Error that represents an operation being cancelled.
 *
 * Used for flow control
 *
 * @extends {Error}
 */
var CancelError = /*#__PURE__*/function (_Error2) {
  _inherits(CancelError, _Error2);
  var _super2 = _createSuper(CancelError);
  function CancelError() {
    _classCallCheck(this, CancelError);
    return _super2.apply(this, arguments);
  }
  return _createClass(CancelError);
}( /*#__PURE__*/_wrapNativeSuper(Error));
exports.CancelError = CancelError;

/***/ }),

/***/ 31199:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getLISFromString = exports.getLISFromFile = exports.getLDFFromFile = exports.getLDF = exports.LDFErrorType = void 0;
var fs = __importStar(__webpack_require__(55674));
var path_1 = __importDefault(__webpack_require__(71017));
var childProcess = __importStar(__webpack_require__(32081));
var shouldinstall_runner_1 = __webpack_require__(18772);
var tmp = __importStar(__webpack_require__(36276));
var LDFErrorType;
(function (LDFErrorType) {
  LDFErrorType["LDFSuccess"] = "LDFSuccess";
  LDFErrorType["LDFVersionMismatch"] = "LDFVersionMismatch";
  LDFErrorType["LDFLicenseMismatch"] = "LDFLicenseMismatch";
  LDFErrorType["LDFDistributorMismatch"] = "LDFDistributorMismatch";
  LDFErrorType["LDFInvalidSignature"] = "LDFInvalidSignature";
  LDFErrorType["LDFGeneralFailure"] = "LDFGeneralFailure";
})(LDFErrorType || (exports.LDFErrorType = LDFErrorType = {}));
;
/**
 * Contains utilities for interacting with plists
 */
var LicenseDescription = /*#__PURE__*/function () {
  function LicenseDescription(logger, serialNumber, allowedDistributors, excludedDistributors) {
    var _this = this;
    _classCallCheck(this, LicenseDescription);
    // A helper function that will ensure the path exists and create it if not,
    // and write the string into the file.
    // filePath is the full path and filename.
    //
    this.writeLDFToFileSync = function (filePath) {
      var parentDir = path_1["default"].dirname(filePath);
      if (!fs.existsSync(parentDir)) {
        fs.mkdirSync(parentDir, '0777');
        _this.logInfo("writeLDFToFileSync() - LDF folder created at: ".concat(parentDir));
      }
      _this.logInfo("writeLDFToFileSync() - LDF folder: \"".concat(parentDir, "\" exists: ").concat(fs.existsSync(parentDir)));
      fs.writeFileSync(filePath, _this.fullText, {
        mode: '777'
      });
      _this.logInfo("writeLDFToFileSync() - Wrote LDF string to file: \"".concat(filePath, "\" exists: ").concat(fs.existsSync(filePath)));
      return true;
    };
    if (serialNumber) {
      this.serialNumber = serialNumber.trim().toUpperCase(); // Remove any spaces and convert to uppercase (uppercase is required)
    } else {
      this.serialNumber = serialNumber;
    }
    this.logger = logger;
    //this.licenseObject = {};
    this.localCurlPath = process.platform === 'darwin' ? 'curl' : 'curl.exe';
    this.major = '30';
    this.minor = '0';
    this.patch = '0';
    this.changelist = '0';
    this.brandedMajorVersion = '2025';
    this.fullText = '';
    this.LIS = '';
    this.ldfPath = '';
    this.errorType = LDFErrorType.LDFSuccess;
    this.isViewer = this.serialNumber !== undefined && this.serialNumber === 'VIEWER';
    if (this.isViewer) {
      this.LIS = 'VIEWER';
    }
    this.isDemo = this.serialNumber !== undefined && this.serialNumber === 'DEMO';
    if (this.isDemo) {
      this.LIS = 'DEMO';
    }
    if (allowedDistributors !== undefined) {
      this.allowedDistributors = allowedDistributors;
    } else {
      this.allowedDistributors = [];
    }
    if (excludedDistributors !== undefined) {
      this.excludedDistributors = excludedDistributors;
    } else {
      this.excludedDistributors = [];
    }
  }
  // This function should only be used to transfer the logger to a new object if we're creating one from an existing object.
  _createClass(LicenseDescription, [{
    key: "getLogger",
    value: function getLogger() {
      return this.logger;
    }
  }, {
    key: "logInfo",
    value: function logInfo(msg) {
      if (this.logger !== null) {
        this.logger.info(msg);
      }
    }
  }, {
    key: "stringify",
    value: function stringify() {
      var result = "LicenseDescription Object. major=".concat(this.major, ", minor=").concat(this.minor, ", patch=").concat(this.patch, ", changelist=").concat(this.changelist, ", brandedMajorVersion=").concat(this.brandedMajorVersion, ", localCurlPath=").concat(this.localCurlPath, ", licenseObject=").concat(JSON.stringify(this.licenseObject));
      return result;
    }
  }, {
    key: "isEmpty",
    value: function isEmpty() {
      return this.fullText.length === 0;
    }
  }, {
    key: "formattedHeader",
    value: function formattedHeader(headerSection) {
      var header = headerSection.replace(/-----BEGIN HEADER-----/, '').replace(/\r|\n/g, '');
      return header;
    }
  }, {
    key: "formattedDescription",
    value: function formattedDescription(descriptionSection) {
      var description = descriptionSection.replace(/-----BEGIN DESCRIPTION-----/, '');
      return JSON.parse(description);
    }
  }, {
    key: "formattedSignature",
    value: function formattedSignature(signatureSection) {
      var signature = signatureSection.replace(/-----END SIGNATURE-----| |\r|\n/g, '');
      return signature;
    }
  }, {
    key: "getProtection",
    value: function getProtection() {
      return this.licenseObject['description']['protection'];
    }
    // Download LDF and return the string representation of it. Does not parse it.
    // It's important to not modify this string because that will break any signature in it.
    // Returns empty s tring on error.
    //
  }, {
    key: "downloadLDF",
    value: function downloadLDF() {
      this.logInfo('Retrieving license description...');
      if (this.serialNumber) {
        // Build arguments for following command
        var replaceAll = function replaceAll(str, find, replace) {
          return str.replace(new RegExp(find, 'g'), replace);
        };
        this.logInfo("downloadLDF() - Serial was: ".concat(this.serialNumber));
        var licenseId = LicenseDescription.getLicenseIDFromSerial(this.serialNumber);
        if (licenseId === '') {
          this.logInfo("downloadLDF() - Unknown format for serial number: ".concat(this.serialNumber));
        } else {
          this.logInfo("downloadLDF() - Got licenseId: ".concat(licenseId));
        }
        // Sanitize command args
        var token = '2Gs4i4mdBwqkzfWHBrvq8CV3hr2c';
        var buildVersion = "".concat(this.major, ".").concat(this.minor, ".").concat(this.patch, "(").concat(this.changelist, ")"); // eg 28.0.0(234934)
        var requester = 'vectorworks';
        var data = "{\"branded-version\":\"".concat(this.brandedMajorVersion, "\",\"serial-number\":\"").concat(this.serialNumber, "\",\"build-version\":\"").concat(buildVersion, "\",\"requester\":\"").concat(requester, "\",\"license-id\": \"").concat(licenseId, "\"}");
        var dataArg = replaceAll(data, '"', '\\"');
        var curlPath = this.localCurlPath;
        var proxyInfo = this.proxyInfo;
        var curlEnv = {
          childEnv: process.env,
          prefix: ''
        };
        if (proxyInfo) {
          curlEnv = proxyInfo.getCURLEnv();
          this.logInfo("downloadLDF() - ProxyInfo was present. Using: ".concat(proxyInfo.getProxyUrl()));
        } else {
          this.logInfo('downloadLDF() - No Proxy present.');
        }
        var curlCA = process.platform === 'darwin' ? '' : '--ca-native ';
        var cmd = "\"".concat(curlPath, "\" ").concat(curlCA, " -v ").concat(curlEnv.prefix, " --request POST --url https://activation.vectorworks.net/get-license-description-file --header \"Authorization: Bearer ").concat(token, "\" --header \"Content-Type: application/json\" --data \"").concat(dataArg, "\"");
        this.logInfo("Calling command: ".concat(cmd));
        try {
          // Run curl command
          var command = childProcess.execSync(cmd, {
            env: curlEnv.childEnv,
            stdio: 'pipe'
          });
          var commandOuput = command.toString();
          this.logInfo("Curl command succeeded with: \n".concat(commandOuput));
          // Recover command output to update LDF contents.
          var downloadedLDFObject = JSON.parse(commandOuput);
          if (downloadedLDFObject["error-id"] === 'ok') {
            // Removing special characters and escaping along with trailing character.
            var formattedDownloadedObject = JSON.stringify(downloadedLDFObject["license-description-file"]).replace(/"/, '').replace(/-\n"/, '').replace(/\\n/g, '\n').replace(/\\/g, '');
            // I don't know why we're doing this trimming. Perhaps there's an extra character at the end?
            var trimmedString = formattedDownloadedObject.substring(0, formattedDownloadedObject.length - 1);
            return trimmedString;
          } else {
            // There was an error
            this.logInfo("Download failed with: ".concat(downloadedLDFObject["error-id"], " - ").concat(downloadedLDFObject["error-code"]));
            if (downloadedLDFObject["error-id"] === 'bad-request' && downloadedLDFObject["error-code"] === 'serial-number-branded-version-mismatch') {
              this.errorType = LDFErrorType.LDFVersionMismatch;
            }
            return '';
          }
        } catch (error) {
          this.logInfo("Download failed with: ".concat(error));
          return '';
        }
      } else {
        // Serial blank, undefined, or null
        this.logInfo("Could not retrieve license description. Serial number is: ".concat(this.serialNumber));
      }
      return '';
    }
  }, {
    key: "parseLDFFromString",
    value:
    // Parse the LDF info in the string (with 'header', 'description', 'signature')
    // This stores the parsed data in this.licenseObject.
    //
    function parseLDFFromString(fullLDFText) {
      var lines = [];
      this.logInfo('Parsing license description string...');
      try {
        // Parsing on section tags.
        var headerLine = fullLDFText.split(/-----END HEADER-----/);
        lines.push(headerLine[0]);
        var descriptionLine = headerLine[1].split(/-----END DESCRIPTION-----/);
        lines.push(descriptionLine[0]);
        var signatureLine = fullLDFText.split(/-----BEGIN SIGNATURE-----/);
        lines.push(signatureLine[1]);
        // Assign formatted sections to header, description, and signature
        this.header = this.formattedHeader(lines[0]);
        this.description = this.formattedDescription(lines[1]);
        this.signature = this.formattedSignature(lines[2]);
        this.licenseObject = {
          'header': this.header,
          'description': this.description,
          'signature': this.signature
        };
        this.logInfo("Parsing succeeded. Parsed object is: ".concat(JSON.stringify(this.licenseObject)));
      } catch (_a) {
        this.logInfo("Failed to parse license description string: ".concat(fullLDFText));
        this.logInfo("License object = ".concat(this.licenseObject));
      }
    }
    // Returns true if this appears to be a correct LDF.
    // Currently this does a simple check that required keys exist.
    // Note it does not currently validate the signature.
    //
  }, {
    key: "parsedDataIsValid",
    value: function parsedDataIsValid() {
      var _this2 = this;
      var result = false;
      if (this.licenseObject && 'header' in this.licenseObject && 'description' in this.licenseObject && 'signature' in this.licenseObject) {
        var requiredKeys = ['distributor', 'version', 'product', 'protection', 'license-type', 'modules'];
        if (requiredKeys.every(function (i) {
          return _this2.licenseObject['description'].hasOwnProperty(i);
        })) {
          result = true;
        }
      }
      return result;
    }
    // Generates the LicenseID from the LDFObject items (ie, from the actual License Description File)
    //
  }, {
    key: "computeLicenseID",
    value: function computeLicenseID() {
      var result = '';
      if ('eval-token' in this.description) {
        // licenseID = eval-token
        result = this.description['eval-token'];
      } else {
        if ('license-number' in this.description && 'distributor' in this.description) {
          result = this.description['distributor'] + '-' + this.description['license-number'];
        }
      }
      return result;
    }
    // Returns true if this object matches the input licenseID
    // if licenseID or serialNumber (arguments) are empty it won't check them.
    // licenseIDToCheck comes from the serial entered.
    //
  }, {
    key: "parsedDataMatchesLicense",
    value: function parsedDataMatchesLicense(licenseIDToCheck) {
      var computedLicenseID = this.computeLicenseID();
      return computedLicenseID === licenseIDToCheck;
    }
    // Helper function to get the distributor from the ldf.
  }, {
    key: "getDistributor",
    value: function getDistributor() {
      var ldfDistributor = '';
      if (!('eval-token' in this.description)) {
        // licenseID = eval-token
        if ('distributor' in this.description) {
          ldfDistributor = this.description['distributor'];
        }
      }
      return ldfDistributor;
    }
    // Returns true if this object matches the allowed/excluded distributor settings.
    //
  }, {
    key: "parsedDataMatchesAllowedDistributors",
    value: function parsedDataMatchesAllowedDistributors() {
      var ldfDistributor = '';
      if ('eval-token' in this.description) {
        // licenseID = eval-token
        return true; // We currently don't enforce eval token's distributor to match.
      } else {
        if ('distributor' in this.description) {
          ldfDistributor = this.description['distributor'];
        }
      }
      // First check that it's not excluded by this.excludedDistributors
      if (this.excludedDistributors && this.excludedDistributors.length > 0) {
        if (this.excludedDistributors.includes(ldfDistributor)) {
          return false;
        }
      }
      // Now if allowedDistributors is empty, or if it contains the distributor, then return true.
      if (this.allowedDistributors.length === 0 || this.allowedDistributors.includes(ldfDistributor)) {
        return true;
      }
      // If we got here, then it's not excluded but also not in the include list.
      return false;
    }
    // Read from the path and put the resulting items inside this.licenseObject
  }, {
    key: "parseLDFFromFile",
    value: function parseLDFFromFile(fullLDFPath) {
      try {
        var allLDFContent = fs.readFileSync(fullLDFPath, 'utf-8');
        this.fullText = allLDFContent;
        this.parseLDFFromString(allLDFContent);
      } catch (_a) {
        this.logInfo("Failed to parse license description file. Attempted parsing at: ".concat(fullLDFPath));
        this.logInfo("License object = ".concat(this.licenseObject));
      }
    }
    // Given a serialNumber, generate and return the licenseID for it.
    // Note that this doesn't add an extension for the LDF filename. It
    // only returns something like "US-ABCDEF".
    //
  }], [{
    key: "getLicenseIDFromSerial",
    value: function getLicenseIDFromSerial(serialNumber) {
      var licenseID = '';
      if (serialNumber.toLowerCase().startsWith('vweval')) {
        serialNumber = "VWEval" + serialNumber.slice(6); // Enforce  proper casing for VWEval. This is required.
        licenseID = serialNumber;
      } else {
        var splitSerial = serialNumber.split('-');
        if (splitSerial.length == 4) {
          var distributor = splitSerial[0].substring(3, 5);
          licenseID = distributor + '-' + splitSerial[3];
        }
      }
      return licenseID;
    }
  }]);
  return LicenseDescription;
}(); // end of LicenseDescription class.
// Try to load LDF file from passed in folder. Returns a LicenseDescripton object if successful or null if not.
// This should generally only be called by getLDF.
var getLDF_FromFile = function getLDF_FromFile(serial, userFolder, versionInfo, curlPath, logger, allowedDistributors, excludedDistributors, proxyInfo) {
  logger.info("getLDF_FromFile(): Starting for folder ".concat(userFolder, "."));
  var parsedSuccessfully = false;
  var ldo = new LicenseDescription(logger, serial, allowedDistributors, excludedDistributors);
  if (ldo.isViewer) {
    // Viewer is special
    parsedSuccessfully = true;
  } else if (ldo.isDemo) {
    // Demo is special
    parsedSuccessfully = true;
  } else if (serial) {
    var ldfFolder = userFolder;
    var licenseID = LicenseDescription.getLicenseIDFromSerial(serial);
    var ldfName = licenseID + '.ldf';
    ldo.major = versionInfo.major.toString();
    ldo.minor = versionInfo.minor.toString();
    ldo.patch = versionInfo.patch.toString();
    ldo.changelist = versionInfo.changelist.toString();
    ldo.brandedMajorVersion = (versionInfo.major + 1995).toString(); // eg 30 -> 2025
    ldo.localCurlPath = curlPath;
    if (proxyInfo) {
      ldo.proxyInfo = proxyInfo;
    }
    var ldfFullPathUserFolder = ldfFolder !== '' ? path_1["default"].join(ldfFolder, ldfName) : '';
    if (ldfFullPathUserFolder !== '' && fs.existsSync(ldfFullPathUserFolder)) {
      logger.info("getLDF_FromFile(): Trying filepath: ".concat(ldfFullPathUserFolder));
      ldo.parseLDFFromFile(ldfFullPathUserFolder);
      if (ldo.parsedDataIsValid()) {
        if (ldo.parsedDataMatchesLicense(licenseID)) {
          if (ldo.parsedDataMatchesAllowedDistributors()) {
            parsedSuccessfully = true;
            ldo.ldfPath = ldfFullPathUserFolder;
          } else {
            var ldoDistributor = ldo.getDistributor();
            logger.info("getLDF_FromFile(): parsed data distributor \"".concat(ldoDistributor, "\" does not match allowed distributors: (included: ").concat(ldo.allowedDistributors, ", excluded: ").concat(ldo.excludedDistributors, "). Returning empty LicenseDescription."));
            ldo = new LicenseDescription(logger, serial, allowedDistributors, excludedDistributors); // Clear it out.
            ldo.errorType = LDFErrorType.LDFDistributorMismatch;
          }
        } else {
          logger.info("getLDF_FromFile(): parsed data license \"".concat(licenseID, "\" does not match serial: ").concat(serial, ". Returning empty LicenseDescription."));
          ldo = new LicenseDescription(logger, serial, allowedDistributors, excludedDistributors); // Clear it out.
          ldo.errorType = LDFErrorType.LDFLicenseMismatch;
          ;
        }
      } else {
        logger.info("getLDF_FromFile(): parsedData invalid.");
      }
    } else {
      logger.info("getLDF_FromFile(): No LDF file at: ".concat(ldfFullPathUserFolder, "."));
    }
  }
  if (parsedSuccessfully) {
    logger.info("getLDF_FromFile(): returning successfully parsed LicenseDescription object.");
    return Promise.resolve(ldo);
  }
  logger.info("getLDF_FromFile(): unable to find or parse LicenseDescription object at ".concat(userFolder, "."));
  return Promise.resolve(null);
};
// Try to load LDF file from the internet. Returns a LicenseDescripton object if successful or null if not.
// This should generally only be called by getLDF.
var getLDF_FromNet = function getLDF_FromNet(serial, versionInfo, curlPath, logger, allowedDistributors, excludedDistributors, proxyInfo) {
  logger.info("getLDF_FromNet(): Starting.");
  var parsedSuccessfully = false;
  var ldo = new LicenseDescription(logger, serial, allowedDistributors, excludedDistributors);
  if (ldo.isViewer) {
    // Viewer is special
    parsedSuccessfully = true;
  } else if (ldo.isDemo) {
    // Demo is special
    parsedSuccessfully = true;
  } else if (serial) {
    var licenseID = LicenseDescription.getLicenseIDFromSerial(serial);
    ldo.major = versionInfo.major.toString();
    ldo.minor = versionInfo.minor.toString();
    ldo.patch = versionInfo.patch.toString();
    ldo.changelist = versionInfo.changelist.toString();
    ldo.brandedMajorVersion = (versionInfo.major + 1995).toString(); // eg 30 -> 2025
    ldo.localCurlPath = curlPath;
    if (proxyInfo) {
      ldo.proxyInfo = proxyInfo;
    }
    // file didn't work so try to download it...
    logger.info('getLDF_FromNet(): Trying to download ldf to a string.');
    var ldString = ldo.downloadLDF();
    logger.info("getLDF_FromNet(): Done downloading LDF.");
    ldo.fullText = ldString;
    ldo.parseLDFFromString(ldString);
    if (ldo.parsedDataIsValid()) {
      if (ldo.parsedDataMatchesLicense(licenseID)) {
        if (ldo.parsedDataMatchesAllowedDistributors()) {
          parsedSuccessfully = true;
        } else {
          var ldoDistributor = ldo.getDistributor();
          logger.info("getLDF_FromNet(): parsed data distributor \"".concat(ldoDistributor, "\" does not match allowed distributors: (included: ").concat(ldo.allowedDistributors, ", excluded: ").concat(ldo.excludedDistributors, "). Returning empty LicenseDescription."));
          ldo = new LicenseDescription(logger, serial, allowedDistributors, excludedDistributors); // Clear it out.
          ldo.errorType = LDFErrorType.LDFDistributorMismatch;
        }
      } else {
        logger.info("getLDF_FromNet(): downloaded parsed data license \"".concat(licenseID, "\" does not match serial: ").concat(serial, ". Returning empty LicenseDescription."));
        ldo = new LicenseDescription(logger, serial, allowedDistributors, excludedDistributors); // Clear it out.
        ldo.errorType = LDFErrorType.LDFLicenseMismatch;
      }
    }
  }
  if (parsedSuccessfully) {
    logger.info("getLDF_FromNet(): returning successfully parsed LicenseDescription object.");
    return Promise.resolve(ldo);
  }
  logger.info("getLDF_FromNet(): unable to find or parse LicenseDescription object from network.");
  return Promise.resolve(null);
};
// Try to load LDF file. If failure, try to download it.
// If userFolder is empty string, do not try to load it from file (but will still try to download it)
// On success returns the licenseObject member of the LicenseDescription
// On failure will return empty object - that is, a ldo where isViewer and isDemo are false and isEmpty() is true.
// On successful load from a file, this will set this ldfPath to the path used to load.
//
var getLDF = function getLDF(downloadPreference, serial, userFolder, versionInfo, curlPath, logger, allowedDistributors, excludedDistributors, proxyInfo) {
  logger.info("getLDF(): serial was ".concat(serial, ", userFolder was ").concat(userFolder, ", downloadPreference was ").concat(downloadPreference, ", versionInfo was ").concat(JSON.stringify(versionInfo), "."));
  var ldoDefault = new LicenseDescription(logger, serial, allowedDistributors, excludedDistributors);
  if (ldoDefault.isViewer) {
    logger.info("getLDF(): Viewer serial. Returning viewer LicenseDescription object.");
    return Promise.resolve(ldoDefault);
  } else if (ldoDefault.isDemo) {
    logger.info("getLDF(): Demo serial. Returning demo LicenseDescription object.");
    return Promise.resolve(ldoDefault);
  }
  return Promise.resolve().then(function () {
    if (downloadPreference === 'preferFile' || downloadPreference === 'onlyFile') {
      return getLDF_FromFile(serial, userFolder, versionInfo, curlPath, logger, allowedDistributors, excludedDistributors, proxyInfo);
    } else {
      return getLDF_FromNet(serial, versionInfo, curlPath, logger, allowedDistributors, excludedDistributors, proxyInfo);
    }
  }).then(function (ldo) {
    if (ldo !== null) {
      // We got it. Return it.
      logger.info("getLDF(): returning successful LicenseDescription object from first attempt: ".concat(JSON.stringify(ldo.licenseObject), "."));
      return Promise.resolve(ldo);
    } else {
      // Try the other method for prefer preferences.
      if (downloadPreference === 'preferFile') {
        logger.info("getLDF(): File-based attempt failed to successfully get an LDF. Trying network method.");
        return getLDF_FromNet(serial, versionInfo, curlPath, logger, allowedDistributors, excludedDistributors, proxyInfo);
      } else if (downloadPreference === 'preferDownload') {
        logger.info("getLDF(): Network attempt failed to successfully get an LDF. Trying file-based method.");
        return getLDF_FromFile(serial, userFolder, versionInfo, curlPath, logger, allowedDistributors, excludedDistributors, proxyInfo);
      } else {
        logger.info("getLDF(): Single method (".concat(downloadPreference, ") failed to successfully get an LDF. Returning empty LDO."));
        return Promise.resolve(ldo);
      }
    }
  }).then(function (ldo) {
    if (ldo !== null) {
      // We got it. Return it.
      logger.info("getLDF(): returning successful LicenseDescription object.");
      return Promise.resolve(ldo);
    } else {
      // We didn't get it. Return an empty one.
      logger.info("getLDF(): returning empty LicenseDescription object.");
      return Promise.resolve(ldoDefault);
    }
  });
};
exports.getLDF = getLDF;
// Try to load LDF file from a file path.
// On success returns the licenseObject member of the LicenseDescription
// On failure will return empty object
// On success this will set this ldfPath to the path used to load.
//
var getLDFFromFile = function getLDFFromFile(serial, ldfFilePath, versionInfo, logger, allowedDistributors, excludedDistributors) {
  logger.info("getLDFFromFile(): serial was ".concat(serial, ", ldfFilePath was ").concat(ldfFilePath, ", versionInfo was ").concat(JSON.stringify(versionInfo), "."));
  var parsedSuccessfully = false;
  var ldo = new LicenseDescription(logger, serial, allowedDistributors, excludedDistributors);
  if (ldo.isViewer) {
    // Viewer is special
    parsedSuccessfully = true;
  } else if (ldo.isDemo) {
    // Demo is special
    parsedSuccessfully = true;
  } else {
    if (serial) {
      ldo.major = versionInfo.major.toString();
      ldo.minor = versionInfo.minor.toString();
      ldo.patch = versionInfo.patch.toString();
      ldo.changelist = versionInfo.changelist.toString();
      ldo.brandedMajorVersion = (versionInfo.major + 1995).toString(); // eg 30 -> 2025    
      logger.info("getLDFFromFile(): called LicenseDescription constructor. Got ".concat(ldo.stringify(), "."));
      if (fs.existsSync(ldfFilePath)) {
        logger.info("getLDFFromFile(): parsing from filepath: ".concat(ldfFilePath));
        ldo.parseLDFFromFile(ldfFilePath);
        if (ldo.parsedDataIsValid()) {
          var licenseID = LicenseDescription.getLicenseIDFromSerial(serial);
          if (ldo.parsedDataMatchesLicense(licenseID)) {
            if (ldo.parsedDataMatchesAllowedDistributors()) {
              parsedSuccessfully = true;
              ldo.ldfPath = ldfFilePath;
            } else {
              var ldoDistributor = ldo.getDistributor();
              logger.info("getLDF(): parsed data distributor \"".concat(ldoDistributor, "\" does not match allowed distributors: (included: ").concat(ldo.allowedDistributors, ", excluded: ").concat(ldo.excludedDistributors, "). Returning empty LicenseDescription."));
              ldo = new LicenseDescription(logger, serial, allowedDistributors, excludedDistributors); // Clear it out.
              ldo.errorType = LDFErrorType.LDFDistributorMismatch;
            }
          } else {
            logger.info("getLDFFromFile(): parsed data license \"".concat(licenseID, "\" does not match serial: ").concat(serial, ". Returning empty LicenseDescription."));
            ldo = new LicenseDescription(logger, serial, allowedDistributors, excludedDistributors); // Clear it out.
            ldo.errorType = LDFErrorType.LDFLicenseMismatch;
          }
        } else {
          logger.info("getLDFFromFile(): parsedData invalid.");
        }
      }
    }
  }
  logger.info("getLDFFromFile(): returning: ".concat(JSON.stringify(ldo.licenseObject), " (parsedSuccessfully? ").concat(parsedSuccessfully, ")."));
  return Promise.resolve(ldo);
};
exports.getLDFFromFile = getLDFFromFile;
// Given a LDF File, call ShouldInstall to get a LIS from it.
// Returns the output of ShouldInstall which is hopefully a LIS string.
//
var getLISFromFile = function getLISFromFile(ldfFilePath, shouldInstallPath, logger) {
  logger.info("getLISFromFile(): ldfFilePath was ".concat(ldfFilePath, "."));
  var args = ['vw_get_lis', "".concat(ldfFilePath.trim())];
  var shouldInstallRunner = new shouldinstall_runner_1.ShouldInstallRunner(shouldInstallPath, logger);
  return shouldInstallRunner.runShouldInstall(args).then(function (output) {
    var stdout = output.stdout.trim();
    logger.info("getLISFromFile(): got output: ".concat(stdout, "."));
    return Promise.resolve(stdout);
  });
};
exports.getLISFromFile = getLISFromFile;
// Given a LDF File represented as a string in memory, call ShouldInstall to get a LIS from it.
// Returns the output of ShouldInstall which is hopefully a LIS string.
//
var getLISFromString = function getLISFromString(fullLDFString, shouldInstallPath, logger) {
  var tempPathInfo = process.env['VWIM_TMP_PATH'] || undefined;
  var tempName = tmp.tmpNameSync({
    tmpdir: tempPathInfo
  });
  logger.info("getLISFromString(): called. Saving string into ".concat(tempName, "."));
  fs.writeFileSync(tempName, fullLDFString);
  var args = ['vw_get_lis', "".concat(tempName)];
  var shouldInstallRunner = new shouldinstall_runner_1.ShouldInstallRunner(shouldInstallPath, logger);
  return shouldInstallRunner.runShouldInstall(args).then(function (output) {
    var stdout = output.stdout.trim();
    logger.info("getLISFromString(): got output: ".concat(stdout, "."));
    fs.unlinkSync(tempName);
    return Promise.resolve(stdout);
  });
};
exports.getLISFromString = getLISFromString;
exports["default"] = LicenseDescription;

/***/ }),

/***/ 31507:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


/**
 * This module impelemnts the LicenseInfo interface.
 *
 */
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var shouldinstall_runner_1 = __webpack_require__(18772);
var LicenseInfo = /*#__PURE__*/function () {
  function LicenseInfo(serialNumber, logger, LDFObject, shouldInstallPath, allowedDistributors, excludedDistributors) {
    _classCallCheck(this, LicenseInfo);
    this.toString = function () {
      return "LicenseInfo class"; // (serialNumber: ${this.serialNumber}, LDFObject: ${JSON.stringify(this.LDFObject)}, LIS: ${this.LIS}, logger: ${this.logger === null ? "null" : "present"}, shouldInstallPath: ${this.shouldInstallPath})`;
    };

    this.serialNumber = serialNumber;
    this.logger = logger;
    this.LDFObject = LDFObject;
    this.shouldInstallPath = shouldInstallPath;
    this.allowedDistributors = allowedDistributors;
    this.excludedDistributors = excludedDistributors;
  }
  _createClass(LicenseInfo, [{
    key: "logInfo",
    value: function logInfo(msg) {
      if (this.logger !== null) {
        this.logger.info(msg);
      }
    }
  }, {
    key: "checkComponents",
    value: function checkComponents(componentsString) {
      var _this = this;
      this.logInfo("LicenseInfo::checkComponents(): Called with components: ".concat(componentsString));
      if (componentsString.trim() === '') {
        return Promise.resolve(true); // it is vacuously true.
      }
      // Supports platform-win and platform-mac.
      var ourPlatform = process.platform === 'darwin' ? 'platform-mac' : 'platform-win';
      componentsString = componentsString.replaceAll(ourPlatform, '1');
      componentsString = componentsString.replaceAll(/platform-[^\s()]+/g, '0'); // all other platforms are false
      // Supports license-DD-XXXXXX.
      if ((!this.LDFObject.isEmpty() && this.LDFObject.LIS) !== '') {
        var ourLicense = "license-".concat(this.LDFObject.computeLicenseID());
        componentsString = componentsString.replaceAll(ourLicense, '1');
        componentsString = componentsString.replaceAll(/license-[^\s()]+/g, '0'); // all other licenses are false
      }

      var shouldInstallSerialOrLIS = (!this.LDFObject.isEmpty() && this.LDFObject.LIS) !== '' ? this.LDFObject.LIS : this.serialNumber;
      if (shouldInstallSerialOrLIS !== '') {
        this.logInfo("LicenseInfo::checkComponents(): passing serial or LIS: ".concat(shouldInstallSerialOrLIS, "."));
        var args = ["".concat(shouldInstallSerialOrLIS), "".concat(componentsString)];
        var shouldInstallRunner = new shouldinstall_runner_1.ShouldInstallRunner(this.shouldInstallPath, this.logger);
        return shouldInstallRunner.runShouldInstall(args).then(function (output) {
          var stdout = output.stdout.trim();
          _this.logInfo("LicenseInfo::checkComponents(): got output: ".concat(stdout, "."));
          return Promise.resolve(stdout === '1');
        });
      } else {
        this.logInfo("LicenseInfo::checkComponents(): no serial or LIS. Returning true.");
        return Promise.resolve(true);
      }
    }
  }, {
    key: "checkComponentsSync",
    value: function checkComponentsSync(componentsString) {
      this.logInfo("LicenseInfo::checkComponentsSync(): Called with components: ".concat(componentsString));
      if (componentsString.trim() === '' || componentsString.trim() === '1') {
        return true; // it is vacuously true or trivially true.
      }

      if (componentsString.trim() === '0') {
        return false; // it is trivially false.
      }
      // Make sure any parentheses are separated by spaces then split it into words
      var testComponents = componentsString.replaceAll('(', ' ( ').replaceAll(')', ' ) ').replaceAll(/\s+/g, ' ').trim().toLowerCase().split(' ');
      // Check if testComponents contains nothing but 1, 0, "and", "or", "(", ")". If it does, we can evaluate it here
      if (testComponents.every(function (element) {
        return ['1', '0', 'and', 'or', '(', ')'].includes(element);
      })) {
        // Create a string called expression that is the concatenation of all elements in testComponents
        var safeExpressionString = testComponents.join(' ').replaceAll('and', '&&').replaceAll('or', '||');
        // Evaluate expressionString into true/false
        this.logInfo("LicenseInfo::checkComponentsSync(): expressionString: ".concat(safeExpressionString));
        try {
          var evaluatedExpression = !!eval(safeExpressionString);
          this.logInfo("LicenseInfo::checkComponentsSync(): expression evaluated to: ".concat(evaluatedExpression));
          return evaluatedExpression;
        } catch (e) {
          this.logInfo("LicenseInfo::checkComponentsSync(): Error caught evaluating expression. Returning false.");
          return false;
        }
      }
      // Supports platform-win and platform-mac.
      var ourPlatform = process.platform === 'darwin' ? 'platform-mac' : 'platform-win';
      componentsString = componentsString.replaceAll(ourPlatform, '1');
      componentsString = componentsString.replaceAll(/platform-[^\s()]+/g, '0'); // all other platforms are false
      // Supports licID-DD-XXXXXX.
      if (!this.LDFObject.isEmpty() && this.LDFObject.LIS !== '') {
        var ourLicense = "licID-".concat(this.LDFObject.computeLicenseID());
        componentsString = componentsString.replaceAll(ourLicense, '1');
        componentsString = componentsString.replaceAll(/licID-[^\s()]+/g, '0'); // all other licenses are false
      }

      var shouldInstallSerialOrLIS = (!this.LDFObject.isEmpty() && this.LDFObject.LIS) !== '' ? this.LDFObject.LIS : this.serialNumber;
      if (shouldInstallSerialOrLIS !== '') {
        this.logInfo("LicenseInfo::checkComponentsSync(): passing serial or LIS: ".concat(shouldInstallSerialOrLIS, "."));
        var args = ["".concat(shouldInstallSerialOrLIS), "".concat(componentsString)];
        try {
          var shouldInstallRunner = new shouldinstall_runner_1.ShouldInstallRunner(this.shouldInstallPath, this.logger);
          var siOut;
          siOut = shouldInstallRunner.runShouldInstallSync(args);
          var returnString = siOut.stdout.trim();
          this.logInfo("LicenseInfo::checkComponentsSync(): got return string: ".concat(returnString, "."));
          return returnString == '1';
        } catch (_a) {
          this.logInfo("LicenseInfo::checkComponentsSync(): Error caught calling shouldInstall. Returning true.");
          return true;
        }
      }
      this.logInfo("LicenseInfo::checkComponentsSync(): no serial or LIS. Returning true.");
      return true; // default
    }
  }]);
  return LicenseInfo;
}();
exports["default"] = LicenseInfo;

/***/ }),

/***/ 70181:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, defineProperty = Object.defineProperty || function (obj, key, desc) { obj[key] = desc.value; }, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return defineProperty(generator, "_invoke", { value: makeInvokeMethod(innerFn, self, context) }), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; defineProperty(this, "_invoke", { value: function value(method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; } function maybeInvokeDelegate(delegate, context) { var methodName = context.method, method = delegate.iterator[methodName]; if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel; var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), defineProperty(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (val) { var object = Object(val), keys = []; for (var key in object) keys.push(key); return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __awaiter = this && this.__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }
  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Logger = exports.FileTransport = exports.StdoutTransport = exports.Transport = exports.LogFileSinks = exports.createSink = exports.stdoutFormat = exports.logFileFormat = exports.printPrimitive = exports.disableLogging = exports.LogLevels = void 0;
/**
 * Contains a Winston-esque logger and classes associated with it
 */
var fs = __importStar(__webpack_require__(55674));
var stream = __importStar(__webpack_require__(12781));
var os_1 = __webpack_require__(22037);
var errors_1 = __webpack_require__(94515);
var debug = __webpack_require__(15158)('vw-logger');
/* tslint:disable:function-name no-console */
/**
 * Enumeration for logging levels
 *
 * Higher levels include all of the levels with a lower numerical value than it. I.E. verbose will
 * log info, warn, error, stdout logs but not debug logs.
 *
 * @enum {number}
 */
var LogLevels;
(function (LogLevels) {
  LogLevels[LogLevels["stdout"] = 0] = "stdout";
  LogLevels[LogLevels["error"] = 1] = "error";
  LogLevels[LogLevels["warn"] = 2] = "warn";
  LogLevels[LogLevels["info"] = 3] = "info";
  LogLevels[LogLevels["verbose"] = 4] = "verbose";
  LogLevels[LogLevels["debug"] = 5] = "debug";
})(LogLevels || (exports.LogLevels = LogLevels = {}));
/**
 * Controls logging in development builds
 */
exports.disableLogging = Boolean( false && 0);
/**
 * Recursively formats input to be outputted as logging format.
 *
 * Will pretty print Errors, objects, or other values. As nested objects are inspected spacing
 * is handled appropriately.
 *
 * @param {any} value - The value to pretty print.
 * @param {number} [level=1] - The depth level, this should NOT be passed in.
 *
 * @returns {string} - A string of value pretty printed.
 */
var printPrimitive = function printPrimitive(value) {
  var level = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
  if (value instanceof Logger) {
    // Loggers are super deep and will spam the log so just print that it's a logger.
    return 'logger object';
  }
  if (_typeof(value) === 'object' && value !== null) {
    if (Array.isArray(value)) {
      var _objectRep = value.map(function (v) {
        return (0, exports.printPrimitive)(v, level + 1);
      }).join(",\n".concat(' '.repeat(level * 2 + 2)));
      return "[\n".concat(' '.repeat(level * 2 + 2)).concat(_objectRep, "\n").concat(' '.repeat(level * 2), "]");
    }
    if (value instanceof Error) {
      var splitStack = value.stack ? value.stack.split('\n') : ['No stack available'];
      var stackString = splitStack.join("\n".concat(' '.repeat(level * 2 + 2)));
      if ((0, errors_1.isBaseError)(value)) {
        var keyList = value.keyList;
        var _objectRep2 = keyList.map(function (key) {
          return "".concat(key, ": ").concat((0, exports.printPrimitive)(value[key], level + 1));
        }).join("\n".concat(' '.repeat(level * 2 + 2)));
        return "{\n".concat(' '.repeat(level * 2 + 2)).concat(stackString, "\n").concat(' '.repeat(level * 2 + 2)).concat(_objectRep2, "\n").concat(' '.repeat(level * 2), "},");
      }
      return "{\n".concat(' '.repeat(level * 2 + 2)).concat(stackString, "\n").concat(' '.repeat(level * 2), "},");
    }
    var objectRep = Object.keys(value).map(function (key) {
      return "".concat(key, ": ").concat((0, exports.printPrimitive)(value[key], level + 1));
    }).join("\n".concat(' '.repeat(level * 2 + 2)));
    return "{\n".concat(' '.repeat(level * 2 + 2)).concat(objectRep, "\n").concat(' '.repeat(level * 2), "},");
  }
  if (typeof value === 'string') {
    return "".concat(value.replace(/\n/g, "\n".concat(' '.repeat(level * 2 + 2))), ",");
  }
  return "".concat(value, ",");
};
exports.printPrimitive = printPrimitive;
/**
 * Formatter for the log file that is written to disk
 *
 * @param {LogObject} info - The Log information object of what to log.
 *
 * @returns {string} - A formatted string to write to disk.
 */
var logFileFormat = function logFileFormat(info) {
  var meta = info.meta;
  var metaStrings = [];
  if (meta && Object.keys(meta).length > 0) {
    metaStrings = Object.keys(meta).map(function (key) {
      var value = meta[key];
      return "  ".concat(key, ": ").concat((0, exports.printPrimitive)(value));
    });
  }
  var timestamp = new Date().toISOString();
  if (metaStrings.length > 0) {
    return "[".concat(timestamp, "] - ").concat(LogLevels[info.level], ": ").concat(info.message, "\n").concat(metaStrings.join('\n'));
  }
  return "[".concat(timestamp, "] - ").concat(LogLevels[info.level], ": ").concat(info.message);
};
exports.logFileFormat = logFileFormat;
/**
 * Format for writing to stdout, used in CLI applications
 *
 * This should NOT be used in the renderer process.
 *
 * @param {LogObject} info - The Log information object of what to log.
 *
 * @returns {string} - A formatted string to write to stdout.
 */
var stdoutFormat = function stdoutFormat(info) {
  return info.message;
};
exports.stdoutFormat = stdoutFormat;
/**
 * Creates a file transport at a file path with a name
 *
 * @param {string} filePath - The path of the new log file.
 * @param {string} name - The name of the sink, to be used to fetch the sink later.
 *
 * @return {FileTransport} - A new FileTransport object configured appropriately.
 */
var createSink = function createSink(filePath, name, parentLogger) {
  var sink = new FileTransport({
    filePath: filePath,
    name: name,
    formatter: exports.logFileFormat,
    level: LogLevels.info,
    parentLogger: parentLogger
  });
  return sink;
};
exports.createSink = createSink;
/**
 * Enumeration of log file sink names.
 *
 * cli is intended to be used as a stdout only sink to show output to the end-user. main is intended
 * to be the main logging file.
 *
 * @enum {string}
 */
var LogFileSinks;
(function (LogFileSinks) {
  LogFileSinks["main"] = "main-log-file-sink";
  LogFileSinks["cli"] = "CLI-sink";
})(LogFileSinks || (exports.LogFileSinks = LogFileSinks = {}));
/**
 * Abstract Class for log transports
 *
 * Gives transports a name they can be referenced by, a silent flag to turn them off, and a log
 * level to control output.
 *
 * _writev is not implemented due to it only being used when
 * cork/uncork are used, which are not used in the logger.
 *
 * @extends {stream.Writeable}
 */
var Transport = /*#__PURE__*/function (_stream$Writable) {
  _inherits(Transport, _stream$Writable);
  var _super = _createSuper(Transport);
  /**
   * Creates a Transport
   * @param {BaseTransportOptions} opts - The options for the transport
   */
  function Transport(opts) {
    var _this;
    _classCallCheck(this, Transport);
    _this = _super.call(this, {
      objectMode: true
    });
    _this.formatter = opts.formatter;
    _this.name = opts.name;
    _this.silent = opts.silent || false;
    _this.level = opts.level;
    // Default to saying the sink is ready right away
    _this.ready = true;
    _this.failedToOpen = false;
    _this.needsToDrain = false;
    _this.buffer = [];
    _this.parentLogger = opts.parentLogger;
    _this.on('ready', function () {
      _this.drainBuffer();
    }).on('drain', function () {
      _this.drainBuffer();
    });
    return _this;
  }
  /**
  * Returns if the file stream is ready or not
  *
  * @returns {boolean} - True if the stream is ready, false otherwise.
  */
  _createClass(Transport, [{
    key: "isReady",
    value: function isReady() {
      return this.ready;
    }
    /**
     * Returns if opening the stream failed.
     *
     * If the stream hasn't failed this does not mean its successful.
     *
     * @returns {boolean} - True if the stream failed to open, false otherwise.
     */
  }, {
    key: "didOpenFail",
    value: function didOpenFail() {
      return this.failedToOpen;
    }
    /**
     * Turn on the log sink so messages aren't logged
     */
  }, {
    key: "open",
    value: function open() {
      debug('Opening', this);
      this.silent = false;
    }
    /**
     * Turn off the log sink so messages aren't logged
     */
  }, {
    key: "close",
    value: function close() {
      debug('Closing', this);
      this.end();
      //this.silent = true;
    }
    /**
     * Method to pass data to the transports log function
     *
     * Per Node.JS' API this is required to be implemented in a writeable stream. This is what data
     * is passed through during pipe.
     *
     * This will make sure the transport is not silent and the level of the LogObject is valid for
     * this transport. It will then use the formatter of the transport. In the event of any errors
     * formatting the log message chunk.message will be used and the formatting error is also output.
     *
     * @param {LogObject} chunk - The object passed through. Because we are in objectMode
     * this will be an object.
     * @param {string} _encoding - Unused: The encoding, always UTF-8.
     * @param {ErrorCallback} callback - The callback to signal when write is done.
     */
  }, {
    key: "_write",
    value: function _write(chunk, _encoding, callback) {
      if (this.name === 'main-log-file-sink' && this.parentLogger.closing) {
        this.parentLogger.logDebug("_write(".concat(this.name, ") - start"));
      }
      // If the stream is silent do not do anything
      if (this.silent) {
        callback(null);
        return;
      }
      // Do not log the message if its level is higher than the level set for the transport.
      if (typeof chunk.level !== 'number' || chunk.level > this.level) {
        callback(null);
        return;
      }
      var message;
      try {
        message = this.formatter(chunk);
      } catch (formatError) {
        // On an error just log the message with information about the failure in logging along
        // with just the message.
        debug("An error has occurred in the formatter of ".concat(this.name), formatError);
        message = "".concat(chunk.message, " - Formatter failed with error -- ").concat(formatError);
      }
      if (this.needsToDrain) {
        debug("Transport ".concat(this.name, " is queuing item"));
        this.buffer.push({
          message: message,
          callback: callback
        });
        return;
      }
      if (!this.ready) {
        debug("Transport ".concat(this.name, " is queuing item -- Not ready"));
        this.buffer.push({
          message: message,
          callback: callback
        });
        return;
      }
      // Call the transports implemented log function to send the log to its final destination.
      if (!this.log(message, callback)) {
        // FIX: We potentailly lose this message here. I'm adding LOST so we can confirm this is a problem
        //this.buffer.push({ message: `LOST: ${message}`, callback});
        debug("Transport ".concat(this.name, " needs to drain"));
        this.needsToDrain = true;
      }
    }
  }, {
    key: "drainBuffer",
    value: function drainBuffer() {
      this.needsToDrain = false;
      if (this.buffer.length > 0) {
        var message = null;
        var callback = null;
        do {
          var results = this.buffer.shift();
          if (results) {
            message = results.message;
            callback = results.callback;
          }
        } while (message && callback && this.log(message, callback) && this.buffer.length > 0);
      }
    }
  }]);
  return Transport;
}(stream.Writable);
exports.Transport = Transport;
/**
 * A transport for writing messages to stdout.
 *
 * It is important to note that in NodeJS the Synchronous/Asynchronous nature of stdout depends
 * on platform.
 *
 * @extends {Transport}
 */
var StdoutTransport = /*#__PURE__*/function (_Transport) {
  _inherits(StdoutTransport, _Transport);
  var _super2 = _createSuper(StdoutTransport);
  /**
   * Create a StdoutTransport
   *
   * @param {StdoutTransportOptions} opts - The configuration for the transport.
   */
  function StdoutTransport(opts) {
    var _this2;
    _classCallCheck(this, StdoutTransport);
    _this2 = _super2.call(this, opts);
    process.stdout.on('error', function (error) {
      _this2.emit('error', error);
    });
    _this2.writeToDevConsole = opts.writeToDevConsole || false;
    return _this2;
  }
  /**
   * The function called before the 'finish' event is emitted
   *
   * This makes sure the log file stream is closed before being 'finished'.
   */
  _createClass(StdoutTransport, [{
    key: "_final",
    value: function _final(callback) {
      this.parentLogger.logDebug("StdoutTransport::_final(".concat(this.name, ") - called"));
      callback(null);
    }
    /**
     * Write the message to stdout.
     *
     * @param {string} message - The message to write.
     * @param {ErrorCallback} callback - The callback when the write is complete.
     */
  }, {
    key: "log",
    value: function log(message, callback) {
      var _this3 = this;
      // If needsToDrain is true we do not want to write the message, but rather wait until the
      // drain event is emitted.
      if (this.needsToDrain) {
        debug("".concat(this.name, " Waiting for log stream to drain before logging"));
        return false;
      }
      // If written is false we need to wait for the stream to drain before writing more data.
      var written = process.stdout.write("".concat(message).concat(os_1.EOL));
      if (this.writeToDevConsole) {
        console.log(message);
      }
      if (written) {
        callback(null);
      } else {
        process.stdout.once('drain', function () {
          _this3.emit('drain');
          callback(null);
        });
      }
      return written;
    }
  }]);
  return StdoutTransport;
}(Transport);
exports.StdoutTransport = StdoutTransport;
/**
 * A transport for writing to a file.
 *
 * This start from the start of the file.
 *
 * @extends {Transport}
 */
var FileTransport = /*#__PURE__*/function (_Transport2) {
  _inherits(FileTransport, _Transport2);
  var _super3 = _createSuper(FileTransport);
  /**
   * Create a FileTransport
   *
   * @param {FileTransportOptions} opts - The configuration for the FileTransport.
   */
  function FileTransport(opts) {
    var _this4;
    _classCallCheck(this, FileTransport);
    _this4 = _super3.call(this, opts);
    _this4.needsToDrain = false;
    _this4.filePath = opts.filePath;
    // Open the file stream so the transport can work
    _this4.ready = false;
    _this4.openStream();
    return _this4;
  }
  /**
   * Write the message to the log file
   *
   * If the log stream is not open the call with wait for the 'ready' event. If the stream needs to
   * drain the transport will wait for the 'drain' event before logging.
   *
   * @param {string} message - The message to write.
   * @param {ErrorCallback} callback - The callback when the write is complete.
   *
   */
  _createClass(FileTransport, [{
    key: "log",
    value: function log(message, callback) {
      var _this5 = this;
      // If the file stream is not open wait for the ready event;
      if (!this.ready) {
        this.parentLogger.logDebug("".concat(this.name, " Waiting for log stream to be ready before logging"));
        return false;
      }
      // If needsToDrain is true we do not want to write the message, but rather wait until the
      // drain event is emitted.
      if (this.needsToDrain) {
        debug("".concat(this.name, " Waiting for log stream to drain before logging"));
        return false;
      }
      var written = this.fileStream.write("".concat(message).concat(os_1.EOL));
      // If written is false we need to wait for the stream to drain before writing more data.
      if (written) {
        callback(null);
      } else {
        debug("".concat(this.name, " -- File at path ").concat(this.filePath, " has requested to drain"));
        this.fileStream.once('drain', function () {
          if (_this5.name === 'main-log-file-sink' && _this5.parentLogger.closing) {
            _this5.parentLogger.logDebug("log(".concat(_this5.name, ") - draining"));
          }
          _this5.emit('drain');
          callback(null);
        });
      }
      return written;
    }
    /**
     * The function called before the 'finish' event is emitted
     *
     * This makes sure the log file stream is closed before being 'finished'.
     */
  }, {
    key: "_final",
    value: function _final(callback) {
      var _this6 = this;
      this.parentLogger.logDebug("FileTransport::_final(".concat(this.name, ") - starting"));
      if (!this.fileStream) {
        this.parentLogger.logDebug("FileTransport::_final(".concat(this.name, ") - no stream"));
        callback(null);
      } else {
        this.parentLogger.logDebug("FileTransport::_final(".concat(this.name, ") - ending stream"));
        this.fileStream.on('close', function () {
          _this6.parentLogger.logDebug("FileTransport::_final(".concat(_this6.name, ") - close called."));
          callback(null);
        });
        this.fileStream.end();
      }
    }
    /**
     * Opens up the file stream and emits a ready event to denote that the transport is ready.
     *
     * Sets up the stream to emit any errors as well.
     */
  }, {
    key: "openStream",
    value: function openStream() {
      var _this7 = this;
      this.fileStream = fs.createWriteStream(this.filePath).on('error', function (error) {
        if (!_this7.ready) {
          _this7.failedToOpen = true;
          _this7.fileStream.end();
        }
        _this7.parentLogger.logDebug("openStream(".concat(_this7.name, ") - An error has occurred in the stream ").concat(_this7.filePath, ": ").concat(error));
        _this7.emit('error', error);
      }).on('close', function () {
        _this7.parentLogger.logDebug("openStream(".concat(_this7.name, ") - Write stream at filepath ").concat(_this7.filePath, " has been closed successfully"));
      }).on('open', function () {
        // Emit we are done so we can start writing logs
        _this7.ready = true;
        _this7.emit('ready');
      });
    }
  }]);
  return FileTransport;
}(Transport);
exports.FileTransport = FileTransport;
/**
 * Check that an item is a LogObject
 *
 * @param {any} item - The item to test;
 *
 * @returns {boolean} - True if the item is a LogObject, false otherwise.
 */
var isLogObject = function isLogObject(item) {
  if (item && _typeof(item) === 'object' && typeof item.message === 'string' && typeof item.level === 'number' && Object.values(LogLevels).includes(item.level)) {
    return true;
  }
  return false;
};
/**
 * A simple logger class. Based on Winston@3's design.
 *
 * Based on a Transform stream. Transform streams are both readable and writeable. The writeable
 * piece of this stream is what the end user is logging. This writeable piece is then sent through
 * _transform to prepare the data to be piped from the readable end.
 *
 * Transports can be added but not removed. To turn off logging to a transport that transport should
 * be fetched with getTransport() and then the silent flag in those transports should be set to
 * true.
 *
 * @extends {stream.Transform}
 */
var Logger = /*#__PURE__*/function (_stream$Transform) {
  _inherits(Logger, _stream$Transform);
  var _super4 = _createSuper(Logger);
  function Logger() {
    var _this8;
    _classCallCheck(this, Logger);
    _this8 = _super4.call(this, {
      objectMode: true
    });
    _this8.transports = [];
    _this8.open = true;
    _this8.history = [];
    _this8.collectingHistory = false;
    _this8.closing = false;
    _this8.consoleDebugOn = false;
    return _this8;
  }
  // Basically does a console.log, used only when necessary to debug the logging system
  // Which can be challenging to do sometimes
  _createClass(Logger, [{
    key: "logDebug",
    value: function logDebug(msg) {
      if (this.consoleDebugOn) {
        console.log('#### Logger Console: ' + msg);
      }
    }
    /**
     * Logs a message at stdout level.
     *
     * @param {string} message - The message to log.
     * @param {any} [meta] - Any additional metadata to log.
     */
  }, {
    key: "stdout",
    value: function stdout(message, meta) {
      if (this) {
        this.log(LogLevels.stdout, message, meta);
      }
    }
    /**
     * Logs a message at error level.
     *
     * @param {string} message - The message to log.
     * @param {any} [meta] - Any additional metadata to log.
     */
  }, {
    key: "error",
    value: function error(message, meta) {
      if (this) {
        this.log(LogLevels.error, message, meta);
      }
    }
    /**
     * Logs a message at warn level.
     *
     * @param {string} message - The message to log.
     * @param {any} [meta] - Any additional metadata to log.
     */
  }, {
    key: "warn",
    value: function warn(message, meta) {
      if (this) {
        this.log(LogLevels.warn, message, meta);
      }
    }
    /**
     * Logs a message at info level.
     *
     * @param {string} message - The message to log.
     * @param {any} [meta] - Any additional metadata to log.
     */
  }, {
    key: "info",
    value: function info(message, meta) {
      if (this) {
        this.log(LogLevels.info, message, meta);
      }
    }
    /**
     * Logs a message at verbose level.
     *
     * @param {string} message - The message to log.
     * @param {any} [meta] - Any additional metadata to log.
     */
  }, {
    key: "verbose",
    value: function verbose(message, meta) {
      if (this) {
        this.log(LogLevels.verbose, message, meta);
      }
    }
    /**
     * Logs a message at debug level.
     *
     * @param {string} message - The message to log.
     * @param {any} [meta] - Any additional metadata to log.
     */
  }, {
    key: "debug",
    value: function debug(message, meta) {
      if (this) {
        this.log(LogLevels.debug, message, meta);
      }
    }
    /**
     * Log a message using Winston-esque API
     *
     * @param {LogLevels} level - The level to log at.
     * @param {string} message - The log message.
     * @param {any} [meta] - Any additional metadata to include.
     */
  }, {
    key: "log",
    value: function log(level, message, meta) {
      if (this.open) {
        // If written is false we need to wait for the stream to drain before writing more data.
        this.write({
          level: level,
          message: message,
          meta: meta
        });
        if (this.collectingHistory) {
          this.history.push({
            level: level,
            message: message,
            meta: meta
          });
        }
      }
    }
    /**
     * Add a new transport to the logger
     *
     * Pipes the output of this stream to the new transport and attaches an error event listener to
     * the transport that will cause the logger to emit those errors as error events.
     *
     * Removing a transport should be done by silencing the transport.
     *
     * @param {Transport} transport - The transport to add
     *
     * @returns {this} - Returns this.
     */
  }, {
    key: "add",
    value: function add(transport) {
      var _this9 = this;
      var events = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      this.logDebug("Adding transport(".concat(this.transports.length, "): ").concat(transport.name));
      this.pipe(transport, {
        end: false
      }); // We want to handle closing manually becuase automatically pretty much fails.
      this.transports.push(transport);
      this.onEvent('error', transport);
      events.forEach(function (event) {
        return _this9.onEvent(event, transport);
      });
      if (this.history.length > 0) {
        this.history.forEach(function (item) {
          transport.write(item, undefined);
        });
      }
      return this;
    }
    /**
     * Removes a transport from the logger.
     *
     * @param {string} name - The transport's name to remove.
     *
     * @returns {Transport | null} - The removed transport if it exists, null otherwise.
     */
  }, {
    key: "remove",
    value: function remove(name) {
      var indexToRemove = this.transports.findIndex(function (t) {
        return t.name === name;
      });
      if (indexToRemove === -1) {
        return null;
      }
      var removed = this.transports.splice(indexToRemove, 1);
      if (removed.length === 0) {
        return null;
      }
      return removed[0];
    }
    /**
     * Get a transport by name if it exists
     *
     * @param {string} name - The transport's name to find.
     *
     * @returns {Transport | null} - The transport if it exists, null otherwise.
     */
  }, {
    key: "getTransport",
    value: function getTransport(name) {
      return this.transports.find(function (t) {
        return t.name === name;
      }) || null;
    }
    /**
     * The intermediate between the writeable part of the stream to the readable part.
     *
     * Transforms the input into an output that can be read from this stream. This will only transform
     * strings or objects that are valid LogObjects. If chunk is neither of those nothing is written.
     * A string is treated as an info level log.
     *
     * @param {any} chunk - The chunk to write. Should be either a LogObject or a string.
     */
  }, {
    key: "_transform",
    value: function _transform(chunk, _encoding, callback) {
      if (isLogObject(chunk)) {
        this.push(chunk);
      } else if (typeof chunk === 'string') {
        debug('String written to Logger, transforming to a LogObject');
        var toWrite = {
          message: chunk,
          level: LogLevels.info
        };
        this.push(toWrite);
      } else {
        debug('Non-string/LogObject written to Logger. Ignoring', chunk);
      }
      callback(null);
    }
    /**
     * Tells the logger to stop calling write before calling end
     *
     * Override of stream.Writeable.end(). This will prevent write after end errors.
     */
  }, {
    key: "end",
    value: function end(cb) {
      this.open = false;
      return _get(_getPrototypeOf(Logger.prototype), "end", this).call(this, cb);
    }
    /**
     * Called when Logger.end() is called.
     *
     * This occurs before the 'finish' event. This waits for all output streams to emit 'finish',
     * meaning they're done writing before this emits 'finish' event.
     *
     * @param {ErrorCallback} callback - The callback to signal when write is done.
     */
  }, {
    key: "_final",
    value: function _final(callback) {
      // This does nothing special because it's handled in finishLoggerAndWait
      this.logDebug("Logger::_final() - starting");
      callback(null);
    }
    /**
     * Set up a transport to emit a transports event upstream.
     *
     * This attaches an event listener to a transport and on that event listener emits the event
     * through the logger. The event will be transmitted with two arguments, the first is anything
     * send from the transport, and the second is the transport itself.
     *
     * @param {string} event - The event to listen to.
     * @param {Transport} transport - The transport to listen on.
     */
  }, {
    key: "onEvent",
    value: function onEvent(event, transport) {
      function transportEvent(args) {
        debug('An event has occurred downstream', {
          event: event,
          args: args,
          transport: transport
        });
        this.logDebug("logger::onEvent: event has occurred downstream: ".concat(transport.name, " -> ").concat(event, " ").concat(args));
        this.emit(event, args, transport);
      }
      // Attach the event handler as a property on the transport
      if (!transport['__logger' + event]) {
        transport['__logger' + event] = transportEvent.bind(this);
        transport.on(event, transport['__logger' + event]);
      }
    }
  }, {
    key: "finishLoggerAndWait",
    value: function finishLoggerAndWait() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var rb, wb, _iterator, _step, oneTransport;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              this.closing = true;
              this.logDebug("finishLoggerAndWait() - waiting for this.end");
              _context.next = 4;
              return this.waitForSelfToFinish();
            case 4:
              this.logDebug("finishLoggerAndWait() - done waiting for this.end");
              if (this.consoleDebugOn) {
                rb = this.readableBuffer;
                this.logDebug("finishLoggerAndWait() - ReadableBuffer of logger = length: ".concat(rb.length));
                wb = this.writableBuffer;
                this.logDebug("finishLoggerAndWait() - writableBuffer of logger = length: ".concat(wb.length));
              }
              _iterator = _createForOfIteratorHelper(this.transports);
              _context.prev = 7;
              _iterator.s();
            case 9:
              if ((_step = _iterator.n()).done) {
                _context.next = 23;
                break;
              }
              oneTransport = _step.value;
              this.logDebug("finishLoggerAndWait() - waiting for transport: ".concat(oneTransport.name));
              _context.prev = 12;
              _context.next = 15;
              return this.closeTransportAndWaitForFinish(oneTransport);
            case 15:
              _context.next = 21;
              break;
            case 17:
              _context.prev = 17;
              _context.t0 = _context["catch"](12);
              this.logDebug("finishLoggerAndWait() - error closing transport: ".concat(oneTransport.name));
              this.logDebug(_context.t0);
            case 21:
              _context.next = 9;
              break;
            case 23:
              _context.next = 28;
              break;
            case 25:
              _context.prev = 25;
              _context.t1 = _context["catch"](7);
              _iterator.e(_context.t1);
            case 28:
              _context.prev = 28;
              _iterator.f();
              return _context.finish(28);
            case 31:
              this.transports.length = 0; // remove them all.
              this.logDebug("finishLoggerAndWait() - done");
            case 33:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[7, 25, 28, 31], [12, 17]]);
      }));
    }
  }, {
    key: "closeTransportAndWaitForFinish",
    value: function closeTransportAndWaitForFinish(transportGeneric) {
      var _this10 = this;
      if (!transportGeneric.close) {
        // e.g. transport.name === 'console'
        this.logDebug("closeTransportAndWaitForFinish(".concat(transportGeneric.name, ") - no close method."));
        return Promise.resolve();
      }
      var transport = transportGeneric;
      this.logDebug("closeTransportAndWaitForFinish(".concat(transport.name, ") - start. buffer size is: ").concat(transport.buffer.length, ". NeedsDrained: ").concat(transport.needsToDrain, "."));
      transport.end();
      // e.g. transport.name === 'file'
      var waitPromise = new Promise(function (resolve, _reject) {
        transport.once('finish', function () {
          _this10.logDebug("closeTransportAndWaitForFinish(".concat(transport.name, ") - finished"));
          resolve();
        });
        transport.once('error', function (error) {
          _this10.logDebug("closeTransportAndWaitForFinish(".concat(transport.name, ") - error ").concat(error));
          resolve();
        });
      });
      this.logDebug("closeTransportAndWaitForFinish(".concat(transport.name, ") - about to do waitPromise"));
      return waitPromise.then(function () {
        _this10.logDebug("closeTransportAndWaitForFinish(".concat(transport.name, ") - done with waitPromise"));
        if (!transportGeneric._doneFinish) {
          transportGeneric._doneFinish = true;
        }
        _this10.logDebug("closeTransportAndWaitForFinish(".concat(transport.name, ") - final resolve"));
        return Promise.resolve();
      });
    }
    // calls End on self and return when both the read and write strings are done.
  }, {
    key: "waitForSelfToFinish",
    value: function waitForSelfToFinish() {
      var _this11 = this;
      if (this.consoleDebugOn) {
        var rb = this.readableBuffer;
        this.logDebug("waitForSelfToFinish() - ReadableBuffer length: ".concat(rb.length));
        var wb = this.writableBuffer;
        this.logDebug("waitForSelfToFinish() - writableBuffer length: ".concat(wb.length));
      }
      this.logDebug("waitForSelfToFinish() - calling end");
      _get(_getPrototypeOf(Logger.prototype), "end", this).call(this);
      // This waits for our self transform stream to emit both "end" and "finish" (or error).
      var waitPromise = new Promise(function (resolve, _reject) {
        var isFinished = false; // The writeable side emits "finish" when it's done.
        var isEnded = false; // The readable emits "end" when it's done
        _this11.once('finish', function () {
          _this11.logDebug("waitForSelfToFinish()) - finished");
          isFinished = true;
          if (isEnded) {
            resolve();
          }
        });
        _this11.once('end', function () {
          _this11.logDebug("waitForSelfToFinish()) - ended");
          isEnded = true;
          if (isFinished) {
            resolve();
          }
        });
        _this11.once('error', function (error) {
          _this11.logDebug("waitForSelfToFinish() - error ".concat(error));
          resolve();
        });
      });
      this.logDebug("waitForSelfToFinish() - about to do waitPromise");
      return waitPromise.then(function () {
        _this11.logDebug("waitForSelfToFinish() - done with waitPromise");
        return Promise.resolve();
      });
    }
  }]);
  return Logger;
}(stream.Transform);
exports.Logger = Logger;

/***/ }),

/***/ 45637:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _exports$PlistLocatio;
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PlistLocations = void 0;
/**
 * Contains utilities for interacting with plists
 */
var fs_extra_1 = __webpack_require__(55674);
var path = __importStar(__webpack_require__(71017));
var os = __importStar(__webpack_require__(22037));
var enums_1 = __webpack_require__(38261);
exports.PlistLocations = (_exports$PlistLocatio = {}, _defineProperty(_exports$PlistLocatio, enums_1.PlistScopes.user, path.join(os.homedir(), 'Library', 'Preferences')), _defineProperty(_exports$PlistLocatio, enums_1.PlistScopes.system, path.join('/', 'Library', 'Preferences')), _exports$PlistLocatio);
// We do not have a type file so just require to avoid TS being weird with no declaration file
var _require = __webpack_require__(22483),
  parseBuffer = _require.parseBuffer;
/**
 * Reads a plist
 *
 * @param {Object} params
 * @param {string} params.path - The path to the plist to read.
 *
 * @return {Promise<{ [key: string]: any }} - A promise for the contents of the plist.
 */
var getPlistValues = function getPlistValues(params) {
  return (0, fs_extra_1.readFile)(params.path).then(function (plistData) {
    var obj = parseBuffer(plistData);
    if (Array.isArray(obj)) {
      return Promise.resolve(obj[0]);
    }
    return Promise.resolve(obj);
  })["catch"](function (error) {
    return Promise.reject(error);
  });
};
exports["default"] = {
  getPlistValues: getPlistValues
};

/***/ }),

/***/ 20254:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ProxyInfo = void 0;
/**
 * Contains utilities to read and store a Vectorworks proxy file
 */
var fs = __importStar(__webpack_require__(55674));
var path = __importStar(__webpack_require__(71017));
var childProcess = __importStar(__webpack_require__(32081));
var debug = __webpack_require__(15158)('proxy-reader');
/**
 * A class that represents a parsed Vectorworks proxy file
 */
var ProxyInfo = /*#__PURE__*/function () {
  /**
   * Creates a new ProxyInfo object
   *
   * @param {string} address - The URL of the proxy.
   * @param {number} port - The port of the proxy.
   * @param {string} [username] - Optional. The username to authenticate with.
   * @param {string} [password] - Optional. The password to authenticate with.
   */
  function ProxyInfo(address, port, username, password) {
    _classCallCheck(this, ProxyInfo);
    this.address = address;
    this.port = port;
    this.username = username || null;
    this.password = password || null;
  }
  /**
   * Gets the proxy URL as an HTTP proxy
   *
   * @returns {string} - The proxy URL to use.
   */
  _createClass(ProxyInfo, [{
    key: "getProxyUrl",
    value: function getProxyUrl() {
      return "http://".concat(this.address, ":").concat(this.port);
    }
    /**
     * Gets the proxy information as a string for logging.
     * Does not put password in string.
     *
     * @returns {string} - The proxy info (basically for logging)
     */
  }, {
    key: "getProxyDescription",
    value: function getProxyDescription() {
      var result = "address:".concat(this.address, ", port:").concat(this.port, ", username:").concat(this.username ? this.username : 'absent', ", password:").concat(this.password ? 'present' : 'absent');
      return result;
    }
    /**
     * Gets an encoded string with the credentials, or null if username or password is missing
     *
     * The credentials are intended to be sent with the Authorization header.
     *
     * @returns {string | null} - An encoded credential string, or null if username or password is
     * is missing.
     */
  }, {
    key: "getAuthentication",
    value: function getAuthentication() {
      if (!this.username || !this.password) {
        return null;
      }
      var encodedCred = new Buffer("".concat(this.username, ":").concat(this.password)).toString('base64');
      return "Basic ".concat(encodedCred);
    }
    /**
     * Returns an object with:
     * childEnv = an environment to use for child process with user and pass included
     * prefix = "-x http://localhost:3128 --proxy-user \"user:pass\""
     */
  }, {
    key: "getCURLEnv",
    value: function getCURLEnv() {
      var result = {
        childEnv: process.env,
        prefix: ''
      };
      var prefixStart = " -x \"".concat(this.getProxyUrl(), "\" ");
      var creds = '';
      if (this.username && this.password) {
        result.childEnv.VWInstallerProxyCreds = "".concat(this.username, ":").concat(this.password);
        if (process.platform === 'win32') {
          creds = ' --proxy-user "%VWInstallerProxyCreds%" ';
        } else {
          creds = ' --proxy-user "$VWInstallerProxyCreds" ';
        }
      }
      result['prefix'] = prefixStart + creds;
      return result;
    }
  }]);
  return ProxyInfo;
}();
exports.ProxyInfo = ProxyInfo;
/**
 * Parses the contents of a proxy file into a ProxyInfo object
 *
 * @param {string} proxyFileContents - The contents of the proxy file
 *
 * @return {ProxyInfo | null} - The ProxyInfo from the contents, or null if the contents cannot
 * be parsed.
 */
var parseProxyFile = function parseProxyFile(proxyFileContents) {
  var lines = proxyFileContents.split('\n').map(function (l) {
    return l.toLowerCase();
  });
  var address = '';
  var port = null;
  var username;
  var password;
  lines.forEach(function (rawLine) {
    var line = rawLine.trim();
    if (line.startsWith('#') || line.trim().length === 0) {
      return;
    }
    if (line.startsWith('address')) {
      address = line.split(' ')[1];
      debug("Found proxy address ".concat(address));
    } else if (line.startsWith('port')) {
      try {
        port = parseInt(line.split(' ')[1], 10);
        if (isNaN(port)) {
          debug("Port is invalid, not a number, got ".concat(line.split(' ')[1]));
          port = 0;
        } else {
          debug("Got port ".concat(port));
        }
      } catch (error) {
        debug('An error has occurred reading the port', error);
        port = 0;
      }
    } else if (line.startsWith('username')) {
      username = line.split(' ')[1];
    } else if (line.startsWith('password')) {
      password = line.split(' ')[1];
    }
  });
  if (!address || address.length === 0 || !port) {
    debug('type, address, or port is null');
    return null;
  }
  return new ProxyInfo(address, port, username, password);
};
// Returns a string with the decrypted and translated (into the txt format) contents
// or empty string.
var readProxyBinFile = function readProxyBinFile(proxyBinPath, proxyToolPath) {
  var exists = fs.pathExistsSync(proxyBinPath);
  var toolExists = fs.pathExistsSync(proxyToolPath);
  var result = '';
  if (exists && toolExists) {
    var cmd = "\"".concat(proxyToolPath, "\" decrypt \"").concat(proxyBinPath, "\" @stdout d7S57r5mgzNf");
    var stdout = '';
    try {
      stdout = childProcess.execSync(cmd).toString();
    } catch (_a) {}
    if (stdout !== '') {
      var jsonString = stdout;
      var jsonData = {};
      try {
        jsonData = JSON.parse(jsonString);
      } catch (_b) {} // On error we just let the empty data sit, which returns an empty string.
      // Create the text from the JSON string...
      if ('type' in jsonData && 'host' in jsonData && 'port' in jsonData) {
        result = "proxytype ".concat(jsonData['type'], "\naddress ").concat(jsonData['host'], "\nport ").concat(jsonData['port'], "\n");
        if ('username' in jsonData) {
          result += "username ".concat(jsonData['username'], "\n");
        }
        if ('password' in jsonData) {
          result += "password ".concat(jsonData['password'], "\n");
        }
      }
    }
  }
  return result;
};
/**
 * Synchronously read the a proxy file and parse its contents
 *
 * @param {string} proxyPath - The path to the proxy file (.txt).
 * @param {boolean} checkForBin - if true, this will also check for a bin file in the same location.
 *
 * @returns {ProxyInfo | null} - The parsed Proxy File as a ProxyInfo object or null if there
 * is an issue parsing the file.
 */
var readProxyFile = function readProxyFile(proxyPath, checkForBin, proxyToolPath) {
  // Get bin file name
  var parsedTxt = path.parse(proxyPath);
  var binFilePath = path.join(parsedTxt.dir, parsedTxt.name + '.bin');
  var binExists = fs.pathExistsSync(binFilePath);
  var contents = "";
  if (binExists && checkForBin) {
    // Decrypt and translate bin file
    contents = readProxyBinFile(binFilePath, proxyToolPath);
  } else {
    // Normal parsing of plain .txt file
    var exists = fs.pathExistsSync(proxyPath);
    if (!exists) {
      return null;
    }
    contents = fs.readFileSync(proxyPath, 'utf8');
  }
  if (contents) {
    var results = parseProxyFile(contents);
    return results;
  }
  return null;
};
exports["default"] = readProxyFile;

/***/ }),

/***/ 18772:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ShouldInstallRunner = void 0;
/**
 * Contains a class used to run the shouldinstall utility
 *
 * Also contains tools to run serial finder.
 */
var childProcess = __importStar(__webpack_require__(32081));
var cross_spawn_1 = __importDefault(__webpack_require__(88309));
var enums_1 = __webpack_require__(38261);
var errors_1 = __webpack_require__(94515);
var path = __importStar(__webpack_require__(71017));
/**
 * A class that will handle running ShouldInstall and SerialFinder to find and validate serial
 * numbers.
 *
 * This can work with other applications that are not Vectorworks so long as the ShouldInstall
 * is ran in the same way.
 */
var ShouldInstallRunner = /*#__PURE__*/function () {
  /**
   * Create a new serial valid
   *
   * @param {string} shouldInstallPath - The path to should install.
   * @param {LoggerLib.Logger} logger - A logger object
   */
  function ShouldInstallRunner(shouldInstallPath, logger) {
    _classCallCheck(this, ShouldInstallRunner);
    this.shouldInstallPath = shouldInstallPath;
    this.logger = logger;
    var serialFinderName = process.platform === 'darwin' ? 'SerialFinder' : 'SerialFinder.exe';
    this.serialFinderPath = path.join(path.dirname(shouldInstallPath), serialFinderName);
  }
  _createClass(ShouldInstallRunner, [{
    key: "logInfo",
    value: function logInfo(msg) {
      if (this.logger !== null) {
        this.logger.info(msg);
      }
    }
    /**
     * Runs ShouldInstall
     *
     * @param {string[]} args - The string arguments to should install.
     *
     * @return {Promise<{ stdout: string, stderr: string }>} - A promise for the output of
     * ShouldInstall.
     */
  }, {
    key: "runShouldInstall",
    value: function runShouldInstall(args) {
      var _this = this;
      return new Promise(function (resolve, reject) {
        var output = [];
        var stderr = [];
        _this.logInfo("ShouldInstallRunner() - running Should Install at: ".concat(_this.shouldInstallPath, " with args: ").concat(args));
        var proc = (0, cross_spawn_1["default"])(_this.shouldInstallPath, args).on('error', function (error) {
          reject(new errors_1.BaseError('Should Install failed', enums_1.ErrorTypes.shouldInstallFailed, {
            error: error,
            stdout: output.join(''),
            stderr: stderr.join('')
          }));
        }).on('exit', function () {
          var stdout = output.join('');
          var err = stderr.join('');
          _this.logInfo("ShouldInstallRunner() - got stdout=\"".concat(stdout, "\" and stderr=\"").concat(err, "\"."));
          resolve({
            stdout: stdout,
            stderr: err
          });
        });
        if (proc.stderr) {
          proc.stderr.on('data', function (data) {
            if (Buffer.isBuffer(data)) {
              stderr.push(data.toString('utf8'));
            } else {
              stderr.push(data);
            }
          });
        }
        if (proc.stdout) {
          proc.stdout.on('data', function (data) {
            if (Buffer.isBuffer(data)) {
              output.push(data.toString('utf8'));
            } else {
              output.push(data);
            }
          });
        }
      });
    }
    /**
     * Runs ShouldInstall synchronously.
     *
     * @param {string[]} args - The string arguments to should install.
     *
     * @return { stdout: string, stderr: string } - A promise for the output of
     * ShouldInstall.
     */
  }, {
    key: "runShouldInstallSync",
    value: function runShouldInstallSync(args) {
      var proc = childProcess.spawnSync(this.shouldInstallPath, args, {
        stdio: 'pipe',
        encoding: 'utf-8'
      });
      this.logInfo("ShouldInstallRunner::runShouldInstallSync() - got output: ".concat(JSON.stringify(proc), "."));
      return {
        stdout: proc.stdout,
        stderr: proc.stderr
      };
    }
    /**
     * Runs serial finder and returns its output as a string
     *
     * @returns {Promise<string>} - A promise for SerialFinder's output.
     */
  }, {
    key: "runSerialFinder",
    value: function runSerialFinder() {
      var _this2 = this;
      return new Promise(function (resolve, reject) {
        var serialFinderPathQuoted = "\"".concat(_this2.serialFinderPath, "\"");
        childProcess.exec(serialFinderPathQuoted, function (error, stdout, stderr) {
          if (error) {
            reject(new errors_1.BaseError('SerialFinder failed', enums_1.ErrorTypes.shouldInstallFailed, {
              stdout: stdout,
              stderr: stderr,
              error: error
            }));
          }
          resolve(stdout.trim());
        });
      });
    }
  }]);
  return ShouldInstallRunner;
}();
exports.ShouldInstallRunner = ShouldInstallRunner;

/***/ }),

/***/ 45627:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isDeltaMetadata = exports.isDeltaOperationData = exports.isUpdateInfo = exports.isUpdateItem = exports.isChannelMap = exports.emptyLocationInfo = exports.getLocationData = exports.isVersionInfo = exports.emptyVersionInfo = void 0;
/**
 * Contains types used by other libraries and applications
 */
var enums_1 = __webpack_require__(38261);
var emptyVersionInfo = function emptyVersionInfo() {
  return {
    product: 'vectorworks',
    major: 0,
    minor: 0,
    patch: 0,
    changelist: 0,
    identifier: '',
    name: '',
    distributor: '',
    language: '',
    channel: 'main',
    platform: '',
    versionFilePath: '',
    isInitialRelease: 0,
    macExecutableName: '',
    winExecutableName: '',
    designation: null,
    valid: false,
    subKey: '',
    productGUID: ''
  };
};
exports.emptyVersionInfo = emptyVersionInfo;
/**
 * Typeguard for VersionInfo
 *
 * @param {any} item - The item to test.
 *
 * @return {boolean} - True if item is a VersionInfo object, false otherwise
 */
var isVersionInfo = function isVersionInfo(item) {
  if (!item || _typeof(item) !== 'object') {
    return false;
  }
  var major = item.major,
    minor = item.minor,
    patch = item.patch,
    changelist = item.changelist,
    identifier = item.identifier,
    designation = item.designation,
    name = item.name;
  if (![major, minor, patch, changelist].every(function (entry) {
    return typeof entry === 'number';
  })) {
    return false;
  }
  if (typeof identifier !== 'string') {
    return false;
  }
  if (typeof name !== 'string') {
    return false;
  }
  if (typeof designation !== 'string' && typeof designation !== 'undefined' && designation !== null) {
    return false;
  }
  return true;
};
exports.isVersionInfo = isVersionInfo;
// returns locationData for key or empty (with valid: false) if not found.
var getLocationData = function getLocationData(key, locationInfo) {
  if (key in locationInfo.locationInfo) {
    var locationData = locationInfo.locationInfo[key];
    if (locationData !== null) {
      return locationData;
    }
  }
  return {
    locationPath: '',
    valid: false,
    override: false,
    defaultUsed: false,
    defaultValue: '',
    defaultValueViewer: '',
    originalLocationPath: '',
    userFriendlyName: '',
    canUninstall: false,
    shouldUninstall: false,
    optionalUninstall: false
  };
};
exports.getLocationData = getLocationData;
var emptyLocationInfo = function emptyLocationInfo() {
  return {
    locationInfo: {},
    isSet: false
  };
};
exports.emptyLocationInfo = emptyLocationInfo;
/**
 * Typeguard for ChannelMap
 *
 * @param {unknown} toTest - The item to test.
 *
 * @returns {boolean} - true if toTest is a ChannelMap, false otherwise.
 */
var isChannelMap = function isChannelMap(toTest) {
  if (_typeof(toTest) !== 'object' || !toTest) {
    return false;
  }
  return Object.values(toTest).every(function (entry) {
    if (_typeof(entry) !== 'object' || !entry) {
      return false;
    }
    return typeof entry.latest === 'string';
  });
};
exports.isChannelMap = isChannelMap;
/**
 * Typeguard for UpdateItem
 *
 * @param {unknown} toTest - The item to test.
 *
 * @returns {boolean} - true if toTest is an UpdateItem, false otherwise.
 */
var isUpdateItem = function isUpdateItem(toTest) {
  if (_typeof(toTest) !== 'object' || !toTest) {
    return false;
  }
  if (typeof toTest['identifier'] !== 'string') {
    return false;
  }
  if (typeof toTest['update-name'] !== 'string') {
    return false;
  }
  if (typeof toTest['update-info-url'] !== 'string') {
    return false;
  }
  if (typeof toTest['update-info-text'] !== 'string') {
    return false;
  }
  if (typeof toTest['hashfile-change'] !== 'string') {
    return false;
  }
  return ['children', 'parents'].every(function (key) {
    return Array.isArray(toTest[key]) && toTest[key].every(function (i) {
      return typeof i === 'string';
    });
  });
};
exports.isUpdateItem = isUpdateItem;
/**
 * Typeguard for UpdateInfo
 *
 * @param {unknown} toTest - The item to test.
 *
 * @returns {boolean} - True if toTest is an UpdateInfo, false otherwise.
 */
var isUpdateInfo = function isUpdateInfo(toTest) {
  if (_typeof(toTest) !== 'object' || !toTest) {
    return false;
  }
  var channels = toTest.channels;
  if (!(0, exports.isChannelMap)(channels)) {
    return false;
  }
  var updates = toTest.updates;
  if (_typeof(updates) !== 'object' || !updates) {
    return false;
  }
  return Object.keys(updates).every(function (key) {
    return (0, exports.isUpdateItem)(updates[key]);
  });
};
exports.isUpdateInfo = isUpdateInfo;
/**
 * Typeguard for DeltaOperationData
 *
 * @param {any} item - The item to test
 *
 * @returns {boolean} - true if the item is a DeltaOperationData object, false otherwise
 */
var isDeltaOperationData = function isDeltaOperationData(item) {
  if (!item || _typeof(item) !== 'object') {
    return false;
  }
  return Object.keys(item).every(function (packageName) {
    var files = item[packageName];
    // verify each is an object of string: string
    if (!files || _typeof(files) !== 'object') {
      return false;
    }
    return Object.keys(files).every(function (key) {
      return typeof files[key] === 'string';
    });
  });
};
exports.isDeltaOperationData = isDeltaOperationData;
/**
 * Typeguard for DeltaMetadata
 *
 * @param {any} item - The item to test
 *
 * @returns {boolean} - true if the item is a DeltaMetadata, false otherwise.
 */
var isDeltaMetadata = function isDeltaMetadata(item) {
  if (!item || _typeof(item) !== 'object') {
    return false;
  }
  return Object.keys(item).every(function (packageName) {
    var packageData = item[packageName];
    if (!packageData || _typeof(packageData) !== 'object') {
      return false;
    }
    var platform = packageData.platform,
      flags = packageData.flags,
      order = packageData.order,
      components = packageData.components;
    if (typeof platform !== 'string' || platform.length > 0 && !Object.values(enums_1.Platforms).includes(platform.toLowerCase())) {
      return false;
    }
    if (typeof flags !== 'string' || typeof order !== 'number' || typeof components !== 'string') {
      return false;
    }
    return true;
  });
};
exports.isDeltaMetadata = isDeltaMetadata;

/***/ }),

/***/ 54791:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i["return"] && (_r = _i["return"](), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var enums_1 = __webpack_require__(38261);
var types_1 = __webpack_require__(45627);
var errors_1 = __webpack_require__(94515);
var utils_1 = __webpack_require__(93176);
var debug = __webpack_require__(15158)('update-instance');
/** Class representing an update from one version to the next */
var UpdateInstance = /*#__PURE__*/function () {
  /**
   * Create an empty update.
   * @param {Object} params - Initial setup info about the update.
   * @param {UpdateInstance~VersionInfo} params.from - The version this update is from.
   * @param {UpdateInstance~VersionInfo} params.to - The version this update goes to.
   */
  function UpdateInstance(_ref) {
    var from = _ref.from,
      to = _ref.to,
      product = _ref.product,
      distributor = _ref.distributor,
      language = _ref.language,
      channel = _ref.channel,
      logger = _ref.logger;
    _classCallCheck(this, UpdateInstance);
    this.from = from;
    this.to = to;
    this.product = product;
    this.distributor = distributor;
    this.language = language;
    this.channel = channel;
    this.packages = [];
    this.packageCounts = {};
    this.updatePath = [from.identifier, to.identifier];
    this.logger = logger;
    debug('Initial Update Path is', this.updatePath);
  }
  _createClass(UpdateInstance, [{
    key: "addPackage",
    value:
    /**
     * Add a package to this update
     * @param {UpdateInstance~PackageInfo} params - The package to add.
     */
    function addPackage(params) {
      var _this = this;
      var name = params.name,
        product = params.product,
        _params$platform = params.platform,
        platform = _params$platform === void 0 ? enums_1.Platforms.common : _params$platform,
        _params$components = params.components,
        components = _params$components === void 0 ? '' : _params$components,
        _params$updateIdentif = params.updateIdentifier,
        updateIdentifier = _params$updateIdentif === void 0 ? '' : _params$updateIdentif,
        _params$files = params.files,
        files = _params$files === void 0 ? [] : _params$files,
        _params$guarantees = params.guarantees,
        guarantees = _params$guarantees === void 0 ? [] : _params$guarantees,
        _params$volatile = params["volatile"],
        _volatile = _params$volatile === void 0 ? [] : _params$volatile,
        updateLocation = params.updateLocation,
        isValid = params.isValid;
      files.forEach(function (file) {
        var identifier = file.identifier;
        if (!_this.packageCounts[identifier]) {
          _this.packageCounts[identifier] = {};
          _this.packageCounts[identifier][name] = 1;
        } else if (!_this.packageCounts[identifier][name]) {
          _this.packageCounts[identifier][name] = 1;
        } else {
          _this.packageCounts[identifier][name] += 1;
        }
      });
      this.packages.push({
        name: name,
        product: product,
        platform: platform,
        components: components,
        updateIdentifier: updateIdentifier,
        files: files,
        guarantees: guarantees,
        "volatile": _volatile,
        updateLocation: updateLocation,
        isValid: isValid
      });
    }
  }, {
    key: "describe",
    value: function describe() {
      var result = "UpdateInstance description for ".concat(this.from.identifier, " -> ").concat(this.to.identifier, ":\n");
      for (var i = 0; i < this.packages.length; ++i) {
        var p = this.packages[i];
        result += "Package: ".concat(p.name, "\n");
        for (var j = 0; j < p.files.length; ++j) {
          var f = p.files[j];
          result += "  File (".concat(f.operation, ") - ").concat(f.name, "\n");
        }
      }
      return result;
    }
    /**
     * toMerge is an array of files w/ the same name. Either an error has occurred or
     * they can be merged in a few special cases
     */
  }, {
    key: "mergeDuplicates",
    value: function mergeDuplicates(toMerge) {
      var _this2 = this;
      // Identifier on a FileInfo is the identifier of the build it is originally from,
      // this means the list will be sorted to oldest files to newest
      this.logger.info("UpdateInstance::mergeDuplicates() - Start");
      debug('Sorting toMerge', toMerge);
      // Sorts it in update path order (so items earlier in the path come before items that are later in the path)
      toMerge.sort(function (a, b) {
        var aIdentifier = a.identifier;
        var aIndex = _this2.updatePath.findIndex(function (identifier) {
          return aIdentifier === identifier;
        });
        var bIdentifier = b.identifier;
        var bIndex = _this2.updatePath.findIndex(function (identifier) {
          return bIdentifier === identifier;
        });
        if (aIndex === -1 || bIndex === -1) {
          throw new errors_1.BaseError('File was found with an identifier that does not exist', enums_1.ErrorTypes.duplicateOperationMismatch, {
            a: a,
            b: b
          });
        }
        if (aIndex < bIndex) {
          return -1;
        }
        if (aIndex === bIndex) {
          return 0;
        }
        return 1;
      });
      // First error case
      // There is a case where a file is moved across packages so we have an add in one package
      // and a delete in another, in the case both packages are valid for that user we will
      // see a duplicate operation of an add and delete. If the file MD5s are the same
      // we can just ignore this.
      // This will be a length of two because when merging packages an add + delete results in a
      // noop, so this case will always be a length of two.
      // I.e. Delete from P1, Add to P2 then Delete from P2 and Add to P3, this merges to Delete
      // from P1 and Add to P3, since the Add/Delete in P2 result in a No-Op
      if (toMerge.length === 2) {
        var a = toMerge[0];
        var b = toMerge[1];
        var operationA = a.operation;
        var operationB = b.operation;
        if (operationA === enums_1.FileOperations.added && operationB === enums_1.FileOperations.deleted || operationA === enums_1.FileOperations.deleted && operationB === enums_1.FileOperations.added) {
          this.logger.info("UpdateInstance::mergeDuplicates() - found case of moving packages for ".concat(a.identifier, ":").concat(a.packageName, ":").concat(a.name, " ->").concat(b.identifier, ":").concat(b.packageName, ":").concat(b.name));
          return null;
        }
        if (operationA === enums_1.FileOperations["volatile"] && operationB === enums_1.FileOperations.deleted) {
          this.logger.info("UpdateInstance::mergeDuplicates() - found files made volatile for ".concat(a.identifier, ":").concat(a.packageName, ":").concat(a.name));
          return a;
        }
        if (operationB === enums_1.FileOperations["volatile"] && operationA === enums_1.FileOperations.deleted) {
          this.logger.info("UpdateInstance::mergeDuplicates() - found files made volatile for ".concat(b.identifier, ":").concat(b.packageName, ":").concat(b.name));
          return b;
        }
      }
      // Second error case
      // This case stems from when an installation has a file in two installed packages from the
      // start. In this case one of those is 'delete' aka removed from the duplicate package, and
      // the other file is changed. In the event that the file is just removed from the duplicate
      // we will see a delete and we cannot do anything here as we have no means to know if
      // it is a bugged delete or a real delete (Just delete no change).
      // A third error case is dealt with here as well, where a file is deleted from a package
      // but added to another package with a different MD5.
      var changeCount = toMerge.reduce(function (count, file) {
        if (file.operation === enums_1.FileOperations.changed || file.operation === enums_1.FileOperations.added) {
          return count + 1;
        }
        return count;
      }, 0);
      var firstOperation = toMerge[0].operation;
      var firstMd5 = toMerge[0].md5;
      var sameOperation = toMerge.every(function (file) {
        return file.operation === firstOperation;
      });
      var sameMd5 = toMerge.every(function (file) {
        return file.md5 === firstMd5;
      });
      debug("mergeDuplicates found a change count of ".concat(changeCount));
      if (changeCount === 1) {
        // Verify all other operations are deletes
        var changeIndex = toMerge.findIndex(function (file) {
          return file.operation === enums_1.FileOperations.changed || file.operation === enums_1.FileOperations.added;
        });
        var newArray = toMerge.slice();
        if (changeIndex) {
          var _newArray$splice = newArray.splice(changeIndex, 1),
            _newArray$splice2 = _slicedToArray(_newArray$splice, 1),
            removedElement = _newArray$splice2[0];
          debug('mergeDuplicates checking files', {
            removedElement: removedElement,
            newArray: newArray
          });
          if (!newArray.every(function (file) {
            return file.operation === enums_1.FileOperations.changed;
          })) {
            throw new errors_1.BaseError('All other files are not deletes', enums_1.ErrorTypes.duplicateOperationMismatch, {
              toMerge: toMerge
            });
          }
          return removedElement;
        }
      } else if (changeCount > 1 && sameOperation && sameMd5) {
        // In this case the same operation exists in multiple packages and we can just use
        // the first one
        return toMerge[0];
      } else if (changeCount > 1 && sameOperation) {
        // Third Error Case
        // MD5s are different
        // In this case we have a file that was changed in one service pack, then moved packages
        // AND changed in another service pack
        // So use the latest file.
        debug('Files changed packages and changed contents, returning latest', toMerge[toMerge.length - 1]);
        return toMerge[toMerge.length - 1];
      }
      throw new errors_1.BaseError('Duplicate files found with different operations', enums_1.ErrorTypes.duplicateOperationMismatch, {
        toMerge: toMerge
      });
    }
    /**
     * Take this.packages and find the valid ones for this license, platform.
     * For the valid packages, concat all their files into one big array
     * For this big array, build another structure that stacks files with the same destination.
     * For the new structure, handle any special cases, like if two files have the same dest, via mergeDuplicates
     *
     * Returns the resulting FileInfo[] array.
     * @param {Object} params
     * @param {VersionInfo} params.versionInfo - The version information
     * @param {string} params.platform - The target platform
     * @param {LicenseInfo | null} params.licenseInfo - The license information. If null, all files will be included.
     * @param {LoggerLib.Logger} params.logger - used for logging
    * @returns {FileInfo[]} A list of files and their corresponding operations.
    */
  }, {
    key: "buildFileInfoArray",
    value: function buildFileInfoArray(versionInfo, platform, licenseInfo, logger) {
      var _ref2,
        _this3 = this;
      var product = versionInfo.product,
        major = versionInfo.major,
        minor = versionInfo.minor,
        changelist = versionInfo.changelist,
        identifier = versionInfo.identifier;
      logger.info("UpdateInstance::buildFileInfoArray() - Generating for update from ".concat(this.from.identifier, " to ").concat(this.to.identifier, "."));
      if (this.from.identifier !== identifier) {
        throw new errors_1.BaseError('Installation passed in does not match this update', enums_1.ErrorTypes.versionMismatch, {
          from: this.from,
          install: {
            major: major,
            minor: minor,
            changelist: changelist,
            identifier: identifier
          }
        });
      }
      var validPackages = this.packages.filter(function (packageObj) {
        logger.info("UpdateInstance::buildFileInfoArray() - Filter check for package ".concat(packageObj.name, ": Package Product=").concat(packageObj.product, ", product=").concat(product, ", Package platform=").concat(packageObj.platform, ", platform=").concat(platform, "."));
        return (packageObj.product === product || packageObj.product === undefined) && (packageObj.platform === platform || packageObj.platform === enums_1.Platforms.common || packageObj.platform === undefined) && packageObj.name.startsWith( /*'darwin-vision'*/ /*'windows-vision'*/'') && (
        // For faster testing, this can limit us to one chosen package.
        licenseInfo === null ? true : licenseInfo.checkComponentsSync(packageObj.components));
      });
      logger.info('UpdateInstance::buildFileInfoArray() - Found the following validPackages', validPackages.map(function (p) {
        return "".concat(p.name, " -> ").concat(p["volatile"]);
      }));
      // Get all the files from every valid package.
      var files = (_ref2 = []).concat.apply(_ref2, _toConsumableArray(validPackages.map(function (packageObj) {
        return packageObj.files;
      })));
      // Ensure unique files
      // If we have duplicates and different operations we have an issue
      // First, find duplicates, ie, files in the same desintation location (including updateLocation)...
      var fileMap = {};
      files.forEach(function (file) {
        var key = "".concat(file.name, "-").concat(file.updateLocation);
        var val = fileMap[key];
        if (val) {
          val.push(file);
        } else {
          fileMap[key] = [file];
        }
      });
      // Now for each item in this big array, handle it, merging if necessary.
      var toReturn = [];
      Object.values(fileMap).forEach(function (array) {
        if (array && array.length === 0) {
          // No operations on this file. I don't think we can ever reach this return statement.
          return;
        }
        if (array && array.length === 1) {
          // This is the expected case - one operation on this file.
          toReturn.push(array[0]);
        } else if (array && licenseInfo === null) {
          // if LI is null, we are including all files, so this is normal.
          var _iterator = _createForOfIteratorHelper(array),
            _step;
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var fileObj = _step.value;
              toReturn.push(fileObj);
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        } else if (array) {
          // We have a problem here. Attempt to merge them.
          debug('UpdateInstance::buildFileInfoArray() - found duplicate files', {
            array: array
          });
          // See if we can merge these files
          // Sort the files by order of which identifier is first
          var mergeResults = _this3.mergeDuplicates(array);
          if (mergeResults) {
            toReturn.push(mergeResults);
          }
        }
      });
      logger.info("UpdateInstance::buildFileInfoArray() - Done");
      return toReturn;
    }
    /**
     * Same as buildFileInfoArray but restricts results to items that match an item in guaranteeInfo.
     * @param {VersionInfo} params.versionInfo - The version information
     * @param {LicenseInfo} params.licenseInfo - The version information
     * @param {{[location: string]: string[]}} params.guaranteeInfo: A map of location (relative) to package names that serves to limit
     * @param {boolean} params.allFiles - if true will include all files (may be out of date)
     * @returns {UpdateInstance~FileInfo[]} A list of files and their corresponding operations.
     *
     */
  }, {
    key: "buildFileInfoArraySubset",
    value: function buildFileInfoArraySubset(licenseInfo, versionInfo, logger, guaranteeInfo, allFiles) {
      var _ref3,
        _this4 = this;
      var platform = versionInfo.platform,
        product = versionInfo.product,
        major = versionInfo.major,
        minor = versionInfo.minor,
        patch = versionInfo.patch,
        changelist = versionInfo.changelist,
        identifier = versionInfo.identifier;
      logger.info("UpdateInstance::buildFileInfoArraySubset() - Generating for update from ".concat(this.from.identifier, " to ").concat(this.to.identifier, "."));
      if (this.from.identifier !== identifier) {
        throw new errors_1.BaseError('Installation passed in does not match this update', enums_1.ErrorTypes.versionMismatch, {
          from: this.from,
          install: {
            major: major,
            minor: minor,
            patch: patch,
            changelist: changelist,
            identifier: identifier
          }
        });
      }
      var validPackages = this.packages.filter(function (packageObj) {
        logger.info("UpdateInstance::buildFileInfoArraySubset() - Filter check for package ".concat(packageObj.name, ": Package Product=").concat(packageObj.product, ", product=").concat(product, ", Package platform=").concat(packageObj.platform, ", platform=").concat(platform, "."));
        return (packageObj.product === product || packageObj.product === undefined) && (packageObj.platform === platform || packageObj.platform === enums_1.Platforms.common || packageObj.platform === undefined) && (allFiles ? true : licenseInfo.checkComponentsSync(packageObj.components));
      });
      logger.info('UpdateInstance::buildFileInfoArraySubset() - Found the following validPackages', validPackages.map(function (p) {
        return p.name;
      }));
      // Filter down to to only the files that match an item in guaranteeInfo.
      var files = (_ref3 = []).concat.apply(_ref3, _toConsumableArray(validPackages.map(function (packageObj) {
        return packageObj.files.filter(function (fInfo) {
          var foundLocation = Object.entries(guaranteeInfo).some(function (_ref4) {
            var _ref5 = _slicedToArray(_ref4, 2),
              key = _ref5[0],
              _value = _ref5[1];
            if (fInfo.name.startsWith(key)) {
              //logger.info(`File matches: ${JSON.stringify(fInfo)} `)
              return true;
            }
            return false;
          });
          return foundLocation;
        });
      })));
      // Ensure unique files. If we have duplicates and different/incompatible operations we have an issue
      // First, create a map for each file
      var fileMap = {};
      files.forEach(function (file) {
        var key = "".concat(file.name, "-").concat(file.updateLocation);
        var val = fileMap[key];
        if (val) {
          val.push(file);
        } else {
          fileMap[key] = [file];
        }
      });
      // Now go through that map and build toReturn array. If any map items have more than one file, attempt to merge.
      var toReturn = [];
      Object.values(fileMap).forEach(function (array) {
        if (array && array.length === 0) {
          return;
        }
        if (array && array.length === 1) {
          toReturn.push(array[0]);
        } else if (array && allFiles) {
          var _iterator2 = _createForOfIteratorHelper(array),
            _step2;
          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var fileObj = _step2.value;
              toReturn.push(fileObj);
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
        } else if (array) {
          debug('UpdateInstance::buildFileInfoArraySubset() - found duplicate files', {
            array: array
          });
          // See if we can merge these files
          var mergeResults = _this4.mergeDuplicates(array);
          if (mergeResults) {
            toReturn.push(mergeResults);
          }
        }
      });
      logger.info("UpdateInstance::buildFileInfoArraySubset() - Done");
      return toReturn;
    }
  }, {
    key: "toJSON",
    value: function toJSON() {
      var result = {};
      for (var x in this) {
        if (x !== "logger") {
          result[x] = this[x];
        }
      }
      return result;
    }
  }, {
    key: "merge",
    value:
    /**
     * Merges one UpdateInstance to this one. UpdateInstance object must perform
     * an update for the same product in a continuous line. For example you must go from
     * SP1->SP2->SP3->SP4. An error will occur if you try to go SP1->SP2->SP4. This does not
     * handle overlap in file changes between packages.
     *
     * This doesn't care if this leads to updateInstanceToMerge or if updateInstanceToMerge
     * leads to this.
     *
     * @param {UpdateInstance} updateInstanceToMerge - A single UpdateInstance
     * @throws Will throw an error if a continuous update cannot be made or an invalid operation
     * between two files in adjacent updates occurs that we can't handle.
     */
    function merge(updateInstanceToMerge) {
      var _this5 = this;
      this.logger.info("updateInstance::merge() - Merging ".concat(this.from.identifier, " -> ").concat(this.to.identifier, " and ").concat(updateInstanceToMerge.from.identifier, " -> ").concat(updateInstanceToMerge.to.identifier, "."));
      // Verify self and passed in updateInstance are consecutive --
      // to and from need to match up. We check identifiers and the changelist.
      if (this.to.identifier !== updateInstanceToMerge.from.identifier && this.from.identifier !== updateInstanceToMerge.to.identifier || this.to.changelist !== updateInstanceToMerge.from.changelist && this.from.changelist !== updateInstanceToMerge.to.changelist) {
        throw new TypeError("Updates are not continuous. This: '".concat(this.from.identifier, " (").concat(this.from.changelist, ")' -> '").concat(this.to.identifier, " (").concat(this.to.changelist, ")'\n        Provided: '").concat(updateInstanceToMerge.from.identifier, " (").concat(updateInstanceToMerge.from.changelist, ")' -> '").concat(updateInstanceToMerge.to.identifier, " (").concat(updateInstanceToMerge.to.changelist, ")'"));
      }
      var formerUpdate;
      var latterUpdate;
      var from;
      var to;
      /** If true update path will be appended to, otherwise it will be prepended */
      var selfIsFormer = true;
      if (updateInstanceToMerge.to.identifier === this.from.identifier) {
        // updateInstanceToMerge -> this
        selfIsFormer = false;
        formerUpdate = updateInstanceToMerge.packages;
        latterUpdate = this.packages;
        from = Object.assign({}, updateInstanceToMerge.from);
        to = Object.assign({}, this.to);
      } else {
        // this -> updateInstanceToMerge
        formerUpdate = this.packages;
        latterUpdate = updateInstanceToMerge.packages;
        from = Object.assign({}, this.from);
        to = Object.assign({}, updateInstanceToMerge.to);
      }
      this.logger.info("updateInstance::merge() - selfIsFormer? ".concat(selfIsFormer, "."));
      // Find packages that are in the latter update but not in the former one (eg, "new" packages)
      var newPackages = latterUpdate.filter(function (packageObj) {
        // Find the corresponding package in the firstUpdate
        var correspondingInFormer = formerUpdate.find(function (potentialObj) {
          return packageObj.product === potentialObj.product && packageObj.platform === potentialObj.platform && packageObj.name === potentialObj.name;
        });
        return !correspondingInFormer;
      });
      this.logger.info("updateInstance::merge() - newPackages not in former: ".concat(newPackages.length, "."));
      // For each package in formerUpdate, merge with the latter or just
      // return the unchanged package if it doesn't exist in the latter
      var mergedPackages = formerUpdate.map(function (formerPackageObj) {
        // Find the corresponding package in the last update
        var latterPackageFound = latterUpdate.find(function (potentialObj) {
          return formerPackageObj.product === potentialObj.product && formerPackageObj.platform === potentialObj.platform && formerPackageObj.name === potentialObj.name;
        });
        if (!latterPackageFound) {
          _this5.logger.info("updateInstance::merge() - including unchanged package ".concat(formerPackageObj.name, "."));
          return formerPackageObj;
        }
        // Merge the two packages
        _this5.logger.info("updateInstance::merge() - merging package ".concat(formerPackageObj.name, "."));
        return (0, utils_1.mergePackages)(formerPackageObj, latterPackageFound, _this5.logger);
      });
      this.from = from;
      this.to = to;
      this.packages = mergedPackages.concat(newPackages);
      Object.assign(this.packageCounts, updateInstanceToMerge.packageCounts);
      if (selfIsFormer) {
        debug("Appending ".concat(to.identifier, " to updatePath"));
        this.logger.info("updateInstance::merge() - Appending ".concat(to.identifier, " to updatePath."));
        this.updatePath.push(to.identifier);
      } else {
        debug("Prepending ".concat(from.identifier, " to updatePath"));
        this.logger.info("updateInstance::merge() - Appending ".concat(from.identifier, " to updatePath."));
        this.updatePath = [from.identifier].concat(_toConsumableArray(this.updatePath));
      }
      debug("Update Path is now", this.updatePath);
      this.logger.info("updateInstance::merge() - Update Path is now ".concat(this.updatePath, "."));
    }
  }], [{
    key: "getFileCountMap",
    value: function getFileCountMap(updateInstance, fileList) {
      var packageCounts = updateInstance.packageCounts;
      var counts = {};
      fileList.forEach(function (file) {
        if (file.operation !== enums_1.FileOperations.added && file.operation !== enums_1.FileOperations.changed) {
          return;
        }
        var identifier = file.identifier,
          packageName = file.packageName;
        if (!counts[identifier]) {
          counts[identifier] = {};
        }
        if (!counts[identifier][packageName]) {
          counts[identifier][packageName] = {
            used: 1,
            total: packageCounts[identifier][packageName]
          };
        } else {
          counts[identifier][packageName].used += 1;
        }
      });
      debug('getFileCountMap(): Got counts of', counts);
      return counts;
    }
    // Make a minimal updateInfo based on the passed in versionInfo.
    // This is used as a starting point to build upon.
    // If fromToUse exists and toToUse both exist, then they're used for this.from and this.to.
    // If toToUse is empty, it will be set from an empty VersionInfo.
    // If fromToUse is undefined, it will be set from toToUse.
    //
  }, {
    key: "fromVersionInfo",
    value: function fromVersionInfo(versionInfo, logger, fromToUse, toToUse) {
      var major = versionInfo.major,
        minor = versionInfo.minor,
        patch = versionInfo.patch,
        identifier = versionInfo.identifier,
        name = versionInfo.name,
        changelist = versionInfo.changelist,
        product = versionInfo.product,
        language = versionInfo.language,
        distributor = versionInfo.distributor,
        subKey = versionInfo.subKey,
        channel = versionInfo.channel,
        designation = versionInfo.designation,
        platform = versionInfo.platform,
        versionFilePath = versionInfo.versionFilePath,
        isInitialRelease = versionInfo.isInitialRelease,
        macExecutableName = versionInfo.macExecutableName,
        winExecutableName = versionInfo.winExecutableName;
      var to = toToUse || Object.assign((0, types_1.emptyVersionInfo)(), {
        product: product,
        major: major,
        minor: minor,
        patch: patch,
        changelist: changelist,
        identifier: identifier,
        name: name,
        distributor: distributor,
        subKey: subKey,
        language: language,
        channel: channel,
        designation: designation,
        platform: platform,
        versionFilePath: versionFilePath,
        isInitialRelease: isInitialRelease,
        macExecutableName: macExecutableName,
        winExecutableName: winExecutableName
      });
      var from = fromToUse || Object.assign({}, to);
      var params = {
        to: to,
        from: from,
        product: product,
        distributor: distributor,
        language: language,
        channel: channel,
        logger: logger
      };
      debug('UpdateInstance.fromVersionInfo() -- Creating with following params', params);
      return new UpdateInstance(params);
    }
    // Create an updateInfo from a buildMD5.
    // This is a "full" style update, used for install, offline update, repair, and guarantee.
    // This basically does:
    // * Creates an object that will become an UpdateInstance from the versionInfo.
    // * Sets up a version defaulting on what's in the md5Map but if it has bad items, is overridden by versionInfo's version
    //   * Assigns this version into updateInstance.from and updateInstance.to
    // * From the md5Map, for each package...
    //   * Creates FileInfo[]s -- one for each file in the package (operation is added)
    //   * Stores those FileInfo's and other stuff into a PackageInfo and adds it to this.
    // 
  }, {
    key: "fromBuildMD5",
    value: function fromBuildMD5(md5Map, versionInfo, logger) {
      var updateInstance = UpdateInstance.fromVersionInfo(versionInfo, logger);
      var updateIdentifier = versionInfo.identifier;
      var splitVersion = md5Map.version.split('.'); // This can either be like "30.1.542934" or "30.1.0.592934" (ie patch is optional)
      var major = parseInt(splitVersion[0], 10);
      var minor = parseInt(splitVersion[1], 10);
      var patch = 0;
      var changelist = 0;
      if (splitVersion.length === 4) {
        // Version is in the form of "30.1.3.542934", with patch being "3"
        patch = parseInt(splitVersion[2], 10);
        changelist = parseInt(splitVersion[3], 10);
      } else {
        // Version is in the form of "30.1.542934", with patch being "0" by default.
        changelist = parseInt(splitVersion[2], 10);
      }
      if (isNaN(major)) {
        major = versionInfo.major;
      }
      if (isNaN(minor)) {
        minor = versionInfo.minor;
      }
      if (isNaN(patch)) {
        patch = versionInfo.patch;
      }
      if (isNaN(changelist)) {
        changelist = versionInfo.changelist;
      }
      Object.assign(updateInstance.to, {
        major: major,
        minor: minor,
        patch: patch,
        changelist: changelist
      });
      var packages = md5Map.metafile.packages;
      Object.keys(packages).forEach(function (packageName) {
        var currentPackage = packages[packageName];
        debug("UpdateInstance.fromBuildMd5 attempting to add package \"".concat(packageName, "\""));
        if (packageName.startsWith('discards-') || packageName.includes('-overlay') ||
        // Add here any fixes that we don't want to continue making
        false) {
          logger.info("UpdateInstance.fromBuildMd5 ignoring \"".concat(packageName, "\""));
          return;
        }
        var product = updateInstance.product;
        var components = currentPackage.meta.components;
        var platform = currentPackage.meta.platform;
        if (!platform) {
          platform = enums_1.Platforms.common;
        }
        var updateLocation = currentPackage.meta.updateLocation || enums_1.MAIN_DIR;
        var _volatile2 = [];
        var volatileStr = '';
        if ('volatile' in currentPackage.meta) {
          volatileStr = currentPackage.meta['volatile'];
        }
        if (volatileStr) {
          _volatile2 = volatileStr.split(',');
          for (var i = 0; i < _volatile2.length; ++i) {
            _volatile2[i] = _volatile2[i].trim();
            logger.info("UpdateInstance::fromBuildMd5() - Got volatile item for package ".concat(packageName, ": ").concat(_volatile2[i]));
          }
        }
        if (_typeof(md5Map.md5s[packageName]) !== 'object') {
          throw new errors_1.BaseError("Cannot find md5s for \"".concat(packageName, "\""), enums_1.ErrorTypes.invalidBuildMd5);
        }
        var fileMap = md5Map.md5s[packageName];
        var files = Object.keys(fileMap).map(function (fileName) {
          var md5 = fileMap[fileName].md5;
          var size = parseInt(fileMap[fileName].size, 10);
          var downloadUrl = ''; // We don't set this for individual files
          var isVolatile = false;
          if (_volatile2.length > 0) {
            for (var _i2 = 0; _i2 < _volatile2.length; ++_i2) {
              if (fileName.startsWith(_volatile2[_i2])) {
                isVolatile = true;
                break;
              }
            }
          }
          return {
            md5: md5,
            downloadUrl: downloadUrl,
            size: size,
            packageName: packageName,
            updateLocation: updateLocation,
            identifier: updateIdentifier,
            operation: enums_1.FileOperations.added,
            name: fileName,
            opIdentifier: '',
            isVolatile: isVolatile
          };
        });
        var params = {
          product: product,
          platform: platform,
          components: components,
          updateIdentifier: updateIdentifier,
          files: files,
          name: packageName,
          guarantees: [],
          "volatile": _volatile2,
          isValid: false,
          updateLocation: updateLocation
        };
        updateInstance.addPackage(params);
      });
      logger.info("UpdateInstance::fromBuildMD5() - Got updatePath=".concat(JSON.stringify(updateInstance.updatePath)));
      return updateInstance;
    }
    /**
    * Initialize this with the text in deltaText (in json format)
    * This will clear any data currently in this and this will be set to the info in the json
    * The json file must be in a "Delta json" format.
    * @param {string} deltaText - a string representation of the json file.
    */
  }, {
    key: "fromDeltaText",
    value: function fromDeltaText(versionInfo, deltaText, logger) {
      var isDeltaData = function isDeltaData(item) {
        if (!item || _typeof(item) !== 'object') {
          debug('Delta file failed object test');
          return false;
        }
        var from = item.from,
          to = item.to,
          added = item.added,
          changed = item.changed,
          deleted = item.deleted,
          meta = item.meta;
        if (![from, to].every(function (versionInfo) {
          return (0, types_1.isVersionInfo)(versionInfo);
        })) {
          debug('Delta file failed from, to test');
          return false;
        }
        if (![added, changed, deleted].every(function (operation) {
          return (0, types_1.isDeltaOperationData)(operation);
        })) {
          debug('Delta file failed operation test');
          return false;
        }
        debug('Testing metadata');
        return (0, types_1.isDeltaMetadata)(meta);
      };
      // Pass to and from so updatePath will be correct.
      var deltaData = JSON.parse(deltaText);
      // Add patch 0 if we have an older delta that doesn't contain it.
      if (deltaData['from'] !== undefined && !('patch' in deltaData['from'])) {
        deltaData['from']['patch'] = 0;
      }
      // Add patch 0 if we have an older delta that doesn't contain it.
      if (deltaData['to'] !== undefined && !('patch' in deltaData['to'])) {
        deltaData['to']['patch'] = 0;
      }
      if (!isDeltaData(deltaData)) {
        throw new errors_1.BaseError('The delta text is not a valid DeltaFile!', enums_1.ErrorTypes.invalidDeltaFile);
      }
      logger.info("updateInstance::fromDeltaText() - Creating updateInstance from delta from: ".concat(deltaData.from.identifier, " to: ").concat(deltaData.to.identifier, "."));
      var updateInstance = UpdateInstance.fromVersionInfo(versionInfo, logger, deltaData.from, deltaData.to);
      updateInstance.from = deltaData.from;
      updateInstance.to = deltaData.to;
      // Go through deleted, changed, and added files and add them to the packages
      var operations = {
        deleted: enums_1.FileOperations.deleted,
        changed: enums_1.FileOperations.changed,
        added: enums_1.FileOperations.added,
        "volatile": enums_1.FileOperations["volatile"]
      };
      var addFilesToPackage = function addFilesToPackage(fileDict, thePackage, fileOperation, updateLocation) {
        Object.keys(fileDict).forEach(function (theFile) {
          // Ignore version file
          var splitHash = fileDict[theFile].split('-');
          var theHash = splitHash[0];
          var size = 0;
          if (splitHash[1] !== undefined) {
            size = parseInt(splitHash[1], 10);
          }
          var source = updateInstance.to.identifier;
          // Typescript is being real weird so we cast here. We already define above as being a
          // delete add or change
          var toAdd = {
            size: size,
            updateLocation: updateLocation || enums_1.MAIN_DIR,
            name: theFile,
            operation: fileOperation,
            md5: theHash,
            identifier: source,
            packageName: thePackage.name,
            downloadUrl: "" // these files don't have url's
          };

          thePackage.files.push(toAdd);
        });
      };
      // Get packages.
      Object.keys(deltaData.meta).forEach(function (packageName) {
        debug("UpdateInstance::initFromDelta() - adding package ".concat(packageName));
        if (!packageName.startsWith('discards-') && !packageName.includes('-overlay') &&
        // Add here any fixes that we don't want to continue making
        !packageName.toLowerCase().startsWith('updaterfix2023a')) {
          var packageData = deltaData.meta[packageName];
          // platform in packageData is a string so we cast to platform, isDeltaData verified the
          // non blank platforms are valid
          var platform = packageData.platform.length === 0 ? enums_1.Platforms.common : packageData.platform;
          var _volatile3 = [];
          var volatileStr = packageData["volatile"] || '';
          if (volatileStr) {
            _volatile3 = volatileStr.split(',');
            for (var i = 0; i < _volatile3.length; ++i) {
              _volatile3[i] = _volatile3[i].trim();
            }
          }
          var packageInfo = {
            platform: platform,
            name: packageName,
            product: updateInstance.product,
            components: packageData.components,
            updateIdentifier: updateInstance.to.identifier,
            files: [],
            guarantees: packageData.guarantees || [],
            "volatile": _volatile3,
            updateLocation: enums_1.MAIN_DIR,
            isValid: false
          };
          Object.keys(operations).forEach(function (operation) {
            if (operation in deltaData) {
              Object.keys(deltaData[operation]).forEach(function (thePackageName) {
                if (thePackageName === packageInfo.name) {
                  var useOperation;
                  useOperation = operation;
                  addFilesToPackage(deltaData[operation][thePackageName], packageInfo, useOperation, packageData.updateLocation);
                }
              });
            }
          });
          updateInstance.addPackage(packageInfo);
        }
      });
      return updateInstance;
    }
  }]);
  return UpdateInstance;
}();
exports["default"] = UpdateInstance;

/***/ }),

/***/ 93176:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _enums_1$FileOperatio, _enums_1$FileOperatio2, _enums_1$FileOperatio3, _enums_1$FileOperatio4, _enums_1$FileOperatio5, _mergeCases;
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.mergePackages = exports.invalidMerge = void 0;
var enums_1 = __webpack_require__(38261);
/**
 * Helper function that will throw a TypeError error when merging
 *
 * @param {FileInfo} firstFile - The first file that failed.
 * @param {FileInfo} latterFile - The second file that failed.
 */
var invalidMerge = function invalidMerge(firstFile, latterFile) {
  throw TypeError("Invalid merge ".concat(firstFile.operation, " -> ").concat(latterFile.operation, "\n\n    First File:'").concat(firstFile.name, "'\n\n    Last File: '").concat(latterFile.name, "'"));
};
exports.invalidMerge = invalidMerge;
/**
 * The top level keys are the operations of the first file, and the inner key is the operation of
 * the latter file.
 *
 * This returns a function that will return the file operation to add based on the combination of
 * operations
 *
 */
var mergeCases = (_mergeCases = {}, _defineProperty(_mergeCases, enums_1.FileOperations.deleted, (_enums_1$FileOperatio = {}, _defineProperty(_enums_1$FileOperatio, enums_1.FileOperations["volatile"], function (
// deleted -> volatile: volatile always wins
_firstFile, latterFile) {
  return [latterFile];
}), _defineProperty(_enums_1$FileOperatio, enums_1.FileOperations.added, function (firstFile, latterFile) {
  var _operation = latterFile.operation,
    rest = __rest(latterFile, ["operation"]);
  return firstFile.md5 === latterFile.md5 ? [Object.assign({
    operation: enums_1.FileOperations.none
  }, rest)] : [Object.assign({
    operation: enums_1.FileOperations.changed
  }, rest)];
}), _defineProperty(_enums_1$FileOperatio, enums_1.FileOperations.deleted, invalidMerge), _defineProperty(_enums_1$FileOperatio, enums_1.FileOperations.changed, invalidMerge), _defineProperty(_enums_1$FileOperatio, enums_1.FileOperations.renamed, invalidMerge), _enums_1$FileOperatio)), _defineProperty(_mergeCases, enums_1.FileOperations.added, (_enums_1$FileOperatio2 = {}, _defineProperty(_enums_1$FileOperatio2, enums_1.FileOperations.added, function (_firstFile, latterFile) {
  return [latterFile];
}), _defineProperty(_enums_1$FileOperatio2, enums_1.FileOperations["volatile"], function (
// add -> volatile: Volatile always wins.
_firstFile, latterFile) {
  return [latterFile];
}), _defineProperty(_enums_1$FileOperatio2, enums_1.FileOperations.deleted, function (_firstFile, latterFile) {
  var _operation = latterFile.operation,
    rest = __rest(latterFile, ["operation"]);
  return [Object.assign({
    operation: enums_1.FileOperations.none
  }, rest)];
}), _defineProperty(_enums_1$FileOperatio2, enums_1.FileOperations.changed, function (_firstFile, latterFile) {
  var _operation = latterFile.operation,
    rest = __rest(latterFile, ["operation"]);
  return [Object.assign({
    operation: enums_1.FileOperations.added
  }, rest)];
}), _defineProperty(_enums_1$FileOperatio2, enums_1.FileOperations.renamed, function (_firstFile, latterFile) {
  var retVal = {
    operation: enums_1.FileOperations.added,
    updateLocation: latterFile.updateLocation,
    name: latterFile.newName,
    md5: latterFile.md5,
    size: latterFile.size,
    downloadUrl: latterFile.downloadUrl,
    packageName: latterFile.packageName,
    identifier: latterFile.identifier,
    opIdentifier: latterFile.opIdentifier,
    isVolatile: latterFile.isVolatile
  };
  return [retVal];
}), _enums_1$FileOperatio2)), _defineProperty(_mergeCases, enums_1.FileOperations.changed, (_enums_1$FileOperatio3 = {}, _defineProperty(_enums_1$FileOperatio3, enums_1.FileOperations["volatile"], function (
// change -> volatile: Volatile always wins.
_firstFile, latterFile) {
  return [latterFile];
}), _defineProperty(_enums_1$FileOperatio3, enums_1.FileOperations.added, function (
// For changed -> added, we treat it as a change
_firstFile, latterFile) {
  return [latterFile];
}), _defineProperty(_enums_1$FileOperatio3, enums_1.FileOperations.deleted, function (_firstFile, latterFile) {
  var retVal = latterFile;
  retVal.md5 = ''; // We clear the MD5 so that if an "added" occurs later on, it doesn't become a delete->add No-Op (since the MD5 will differ)
  return [retVal];
}), _defineProperty(_enums_1$FileOperatio3, enums_1.FileOperations.changed, function (_firstFile, latterFile) {
  return [latterFile];
}), _defineProperty(_enums_1$FileOperatio3, enums_1.FileOperations.renamed, function (firstFile, latterFile) {
  var _operation = latterFile.operation,
    name = latterFile.name,
    _newName = latterFile.newName,
    restOfAdd = __rest(latterFile, ["operation", "name", "newName"]);
  var addOp = Object.assign({
    name: latterFile.newName,
    operation: enums_1.FileOperations.added
  }, restOfAdd);
  var _delOp = firstFile.operation,
    restOfDelete = __rest(firstFile, ["operation"]);
  var deleteOp = Object.assign({
    operation: enums_1.FileOperations.deleted
  }, restOfDelete);
  return [deleteOp, addOp];
}), _enums_1$FileOperatio3)), _defineProperty(_mergeCases, enums_1.FileOperations.renamed, (_enums_1$FileOperatio4 = {}, _defineProperty(_enums_1$FileOperatio4, enums_1.FileOperations["volatile"], function (
// rename -> volatile: Volatile always wins.
_firstFile, latterFile) {
  return [latterFile];
}), _defineProperty(_enums_1$FileOperatio4, enums_1.FileOperations.added, invalidMerge), _defineProperty(_enums_1$FileOperatio4, enums_1.FileOperations.deleted, function (firstFile) {
  var _operation = firstFile.operation,
    rest = __rest(firstFile, ["operation"]);
  return [Object.assign({
    operation: enums_1.FileOperations.deleted
  }, rest)];
}), _defineProperty(_enums_1$FileOperatio4, enums_1.FileOperations.changed, function (firstFile, latterFile) {
  var _delOp = firstFile.operation,
    restOfDelete = __rest(firstFile, ["operation"]);
  var _addOp = latterFile.operation,
    restOfAdd = __rest(latterFile, ["operation"]);
  return [Object.assign({
    operation: enums_1.FileOperations.deleted
  }, restOfDelete), Object.assign({
    operation: enums_1.FileOperations.added
  }, restOfAdd)];
}), _defineProperty(_enums_1$FileOperatio4, enums_1.FileOperations.renamed, function (firstFile, latterFile) {
  var _name = latterFile.name,
    rest = __rest(latterFile, ["name"]);
  return [Object.assign({
    name: firstFile.name
  }, rest)];
}), _enums_1$FileOperatio4)), _defineProperty(_mergeCases, enums_1.FileOperations["volatile"], (_enums_1$FileOperatio5 = {}, _defineProperty(_enums_1$FileOperatio5, enums_1.FileOperations["volatile"], function (
// Volatile files always stay volatile.
_firstFile, latterFile) {
  return [latterFile];
}), _defineProperty(_enums_1$FileOperatio5, "invalidMerge", invalidMerge), _enums_1$FileOperatio5)), _mergeCases);
/**
 * Given two in-order packages, merge their operations.
 *
 * @param {UpdateInstance~PackageInfo} formerPackage - The first package, chronologically to merge.
 * @param {UpdateInstance~PackageInfo} latterPackage - The latter package to merge.
 *
 * @returns {PackageInfo} - A new PackageInfo object of the merged package
 */
var mergePackages = function mergePackages(formerPackage, latterPackage, logger) {
  var formerFiles = formerPackage.files;
  var latterFiles = latterPackage.files;
  var formerCount = formerFiles ? formerFiles.length : 0;
  var latterCount = latterFiles ? latterFiles.length : 0;
  var mergedFilesRaw = [];
  var callInfo = "".concat(formerPackage.updateIdentifier, "::").concat(formerPackage.name, " (").concat(formerCount, "), ").concat(latterPackage.updateIdentifier, "::").concat(latterPackage.name, " (").concat(latterCount, ")");
  logger.info("mergePackages(".concat(callInfo, " - Start)"));
  formerFiles.forEach(function (formerFile) {
    // Find a corresponding file in lastFiles
    var fileName = formerFile.name;
    if (formerFile.operation === enums_1.FileOperations.renamed) {
      fileName = formerFile.newName;
    }
    var latterFile = latterFiles.find(function (latterFile) {
      return latterFile.name === fileName;
    });
    // The file is not touched in the latter update, so just keep this operation.
    if (!latterFile) {
      mergedFilesRaw.push(formerFile);
      return;
    }
    if (!mergeCases[formerFile.operation]) {
      throw TypeError("Invalid operation on first file\nOperation: '".concat(formerFile.operation, "'"));
    }
    if (!mergeCases[formerFile.operation][latterFile.operation]) {
      throw TypeError("Invalid operation on the latter file.\nOperation: '".concat(latterFile.operation, "'"));
    }
    var formerOp = formerFile.operation;
    var latterOp = latterFile.operation;
    var results = mergeCases[formerOp][latterOp](formerFile, latterFile);
    results.forEach(function (res) {
      mergedFilesRaw.push(res);
    });
  });
  // Find files in latterPackage that are not in formerPackage and create a list
  var onlyInLatter = latterFiles.reduce(function (untouched, file) {
    var fileName = file.name;
    var foundMatchingFile = mergedFilesRaw.find(function (newFile) {
      var namesMatch = newFile.name === fileName;
      var newNewToName = newFile.operation === enums_1.FileOperations.renamed && newFile.newName === fileName;
      var newToName = file.operation === enums_1.FileOperations.renamed && file.newName === newFile.name;
      var newToNew = file.operation === enums_1.FileOperations.renamed && newFile.operation === enums_1.FileOperations.renamed && file.newName === newFile.newName;
      return namesMatch || Boolean(newNewToName) || Boolean(newToName) || Boolean(newToNew);
    });
    if (!foundMatchingFile) {
      untouched.push(file);
      return untouched;
    }
    return untouched;
  }, []);
  // Append the files that are just in the latter files to the mergedFilesRaw list.
  var _iterator = _createForOfIteratorHelper(onlyInLatter),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var fileObj = _step.value;
      mergedFilesRaw.push(fileObj);
    }
    // Build a dictionary of file name vs indices that we can use in the next loop to speed up checking (so we don't have to filter the full list for each file)
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  var fileCounts = {};
  mergedFilesRaw.forEach(function (fileObj, index) {
    if (fileObj.name in fileCounts) {
      fileCounts[fileObj.name].push(index);
    } else {
      fileCounts[fileObj.name] = [index];
    }
  });
  // Look for duplicate operations on files. Rename changes result in two new operations, so it is
  // possible we add and delete a file here. In that case combine the add and delete to a change.
  var newFilesUnstripped = mergedFilesRaw.reduce(function (fileList, fileObj) {
    if (fileObj.operation === enums_1.FileOperations.deleted || fileObj.operation === enums_1.FileOperations.added) {
      // Find all files with the same name
      if (fileCounts[fileObj.name].length > 1) {
        // Since we iterate through the entire array we check once on the add file and once
        // on the delete file.
        if (!fileList.find(function (f) {
          return f.name === fileObj.name;
        })) {
          // Only want to do this if we have not already done it (if it's not in fileList)
          // Create sameFiles which is an array of fileInfo based on fileCounts...
          var sameFiles = [];
          var _iterator2 = _createForOfIteratorHelper(fileCounts[fileObj.name]),
            _step2;
          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var index = _step2.value;
              sameFiles.push(mergedFilesRaw[index]);
            }
            // Merge the add and delete into a change
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
          var addFile = sameFiles.find(function (f) {
            return f.operation === enums_1.FileOperations.added;
          });
          var deleteFile = sameFiles.find(function (f) {
            return f.operation === enums_1.FileOperations.deleted;
          });
          if (!addFile || !deleteFile) {
            throw TypeError('Expected an add file and delete file but one was missing!');
          }
          var merge = mergeCases[enums_1.FileOperations.deleted][enums_1.FileOperations.added];
          fileList.push.apply(fileList, _toConsumableArray(merge(deleteFile, addFile)));
        }
      } else {
        fileList.push(fileObj);
      }
    } else {
      fileList.push(fileObj);
    }
    return fileList;
  }, []);
  // Go through all files and remove any no-ops
  var newFiles = newFilesUnstripped.reduce(function (fileList, file) {
    if (file.operation === enums_1.FileOperations.none) {
      return fileList;
    }
    var newFile = Object.assign({}, file);
    fileList.push(newFile);
    return fileList;
  }, []);
  logger.info("mergePackages(".concat(callInfo, ") - Finished with ").concat(newFiles ? newFiles.length : 0, " result files."));
  return Object.assign({}, latterPackage, {
    files: newFiles
  });
};
exports.mergePackages = mergePackages;

/***/ }),

/***/ 23560:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/**
 * Contains a class used to package and extract vwupdates
 */
var events_1 = __webpack_require__(82361);
var archiver_1 = __webpack_require__(83833);
var fs = __importStar(__webpack_require__(57147));
var path = __importStar(__webpack_require__(71017));
var klaw_1 = __importDefault(__webpack_require__(1650));
var through2 = __importStar(__webpack_require__(14650));
var utils_1 = __webpack_require__(78325);
var enums_1 = __webpack_require__(38261);
var errors_1 = __webpack_require__(94515);
var debug = __webpack_require__(15158)('update-packager');
/**
 * A class used to handle packaging and extracting vwupdates
 *
 * @extends {EventEmitter}
 */
var UpdatePackager = /*#__PURE__*/function (_events_1$EventEmitte) {
  _inherits(UpdatePackager, _events_1$EventEmitte);
  var _super = _createSuper(UpdatePackager);
  function UpdatePackager() {
    _classCallCheck(this, UpdatePackager);
    return _super.apply(this, arguments);
  }
  _createClass(UpdatePackager, [{
    key: "cancel",
    value:
    /**
     * Cancel the current operation
     */
    function cancel() {
      this.emit('cancel');
    }
    /**
     * Zips up files in an archive
     *
     *
     * @param {string} outputFilepath - The filePath of the output zip archive including extension.
     * @param {{ name: string, location: string }[]} files - A list of objects containing information
     * about the files to archive. Name is the name to store the file in the archive, location is the
     * location on disk of the file to archive.
     *
     * @returns {Promise<string>} - A promise for the path to the archived zip file
     */
  }, {
    key: "createArchive",
    value: function createArchive(outputFilepath, files, logger) {
      var _this = this;
      return new Promise(function (resolve, reject) {
        var archive;
        var output;
        var numFiles = files.length;
        logger.info("updatePackager::createArchive() - Starting to package to: ".concat(outputFilepath, " (").concat(numFiles, " files)."));
        archive = (0, archiver_1.create)('zip', {
          zlib: {
            level: 9
          }
        });
        logger.info("updatePackager::createArchive() - Created archive.");
        output = fs.createWriteStream(outputFilepath);
        logger.info("updatePackager::createArchive() - opened write stream.");
        var cleanFailure = function cleanFailure() {
          logger.info("updatePackager::cleanFailure");
          archive.abort();
          output.destroy();
          (0, utils_1.removeDirectory)(outputFilepath);
        };
        var cancelReq = function cancelReq() {
          logger.info("updatePackager::cancelReq");
          cleanFailure();
          reject(new errors_1.CancelError());
        };
        _this.once('cancel', cancelReq);
        archive.on('warning', function (error) {
          _this.removeListener('cancel', cancelReq);
          cleanFailure();
          reject(new errors_1.BaseError('A warning has occurred writing the update to a zip', enums_1.ErrorTypes.failToWriteZip, error));
        }).on('error', function (error) {
          _this.removeListener('cancel', cancelReq);
          //cleanFailure();
          logger.info("updatePackager::writeStream Error event: ".concat(error));
          reject(new errors_1.BaseError('An error has occurred writing the update to a zip', enums_1.ErrorTypes.failToWriteZip, error));
        }).on('progress', function (progressData) {
          logger.info("updatePackager::progress ".concat(progressData));
          _this.emit('package-progress', progressData);
        });
        output.on('finish', function () {
          _this.removeListener('cancel', cancelReq);
          _this.emit('packaging-complete');
          logger.info("updatePackager::writestream - complete.");
          debug('packageFiles completed successfully');
          resolve(outputFilepath);
        }).on('error', function (error) {
          _this.removeListener('cancel', cancelReq);
          cleanFailure();
          logger.info("updatePackager::createArchive() - Received error: ".concat(error));
          reject(new errors_1.BaseError('An error has occurred writing the packaged update to a zip', enums_1.ErrorTypes.failToWriteZip, error));
        });
        logger.info("updatePackager::createArchive() - piping archive to output.");
        archive.pipe(output);
        logger.info("updatePackager::createArchive() - archiving files...");
        files.forEach(function (file) {
          logger.info("updatePackager::createArchive() - archiving file: ".concat(file.location, "/").concat(file.name));
          archive.file(file.location, {
            name: file.name
          });
        });
        logger.info("updatePackager::createArchive() - finalizing.");
        archive.finalize();
        logger.info("updatePackager::createArchive() - done.");
      });
    }
    // Returns promise of absolute paths to every file in dir.
  }, {
    key: "GetAllFiles",
    value: function GetAllFiles(dir) {
      var items = []; // files, directories, symlinks, etc
      var excludeDirFilter = through2.obj(function (item, _enc, next) {
        if (!item.stats.isDirectory()) this.push(item);
        next();
      });
      return new Promise(function (resolve, reject) {
        (0, klaw_1["default"])(dir).pipe(excludeDirFilter).on("end", function () {
          return resolve(items);
        }).on('readable', function () {
          var item;
          while (item = this.read()) {
            items.push(item.path);
          }
        }).on("error", reject);
      });
    }
    /**
     * Packages a generic update
     *
     * @param {Object} params
     * @param {string} params.rootFolder - The root of the update (from which files/ etc is found)
     * @param {string} params.target - The target identifier for the update
     * @param {string} params.destination - The filePath for the resulting .vwinstall file.
     *
     * @returns {Promise<string>} - A promise for the path to the archived zip file
     */
  }, {
    key: "packageUpdate",
    value: function packageUpdate(params) {
      var _this2 = this;
      var rootFolder = params.rootFolder,
        destination = params.destination;
      var allFiles = [];
      params.logger.info("UpdatePackager::packageUpdate() - Starting for ".concat(destination, " @ ").concat(rootFolder, "."));
      // First iterate the rootFolder and build fileMap for calling createArchive
      return this.GetAllFiles(rootFolder).then(function (readFiles) {
        params.logger.info("UpdatePackager::packageUpdate() - Found ".concat(readFiles.length, " files."));
        var _iterator = _createForOfIteratorHelper(readFiles),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var f = _step.value;
            var relDir = path.relative(rootFolder, f);
            params.logger.info("UpdatePackager::packageUpdate() - Adding file: ".concat(relDir, " -> ").concat(f, "."));
            allFiles.push({
              name: relDir,
              location: f
            }); // FIX this is broken somewhere but the doc for readdir suuuuuucks
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
        return _this2.createArchive(destination, allFiles, params.logger);
      });
    }
  }]);
  return UpdatePackager;
}(events_1.EventEmitter);
exports["default"] = UpdatePackager;

/***/ }),

/***/ 73809:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, defineProperty = Object.defineProperty || function (obj, key, desc) { obj[key] = desc.value; }, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return defineProperty(generator, "_invoke", { value: makeInvokeMethod(innerFn, self, context) }), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; defineProperty(this, "_invoke", { value: function value(method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; } function maybeInvokeDelegate(delegate, context) { var methodName = context.method, method = delegate.iterator[methodName]; if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel; var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), defineProperty(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (val) { var object = Object(val), keys = []; for (var key in object) keys.push(key); return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i["return"] && (_r = _i["return"](), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function get() {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __awaiter = this && this.__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }
  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
var __asyncValues = this && this.__asyncValues || function (o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator],
    i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () {
    return this;
  }, i);
  function verb(n) {
    i[n] = o[n] && function (v) {
      return new Promise(function (resolve, reject) {
        v = o[n](v), settle(resolve, reject, v.done, v.value);
      });
    };
  }
  function settle(resolve, reject, d, v) {
    Promise.resolve(v).then(function (v) {
      resolve({
        value: v,
        done: d
      });
    }, reject);
  }
};
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.RepairError = exports.JobInProgressError = exports.GetUpdateError = void 0;
var events_1 = __webpack_require__(82361);
var os_1 = __webpack_require__(22037);
var path = __importStar(__webpack_require__(71017));
var fs = __importStar(__webpack_require__(55674));
var klaw_1 = __importDefault(__webpack_require__(1650));
var debug_1 = __importDefault(__webpack_require__(15158));
var through2 = __importStar(__webpack_require__(14650));
var sudo_prompt_vw_1 = __importDefault(__webpack_require__(35637));
var promises_1 = __webpack_require__(93977);
var childProcess = __importStar(__webpack_require__(32081));
var types_1 = __webpack_require__(45627);
var enums_1 = __webpack_require__(38261);
var errors_1 = __webpack_require__(94515);
var downloader_1 = __importDefault(__webpack_require__(66912));
var update_instance_1 = __importDefault(__webpack_require__(54791));
var UpdatePackager_1 = __importDefault(__webpack_require__(23560));
var VWIMHelper_runner_1 = __webpack_require__(2228);
var utils_1 = __webpack_require__(78325);
var genDebugFn = function genDebugFn(name) {
  return (0, debug_1["default"])("updater:".concat(name));
};
var MethodNames;
(function (MethodNames) {
  MethodNames[MethodNames["getUpdateInfo"] = 0] = "getUpdateInfo";
  MethodNames[MethodNames["repair"] = 1] = "repair";
  MethodNames[MethodNames["downloadOfflineUpdate"] = 2] = "downloadOfflineUpdate";
  MethodNames[MethodNames["update"] = 3] = "update";
  MethodNames[MethodNames["getFilesToRepair"] = 4] = "getFilesToRepair";
  MethodNames[MethodNames["setStagingDir"] = 5] = "setStagingDir";
  MethodNames[MethodNames["calculateZipsToDownload"] = 6] = "calculateZipsToDownload";
  MethodNames[MethodNames["downloadAndExtractZipFiles"] = 7] = "downloadAndExtractZipFiles";
  MethodNames[MethodNames["applyUpdate"] = 8] = "applyUpdate";
  MethodNames[MethodNames["applyUpdateWithHelper"] = 9] = "applyUpdateWithHelper";
  MethodNames[MethodNames["fetchAndDownloadUpdate"] = 10] = "fetchAndDownloadUpdate";
  MethodNames[MethodNames["getExtraFilesForRepair"] = 11] = "getExtraFilesForRepair";
  MethodNames[MethodNames["startSearchForExtraFilesForRepair"] = 12] = "startSearchForExtraFilesForRepair";
})(MethodNames || (MethodNames = {}));
var debugFunctions = Object.values(MethodNames).reduce(function (obj, name) {
  obj[name] = genDebugFn(name);
  return obj;
}, {});
/**
 * An error that occurs when fetching updates fail
 *
 * @extends {BaseError}
 */
var GetUpdateError = /*#__PURE__*/function (_errors_1$BaseError) {
  _inherits(GetUpdateError, _errors_1$BaseError);
  var _super = _createSuper(GetUpdateError);
  function GetUpdateError() {
    _classCallCheck(this, GetUpdateError);
    return _super.apply(this, arguments);
  }
  return _createClass(GetUpdateError);
}(errors_1.BaseError);
exports.GetUpdateError = GetUpdateError;
/**
 * An error that occurs when attempting to start another operation while an operation is in progress
 *
 * @extends {BaseError}
 */
var JobInProgressError = /*#__PURE__*/function (_errors_1$BaseError2) {
  _inherits(JobInProgressError, _errors_1$BaseError2);
  var _super2 = _createSuper(JobInProgressError);
  function JobInProgressError() {
    _classCallCheck(this, JobInProgressError);
    return _super2.apply(this, arguments);
  }
  return _createClass(JobInProgressError);
}(errors_1.BaseError);
exports.JobInProgressError = JobInProgressError;
/**
 * An error that occurs when an error occurs during repair
 *
 * @extends {BaseError}
 */
var RepairError = /*#__PURE__*/function (_errors_1$BaseError3) {
  _inherits(RepairError, _errors_1$BaseError3);
  var _super3 = _createSuper(RepairError);
  function RepairError() {
    _classCallCheck(this, RepairError);
    return _super3.apply(this, arguments);
  }
  return _createClass(RepairError);
}(errors_1.BaseError);
exports.RepairError = RepairError;
/**
 * Class used to update an installation
 *
 * This provides a few high level operations, checking for updates, updating, repairing,
 * installing, downloading offline updates and installations.
 *
 * This is not application specific and supports updating files in multiple locations, so long
 * as they are provided and the server follows the same structure.
 *
 * The server structure is as follows:
 *
 * Each Major, distributor, and language will have its update belong in a root as follows.
 *
 * serverRoot/<major>/<distributor>/<lang>/
 *
 * For example serverRoot/24/NNA/eng/ will contain NNA's english update files for the 2019 software.
 *
 * In the verison/dist/lang root the file structure is as follows
 *
 * + VersionInfo.json - This is not the forced name but this is name commonly used. The updater
 * | application will be built with the same name and looks for it. This file contains a serialized
 * | UpdateInfo object.
 * |
 * |+ meta/ - This folder contains the delta files used to update from one identifier to another as
 * | well as hashes for specific update identifiers. Files should be named
 * | delta-<identifierFrom>-<identifierTo>.json.
 * |+++++ hashes/ - Contains the BuildMD5 objects for each build identifier. Files should be named
 * |              <identifier>.json.
 * |+ files/
 * |+++++ <IdentifierA>/ - For each identifier contains a set of zip of each package of files that
 * |                       are new or changed in that update. For example:
 * |                       files/Update0/split/win32-core/win32-core_15.zip.
 * |                       If a file is unchanged between identifiers it will exist in the
 * |                       earliest parent identifier.
 *
 * @extends {UpdaterStrictEmitter}
 */
var Updater = /*#__PURE__*/function (_events_1$EventEmitte) {
  _inherits(Updater, _events_1$EventEmitte);
  var _super4 = _createSuper(Updater);
  /**
   * Create a new updater
   *
   * @param {string} rootUrl - The Root URL of the server, not including major/dist/lang
   * @param {ProxyInfo | null} proxyInfo - The proxy information to use when connecting to the
   * server.
   */
  function Updater(rootUrl, fileSource, sslVerification, logger, curlPath, proxyInfo) {
    var _this;
    _classCallCheck(this, Updater);
    _this = _super4.call(this);
    _this.fixSlashes = function (inPath, platform) {
      if (platform === 'win32') {
        return inPath.replaceAll(/\//g, '\\');
      }
      return inPath.replaceAll(/\\/g, '/');
    };
    _this.GetErrorTypeFromErrorFile = function (errFilePath) {
      var resultError = enums_1.ErrorTypes.unknownError;
      // open and read contents of file
      var lines = fs.readFileSync(errFilePath).toString('utf-8').split('\n');
      // Find error code (first one) and convert to ErrorTypes.
      _this.logger.info("GetErrorTypeFromErrorFile() - Reading error file ".concat(errFilePath, "..."));
      for (var i = 0; i < lines.length; ++i) {
        var thisLine = lines[i].trim();
        _this.logger.info("GetErrorTypeFromErrorFile() - Read line: ".concat(thisLine));
        var parsedInt = parseInt(thisLine, 10);
        if (!Number.isNaN(parsedInt)) {
          switch (parsedInt) {
            case 2001:
              resultError = enums_1.ErrorTypes.noDiskSpace;
              break;
            case 2002:
              resultError = enums_1.ErrorTypes.permissionError;
              break;
            case 2003:
              resultError = enums_1.ErrorTypes.missingDownloadedFile;
              break;
            case 2004:
              resultError = enums_1.ErrorTypes.failToDelete;
              break;
            case 2005:
              resultError = enums_1.ErrorTypes.failToDelete;
              break;
            case 2006:
              resultError = enums_1.ErrorTypes.unknownError;
              break;
            // Bad command file, should not happen
            case 2007:
              resultError = enums_1.ErrorTypes.directoryReadOnlyError;
              break;
            case 2008:
              resultError = enums_1.ErrorTypes.directoryWriteNotPermitted;
              break;
          }
        }
      }
      return resultError;
    };
    _this.currentState = null;
    _this.canCancel = null;
    _this.updateInfo = null;
    _this.stagingDir = '';
    _this.cleanStagingDir = function () {
      return Promise.resolve();
    };
    _this.rootUrl = rootUrl;
    _this.fileSource = fileSource;
    _this.downloadRetryCount = -1;
    _this.curlPath = curlPath;
    _this.proxyInfo = proxyInfo;
    _this.packager = _this.createUpdatePackager();
    _this.sslVerification = sslVerification;
    _this.logger = logger;
    _this.on('done', function () {
      _this.clearState();
    });
    return _this;
  }
  // Replaces ${home}, ${serial}, ${<location key>}, ${product}, ${Product},
  // ${year}, ${major}, ${minor}, ${patch} // eg 2025, 30, 1, 0
  // ${subKey}, ${subKeyPreBackslash}, ${subKeyPreSlash}, ${subKeyPreDot}, ${subKeyPreSpace}, // eg ".NL" etc.
  // ${winInstallDate} // eg 20241028
  // ${macAppName}, ${winAppName}
  //
  _createClass(Updater, [{
    key: "replaceValues",
    value: function replaceValues(val, locationInfo, licenseInfo, versionInfo) {
      // VersionInfo required items
      if (versionInfo) {
        // If we're able to, substitute ${year}
        var year = versionInfo.major + 1995;
        val = val.replaceAll('${year}', "".concat(year));
        val = val.replaceAll('${major}', "".concat(versionInfo.major));
        val = val.replaceAll('${minor}', "".concat(versionInfo.minor));
        val = val.replaceAll('${patch}', "".concat(versionInfo.patch));
        // Find whether "${winInstallDate} is in the string
        if (val.includes('${winInstallDate}')) {
          // Get a date in this format: YYYYMMDD
          var date = new Date();
          var winInstallDate = date.getFullYear() +
          // 2024
          ('0' + (date.getMonth() + 1)).slice(-2) +
          // 05
          ('0' + date.getDate()).slice(-2); // 03
          val = val.replaceAll('${winInstallDate}', winInstallDate);
        }
        var product = versionInfo.product;
        var productCaps = product.charAt(0).toUpperCase() + product.slice(1);
        val = val.replaceAll('${product}', "".concat(product));
        val = val.replaceAll('${Product}', "".concat(productCaps));
        var subKey = versionInfo.subKey;
        var subKeyPreBackslash = subKey === '' ? '' : "\\".concat(subKey);
        var subKeyPreSlash = subKey === '' ? '' : "/".concat(subKey);
        var subKeyPreDot = subKey === '' ? '' : ".".concat(subKey);
        var subKeyPreSpace = subKey === '' ? '' : " ".concat(subKey);
        val = val.replaceAll('${subKey}', subKey);
        val = val.replaceAll('${subKeyPreBackslash}', subKeyPreBackslash);
        val = val.replaceAll('${subKeyPreSlash}', subKeyPreSlash);
        val = val.replaceAll('${subKeyPreDot}', subKeyPreDot);
        val = val.replaceAll('${subKeyPreSpace}', subKeyPreSpace);
        val = val.replaceAll('${macAppName}', versionInfo.macExecutableName);
        val = val.replaceAll('${winAppName}', versionInfo.winExecutableName);
      }
      // licenseInfo required items
      if (licenseInfo) {
        // This is somewhat hard coded - if serial is DEMO, install blank serial
        var serialToUse = licenseInfo.serialNumber;
        if (licenseInfo.serialNumber === 'DEMO') {
          serialToUse = '';
        }
        val = val.replaceAll('${serial}', "".concat(serialToUse));
      }
      // location required items
      if (locationInfo) {
        for (var key in locationInfo.locationInfo) {
          var substrToFind = '${' + key + '}'; // eg ${mainDir}
          var needsReplace = val.includes(substrToFind);
          if (needsReplace) {
            var location = (0, types_1.getLocationData)(key, locationInfo);
            if (location && location.valid) {
              val = val.replaceAll(substrToFind, location.locationPath);
            }
          }
        }
      }
      // General items
      val = val.replaceAll('${home}', (0, os_1.homedir)());
      return val;
    }
  }, {
    key: "writeProductGUID",
    value: function writeProductGUID(guidFullPath, licenseInfo, logger) {
      logger.info('writeProductGUID() - Getting GUID for this license...');
      var lookupMap = {
        'protection-internet': '1D2D2A06-D17B-4646-8F56-65C51A8AA78E',
        'protection-dongle': '212F288E-A76A-491C-9652-AD58C1D3EA1A',
        'protection-site-protection': '0924B113-6B6B-4FEA-A109-D0329EE31818'
      };
      var guid = '4B50F77B-7095-4901-AAFD-1806482D5CB5'; // Default to viewer
      var foundAValue = false;
      for (var _i = 0, _Object$entries = Object.entries(lookupMap); _i < _Object$entries.length; _i++) {
        var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
          key = _Object$entries$_i[0],
          value = _Object$entries$_i[1];
        if (licenseInfo.checkComponentsSync(key)) {
          logger.info("writeProductGUID() - Found protection ".concat(key, ", using GUID: ").concat(value, "."));
          foundAValue = true;
          guid = value;
          break;
        }
      }
      if (!foundAValue) {
        logger.info("writeProductGUID() - No protection found. Using default key for viewer.");
      }
      // Make sure the dir exists then write the GUID into it.
      return fs.ensureDir(path.dirname(guidFullPath)).then(function () {
        return fs.writeFile(guidFullPath, "{".concat(guid, "}\n"));
      });
    }
  }, {
    key: "getCustomValue",
    value: function getCustomValue(customValueName, customValues, licenseInfo) {
      // First get any workspace changes.
      var chosenValue = -1;
      this.logger.info("getCustomValue() - customValues was: ".concat(JSON.stringify(customValues), "."));
      if (customValueName in customValues) {
        for (var i = 0; i < customValues[customValueName].length; ++i) {
          var customValueToCheck = customValues[customValueName][i];
          this.logger.info("getCustomValue() - checking value ".concat(i, " (").concat(customValueToCheck, ")."));
          if (customValueToCheck.components === '1' || licenseInfo.checkComponentsSync(customValueToCheck.components)) {
            this.logger.info("getCustomValue() - found chosenValue: ".concat(i, "."));
            chosenValue = i;
            break;
          }
        }
      } else {
        this.logger.info("getCustomValue() - name ".concat(customValueName, " not in values."));
      }
      if (chosenValue >= 0) {
        return customValues[customValueName][chosenValue];
      }
      return {};
    }
    /**
     * Sets all the values in registration via helper. Windows only.
     * If LicenseInfo and/or VersionInfo are passed, we will substitute values in from them.
     */
  }, {
    key: "registerDLLs",
    value: function registerDLLs(params) {
      var _this2 = this;
      // We save a list of dll's to register as they are copied.
      var copiedDLLs = [];
      // We should be able to copy these over. Get a unique name for this installation.
      var timestamp = new Date().toISOString().replace(/[-:.]/g, '');
      // Get the location c:\users\<username>\AppData\Roaming\Nemetschek\Vectorworks Registered DLLs
      var rootDLLPath = path.join((0, os_1.homedir)(), 'AppData', 'Roaming', 'Nemetschek', 'Vectorworks Registered DLLs', timestamp);
      // Create the directory
      this.logger.info("registerDLLs() - Creating directory: ".concat(rootDLLPath));
      fs.mkdirSync(rootDLLPath, {
        recursive: true
      });
      // Copy the files over
      var _iterator = _createForOfIteratorHelper(params.dllsToRegister),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var dll = _step.value;
          var srcDLL = this.replaceValues(dll, params.locationInfo);
          if (!fs.existsSync(srcDLL)) {
            this.logger.info("registerDLLs() - DLL ".concat(dll, " does not exist. Skipping."));
            continue;
          }
          var destDLL = path.join(rootDLLPath, path.basename(srcDLL));
          this.logger.info("registerDLLs() - Copying DLL from ".concat(srcDLL, " to ").concat(destDLL));
          fs.copySync(srcDLL, destDLL);
          // replace backslashes for forward ones and save it.
          copiedDLLs.push(destDLL.replace(/\//g, '\\'));
        }
        // Now we need to register the dll's.
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      var _params$helper$alloca = params.helper.allocateCommFile(),
        cmdFilePath = _params$helper$alloca.cmdFilePath,
        sigFilePath = _params$helper$alloca.sigFilePath,
        progressFilePath = _params$helper$alloca.progressFilePath,
        finFilePath = _params$helper$alloca.finFilePath;
      var fileDesc = fs.openSync(cmdFilePath, 'w');
      this.logger.info("registerDLLs() - Writing to command file at: ".concat(cmdFilePath));
      // Call regsvr32 on each dll
      for (var _i2 = 0, _copiedDLLs = copiedDLLs; _i2 < _copiedDLLs.length; _i2++) {
        var dllProcessed = _copiedDLLs[_i2];
        var cmd = "exec \"regsvr32 /s \"".concat(dllProcessed, "\"\"");
        this.logger.info("registerDLLs() - Registering DLL with: ".concat(cmd));
        fs.writeFileSync(fileDesc, cmd + '\n');
      }
      this.logger.info("registerDLLs() - Writing signal file at: ".concat(sigFilePath));
      params.helper.signalReady(sigFilePath);
      // Now wait for the finFilePath to show up.
      this.logger.info("registerDLLs() - Waiting for ".concat(finFilePath, " ..."));
      return params.helper.waitForFinFile(finFilePath, progressFilePath, 1000 * 60 * 15).then(function () {
        _this2.logger.info("registerDLLs() - Finished.");
        return Promise.resolve(true);
      })["catch"](function () {
        _this2.logger.info("registerDLLs() - Error.");
        return Promise.resolve(false);
      });
    }
    /**
     * Sets all the values in registration via helper.
     * If LicenseInfo and/or VersionInfo are passed, we will substitute values in from them.
     */
  }, {
    key: "doRegistration",
    value: function doRegistration(params) {
      var _params$helper$alloca2 = params.helper.allocateCommFile(),
        cmdFilePath = _params$helper$alloca2.cmdFilePath,
        sigFilePath = _params$helper$alloca2.sigFilePath,
        progressFilePath = _params$helper$alloca2.progressFilePath,
        finFilePath = _params$helper$alloca2.finFilePath;
      var fileDesc = fs.openSync(cmdFilePath, 'w');
      this.logger.info("doRegistration() - Writing to command file at: ".concat(cmdFilePath));
      // Set up file
      for (var _i3 = 0, _Object$entries2 = Object.entries(params.registrations); _i3 < _Object$entries2.length; _i3++) {
        var _Object$entries2$_i = _slicedToArray(_Object$entries2[_i3], 2),
          key = _Object$entries2$_i[0],
          registrationItem = _Object$entries2$_i[1];
        var components = registrationItem.components;
        // Replace operation-XXX with the proper 1 or 0 value
        var allOperations = ['update', 'install', 'repair', 'changeVersion', 'changeLicense', 'guarantee'];
        for (var i = 0; i < allOperations.length; ++i) {
          components = components.replaceAll("operation-".concat(allOperations[i]), params.operation == allOperations[i] ? '1' : '0');
        }
        var shouldProcess = params.licenseInfo ? params.licenseInfo.checkComponentsSync(components) : true; // If empty string this returns true.
        if (shouldProcess && process.platform === 'darwin' && registrationItem.mac !== undefined && Object.keys(registrationItem.mac).length > 0) {
          // Set up plist setting commands
          var plistSettings = registrationItem.mac;
          // Scope is "user" or "system" and controls whether the command is run as root or user (set earlier with setUserID).
          fs.writeFileSync(fileDesc, "plistLoc ".concat(plistSettings.scope, "\n"));
          this.logger.info("doRegistration() - plistLoc: ".concat(plistSettings.scope));
          // Path is the path to the actual file (minus extension as that's how defaults wants it)
          var plistNameProcessed = this.replaceValues(plistSettings.name, params.locationInfo, params.licenseInfo, params.versionInfo);
          fs.writeFileSync(fileDesc, "plistPath ".concat(plistNameProcessed, "\n"));
          this.logger.info("doRegistration() - plistPath: ".concat(plistNameProcessed));
          // Key is the value inside the plist to write to. Eg NNA User License
          var plistvalueNameProcessed = this.replaceValues(plistSettings.valueName, params.locationInfo, params.licenseInfo, params.versionInfo);
          fs.writeFileSync(fileDesc, "plistValueName ".concat(plistvalueNameProcessed, "\n"));
          this.logger.info("doRegistration() - plistValueName: ".concat(plistvalueNameProcessed));
          // valueType is "array" or empty and controls a specific thing, B series is put into an array, E is just a normal value.
          var valueType = plistSettings.array ? 'array' : '';
          fs.writeFileSync(fileDesc, "plistValueType ".concat(valueType, "\n"));
          this.logger.info("doRegistration() - plistValueType: ".concat(valueType));
          // Data is the actual value for this item - eg the actual serial number or whatever.
          var plistDataProcessed = this.replaceValues(plistSettings.valueData, params.locationInfo, params.licenseInfo, params.versionInfo);
          fs.writeFileSync(fileDesc, "plistValueData ".concat(plistDataProcessed, "\n"));
          this.logger.info("doRegistration() - plistValueData: ".concat(plistDataProcessed));
          fs.writeFileSync(fileDesc, "plistGo\n");
        } else if (shouldProcess && process.platform === 'win32' && registrationItem.win !== undefined && Object.keys(registrationItem.win).length > 0) {
          var regSettings = registrationItem.win;
          // Set up registry setting commands
          var hive = regSettings.hive; // By default this will typically be 'HKLM' or 'HKCU'
          if (hive === 'HKCU' && params.uid !== '') {
            // We have a specific uid so instead of HKCU we use HKU (HKEY_USERS/SID...)
            hive = 'HKU';
          }
          fs.writeFileSync(fileDesc, "regHive ".concat(hive, "\n"));
          this.logger.info("doRegistration() - regHive: ".concat(hive));
          var pathProcessed = this.replaceValues(regSettings.path, params.locationInfo, params.licenseInfo, params.versionInfo);
          if (hive === 'HKU') {
            pathProcessed = params.uid + '\\' + pathProcessed;
          }
          fs.writeFileSync(fileDesc, "regPath ".concat(pathProcessed, "\n"));
          this.logger.info("doRegistration() - regPath: ".concat(pathProcessed));
          var valueNameProcessed = this.replaceValues(regSettings.valueName, params.locationInfo, params.licenseInfo, params.versionInfo);
          fs.writeFileSync(fileDesc, "regValueName ".concat(valueNameProcessed, "\n"));
          this.logger.info("doRegistration() - regValueName: ".concat(valueNameProcessed));
          fs.writeFileSync(fileDesc, "regValueType ".concat(reg